/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrptmc.common.constant.anobj.AnObjPermRuleConstants;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjPermDataBo;

public class AnObjPermRuleService
implements AnObjPermRuleConstants,
AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(AnObjPermRuleService.class);
    private final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_permrule");
    private static volatile AnObjPermRuleService service = null;

    private AnObjPermRuleService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnObjPermRuleService getInstance() {
        if (service != null) return service;
        Class<AnObjPermRuleService> clazz = AnObjPermRuleService.class;
        synchronized (AnObjPermRuleService.class) {
            if (service != null) return service;
            service = new AnObjPermRuleService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public List<String> getPermConfigFields(String entityNum) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPermManageService", (String)"getPermConfigFields", (Object[])new Object[]{entityNum});
    }

    @ExcludeFromJacocoGeneratedReport
    public List<QFilter> getPermQFiltersForReportConfig(long anObjId) {
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        List<AnObjPermDataBo> permRules = this.getPermRules(anObjId);
        if (permRules.isEmpty()) {
            return qFilters;
        }
        Map<String, List<AnObjPermDataBo>> permRuleMap = permRules.stream().collect(Collectors.groupingBy(rule -> rule.getPermObj().getString("number")));
        for (Map.Entry<String, List<AnObjPermDataBo>> permRuleEntry : permRuleMap.entrySet()) {
            String entityNumber = permRuleEntry.getKey();
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
            HashMap customParam = Maps.newHashMapWithExpectedSize((int)16);
            customParam.put("hr_dataperm_ignoreDataRulePerm", "true");
            List<AnObjPermDataBo> permDataBos = permRuleEntry.getValue();
            List permFields = permDataBos.stream().map(AnObjPermDataBo::getPermField).collect(Collectors.toList());
            customParam.put("hr_dataperm_needDimCheckProps", permFields);
            LOGGER.info("AnObjPermRuleService needDimCheckProps: {}", permFields);
            QFilter qFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityNumber, "47150e89000000ac", customParam});
            if (qFilter == null) continue;
            LOGGER.info("AnObjPermRuleService getPermQFilter: {}", (Object)qFilter.toString());
            Map<String, String> permFieldMap = permDataBos.stream().collect(Collectors.toMap(AnObjPermDataBo::getPermField, permBo -> permBo.getAnObjField().getString("fieldalias")));
            this.replaceToFieldAlias(qFilter, permFieldMap);
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                this.replaceToFieldAlias(nest.getFilter(), permFieldMap);
            }
            LOGGER.info("AnObjPermRuleService transferPermQFilter: {}", (Object)qFilter.toString());
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    @ExcludeFromJacocoGeneratedReport
    private void replaceToFieldAlias(QFilter qFilter, Map<String, String> permFieldMap) {
        String property = qFilter.getProperty();
        String fieldAlias = permFieldMap.get(property);
        if (fieldAlias != null) {
            qFilter.__setProperty(fieldAlias);
        }
    }

    public void deletePermRuleByAnObjId(List<Object> anObjIds) {
        this.helper.deleteByFilter(new QFilter[]{new QFilter("anobj", "in", anObjIds)});
    }

    public void copyPermRules(long newAnObjId, long originAnObjId) {
        List<AnObjPermDataBo> permRules = this.getPermRules(originAnObjId);
        if (permRules.isEmpty()) {
            return;
        }
        DynamicObjectCollection saveCol = new DynamicObjectCollection();
        for (AnObjPermDataBo permRule : permRules) {
            DynamicObject permRuleDy = this.helper.generateEmptyDynamicObject();
            permRuleDy.set("anobj", (Object)newAnObjId);
            permRuleDy.set("permobj", permRule.getPermObj().get("id"));
            permRuleDy.set("permfield", (Object)permRule.getPermField());
            permRuleDy.set("anobjfield", permRule.getAnObjField().get("id"));
            permRuleDy.set("index", (Object)permRule.getIndex());
            saveCol.add((Object)permRuleDy);
        }
        this.helper.save(saveCol);
    }

    public void savePermRules(long anObjId, DynamicObjectCollection permRuleEntry) {
        QFilter qFilter = new QFilter("anobj", "=", (Object)anObjId);
        DynamicObject[] permRuleDys = this.helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        Map loadMap = Arrays.stream(permRuleDys).collect(Collectors.toMap(permRuleDy -> permRuleDy.getLong("id"), Function.identity()));
        DynamicObjectCollection saveCol = new DynamicObjectCollection();
        int index = 0;
        for (DynamicObject ruleDy2 : permRuleEntry) {
            long id = ruleDy2.getLong("id");
            DynamicObject permRuleDy2 = (DynamicObject)loadMap.get(id);
            if (permRuleDy2 == null) {
                permRuleDy2 = this.helper.generateEmptyDynamicObject();
            }
            permRuleDy2.set("anobj", (Object)anObjId);
            permRuleDy2.set("anobjfield", ruleDy2.get("field"));
            permRuleDy2.set("permobj", ruleDy2.get("permobj"));
            permRuleDy2.set("permfield", ruleDy2.get("permfield"));
            permRuleDy2.set("index", (Object)index++);
            saveCol.add((Object)permRuleDy2);
        }
        this.helper.save(saveCol);
        List<Long> currentIds = permRuleEntry.stream().map(ruleDy -> ruleDy.getLong("id")).collect(Collectors.toList());
        Set<Long> loadIds = loadMap.keySet();
        currentIds.forEach(loadIds::remove);
        if (!loadIds.isEmpty()) {
            this.helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", loadIds)});
        }
    }

    public List<AnObjPermDataBo> getPermRules(long anObjId) {
        QFilter qFilter = new QFilter("anobj", "=", (Object)anObjId);
        DynamicObject[] permRuleDys = this.helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList permDataBos = Lists.newArrayListWithExpectedSize((int)permRuleDys.length);
        for (DynamicObject permRuleDy : permRuleDys) {
            AnObjPermDataBo permDataBo = new AnObjPermDataBo();
            permDataBo.setId(Long.valueOf(permRuleDy.getLong("id")));
            permDataBo.setIndex(Integer.valueOf(permRuleDy.getInt("index")));
            permDataBo.setAnObj(permRuleDy.getDynamicObject("anobj"));
            permDataBo.setAnObjField(permRuleDy.getDynamicObject("anobjfield"));
            permDataBo.setPermObj(permRuleDy.getDynamicObject("permobj"));
            permDataBo.setPermField(permRuleDy.getString("permfield"));
            permDataBos.add(permDataBo);
        }
        return permDataBos.stream().sorted(Comparator.comparingInt(AnObjPermDataBo::getIndex)).collect(Collectors.toList());
    }

    public Map<String, String> getPermRuleRefAnObjFieldAliasList(long anObjId) {
        HashMap fieldAliasMap = Maps.newHashMapWithExpectedSize((int)16);
        QFilter qFilter = new QFilter("anobj", "=", (Object)anObjId);
        DynamicObject[] permRuleDys = this.helper.queryOriginalArray("anobjfield.fieldalias, anobjfield.fieldname", new QFilter[]{qFilter});
        if (permRuleDys == null) {
            return fieldAliasMap;
        }
        for (DynamicObject permRuleDy : permRuleDys) {
            fieldAliasMap.put(permRuleDy.getString("anobjfield.fieldalias"), permRuleDy.getString("anobjfield.fieldname"));
        }
        return fieldAliasMap;
    }
}

