/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;

public class AnObjPivotConfigTask
extends AbstractTask
implements AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(AnObjPivotConfigTask.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean updateSuccess = true;
        HRBaseServiceHelper anObjHelper = new HRBaseServiceHelper("hrptmc_analyseobject");
        HRBaseServiceHelper pivotHelper = new HRBaseServiceHelper("hrptmc_anobjpivot");
        QFilter qFilter = new QFilter("pivotdim", "is not null", null).or(new QFilter("pivotindex", "is not null", null)).or(new QFilter("pivotdimval", "is not null", null));
        DynamicObject[] anObjDys = anObjHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        List anObjIds = Arrays.stream(anObjDys).map(anObjDy -> anObjDy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] loadPivotDys = pivotHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "in", anObjIds)});
        List notHandleAnObjIds = Arrays.stream(loadPivotDys).map(dy -> dy.getDynamicObject("anobj").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection savePivotConfigCol = new DynamicObjectCollection();
        for (DynamicObject anObjDy2 : anObjDys) {
            try {
                long anObjId = anObjDy2.getLong("id");
                if (notHandleAnObjIds.contains(anObjId)) continue;
                List<DynamicObject> pivotConfigList = AnalyseObjectService.getInstance().generatePivotConfig(anObjDy2, Lists.newArrayListWithCapacity((int)16));
                savePivotConfigCol.addAll(pivotConfigList);
            }
            catch (Exception exception) {
                updateSuccess = false;
                LOGGER.error(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61%s\u66f4\u65b0\u5931\u8d25\u3002", (String)"AnObjPivotConfigTask_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), (Object)anObjDy2.getString("number"));
            }
        }
        try {
            if (!savePivotConfigCol.isEmpty()) {
                pivotHelper.save(savePivotConfigCol);
            }
        }
        catch (Exception ex) {
            updateSuccess = false;
            LOGGER.error(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25", (String)"AnObjPivotConfigTask_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), (Throwable)ex);
        }
        if (updateSuccess) {
            this.deleteSchedule();
        }
    }

    private void deleteSchedule() {
        HRBaseServiceHelper scheduleHelper = new HRBaseServiceHelper("sch_schedule");
        scheduleHelper.deleteByFilter(new QFilter[]{new QFilter("number", "=", (Object)"hrptmc_anobjpivotdataupdate_SKDP_S")});
    }

    public boolean isSupportReSchedule() {
        return super.isSupportReSchedule();
    }
}

