/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.AnObjSideBar;

public class AnObjSideBarService
implements AnalyseObjectConstants.SideBarConstants {
    private final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjsidebar");
    private static volatile AnObjSideBarService service = null;

    private AnObjSideBarService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnObjSideBarService getInstance() {
        if (service != null) return service;
        Class<AnObjSideBarService> clazz = AnObjSideBarService.class;
        synchronized (AnObjSideBarService.class) {
            if (service != null) return service;
            service = new AnObjSideBarService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void newSideBarToCache(List<AnObjSideBar> anObjSideBars, String type, IPageCache pageCache) {
        AnObjSideBar sideBar = new AnObjSideBar();
        sideBar.setType(type);
        sideBar.setIndex(Integer.valueOf(anObjSideBars.size()));
        anObjSideBars.add(sideBar);
        pageCache.put("sideBar", JSON.toJSONString(anObjSideBars));
    }

    public void removeSideBarFromCache(int index, IPageCache pageCache) {
        List anObjSideBars = JSON.parseArray((String)pageCache.get("sideBar"), AnObjSideBar.class);
        anObjSideBars.removeIf(sideBar -> sideBar.getIndex() == index);
        int sideBarIndex = 0;
        for (AnObjSideBar anObjSideBar : anObjSideBars) {
            anObjSideBar.setIndex(Integer.valueOf(sideBarIndex++));
        }
        pageCache.put("sideBar", JSON.toJSONString((Object)anObjSideBars));
    }

    public void compatibleOldSideBar(long anObjId, String oldSidebar, List<AnObjSideBar> anObjSideBars) {
        if (HRStringUtils.isEmpty((String)oldSidebar)) {
            return;
        }
        String[] split = oldSidebar.split(",");
        int index = 0;
        String anObjIdStr = String.valueOf(anObjId);
        for (String sideBar : split) {
            AnObjSideBar newSideBar = new AnObjSideBar();
            newSideBar.setType(sideBar);
            newSideBar.setIndex(Integer.valueOf(index++));
            newSideBar.setAnObjId(anObjIdStr);
            anObjSideBars.add(newSideBar);
        }
    }

    public List<AnObjSideBar> getSideBars(Long anObjId) {
        if (anObjId == null || anObjId == 0L) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        String anObjIdStr = String.valueOf(anObjId);
        DynamicObject[] sideBars = this.helper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        return Arrays.stream(sideBars).map(dy -> {
            AnObjSideBar sideBar = new AnObjSideBar();
            sideBar.setId(dy.getString("id"));
            sideBar.setIndex(Integer.valueOf(dy.getInt("index")));
            sideBar.setType(dy.getString("type"));
            sideBar.setAnObjId(anObjIdStr);
            DynamicObject groupField = dy.getDynamicObject("groupfield");
            if (groupField != null) {
                sideBar.setGroupFieldId(groupField.getString("id"));
            }
            return sideBar;
        }).sorted(Comparator.comparingInt(AnObjSideBar::getIndex)).collect(Collectors.toList());
    }

    public void saveSideBars(long anObjId, List<AnObjSideBar> sideBars, List<AnObjGroupField> anObjGroupFields) {
        DynamicObject[] originSideBars = this.helper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        Map originSideBarMap = Arrays.stream(originSideBars).collect(Collectors.toMap(bar -> bar.getString("id"), Function.identity()));
        DynamicObjectCollection dyCol = new DynamicObjectCollection();
        int index = 0;
        for (AnObjSideBar sideBar2 : sideBars) {
            String id = sideBar2.getId();
            DynamicObject sideBarDy = (DynamicObject)originSideBarMap.get(id);
            if (sideBarDy == null) {
                sideBarDy = this.helper.generateEmptyDynamicObject();
            }
            sideBarDy.set("index", (Object)index++);
            sideBarDy.set("type", (Object)sideBar2.getType());
            sideBarDy.set("anobj", (Object)anObjId);
            if (HRStringUtils.equals((String)sideBar2.getType(), (String)"groupField")) {
                AnObjGroupField groupField = anObjGroupFields.get(sideBar2.getGroupFieldIndex());
                sideBarDy.set("groupfield", (Object)Long.parseLong(groupField.getId()));
            }
            dyCol.add((Object)sideBarDy);
        }
        this.helper.save(dyCol);
        if (originSideBars.length > 0) {
            List currentIds = sideBars.stream().map(AnObjSideBar::getId).filter(Objects::nonNull).collect(Collectors.toList());
            List<Object> delIds = Arrays.stream(originSideBars).filter(sideBar -> !currentIds.contains(sideBar.getString("id"))).map(sideBar -> sideBar.getLong("id")).collect(Collectors.toList());
            if (!delIds.isEmpty()) {
                this.helper.delete(delIds.toArray(new Object[0]));
            }
        }
    }

    public void deleteSideBars(List<Object> anObjIds) {
        this.helper.deleteByFilter(new QFilter[]{new QFilter("anobj", "in", anObjIds)});
    }
}

