/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;

public class AnalyseDimCountService
implements AnalyseObjectConstants {
    private final Set<String> tableAndFieldSet = Sets.newHashSetWithExpectedSize((int)16);
    private final HRBaseServiceHelper dimCountHelper = new HRBaseServiceHelper("hrptmc_dimcount");
    private static final Log LOGGER = LogFactory.getLog(AnalyseDimCountService.class);

    public int getDimensionCount(String entityNumber, String fieldPath, String fieldComplexType) {
        int dimCount;
        String fieldName;
        Map<String, String> dimensionParam = this.getDimensionParam(entityNumber, fieldPath, fieldComplexType, null, new MainEntityTypeUtil());
        if (dimensionParam.isEmpty()) {
            return 0;
        }
        String tableName = dimensionParam.get("tableName");
        DynamicObject dimCountDy = this.queryDimCount(tableName, fieldName = dimensionParam.get("fieldName"));
        if (dimCountDy == null) {
            dimCount = this.getTableDataDistinctCount(dimensionParam);
            this.saveDimCount(tableName, fieldName, dimCount);
        } else {
            dimCount = dimCountDy.getBoolean("isbigdatatable") ? Integer.MAX_VALUE : dimCountDy.getInt("dimcount");
        }
        return dimCount;
    }

    public DynamicObject getDimensionCountDy(Map<String, String> dimensionParam) {
        String fieldName;
        if (dimensionParam.isEmpty()) {
            return null;
        }
        String tableName = dimensionParam.get("tableName");
        DynamicObject dimCountDy = this.queryDimCount(tableName, fieldName = dimensionParam.get("fieldName"));
        if (dimCountDy == null) {
            dimCountDy = this.saveDimCount(tableName, fieldName, this.getTableDataDistinctCount(dimensionParam));
        } else {
            String tableAndFieldKey = tableName + "!" + fieldName;
            if (this.tableAndFieldSet.contains(tableAndFieldKey)) {
                return dimCountDy;
            }
            this.tableAndFieldSet.add(tableAndFieldKey);
            dimCountDy.set("dimcount", (Object)this.getTableDataDistinctCount(dimensionParam));
            dimCountDy.set("isbigdatatable", (Object)false);
            this.dimCountHelper.saveOne(dimCountDy);
        }
        return dimCountDy;
    }

    public Map<String, String> getDimensionParam(String entityNumber, String fieldPath, String fieldComplexType, Map<String, Map<String, String>> baseDataParamMap, MainEntityTypeUtil mainEntityTypeUtil) {
        Map<String, String> baseDataParam;
        if (fieldPath.endsWith(".id")) {
            return Collections.emptyMap();
        }
        MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
        if (baseDataParamMap != null && AnalyseObjectUtil.isBaseDataType((String)fieldComplexType) && !(baseDataParam = this.getBaseDataParam(dataEntityType, fieldPath)).isEmpty()) {
            baseDataParamMap.put(baseDataParam.get("tableName") + "." + baseDataParam.get("fieldName"), baseDataParam);
        }
        String dbRouteKey = dataEntityType.getDBRouteKey();
        String[] aliasArr = fieldPath.split("\\.");
        IDataEntityProperty property = null;
        String entityNum = "";
        String fieldName = aliasArr[aliasArr.length - 1];
        if (AnalyseObjectUtil.isBaseDataType((String)fieldComplexType)) {
            String parentFieldName = aliasArr[aliasArr.length - 2];
            if (aliasArr.length > 2) {
                String grandParentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty grandParentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(grandParentFieldName);
                if (grandParentProp instanceof BasedataProp) {
                    String grandParentEntityNum = ((BasedataProp)grandParentProp).getBaseEntityId();
                    MainEntityType grandParentBaseDataEntityType = mainEntityTypeUtil.getMainEntityType(grandParentEntityNum);
                    property = (IDataEntityProperty)grandParentBaseDataEntityType.getAllFields().get(parentFieldName);
                    MainEntityType parentBaseDataEntityType = mainEntityTypeUtil.getMainEntityType(((BasedataProp)property).getBaseEntityId());
                    dbRouteKey = parentBaseDataEntityType.getDBRouteKey();
                    property = (IDataEntityProperty)parentBaseDataEntityType.getAllFields().get(fieldName);
                }
            }
            if (property == null) {
                property = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
                if (property == null) {
                    LOGGER.error("AnObj-getDimensionParam-fieldNotExist entityNumber: {}, field: {}, fieldPath: {}, fieldComplexType: {}", new Object[]{entityNumber, parentFieldName, fieldPath, fieldComplexType});
                    String msg = ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u522b\u540d\u4e3a%2$s\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AnalyseObjectService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
                    throw new KDBizException(String.format(msg, entityNumber, fieldPath));
                }
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                MainEntityType baseDataEntityType = mainEntityTypeUtil.getMainEntityType(baseEntityId);
                dbRouteKey = baseDataEntityType.getDBRouteKey();
                property = (IDataEntityProperty)baseDataEntityType.getAllFields().get(fieldName);
            }
            if (property != null && property.getParent() instanceof BasedataProp) {
                entityNum = ((BasedataProp)property.getParent()).getBaseEntityId();
            }
        } else {
            property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldName);
            entityNum = entityNumber;
        }
        if (property == null) {
            LOGGER.error("AnObj-getDimensionParam-fieldNotExist entityNumber: {}, fieldPath: {}, fieldComplexType: {}", new Object[]{entityNumber, fieldPath, fieldComplexType});
            String msg = ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u522b\u540d\u4e3a%2$s\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AnalyseObjectService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, entityNumber, fieldPath));
        }
        fieldName = property.getAlias();
        String tableName = property.getParent().getAlias();
        String tableGroup = property.getTableGroup();
        if (HRStringUtils.isNotEmpty((String)tableGroup)) {
            tableName = tableName + "_" + tableGroup;
        }
        boolean isPrivacyField = property instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)property);
        String isMultiLangField = String.valueOf(property instanceof MuliLangTextProp);
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        map.put("dbRouteKey", dbRouteKey);
        map.put("tableName", tableName);
        map.put("fieldPath", fieldPath);
        map.put("fieldName", fieldName);
        map.put("isMultiLangField", isMultiLangField);
        map.put("isPrivacyField", String.valueOf(isPrivacyField));
        map.put("entityNumber", entityNum);
        map.put("fieldNumber", property.getName());
        return map;
    }

    private Map<String, String> getBaseDataParam(MainEntityType dataEntityType, String fieldPath) {
        String entityNumber = dataEntityType.getName();
        String dbRouteKey = dataEntityType.getDBRouteKey();
        String[] aliasArr = fieldPath.split("\\.");
        IDataEntityProperty property = null;
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(entityNumber);
        for (String split : aliasArr) {
            if (HRStringUtils.equals((String)entityNumber, (String)split)) continue;
            property = (IDataEntityProperty)entityType.getProperties().get((Object)split);
            if (!(property instanceof EntryProp)) break;
            entityType = (EntityType)dataEntityType.getAllEntities().get(split);
        }
        if (property == null) {
            LOGGER.error("AnObj-getDimensionParam-fieldNotExist entityNumber: {}, fieldPath: {}", (Object)entityNumber, (Object)fieldPath);
            String msg = ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u522b\u540d\u4e3a%2$s\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AnalyseObjectService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, entityNumber, fieldPath));
        }
        String fieldName = property.getAlias();
        String tableName = property.getParent().getAlias();
        String tableGroup = property.getTableGroup();
        if (HRStringUtils.isNotEmpty((String)tableGroup)) {
            tableName = tableName + "_" + tableGroup;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        map.put("dbRouteKey", dbRouteKey);
        map.put("tableName", tableName);
        map.put("fieldPath", fieldPath);
        map.put("fieldName", fieldName);
        return map;
    }

    private DynamicObject queryDimCount(String tableName, String fieldName) {
        QFilter tableQFilter = new QFilter("tablename", "=", (Object)tableName);
        DynamicObject tableDy = this.dimCountHelper.queryOne("isbigdatatable", new QFilter[]{tableQFilter});
        if (tableDy == null) {
            return null;
        }
        if (tableDy.getBoolean("isbigdatatable")) {
            return tableDy;
        }
        QFilter fieldQFilter = new QFilter("fieldname", "=", (Object)fieldName);
        return this.dimCountHelper.queryOne("dimcount, isbigdatatable", new QFilter[]{tableQFilter, fieldQFilter});
    }

    private DynamicObject saveDimCount(String tableName, String fieldName, int dimCount) {
        DynamicObject dimCountDy = this.dimCountHelper.generateEmptyDynamicObject();
        dimCountDy.set("tablename", (Object)tableName);
        dimCountDy.set("fieldname", (Object)fieldName);
        dimCountDy.set("dimcount", (Object)dimCount);
        dimCountDy.set("isbigdatatable", (Object)false);
        return (DynamicObject)this.dimCountHelper.saveOne(dimCountDy);
    }

    private int getTableDataDistinctCount(Map<String, String> dimensionParamMap) {
        String isPrivacyField = dimensionParamMap.get("isPrivacyField");
        if (HRStringUtils.equals((String)isPrivacyField, (String)"true")) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(dimensionParamMap.get("entityNumber"));
            String fieldNumber = dimensionParamMap.get("fieldNumber");
            int count = 0;
            try (DataSet dataSet = helper.queryDataSet(AnalyseObjectService.class.getName(), fieldNumber, new QFilter[0]);){
                count = dataSet.count(fieldNumber, true);
            }
            return count;
        }
        String querySql = Boolean.parseBoolean(dimensionParamMap.get("isMultiLangField")) ? String.format("select count(distinct %s) from %s_L where flocaleid = '%s'", dimensionParamMap.get("fieldName"), dimensionParamMap.get("tableName"), RequestContext.get().getLang().name()) : String.format("select count(distinct %s) from %s", dimensionParamMap.get("fieldName"), dimensionParamMap.get("tableName"));
        Object[] params = new Object[]{};
        return (Integer)HRDBUtil.query((DBRoute)DBRoute.of((String)dimensionParamMap.get("dbRouteKey")), (String)querySql, (Object[])params, resultSet -> {
            int result = 0;
            while (resultSet.next()) {
                result = (int)resultSet.getLong(1);
            }
            return result;
        });
    }

    public int getTableIdCount(String tableName, String dbRoute) {
        String querySql = String.format(Locale.ROOT, "select count(*) from %s", tableName);
        Object[] params = new Object[]{};
        return (Integer)HRDBUtil.query((DBRoute)DBRoute.of((String)dbRoute), (String)querySql, (Object[])params, resultSet -> {
            int result = 0;
            while (resultSet.next()) {
                result = (int)resultSet.getLong(1);
            }
            return result;
        });
    }
}

