/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseDimCountService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;

public class AnalyseObjectDimCountTask
extends AbstractTask
implements AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(AnalyseObjectDimCountTask.class);

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
        QFilter qFilter = new QFilter("valuetype", "not in", Stream.of(DataTypeEnum.INTEGER.getDataTypeKey(), DataTypeEnum.LONG.getDataTypeKey(), DataTypeEnum.BIGDECIMAL.getDataTypeKey()).collect(Collectors.toSet()));
        String props = "id, entitynumber, fieldalias, fieldpath, complextype, dimcount, isvirtualfield";
        String anObjId = (String)map.get("anObjId");
        DynamicObject[] queryFields = anObjId == null ? queryFieldHelper.query(props, new QFilter[]{qFilter}) : queryFieldHelper.query(props, new QFilter[]{new QFilter("anobj", "=", (Object)Long.valueOf(anObjId)), qFilter});
        if (queryFields.length == 0) {
            return;
        }
        AnalyseDimCountService dimService = new AnalyseDimCountService();
        HashMap baseDataParamMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap handledTableAndDimCountMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        LOGGER.info("AnalyseObjectDimCountTask queryFields count : {}", (Object)queryFields.length);
        for (DynamicObject queryFieldDy : queryFields) {
            DynamicObject dimensionCountDy = null;
            if (anObjId != null && queryFieldDy.getDynamicObject("dimcount") != null) continue;
            Map<Object, Object> dimensionParam = Maps.newHashMapWithExpectedSize((int)16);
            try {
                if (queryFieldDy.getBoolean("isvirtualfield")) {
                    String fieldPath = queryFieldDy.getString("fieldpath");
                    if (!HRStringUtils.isEmpty((String)fieldPath)) {
                        String entityNumber = fieldPath.split("\\.")[0];
                        dimensionParam = dimService.getDimensionParam(entityNumber, fieldPath, queryFieldDy.getString("complextype"), baseDataParamMap, mainEntityTypeUtil);
                    }
                } else {
                    dimensionParam = dimService.getDimensionParam(queryFieldDy.getString("entitynumber"), queryFieldDy.getString("fieldpath"), queryFieldDy.getString("complextype"), baseDataParamMap, mainEntityTypeUtil);
                }
                String tableNameAndFieldName = (String)dimensionParam.get("tableName") + "." + (String)dimensionParam.get("fieldName");
                dimensionCountDy = (DynamicObject)handledTableAndDimCountMap.get(tableNameAndFieldName);
                if (dimensionCountDy != null) {
                    queryFieldDy.set("dimcount", (Object)dimensionCountDy);
                    continue;
                }
                dimensionCountDy = dimService.getDimensionCountDy(dimensionParam);
                queryFieldDy.set("dimcount", (Object)dimensionCountDy);
                handledTableAndDimCountMap.put(tableNameAndFieldName, dimensionCountDy);
            }
            catch (Exception ex) {
                LOGGER.error("AnalyseObjectDimCountTask DimCount Error: ", (Throwable)ex);
            }
        }
        LOGGER.info("AnalyseObjectDimCountTask handledTableAndDimCountMap count : {}", (Object)handledTableAndDimCountMap.size());
        LOGGER.info("AnalyseObjectDimCountTask handledTableAndDimCountMap keys: {}", handledTableAndDimCountMap.keySet());
        for (Map.Entry entry : baseDataParamMap.entrySet()) {
            try {
                if (handledTableAndDimCountMap.containsKey(entry.getKey())) continue;
                dimService.getDimensionCountDy((Map)entry.getValue());
            }
            catch (Exception ex) {
                LOGGER.error("AnalyseObjectDimCountTask BaseData Error basedata:{}", entry.getValue(), (Object)ex);
            }
        }
        LOGGER.info("AnalyseObjectDimCountTask baseDataParamMap count : {}", (Object)baseDataParamMap.size());
        LOGGER.info("AnalyseObjectDimCountTask baseDataParamMap keys: {}", baseDataParamMap.keySet());
        try {
            this.updateAnObjEntityIdCount(anObjId, mainEntityTypeUtil);
        }
        catch (Exception ex) {
            LOGGER.error("AnalyseObjectDimCountTask ID Count Error: ", (Throwable)ex);
        }
        queryFieldHelper.save(queryFields);
    }

    private void updateAnObjEntityIdCount(String anObjId, MainEntityTypeUtil mainEntityTypeUtil) {
        DynamicObjectCollection entityDys;
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrptmc_anobjjoinentity");
        String props = "id, entitynumber, anobj";
        if (anObjId == null) {
            entityDys = joinEntityHelper.queryOriginalCollection(props, new QFilter[0]);
        } else {
            QFilter qFilter = new QFilter("anobj", "=", (Object)Long.valueOf(anObjId));
            entityDys = joinEntityHelper.queryOriginalCollection(props, new QFilter[]{qFilter});
        }
        Set entityNumbers = entityDys.stream().map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        HashMap tableToIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap tableToDbRouteMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet tableNames = Sets.newHashSetWithExpectedSize((int)16);
        HashSet idNames = Sets.newHashSetWithExpectedSize((int)16);
        for (String entityNumber : entityNumbers) {
            try {
                MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
                String tableName2 = dataEntityType.getAlias();
                tableNames.add(tableName2);
                String idName2 = dataEntityType.getPrimaryKey().getAlias();
                idNames.add(idName2);
                tableToIdMap.put(tableName2, idName2);
                tableToDbRouteMap.put(tableName2, dataEntityType.getDBRouteKey());
            }
            catch (Exception ex) {
                LOGGER.error("AnalyseObjectDimCountTask updateAnObjEntityIdCount Error: ", (Throwable)ex);
            }
        }
        AnalyseDimCountService dimService = new AnalyseDimCountService();
        HRBaseServiceHelper dimCountHelper = new HRBaseServiceHelper("hrptmc_dimcount");
        QFilter tableQFilter = new QFilter("tablename", "in", (Object)tableNames);
        QFilter fieldQFilter = new QFilter("fieldname", "in", (Object)idNames);
        DynamicObject[] dynamicObjects = dimCountHelper.query("tablename, fieldname, dimcount, isbigdatatable", new QFilter[]{tableQFilter, fieldQFilter});
        DynamicObjectCollection dimCountCol = Arrays.stream(dynamicObjects).collect(Collectors.toCollection(DynamicObjectCollection::new));
        DynamicObjectCollection newDimCountCol = new DynamicObjectCollection();
        LOGGER.error("AnalyseObjectDimCountTask updateAnObjEntityIdCount tableToIdMap count: {}", (Object)tableToIdMap.size());
        LOGGER.error("AnalyseObjectDimCountTask updateAnObjEntityIdCount tableToIdMap: {}", (Object)tableToIdMap);
        tableToIdMap.forEach((tableName, idName) -> {
            try {
                Optional<DynamicObject> dimCountOp = dimCountCol.stream().filter(dy -> HRStringUtils.equals((String)tableName, (String)dy.getString("tablename")) && HRStringUtils.equals((String)idName, (String)dy.getString("fieldname"))).findAny();
                String dbRoute = (String)tableToDbRouteMap.get(tableName);
                if (dimCountOp.isPresent()) {
                    dimCountOp.get().set("dimcount", (Object)dimService.getTableIdCount((String)tableName, dbRoute));
                } else {
                    DynamicObject newDy = dimCountHelper.generateEmptyDynamicObject();
                    newDy.set("tablename", tableName);
                    newDy.set("fieldname", idName);
                    newDy.set("dimcount", (Object)dimService.getTableIdCount((String)tableName, dbRoute));
                    newDimCountCol.add((Object)newDy);
                }
            }
            catch (Exception ex) {
                LOGGER.error("AnalyseObjectDimCountTask getTableIdCount Error: ", (Throwable)ex);
            }
        });
        dimCountHelper.save(dimCountCol);
        dimCountHelper.save(newDimCountCol);
    }
}

