/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj.virtualentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceAppBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceEntityBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.constant.anobj.VirtualEntityConstants;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class VirtualEntityService
implements VirtualEntityConstants {
    private static final Log LOGGER = LogFactory.getLog(VirtualEntityService.class);
    private final HRBaseServiceHelper virtualEntityHelper = new HRBaseServiceHelper("hrptmc_virtualentity");
    private static volatile VirtualEntityService service = null;

    private VirtualEntityService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VirtualEntityService getInstance() {
        if (service != null) return service;
        Class<VirtualEntityService> clazz = VirtualEntityService.class;
        synchronized (VirtualEntityService.class) {
            if (service != null) return service;
            service = new VirtualEntityService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public Map<Long, Boolean> virtualEntityFieldsIsRefByAnaObj(String virtualEntityNumber, List<Long> virtualFieldIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        VirtualEntityInfo virtualEntityInfo = VirtualEntityService.getInstance().queryAndAssembleVirtualEntity(virtualEntityNumber, new StringBuilder());
        List fieldInfoList = virtualEntityInfo.getFieldInfoList();
        Map<String, Long> virtualFieldMap = fieldInfoList.stream().filter(field -> virtualFieldIds.contains(field.getId())).collect(Collectors.toMap(VirtualFieldInfo::getNumber, VirtualFieldInfo::getId));
        QFilter qFilter1 = new QFilter("entitynumber", "=", (Object)virtualEntityNumber);
        QFilter qFilter2 = new QFilter("fieldalias", "in", virtualFieldMap.keySet());
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
        DynamicObjectCollection fieldDys = queryFieldHelper.queryOriginalCollection("fieldalias", new QFilter[]{qFilter1, qFilter2});
        Set refFieldAlias = fieldDys.stream().map(dy -> dy.getString("fieldalias")).collect(Collectors.toSet());
        virtualFieldMap.forEach((fieldAlias, virtualFieldId) -> result.put(virtualFieldId, refFieldAlias.contains(fieldAlias)));
        return result;
    }

    public Set<String> getRefByAnObjVirtualEntityIds(List<String> virtualEntityNumbers) {
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrptmc_anobjjoinentity");
        DynamicObjectCollection virtualEntityNumCol = joinEntityHelper.queryOriginalCollection("entitynumber", new QFilter[]{new QFilter("entitynumber", "in", virtualEntityNumbers)});
        return virtualEntityNumCol.stream().map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
    }

    public FieldTreeNode buildVirtualEntityFields(JoinEntityBo virtualEntityBo, List<QueryFieldBo> queryFields, Set<String> refByReportFieldAliasList) {
        Map<String, QueryFieldBo> queryFieldMap = queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        DynamicObject virtualEntityDy = VirtualEntityService.getInstance().queryVirtualEntity(virtualEntityBo.getEntityNumber());
        LocaleString entityName = AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)virtualEntityDy.getLocaleString("name")));
        String entityNumber = virtualEntityDy.getString("number");
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        FieldTreeNode fieldTreeNode = new FieldTreeNode(entityName, "", virtualEntityDy.getString("number"), false, false);
        DynamicObjectCollection virtualFields = virtualEntityDy.getDynamicObjectCollection("virtualfields");
        Set<String> allVirtualFieldAliasSet = virtualFields.stream().map(field -> field.getString("fieldnumber")).collect(Collectors.toSet());
        ArrayList secondNodes = Lists.newArrayListWithCapacity((int)10);
        virtualFields.stream().filter(field -> field.getDynamicObject("group") != null).map(field -> field.getDynamicObject("group")).forEach(group -> {
            if (secondNodes.stream().anyMatch(node -> HRStringUtils.equals((String)node.getNumber(), (String)group.getString("number")))) {
                return;
            }
            FieldTreeNode groupNode = new FieldTreeNode(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)group.getLocaleString("name"))), "", group.getString("number"), false, false);
            secondNodes.add(groupNode);
        });
        Map<String, List<DynamicObject>> hasGroupSubFieldMap = virtualFields.stream().filter(field -> field.getDynamicObject("group") != null).collect(Collectors.groupingBy(field -> field.getDynamicObject("group").getString("number")));
        for (FieldTreeNode secondNode : secondNodes) {
            String number = secondNode.getNumber();
            List<DynamicObject> fieldDys = hasGroupSubFieldMap.get(number);
            if (fieldDys == null) continue;
            for (DynamicObject fieldDy : fieldDys) {
                FieldTreeNode fieldNode = this.setVirtualEntityFieldValue(fieldDy, entityNumber, entityName.getLocaleValue(), queryFieldMap, refByReportFieldAliasList, entityTypeUtil);
                secondNode.getChildren().add(fieldNode);
            }
        }
        List<DynamicObject> noGroupFields = virtualFields.stream().filter(field -> field.getDynamicObject("group") == null).collect(Collectors.toList());
        this.buildVirtualBaseDataFields(allVirtualFieldAliasSet, noGroupFields, entityNumber, entityName, queryFieldMap, refByReportFieldAliasList, secondNodes, entityTypeUtil);
        fieldTreeNode.setChildren((List)secondNodes);
        return fieldTreeNode;
    }

    private void buildVirtualBaseDataFields(Set<String> allVirtualFieldAliasSet, List<DynamicObject> virtualFields, String entityNumber, LocaleString entityName, Map<String, QueryFieldBo> queryFieldMap, Set<String> refByReportFieldAliasList, List<FieldTreeNode> secondNodes, MainEntityTypeUtil entityTypeUtil) {
        ArrayList fieldNodes = Lists.newArrayListWithExpectedSize((int)virtualFields.size());
        for (DynamicObject virtualField : virtualFields) {
            FieldTreeNode fieldNode = this.setVirtualEntityFieldValue(virtualField, entityNumber, entityName.getLocaleValue(), queryFieldMap, refByReportFieldAliasList, entityTypeUtil);
            fieldNodes.add(fieldNode);
        }
        Map baseDataFieldMap = fieldNodes.stream().filter(field -> AnalyseObjectUtil.isBaseDataType((String)field.getComplexType())).collect(Collectors.toMap(FieldTreeNode::getFieldAlias, Function.identity()));
        baseDataFieldMap.forEach((fieldAlias, baseDataField) -> {
            if (fieldAlias.endsWith(".id")) {
                return;
            }
            String idAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(".")) + ".id";
            String fieldPath = baseDataField.getFieldPath();
            String idPath = fieldPath.substring(0, fieldPath.lastIndexOf(".")) + ".id";
            if (allVirtualFieldAliasSet.contains(idAlias)) {
                return;
            }
            FieldTreeNode fieldNode = new FieldTreeNode(entityName.getLocaleValue(), entityNumber, new LocaleString(idAlias), idAlias, idAlias, idPath, null, Boolean.FALSE, Boolean.FALSE, "");
            fieldNode.setControlType(baseDataField.getControlType());
            fieldNode.setComplexType(baseDataField.getComplexType());
            fieldNodes.add(fieldNode);
        });
        baseDataFieldMap = fieldNodes.stream().filter(field -> AnalyseObjectUtil.isBaseDataType((String)field.getComplexType())).collect(Collectors.toMap(FieldTreeNode::getFieldAlias, Function.identity()));
        List idFields = fieldNodes.stream().filter(field -> field.getFieldAlias().endsWith(".id")).collect(Collectors.toList());
        for (FieldTreeNode idField : idFields) {
            String suffixPath = idField.getFieldPath().substring(0, idField.getFieldPath().lastIndexOf(".") + 1);
            baseDataFieldMap.forEach((fieldAlias, baseDataField) -> {
                String fieldPath = baseDataField.getFieldPath();
                String baseDataSuffixPath = fieldPath.substring(0, fieldPath.lastIndexOf(".") + 1);
                if (!HRStringUtils.equals((String)fieldPath, (String)idField.getFieldPath()) && HRStringUtils.equals((String)baseDataSuffixPath, (String)suffixPath)) {
                    baseDataField.setChild(Boolean.valueOf(true));
                    idField.getChildren().add(baseDataField);
                }
            });
        }
        secondNodes.addAll(baseDataFieldMap.values().stream().filter(field -> field.getChild() == false).collect(Collectors.toList()));
        secondNodes.addAll(fieldNodes.stream().filter(field -> !AnalyseObjectUtil.isBaseDataType((String)field.getComplexType())).collect(Collectors.toList()));
    }

    private FieldTreeNode setVirtualEntityFieldValue(DynamicObject field, String entityNumber, String entityName, Map<String, QueryFieldBo> queryFieldMap, Set<String> refByReportFieldAliasList, MainEntityTypeUtil entityTypeUtil) {
        String fieldPath;
        LocaleString name = AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)field.getLocaleString("fieldname")));
        FieldTreeNode fieldNode = new FieldTreeNode(entityName, entityNumber, name, field.getString("fieldnumber"), field.getString("fieldnumber"), field.getString("fieldpath"), field.getString("fieldvaluetype"), Boolean.FALSE, Boolean.FALSE, "");
        fieldNode.setControlType(field.getString("controltype"));
        fieldNode.setComplexType(field.getString("complextype"));
        QueryFieldBo queryFieldBo = queryFieldMap.get(field.getString("fieldnumber"));
        if (queryFieldBo != null) {
            fieldNode.setSelected(Boolean.TRUE);
            fieldNode.setName(queryFieldBo.getFieldName());
            fieldNode.setDisabled(Boolean.valueOf(refByReportFieldAliasList.contains(queryFieldBo.getFieldAlias())));
        }
        if (HRStringUtils.isEmpty((String)(fieldPath = fieldNode.getFieldPath()))) {
            return fieldNode;
        }
        String entityNum = fieldPath.substring(0, fieldPath.indexOf(46));
        if (AnalyseObjectUtil.isBaseDataType((String)fieldNode.getComplexType())) {
            String baseDataNum = AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)entityNum, (String)fieldPath, (MainEntityTypeUtil)entityTypeUtil);
            fieldNode.setBaseDataNum(baseDataNum);
        }
        if (AnalyseObjectUtil.isEnumType((String)fieldNode.getControlType())) {
            if (HRStringUtils.isNotEmpty((String)fieldNode.getBaseDataNum())) {
                fieldNode.setEnumEntityNum(fieldNode.getBaseDataNum());
            } else {
                fieldNode.setEnumEntityNum(entityNum);
            }
        }
        return fieldNode;
    }

    public List<DataSourceAppBo> getVirtualEntitiesDataSource() {
        ArrayList dataSourceAppBoList = Lists.newArrayListWithCapacity((int)10);
        DynamicObject[] virtualEntities = this.queryAllVirtualEntities();
        if (virtualEntities.length == 0) {
            return dataSourceAppBoList;
        }
        Map<String, String> businessFieldMap = Arrays.stream(virtualEntities).filter(entity -> entity.getDynamicObject("cloud") != null).map(entity -> entity.getDynamicObject("cloud")).collect(Collectors.toMap(entity -> entity.getString("number"), entity -> entity.getString("name"), (k1, k2) -> k1));
        Map<String, List<DynamicObject>> virtualEntityMap = Arrays.stream(virtualEntities).filter(entity -> entity.getDynamicObject("cloud") != null).collect(Collectors.groupingBy(entity -> entity.getDynamicObject("cloud").getString("number")));
        virtualEntityMap.forEach((businessFieldNum, entityList) -> {
            String businessFieldName = (String)businessFieldMap.get(businessFieldNum);
            DataSourceAppBo dataSourceAppBo = new DataSourceAppBo();
            dataSourceAppBo.setKey("##businessField##_" + businessFieldNum);
            dataSourceAppBo.setTitle(businessFieldName);
            dataSourceAppBoList.add(dataSourceAppBo);
            ArrayList dataSourceEntityBos = Lists.newArrayListWithExpectedSize((int)virtualEntities.length);
            for (DynamicObject virtualEntity : entityList) {
                DataSourceEntityBo entityBo = new DataSourceEntityBo();
                entityBo.setKey(virtualEntity.getString("number"));
                entityBo.setTitle(virtualEntity.getString("name"));
                entityBo.setVirtualEntity(true);
                dataSourceEntityBos.add(entityBo);
            }
            dataSourceAppBo.setChildren((List)dataSourceEntityBos);
        });
        return dataSourceAppBoList;
    }

    public DynamicObject[] queryAllVirtualEntities() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_virtualentity");
        return helper.query("name, number, cloud", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")});
    }

    public DynamicObject queryVirtualEntity(String entityNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_virtualentity");
        return helper.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)entityNumber)});
    }

    public DynamicObject queryVirtualEntity(Long anObjId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjjoinentity");
        DynamicObject queryEntityDy = helper.queryOriginalOne("entitynumber", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        return this.virtualEntityHelper.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)queryEntityDy.getString("entitynumber"))});
    }

    public VirtualEntityInfo queryAndAssembleVirtualEntityByAnObj(Long anObjId, StringBuilder servicePath) {
        DynamicObject virtualEntityDy = this.queryVirtualEntity(anObjId);
        servicePath.append(virtualEntityDy.getDynamicObject("classpath") != null ? virtualEntityDy.getDynamicObject("classpath").getString("classname") : "");
        return this.assembleVirtualEntity(virtualEntityDy);
    }

    public VirtualEntityInfo queryAndAssembleVirtualEntity(String virtualEntityNumber, StringBuilder servicePath) {
        DynamicObject virtualEntityDy = this.virtualEntityHelper.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)virtualEntityNumber)});
        servicePath.append(virtualEntityDy.getDynamicObject("classpath") != null ? virtualEntityDy.getDynamicObject("classpath").getString("classname") : "");
        return this.assembleVirtualEntity(virtualEntityDy);
    }

    private VirtualEntityInfo assembleVirtualEntity(DynamicObject virtualEntityDy) {
        VirtualEntityInfo virtualEntityInfo = new VirtualEntityInfo(Long.valueOf(virtualEntityDy.getLong("id")), virtualEntityDy.getString("number"), virtualEntityDy.getLocaleString("name").getLocaleValue());
        if (virtualEntityDy.getDynamicObject("cloud") != null) {
            virtualEntityInfo.setBusinessDomainId(virtualEntityDy.getDynamicObject("cloud").getString("id"));
        }
        ArrayList fieldInfoList = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection fieldEntry = virtualEntityDy.getDynamicObjectCollection("virtualfields");
        virtualEntityInfo.setSummaryQueryByBatch(virtualEntityDy.getDynamicObject("classpath") != null ? virtualEntityDy.getDynamicObject("classpath").getBoolean("summaryquerybybatch") : false);
        for (DynamicObject fieldDy : fieldEntry) {
            VirtualFieldInfo fieldInfo = new VirtualFieldInfo(Long.valueOf(fieldDy.getLong("id")), fieldDy.getString("fieldnumber"), fieldDy.getLocaleString("fieldname").getLocaleValue());
            fieldInfo.setFieldPath(fieldDy.getString("fieldpath"));
            fieldInfo.setFieldValueType(DataTypeEnum.of((String)fieldDy.getString("fieldvaluetype")));
            fieldInfo.setComplexType(FieldComplexType.getEnum((String)fieldDy.getString("complextype")));
            fieldInfo.setControlType(FieldControlType.getFieldControlTypeByValue((String)fieldDy.getString("controltype")));
            fieldInfo.setCommonField(fieldDy.getBoolean("iscommonfield"));
            fieldInfoList.add(fieldInfo);
        }
        virtualEntityInfo.setFieldInfoList((List)fieldInfoList);
        return virtualEntityInfo;
    }
}

