/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.bizopen.queryservice;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.bizopen.dto.OpenAdminOrgSummaryInfoBo;
import kd.hr.hrptmc.business.bizopen.dto.OpenReportFieldBo;
import kd.hr.hrptmc.business.bizopen.dto.OpenReportQueryInfoBo;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class OpenReportQueryDataService
implements ReportManageConstants {
    private static final Log logger = LogFactory.getLog(OpenReportQueryDataService.class);
    private static final List<String> INDEX_TYPE_LIST = Arrays.asList(DataTypeEnum.INTEGER.getDataTypeKey(), DataTypeEnum.LONG.getDataTypeKey(), DataTypeEnum.BIGDECIMAL.getDataTypeKey());

    public ReportResult queryData4Summary(OpenReportQueryInfoBo openReportQueryInfoBo) {
        ReportResult reportResult;
        long beginTime = System.currentTimeMillis();
        logger.info("OpenReportQueryDataService.queryData4Summary, anObjId : {} , begin : {}", (Object)openReportQueryInfoBo.getAnObjId(), (Object)System.currentTimeMillis());
        try {
            ReportQueryParamInfo reportQueryParamInfo = this.assembleReportQueryParamInfo(openReportQueryInfoBo);
            Class<?> reportQueryUtilClass = Class.forName("kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil");
            Method queryData4SummaryMethod = reportQueryUtilClass.getDeclaredMethod("queryData4Summary", ReportQueryParamInfo.class);
            reportResult = (ReportResult)queryData4SummaryMethod.invoke(null, reportQueryParamInfo);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6HR\u62a5\u8868\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"OpenReportQueryDataService_queryData", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        logger.info("OpenReportQueryDataService.queryData4Summary, anObjId : {} , cost : {}", (Object)openReportQueryInfoBo.getAnObjId(), (Object)(System.currentTimeMillis() - beginTime));
        return reportResult;
    }

    public ReportResult queryData4Detail(OpenReportQueryInfoBo openReportQueryInfoBo) {
        ReportResult reportResult;
        long beginTime = System.currentTimeMillis();
        logger.info("OpenReportQueryDataService.queryData4Detail, anObjId : {} , begin : {}", (Object)openReportQueryInfoBo.getAnObjId(), (Object)beginTime);
        try {
            ReportQueryParamInfo reportQueryParamInfo = this.assembleReportQueryParamInfo(openReportQueryInfoBo);
            Class<?> reportQueryUtilClass = Class.forName("kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil");
            Method queryData4DetailMethod = reportQueryUtilClass.getDeclaredMethod("queryData4Detail", ReportQueryParamInfo.class);
            reportResult = (ReportResult)queryData4DetailMethod.invoke(null, reportQueryParamInfo);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6HR\u62a5\u8868\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"OpenReportQueryDataService_queryData", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        logger.info("OpenReportQueryDataService.queryData4Detail, anObjId : {} , cost : {}", (Object)openReportQueryInfoBo.getAnObjId(), (Object)(System.currentTimeMillis() - beginTime));
        return reportResult;
    }

    private ReportQueryParamInfo assembleReportQueryParamInfo(OpenReportQueryInfoBo openReportQueryInfoBo) {
        ReportQueryParamInfo reportQueryParamInfo;
        try {
            logger.info("assembleReportQueryParamInfo for anObjId:{} begin ,current time:{}", (Object)openReportQueryInfoBo.getAnObjId(), (Object)System.currentTimeMillis());
            ReportManageConfigInfo reportManageConfigInfo = this.assembleReportManageConfigInfo(openReportQueryInfoBo.getAnObjId());
            WorkRptInfo workRptInfo = this.assembleWorkRptInfo(reportManageConfigInfo, openReportQueryInfoBo.getReportType());
            reportQueryParamInfo = new ReportQueryParamInfo(reportManageConfigInfo);
            reportQueryParamInfo.setReportManageConfigInfo(reportManageConfigInfo);
            reportQueryParamInfo.setStart(openReportQueryInfoBo.getBegin());
            reportQueryParamInfo.setLimit(openReportQueryInfoBo.getEnd());
            reportQueryParamInfo.setWhereQFilter(openReportQueryInfoBo.getWhereQFilter());
            reportQueryParamInfo.setOnQFilter(openReportQueryInfoBo.getOnQFilter());
            if ("0".equals(openReportQueryInfoBo.getReportType())) {
                AdminOrgSummaryInfo adminOrgSummaryInfo = OpenReportQueryDataService.assembleAdminOrgSummaryInfo(openReportQueryInfoBo.getOpenAdminOrgSummaryInfoBo());
                reportQueryParamInfo.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
            }
            List<Long> refFieldIdList = openReportQueryInfoBo.getOpenReportFieldBoList().stream().map(OpenReportFieldBo::getRefFieldId).collect(Collectors.toList());
            List<QueryFieldBo> queryFieldBoList = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(refFieldIdList);
            List<CalculateFieldBo> anObjCalculateFieldList = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(openReportQueryInfoBo.getAnObjId(), false);
            List<CalculateFieldBo> calculateFieldBoList = anObjCalculateFieldList.stream().filter(calculateFieldBo -> refFieldIdList.contains(Long.parseLong(calculateFieldBo.getId()))).collect(Collectors.toList());
            List<AnObjGroupField> anObjGroupFieldList = this.getOpenAnObjGroupFields(openReportQueryInfoBo.getAnObjId(), queryFieldBoList, refFieldIdList);
            List<RowFieldInfo> rowFieldInfoList = this.buildRowFieldInfoList(queryFieldBoList, calculateFieldBoList, anObjGroupFieldList, openReportQueryInfoBo.getOpenReportFieldBoList());
            workRptInfo.setRows(rowFieldInfoList);
            logger.info("assembleReportQueryParamInfo for anObjId:{} end  ,current time:{}", (Object)openReportQueryInfoBo.getAnObjId(), (Object)System.currentTimeMillis());
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6HR\u62a5\u8868\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"OpenReportQueryDataService_queryData", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        return reportQueryParamInfo;
    }

    private ReportManageConfigInfo assembleReportManageConfigInfo(Long anObjId) throws Exception {
        ReportManageConfigInfo reportManageConfigInfo = new ReportManageConfigInfo();
        Class<?> rptAnObjUtilClass = Class.forName("kd.hr.hrptmc.formplugin.web.repdesign.util.RptAnObjUtil");
        Method getAnObjDetailMethod = rptAnObjUtilClass.getDeclaredMethod("getAnObjDetail", Long.class);
        AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)getAnObjDetailMethod.invoke(null, anObjId);
        reportManageConfigInfo.setAssignObj(anObjDetailInfo);
        return reportManageConfigInfo;
    }

    private WorkRptInfo assembleWorkRptInfo(ReportManageConfigInfo reportManageConfigInfo, String reportType) {
        WorkRptInfo workRptInfo = new WorkRptInfo();
        workRptInfo.setShow(true);
        workRptInfo.setWorkRptId(String.valueOf(ORM.create().genLongId("hrptmc_workreport")));
        ReportConfigInfo reportConfigInfo = new ReportConfigInfo(reportType);
        workRptInfo.setReportConfig(reportConfigInfo);
        ArrayList<WorkRptInfo> workRptInfoList = new ArrayList<WorkRptInfo>(1);
        workRptInfoList.add(workRptInfo);
        reportManageConfigInfo.setWorkRpt(workRptInfoList);
        return workRptInfo;
    }

    private List<AnObjGroupField> getOpenAnObjGroupFields(Long anObjId, List<QueryFieldBo> queryFieldBoList, List<Long> refFieldIdList) {
        List<AnObjGroupField> anObjGroupFields = AnObjGroupFieldService.getInstance().getGroupFields(anObjId, queryFieldBoList);
        return anObjGroupFields.stream().filter(anObjGroupField -> refFieldIdList.contains(Long.parseLong(anObjGroupField.getId()))).collect(Collectors.toList());
    }

    private List<RowFieldInfo> buildRowFieldInfoList(List<QueryFieldBo> queryFieldList, List<CalculateFieldBo> calculateFieldList, List<AnObjGroupField> anObjGroupFieldList, List<OpenReportFieldBo> openReportFieldBoList) {
        Map<Long, OpenReportFieldBo> openReportFieldBoMap = openReportFieldBoList.stream().collect(Collectors.toMap(OpenReportFieldBo::getRefFieldId, openReportFieldBo -> openReportFieldBo));
        ArrayList rowFieldInfoList = Lists.newArrayListWithCapacity((int)10);
        this.assembleQueryFieldBoToRowFieldList(queryFieldList, rowFieldInfoList, openReportFieldBoMap);
        this.assembleCalculateFieldBoToRowFieldList(calculateFieldList, rowFieldInfoList, openReportFieldBoMap);
        this.assembleAnObjGroupFieldToRowFieldList(anObjGroupFieldList, rowFieldInfoList);
        return rowFieldInfoList;
    }

    private void assembleAnObjGroupFieldToRowFieldList(List<AnObjGroupField> anObjGroupFieldList, List<RowFieldInfo> rowFieldInfoList) {
        if (anObjGroupFieldList != null) {
            for (AnObjGroupField anObjGroupField : anObjGroupFieldList) {
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setName(anObjGroupField.getName());
                fieldInfo.setDisplayName(anObjGroupField.getName());
                fieldInfo.setNumber(anObjGroupField.getNumber());
                fieldInfo.setNumberAlias(anObjGroupField.getNumber());
                fieldInfo.setFieldPath(anObjGroupField.getNumber());
                fieldInfo.setGroupField(true);
                fieldInfo.setGroupFieldId(anObjGroupField.getId());
                fieldInfo.setCalculateField("true");
                fieldInfo.setValueType(DataTypeEnum.STRING.name());
                fieldInfo.setType("1");
                fieldInfo.setFieldSrc("1");
                RowFieldInfo rowfieldInfo = new RowFieldInfo(fieldInfo);
                rowFieldInfoList.add(rowfieldInfo);
            }
        }
    }

    private void assembleCalculateFieldBoToRowFieldList(List<CalculateFieldBo> calculateFieldList, List<RowFieldInfo> rowFieldInfoList, Map<Long, OpenReportFieldBo> openReportFieldBoMap) {
        if (calculateFieldList != null) {
            for (CalculateFieldBo calculateField : calculateFieldList) {
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setFieldId(calculateField.getId());
                fieldInfo.setName(calculateField.getFieldName());
                fieldInfo.setDisplayName(calculateField.getFieldName());
                fieldInfo.setNumber(calculateField.getFieldNumber());
                fieldInfo.setNumberAlias(calculateField.getFieldNumber());
                if (OpenReportQueryDataService.isIndex(calculateField.getValueType())) {
                    fieldInfo.setType("2");
                } else {
                    fieldInfo.setType("1");
                }
                fieldInfo.setValueType(calculateField.getValueType());
                fieldInfo.setFieldSrc("1");
                fieldInfo.setControlType(calculateField.getControlType());
                OpenReportFieldBo openReportFieldBo = openReportFieldBoMap.get(Long.parseLong(calculateField.getId()));
                fieldInfo.setSort(openReportFieldBo.getSort());
                if (openReportFieldBo.getAlgorithm() != null) {
                    fieldInfo.setAlgorithm(openReportFieldBo.getAlgorithm());
                } else {
                    fieldInfo.setAlgorithm("sum");
                }
                fieldInfo.setCalculateField("true");
                RowFieldInfo rowfieldInfo = new RowFieldInfo(fieldInfo);
                rowFieldInfoList.add(rowfieldInfo);
            }
        }
    }

    private void assembleQueryFieldBoToRowFieldList(List<QueryFieldBo> queryFieldList, List<RowFieldInfo> rowFieldInfoList, Map<Long, OpenReportFieldBo> openReportFieldBoMap) {
        if (queryFieldList != null) {
            for (QueryFieldBo queryField : queryFieldList) {
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setFieldId(queryField.getId());
                fieldInfo.setName(queryField.getFieldName());
                fieldInfo.setDisplayName(queryField.getFieldName());
                fieldInfo.setNumber(queryField.getFieldAlias());
                fieldInfo.setEntityNumber(queryField.getEntityNumber());
                fieldInfo.setFieldPath(queryField.getFieldPath());
                fieldInfo.setNumberAlias(queryField.getFieldAlias());
                fieldInfo.setBaseDataNum(queryField.getBaseDataNum());
                if (OpenReportQueryDataService.isIndex(queryField.getValueType())) {
                    fieldInfo.setType("2");
                } else {
                    fieldInfo.setType("1");
                }
                fieldInfo.setValueType(queryField.getValueType());
                fieldInfo.setComplexType(queryField.getComplexType());
                fieldInfo.setControlType(queryField.getControlType());
                fieldInfo.setFieldSrc("0");
                OpenReportFieldBo openReportFieldBo = openReportFieldBoMap.get(Long.parseLong(queryField.getId()));
                if (openReportFieldBo.getSort() != null) {
                    fieldInfo.setSort(openReportFieldBo.getSort());
                } else {
                    fieldInfo.setSort(SortEnum.ASC.getValue());
                }
                fieldInfo.setCalculateField("false");
                RowFieldInfo rowfieldInfo = new RowFieldInfo(fieldInfo);
                rowFieldInfoList.add(rowfieldInfo);
            }
        }
    }

    private static AdminOrgSummaryInfo assembleAdminOrgSummaryInfo(OpenAdminOrgSummaryInfoBo openAdminOrgSummaryInfoBo) {
        AdminOrgSummaryInfo adminOrgSummaryInfo = new AdminOrgSummaryInfo();
        if (openAdminOrgSummaryInfoBo == null) {
            return adminOrgSummaryInfo;
        }
        adminOrgSummaryInfo.setAdminOrgFieldAlias(openAdminOrgSummaryInfoBo.getAdminOrgFieldAlias());
        adminOrgSummaryInfo.setAdminOrgIds(openAdminOrgSummaryInfoBo.getAdminOrgIds());
        adminOrgSummaryInfo.setAdminOrgFieldFullPath(openAdminOrgSummaryInfoBo.getAdminOrgFieldFullPath());
        adminOrgSummaryInfo.setIncludeSubOrg(openAdminOrgSummaryInfoBo.isIncludeSubOrg());
        adminOrgSummaryInfo.setSummaryLevel(openAdminOrgSummaryInfoBo.getSummaryLevel());
        adminOrgSummaryInfo.setAdmOrgArchitectureId(openAdminOrgSummaryInfoBo.getAdmOrgArchitectureId());
        adminOrgSummaryInfo.setDate(openAdminOrgSummaryInfoBo.getDate());
        adminOrgSummaryInfo.setInsertCache(false);
        return adminOrgSummaryInfo;
    }

    private static boolean isIndex(String valueType) {
        return INDEX_TYPE_LIST.contains(valueType);
    }
}

