/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.calfield;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.service.function.FunctionSubPageService;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.constant.calfield.CalculateFieldConstants;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.util.ReportComplexObjTransferUtil;

public class CalculateDataUpdateTask
extends AbstractTask
implements CalculateFieldConstants,
AnalyseObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(CalculateDataUpdateTask.class);

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean bl;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_calculatefield");
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
        QFilter qFilter = new QFilter("viewexpr", "is null", null);
        DynamicObject[] calculateFields = helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (calculateFields.length == 0) {
            this.deleteSchedule();
            return;
        }
        HashMap anObjIdCalculateMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(calculateFields).filter(calField -> HRStringUtils.equals((String)calField.getString("source"), (String)"anobj")).forEach(calField -> {
            DynamicObject anObjDy = calField.getDynamicObject("anobj");
            if (anObjDy == null) {
                return;
            }
            long anObjId = anObjDy.getLong("id");
            List calFieldList = anObjIdCalculateMap.getOrDefault(anObjId, Lists.newArrayListWithCapacity((int)10));
            calFieldList.add(calField);
            anObjIdCalculateMap.putIfAbsent(anObjId, calFieldList);
        });
        Arrays.stream(calculateFields).filter(calField -> HRStringUtils.equals((String)calField.getString("source"), (String)"report")).forEach(calField -> {
            DynamicObject reportDy = calField.getDynamicObject("report");
            if (reportDy == null) {
                return;
            }
            DynamicObject anObjDy = reportDy.getDynamicObject("anobjid");
            if (anObjDy == null) {
                return;
            }
            long anObjId = anObjDy.getLong("id");
            List calFieldList = anObjIdCalculateMap.getOrDefault(anObjId, Lists.newArrayListWithCapacity((int)10));
            calFieldList.add(calField);
            anObjIdCalculateMap.putIfAbsent(anObjId, calFieldList);
        });
        DynamicObjectCollection updateCalculates = new DynamicObjectCollection();
        for (Map.Entry<Long, List<DynamicObject>> entry : anObjIdCalculateMap.entrySet()) {
            this.parseCalculateFields(entry, updateCalculates);
        }
        this.updateRefFields(updateCalculates);
        DynamicObjectCollection newFieldDyCol = this.getUpdateQueryFields(anObjIdCalculateMap);
        boolean bl2 = true;
        try (TXHandle required = TX.required();){
            try {
                helper.save(updateCalculates);
                queryFieldHelper.save(newFieldDyCol);
            }
            catch (Exception ex) {
                bl = false;
                required.markRollback();
                LOGGER.error(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25", (String)"CalculateDataUpdateTask_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), (Throwable)ex);
            }
        }
        if (bl) {
            this.deleteSchedule();
        }
    }

    private void parseCalculateFields(Map.Entry<Long, List<DynamicObject>> calculateEntry, DynamicObjectCollection updateCalculates) {
        try {
            Long anObjId = calculateEntry.getKey();
            List<QueryFieldBo> queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
            Map<String, QueryFieldBo> queryFieldMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
            List<DynamicObject> calFieldList = calculateEntry.getValue();
            for (DynamicObject calFieldDy : calFieldList) {
                try {
                    DynamicObjectCollection refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
                    if (refFieldEntry.isEmpty()) {
                        calFieldDy.set("viewexpr", (Object)calFieldDy.getString("expr"));
                        updateCalculates.add((Object)calFieldDy);
                        continue;
                    }
                    String parsedExpr = calFieldDy.getString("expr");
                    HashMap varMap = Maps.newHashMapWithExpectedSize((int)16);
                    this.fillVarMap(parsedExpr, varMap);
                    HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
                    HashMap baseDataNameOrNumMap = Maps.newHashMapWithExpectedSize((int)16);
                    HashMap enumEntityNumMap = Maps.newHashMapWithExpectedSize((int)16);
                    HashSet refFieldNums = Sets.newHashSetWithExpectedSize((int)16);
                    for (DynamicObject refFieldDy : refFieldEntry) {
                        String refFieldAlias;
                        QueryFieldBo queryFieldBo;
                        String refType = refFieldDy.getString("reftype");
                        if (!HRStringUtils.equals((String)refType, (String)"entityfield") || (queryFieldBo = queryFieldMap.get(refFieldAlias = refFieldDy.getString("reffieldalias"))) == null) continue;
                        refFieldNums.add(refFieldAlias);
                        if (AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType())) {
                            baseDataMap.put("$" + refFieldAlias + "$", queryFieldBo.getBaseDataNum());
                            if (refFieldAlias.endsWith(".name")) {
                                baseDataNameOrNumMap.put("$" + refFieldAlias + "$", "name");
                            } else if (refFieldAlias.endsWith(".number")) {
                                baseDataNameOrNumMap.put("$" + refFieldAlias + "$", "number");
                            }
                        }
                        if (!HRStringUtils.equals((String)queryFieldBo.getControlType(), (String)FieldControlType.COMBO.getValue()) && !HRStringUtils.equals((String)queryFieldBo.getControlType(), (String)FieldControlType.MUL_COMBO.getValue())) continue;
                        if (HRStringUtils.isNotEmpty((String)queryFieldBo.getBaseDataNum())) {
                            enumEntityNumMap.put("$" + refFieldAlias + "$", queryFieldBo.getBaseDataNum());
                            continue;
                        }
                        enumEntityNumMap.put("$" + refFieldAlias + "$", queryFieldBo.getEntityNumber());
                    }
                    if (refFieldNums.isEmpty()) continue;
                    StringBuilder errorMsg = new StringBuilder();
                    FunctionSubPageService service = new FunctionSubPageService();
                    Map result = service.handleBaseDataAndEnum(parsedExpr, (Map)varMap, (Map)baseDataMap, false, (Map)baseDataNameOrNumMap, (Map)enumEntityNumMap, (Set)refFieldNums, null, errorMsg);
                    if (errorMsg.length() > 0) {
                        throw new Exception(errorMsg.toString());
                    }
                    String viewExpr = (String)result.get("viewExpr");
                    String runExpr = (String)result.get("runExpr");
                    calFieldDy.set("viewexpr", (Object)viewExpr);
                    calFieldDy.set("expr", (Object)runExpr);
                    updateCalculates.add((Object)calFieldDy);
                }
                catch (Exception ex) {
                    LOGGER.error("CalculateDataUpdateTask updateError1:", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("CalculateDataUpdateTask updateError2:", (Throwable)ex);
        }
    }

    private void deleteSchedule() {
        HRBaseServiceHelper scheduleHelper = new HRBaseServiceHelper("sch_schedule");
        scheduleHelper.deleteByFilter(new QFilter[]{new QFilter("number", "=", (Object)"hrptmc_calculatedataupdate_SKDP_S")});
    }

    private DynamicObjectCollection getUpdateQueryFields(Map<Long, List<DynamicObject>> anObjIdCalculateMap) {
        FieldDefineService fieldDefineService = new FieldDefineService();
        DynamicObjectCollection newFieldDyCol = new DynamicObjectCollection();
        for (Map.Entry<Long, List<DynamicObject>> calculateEntry : anObjIdCalculateMap.entrySet()) {
            try {
                Long anObjId = calculateEntry.getKey();
                List<DynamicObject> calculateFieldList = calculateEntry.getValue();
                List<JoinEntityBo> joinEntityBos = AnalyseObjectService.getInstance().queryAndAssembleJoinEntities(anObjId);
                if (joinEntityBos.get(0).getVirtualEntity()) continue;
                List<QueryFieldBo> queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
                Set<String> fieldAliasSet = queryFieldBos.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
                List fieldTreeNodes = fieldDefineService.getEntityAllFields(ReportComplexObjTransferUtil.transferJoinEntityBos(joinEntityBos), ReportComplexObjTransferUtil.transferQueryFieldBos(queryFieldBos));
                ArrayList allFieldTreeNodes = Lists.newArrayListWithCapacity((int)10);
                fieldTreeNodes.forEach(field -> this.addFieldTreeNode((FieldTreeNode)field, allFieldTreeNodes));
                Map<String, FieldTreeNode> fieldTreeNodeMap = allFieldTreeNodes.stream().collect(Collectors.toMap(FieldTreeNode::getFieldAlias, node -> node));
                this.addNewIdFields(calculateFieldList, queryFieldBos, fieldAliasSet, fieldTreeNodeMap, anObjId, newFieldDyCol);
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex);
            }
        }
        return newFieldDyCol;
    }

    private void addNewIdFields(List<DynamicObject> calculateFieldList, List<QueryFieldBo> queryFieldBos, Set<String> fieldAliasSet, Map<String, FieldTreeNode> fieldTreeNodeMap, Long anObjId, DynamicObjectCollection newFieldDyCol) {
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
        for (DynamicObject calculateField : calculateFieldList) {
            try {
                DynamicObjectCollection refFieldEntry = calculateField.getDynamicObjectCollection("reffieldentry");
                if (refFieldEntry.isEmpty()) continue;
                Set idFieldAliasSet = refFieldEntry.stream().filter(field -> field.getString("reffieldalias") != null && field.getString("reffieldalias").endsWith(".id")).map(field -> field.getString("reffieldalias")).collect(Collectors.toSet());
                for (String refBaseDataIdField : idFieldAliasSet) {
                    if (!fieldAliasSet.add(refBaseDataIdField)) continue;
                    FieldTreeNode fieldNode = fieldTreeNodeMap.get(refBaseDataIdField);
                    DynamicObject newFieldDy = queryFieldHelper.generateEmptyDynamicObject();
                    newFieldDy.set("anobj", (Object)anObjId);
                    newFieldDy.set("entitynumber", (Object)fieldNode.getEntityNumber());
                    newFieldDy.set("fieldname", (Object)fieldNode.getName());
                    newFieldDy.set("fieldalias", (Object)fieldNode.getFieldAlias());
                    newFieldDy.set("fieldpath", (Object)fieldNode.getFieldPath());
                    newFieldDy.set("valuetype", (Object)fieldNode.getValueType());
                    newFieldDy.set("complextype", (Object)fieldNode.getComplexType());
                    if (HRStringUtils.equals((String)fieldNode.getComplexType(), (String)FieldComplexType.BASE_DATA.getValue())) {
                        newFieldDy.set("controltype", (Object)FieldControlType.BASE_DATA.getValue());
                    } else if (HRStringUtils.equals((String)fieldNode.getComplexType(), (String)FieldComplexType.HIS_BASE_DATA.getValue())) {
                        newFieldDy.set("controltype", (Object)FieldControlType.HIS_BASE_DATA.getValue());
                    } else if (HRStringUtils.equals((String)fieldNode.getComplexType(), (String)FieldComplexType.ADMIN_ORG.getValue())) {
                        newFieldDy.set("controltype", (Object)FieldControlType.BASE_DATA.getValue());
                    }
                    newFieldDy.set("isv", (Object)queryFieldBos.get(0).getIsv());
                    newFieldDy.set("isvirtualfield", (Object)false);
                    newFieldDyCol.add((Object)newFieldDy);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex);
            }
        }
    }

    private void addFieldTreeNode(FieldTreeNode node, List<FieldTreeNode> allFieldTreeNodes) {
        if (node.getField().booleanValue()) {
            allFieldTreeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.addFieldTreeNode(child, allFieldTreeNodes);
            }
        }
    }

    private void updateRefFields(DynamicObjectCollection calculateFields) {
        for (DynamicObject calFieldDy : calculateFields) {
            String expr = calFieldDy.getString("expr");
            DynamicObjectCollection refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
            if (refFieldEntry.isEmpty()) continue;
            Set fieldAliasSet = refFieldEntry.stream().map(field -> field.getString("reffieldalias")).collect(Collectors.toSet());
            StringBuilder varSb = new StringBuilder();
            boolean flag = false;
            for (int i = 0; i < expr.length(); ++i) {
                char ex = expr.charAt(i);
                if (ex != '$' && flag) {
                    varSb.append(ex);
                }
                if (ex == '$') {
                    boolean bl = flag = !flag;
                }
                if (flag || varSb.length() <= 0) continue;
                String refFieldAlias = varSb.toString();
                if (refFieldAlias.endsWith(".id") && !fieldAliasSet.contains(refFieldAlias)) {
                    DynamicObject refFieldDy = refFieldEntry.addNew();
                    refFieldDy.set("reftype", (Object)"entityfield");
                    refFieldDy.set("reffieldalias", (Object)refFieldAlias);
                }
                varSb = new StringBuilder();
            }
        }
    }

    private void fillVarMap(String parsedExpr, Map<String, String> varMap) {
        StringBuilder varSb = new StringBuilder();
        boolean flag = false;
        int index = 1;
        for (int i = 0; i < parsedExpr.length(); ++i) {
            char ex = parsedExpr.charAt(i);
            if (ex != '$' && flag) {
                varSb.append(ex);
            }
            if (ex == '$') {
                boolean bl = flag = !flag;
            }
            if (flag || varSb.length() <= 0) continue;
            varSb.insert(0, "$");
            varSb.append("$");
            varMap.put("var" + index++, varSb.toString());
            varSb = new StringBuilder();
        }
    }
}

