/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.calfield;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class CollectCalculateFunctionService {
    private static final String COLLECT_SUM = "sumAGG";
    private static final String COLLECT_COUNT = "countAGG";
    private static final String COLLECT_AVG = "avgAGG";
    private static final String COLLECT_CALCULATE_SUM_FUNC = "_sum_";
    private static final String COLLECT_CALCULATE_AVG_FUNC = "_avg_";
    private static final String COLLECT_CALCULATE_COUNT_FUNC = "_count_";
    private final Set<Character> specialChar = Stream.of(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('$')).collect(Collectors.toSet());
    private final String currentCalculateFieldNum;
    private Map<String, String> aggregationMap = Maps.newHashMapWithExpectedSize((int)16);
    private final boolean isFromReport;

    public CollectCalculateFunctionService(String currentCalculateFieldNum, boolean isFromReport) {
        this.currentCalculateFieldNum = currentCalculateFieldNum;
        this.isFromReport = isFromReport;
    }

    public Map<String, String> getAggregationMap() {
        return this.aggregationMap;
    }

    public void clearCollectCalculateFunc(CalculateFieldBo currentCalculate, List<CalculateFieldBo> calculateFieldBos) {
        String sumCollectFuncSuffix = currentCalculate.getFieldNumber() + COLLECT_CALCULATE_SUM_FUNC;
        String avgCollectFuncSuffix = currentCalculate.getFieldNumber() + COLLECT_CALCULATE_AVG_FUNC;
        String countCollectFuncSuffix = currentCalculate.getFieldNumber() + COLLECT_CALCULATE_COUNT_FUNC;
        calculateFieldBos.removeIf(field -> field.isHideField() && (field.getFieldNumber().startsWith(sumCollectFuncSuffix) || field.getFieldNumber().startsWith(avgCollectFuncSuffix) || field.getFieldNumber().startsWith(countCollectFuncSuffix)));
    }

    public boolean handleCollectCalculateFunc(Map<String, Object> exprMap, List<CalculateFieldBo> collectCalculates, StringBuilder errorMsg) {
        char[] exprArr;
        String runExpr = (String)exprMap.get("runExpr");
        if (!(runExpr.contains(COLLECT_SUM) || runExpr.contains(COLLECT_AVG) || runExpr.contains(COLLECT_COUNT))) {
            return true;
        }
        if (!this.isFromReport) {
            errorMsg.append(ResManager.loadKDString((String)"\u805a\u5408\u51fd\u6570\u4ec5\u53ef\u5728\u62a5\u8868\u914d\u7f6e\u9636\u6bb5\u4f7f\u7528\u3002", (String)"CollectCalculateFunctionService_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            return false;
        }
        int newCalCount = 1;
        StringBuilder runExprSb = new StringBuilder();
        Set simpleSpecialChar = Stream.of(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/')).collect(Collectors.toSet());
        Set collectFuncSet = Stream.of(COLLECT_COUNT, COLLECT_AVG, COLLECT_SUM).collect(Collectors.toSet());
        StringBuilder fieldSb = new StringBuilder();
        int currentIndex = 0;
        boolean isQuotation = false;
        boolean isField = false;
        boolean inCollectCalFunc = false;
        int inCollectCalFuncStack = 0;
        boolean inFunc = false;
        int inFuncStack = 0;
        StringBuilder inCollectCalFuncSb = new StringBuilder();
        for (char chr : exprArr = runExpr.toCharArray()) {
            if (this.specialChar.contains(Character.valueOf(chr))) {
                if (chr == '\"') {
                    boolean bl = isQuotation = !isQuotation;
                }
                if (chr == '$' && !isField) {
                    isField = true;
                }
                if (inFunc) {
                    if (!isField && chr == '(') {
                        ++inFuncStack;
                    } else if (!isField && chr == ')' && --inFuncStack == 0) {
                        inFunc = false;
                    }
                }
                if (inCollectCalFunc) {
                    inCollectCalFuncSb.append(chr);
                    if (!isField && chr == '(') {
                        if (collectFuncSet.contains(fieldSb.toString())) {
                            errorMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u805a\u5408\u51fd\u6570%s\u4e0d\u80fd\u88ab\u5d4c\u5957\u4f7f\u7528\u3002", (String)"CollectCalculateFunctionService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldSb));
                            return false;
                        }
                        ++inCollectCalFuncStack;
                    } else if (!isField && chr == ')' && --inCollectCalFuncStack == 0) {
                        int startIndex = currentIndex - inCollectCalFuncSb.length();
                        CalculateFieldBo newCalField = this.handleInCollectCalFunc(runExpr, runExprSb, inCollectCalFuncSb, startIndex, currentIndex, newCalCount++);
                        currentIndex = startIndex + newCalField.getFieldNumber().length() + 2;
                        runExpr = runExprSb.toString();
                        runExprSb = new StringBuilder();
                        inCollectCalFuncSb = new StringBuilder();
                        inCollectCalFunc = false;
                        collectCalculates.add(newCalField);
                    }
                }
                if (fieldSb.length() > 0) {
                    if (!isField && chr == '(') {
                        if (collectFuncSet.contains(fieldSb.toString())) {
                            if (inFunc) {
                                errorMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u805a\u5408\u51fd\u6570%s\u4e0d\u80fd\u88ab\u5d4c\u5957\u4f7f\u7528\u3002", (String)"CollectCalculateFunctionService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldSb));
                                return false;
                            }
                            inCollectCalFunc = true;
                            ++inCollectCalFuncStack;
                            inCollectCalFuncSb.append((CharSequence)fieldSb).append(chr);
                        } else if (inCollectCalFunc) {
                            inFunc = true;
                            ++inFuncStack;
                        } else {
                            errorMsg.append(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u805a\u5408\u51fd\u6570\u548c\u975e\u805a\u5408\u51fd\u6570/\u53c2\u6570\u6df7\u5408\u4f7f\u7528\u3002", (String)"CollectCalculateFunctionService_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                            return false;
                        }
                    }
                    if (isField && !inCollectCalFunc) {
                        errorMsg.append(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u805a\u5408\u51fd\u6570\u548c\u975e\u805a\u5408\u51fd\u6570/\u53c2\u6570\u6df7\u5408\u4f7f\u7528\u3002", (String)"CollectCalculateFunctionService_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        return false;
                    }
                    fieldSb = new StringBuilder();
                }
                if (chr == '$' && isField) {
                    isField = false;
                }
            } else if (!isQuotation) {
                fieldSb.append(chr);
                if (inCollectCalFunc) {
                    inCollectCalFuncSb.append(chr);
                }
            }
            ++currentIndex;
        }
        exprMap.put("runExpr", runExpr);
        return true;
    }

    private CalculateFieldBo handleInCollectCalFunc(String runExpr, StringBuilder runExprSb, StringBuilder inCollectCalFuncSb, int startIndex, int endIndex, int newCalCount) {
        String func = inCollectCalFuncSb.toString();
        String refField = func.substring(func.indexOf("(") + 1, func.lastIndexOf(")"));
        String newCalculateField = "";
        String newCalExpr = refField;
        if (func.startsWith(COLLECT_SUM)) {
            newCalculateField = this.currentCalculateFieldNum + COLLECT_CALCULATE_SUM_FUNC + newCalCount;
        } else if (func.startsWith(COLLECT_AVG)) {
            newCalculateField = this.currentCalculateFieldNum + COLLECT_CALCULATE_AVG_FUNC + newCalCount;
            this.aggregationMap.put(newCalculateField, "avg");
        } else if (func.startsWith(COLLECT_COUNT)) {
            newCalculateField = this.currentCalculateFieldNum + COLLECT_CALCULATE_COUNT_FUNC + newCalCount;
            newCalExpr = "1";
        }
        String newRunExpr = runExpr.substring(0, startIndex + 1) + '$' + newCalculateField + '$' + runExpr.substring(endIndex + 1);
        runExprSb.append(newRunExpr);
        CalculateFieldBo calculateFieldBo = new CalculateFieldBo(new LocaleString(newCalculateField), newCalculateField);
        calculateFieldBo.setExpr(newCalExpr);
        calculateFieldBo.setViewExpr(newCalExpr);
        calculateFieldBo.setValueType(DataTypeEnum.BIGDECIMAL.getDataTypeKey());
        calculateFieldBo.setType("simple");
        calculateFieldBo.setHideField(true);
        if (this.isFromReport) {
            calculateFieldBo.setSource("report");
        } else {
            calculateFieldBo.setSource("anobj");
        }
        return calculateFieldBo;
    }
}

