/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.es;

import java.io.IOException;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hrptmc.business.center.es.RptCenterEsAccess;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchClientUtil {
    private static final Log LOGGER = LogFactory.getLog(ElasticsearchClientUtil.class);
    private static RestHighLevelClient client = null;

    private ElasticsearchClientUtil() {
    }

    public static synchronized RestHighLevelClient getClient() {
        if (client == null) {
            client = ElasticsearchClientUtil.createClient();
        }
        try {
            boolean ping = client.ping(RequestOptions.DEFAULT);
            if (!ping) {
                ElasticsearchClientUtil.closeClient();
                client = ElasticsearchClientUtil.createClient();
            }
        }
        catch (IOException e) {
            ElasticsearchClientUtil.closeClient();
            client = ElasticsearchClientUtil.createClient();
        }
        return client;
    }

    private static RestHighLevelClient createClient() {
        Map configMap = EsCommonUtils.getServerConfig((String)"hr");
        return RptCenterEsAccess.createRestHighLevelClient(configMap);
    }

    public static synchronized void closeClient() {
        if (client != null) {
            try {
                client.close();
                client = null;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
    }
}

