/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.model.center.es.EsDistinctResultVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class RptCenterEsAccess {
    private static final Log LOGGER = LogFactory.getLog(RptCenterEsAccess.class);
    private static final String RETRY_ON_CONFLICT_KEY = "fulltext.retryonconflict";
    private static final long MAX_BULK_SIZE = 10000000L;
    private static final long ALL_MAX_BULK = 100000000L;
    public static final int MAX_AGGREGATION_COUNT = 10000;

    private RptCenterEsAccess() {
    }

    private static List<HttpHost> getHttpHosts(Map<String, String> connConfig) {
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(10);
        int port = Integer.parseInt(connConfig.get("port"));
        String ip = connConfig.get("ip");
        String urls = connConfig.get("urls");
        String schema = connConfig.get("schema");
        LOGGER.info("connect to es:ip{},urls:{}", (Object)ip, (Object)urls);
        if (HRStringUtils.isNotEmpty((String)urls)) {
            String[] urlArr;
            for (String url : urlArr = urls.split(",")) {
                try {
                    httpHosts.add(HttpHost.create((String)url));
                }
                catch (Exception exception) {
                    LOGGER.warn("HttpHost.create exception:url:{}", (Object)url);
                }
            }
        }
        if (CollectionUtils.isEmpty(httpHosts)) {
            httpHosts.add(new HttpHost(ip, port, schema));
        }
        return httpHosts;
    }

    public static RestHighLevelClient createRestHighLevelClient(Map<String, String> connConfig) {
        List<HttpHost> httpHosts = RptCenterEsAccess.getHttpHosts(connConfig);
        String username = connConfig.get("username");
        String password = connConfig.get("password");
        LOGGER.info("createRestHighLevelClient httpHosts:{}", httpHosts);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts.toArray(new HttpHost[0]));
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (username != null && password != null) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(5000));
        builder.setHttpClientConfigCallback(arg_0 -> RptCenterEsAccess.lambda$createRestHighLevelClient$2((CredentialsProvider)credentialsProvider, arg_0));
        return new RestHighLevelClient(builder);
    }

    public static Map<String, Object> getMapping(RestHighLevelClient client, String indexName) {
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(new String[]{indexName});
        try {
            Map mappings = client.indices().getMapping(getMappingsRequest, RequestOptions.DEFAULT).mappings();
            MappingMetaData mappingMetaData = mappings.values().stream().findFirst().orElse(null);
            if (mappingMetaData == null) {
                LOGGER.info("getMapping mapping isnull,indexName:{}", (Object)indexName);
                return null;
            }
            Map sourceAsMap = mappingMetaData.getSourceAsMap();
            Map propMap = (Map)sourceAsMap.get("properties");
            if (propMap == null) {
                LOGGER.info("getMapping prop isnull,indexName:{}", (Object)indexName);
                return null;
            }
            return sourceAsMap;
        }
        catch (Exception e) {
            LOGGER.error("getMapping error:", (Throwable)e);
            return null;
        }
    }

    public static long getCount(RestHighLevelClient client, String indexName, String type, QueryBuilder filterQb) {
        Object queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : QueryBuilders.constantScoreQuery((QueryBuilder)filterQb);
        SearchRequest req = new SearchRequest(new String[]{indexName});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.query((QueryBuilder)queryBuilder).size(0);
        req.source(builder);
        try {
            SearchResponse searchResponse = client.search(req, RequestOptions.DEFAULT);
            return searchResponse.getHits().getTotalHits();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
    }

    public static EsDistinctResultVo distinctQuery(RestHighLevelClient client, String indexName, QueryBuilder filterQb, List<String> distinctFieldList, int size, Map<String, Object> afterKey, SortField[] sortFields, boolean missBucket) {
        SearchResponse searchResponse;
        String compName = "distinct_dim";
        Object queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : QueryBuilders.constantScoreQuery((QueryBuilder)filterQb);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query((QueryBuilder)queryBuilder);
        RptCenterEsAccess.sort(sortFields, searchSourceBuilder);
        ArrayList<TermsValuesSourceBuilder> sources = new ArrayList<TermsValuesSourceBuilder>(10);
        for (String distinctField : distinctFieldList) {
            TermsValuesSourceBuilder termsValuesSourceBuilder = (TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(distinctField).field(distinctField)).missingBucket(missBucket);
            sources.add(termsValuesSourceBuilder);
        }
        CompositeAggregationBuilder composite = new CompositeAggregationBuilder(compName, sources);
        if (size == -1) {
            size = 10000;
        }
        composite.size(size);
        if (afterKey != null) {
            composite.aggregateAfter(afterKey);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)composite);
        LOGGER.info("Es distinctQuery indexName : {} ", (Object)indexName);
        LOGGER.info("Es distinctQuery DSL : {} ", (Object)searchSourceBuilder.toString());
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("distinctQuery Exception: ", (Throwable)e);
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
        Aggregations aggregations = searchResponse.getAggregations();
        ParsedComposite parsedComposite = (ParsedComposite)aggregations.get(compName);
        EsDistinctResultVo distinctResultVo = null;
        if (parsedComposite != null) {
            distinctResultVo = new EsDistinctResultVo();
            ArrayList result = new ArrayList(10);
            List list = parsedComposite.getBuckets();
            for (ParsedComposite.ParsedBucket parsedBucket : list) {
                HashMap data = new HashMap(10);
                data.putAll(parsedBucket.getKey());
                result.add(data);
            }
            Map nextAfterKey = parsedComposite.afterKey();
            distinctResultVo.setAfterKey(nextAfterKey);
            distinctResultVo.setDataList(result);
        }
        return distinctResultVo;
    }

    public static EsDistinctResultVo distinctQueryCount(RestHighLevelClient client, String indexName, QueryBuilder filterQb, List<String> distinctFieldList, Map<String, Object> afterKey, boolean missBucket) {
        SearchResponse searchResponse;
        String compName = "distinct_dim_count";
        Object queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : QueryBuilders.constantScoreQuery((QueryBuilder)filterQb);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query((QueryBuilder)queryBuilder);
        ArrayList<TermsValuesSourceBuilder> sources = new ArrayList<TermsValuesSourceBuilder>(10);
        for (String distinctField : distinctFieldList) {
            TermsValuesSourceBuilder termsValuesSourceBuilder = (TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(distinctField).field(distinctField)).missingBucket(missBucket);
            sources.add(termsValuesSourceBuilder);
        }
        CompositeAggregationBuilder composite = new CompositeAggregationBuilder(compName, sources);
        composite.size(10000);
        if (afterKey != null) {
            composite.aggregateAfter(afterKey);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)composite);
        LOGGER.info("Es distinctQuery indexName : {} ", (Object)indexName);
        LOGGER.info("Es distinctQuery DSL : {} ", (Object)searchSourceBuilder.toString());
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("distinctQuery Exception: ", (Throwable)e);
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
        Aggregations aggregations = searchResponse.getAggregations();
        ParsedComposite parsedComposite = (ParsedComposite)aggregations.get(compName);
        EsDistinctResultVo distinctResultVo = null;
        if (parsedComposite != null) {
            distinctResultVo = new EsDistinctResultVo();
            List list = parsedComposite.getBuckets();
            distinctResultVo.setCount(list.size());
            Map nextAfterKey = parsedComposite.afterKey();
            distinctResultVo.setAfterKey(nextAfterKey);
        }
        return distinctResultVo;
    }

    public static SearchResponse querySptSchAfter(RestHighLevelClient client, String indexName, String[] selectFields, QueryBuilder filterQb, SortField[] sortFields, int start, int size, Object[] objSortValues) {
        Object queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : filterQb;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)queryBuilder);
        sourceBuilder.from(start);
        sourceBuilder.size(size);
        sourceBuilder.fetchSource(selectFields, null);
        sourceBuilder.sort("_id", SortOrder.ASC);
        if (objSortValues == null || objSortValues.length == 0) {
            sourceBuilder.searchAfter();
        } else {
            sourceBuilder.searchAfter(objSortValues);
        }
        RptCenterEsAccess.sort(sortFields, sourceBuilder);
        searchRequest.source(sourceBuilder);
        LOGGER.info("Es searchAfter indexName : {} ", (Object)indexName);
        LOGGER.info("Es DSL statement: {}", (Object)sourceBuilder.toString());
        try {
            return client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("searchAfter Exception: ", (Throwable)e);
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
    }

    private static void sort(SortField[] sortFields, SearchSourceBuilder builder) {
        if (sortFields == null) {
            return;
        }
        for (SortField info : sortFields) {
            FieldSortBuilder sortBuilderOrder;
            FieldSortBuilder sortBuilderOrder2;
            NestedSortBuilder nestedSort;
            if (null == info) continue;
            if (info.isAsc()) {
                if (StringUtils.isNotBlank((CharSequence)info.getPath())) {
                    nestedSort = new NestedSortBuilder(info.getPath());
                    sortBuilderOrder2 = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.ASC)).setNestedSort(nestedSort).missing((Object)"_first");
                    builder.sort((SortBuilder)sortBuilderOrder2);
                    continue;
                }
                sortBuilderOrder = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.ASC)).missing((Object)"_first");
                builder.sort((SortBuilder)sortBuilderOrder);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)info.getPath())) {
                nestedSort = new NestedSortBuilder(info.getPath());
                sortBuilderOrder2 = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.DESC)).setNestedSort(nestedSort).missing((Object)"_last");
                builder.sort((SortBuilder)sortBuilderOrder2);
                continue;
            }
            sortBuilderOrder = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.DESC)).missing((Object)"_last");
            builder.sort((SortBuilder)sortBuilderOrder);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createRestHighLevelClient$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setMaxConnTotal(100);
        httpClientBuilder.setMaxConnPerRoute(100);
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        httpClientBuilder.setKeepAliveStrategy((response, context) -> TimeUnit.MINUTES.toMillis(5L)).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(2).setSoKeepAlive(true).build());
        return httpClientBuilder;
    }
}

