/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.es;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.query.es.storage.BaseEsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.business.service.query.es.storage.highlevel.EsAccess;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hrptmc.business.center.es.ElasticsearchClientUtil;
import kd.hr.hrptmc.business.center.es.RptCenterEsAccess;
import kd.hr.hrptmc.common.model.center.es.EsDistinctResultVo;
import org.apache.commons.collections.MapUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;

public class RptCenterEsStorage
extends BaseEsStorage {
    private static final Log LOGGER = LogFactory.getLog(RptCenterEsStorage.class);
    public static final String strDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final RestHighLevelClient client = ElasticsearchClientUtil.getClient();

    public void createIndex(String region, String indexName, Map<String, Object> settingsMap) {
        if (MapUtils.isEmpty(settingsMap)) {
            settingsMap = EsCommonUtils.getIndexSettings((String)region);
        }
        if (!EsAccess.isIndexExist((RestHighLevelClient)this.client, (String)indexName)) {
            EsAccess.createIndex((RestHighLevelClient)this.client, (String)indexName, (Map)settingsMap);
        }
    }

    public Boolean isIndexExist(String indexName) {
        return EsAccess.isIndexExist((RestHighLevelClient)this.client, (String)indexName);
    }

    public Boolean deleteIndex(String indexName) {
        return EsAccess.deleteIndex((RestHighLevelClient)this.client, (String)indexName);
    }

    public Map<String, Object> getMapping(String indexName) {
        return RptCenterEsAccess.getMapping(this.client, indexName);
    }

    public long count(String indexName, List<EsFilterField> filters) {
        QueryBuilder queryBuilder = this.buidQueryBuilder(filters);
        return RptCenterEsAccess.getCount(this.client, indexName, null, queryBuilder);
    }

    public EsDistinctResultVo distinctQuery(String indexName, List<EsFilterField> filters, List<String> distinctFieldList, int size, Map<String, Object> afterKey, SortField[] sortFields) {
        QueryBuilder queryBuilder = this.buidQueryBuilder(filters);
        return RptCenterEsAccess.distinctQuery(this.client, indexName, queryBuilder, distinctFieldList, size, afterKey, sortFields, true);
    }

    public EsDistinctResultVo distinctQueryCount(String indexName, List<EsFilterField> filters, List<String> distinctFieldList, Map<String, Object> afterKey) {
        QueryBuilder queryBuilder = this.buidQueryBuilder(filters);
        return RptCenterEsAccess.distinctQueryCount(this.client, indexName, queryBuilder, distinctFieldList, afterKey, true);
    }

    public List<Map<String, Object>> queryListData(String indexName, String[] selectFields, List<EsFilterField> filters, SortField[] sortFields, int start, int size) {
        QueryBuilder queryBuilder = this.buidQueryBuilder(filters);
        SearchResponse searchResponse = RptCenterEsAccess.querySptSchAfter(this.client, indexName, selectFields, queryBuilder, sortFields, start, size, null);
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return result;
    }
}

