/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ComplexConstant;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.QuerySegment;
import kd.hr.hrptmc.business.center.es.RptCenterEsStorage;
import kd.hr.hrptmc.business.center.query.EsQueryService;
import kd.hr.hrptmc.business.center.query.util.EsQueryUtil;
import kd.hr.hrptmc.business.center.servicehelper.ReportEsServiceHelper;
import kd.hr.hrptmc.common.model.center.es.EsDistinctResultVo;
import org.apache.commons.collections.CollectionUtils;

public class DimEsQueryService
extends EsQueryService {
    private static final Log LOGGER = LogFactory.getLog(DimEsQueryService.class);
    private static final RptCenterEsStorage CENTER_ES_STORAGE = new RptCenterEsStorage();
    private List<Map<String, Object>> dimListMap;
    private final Map<String, String> replaceAliasMap;
    private final DateTimeFormatter DF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final ZoneId UTC = ZoneId.of("UTC");

    public DimEsQueryService(HRComplexObjContext complexObjCont) {
        super(complexObjCont);
        this.replaceAliasMap = Maps.newHashMapWithExpectedSize((int)complexObjCont.getGroupFieldList().size());
    }

    @Override
    public List<Map<String, Object>> query4ListMap() {
        List<Map<String, Object>> dataList;
        int start = 0;
        ArrayList allDataList = Lists.newArrayListWithExpectedSize((int)128);
        while (!(dataList = this.query4ListMap(start, 10000)).isEmpty()) {
            allDataList.addAll(dataList);
            if (dataList.size() < 10000) break;
            start += 10000;
        }
        return allDataList;
    }

    public List<Map<String, DimensionData>> queryDimensionData() {
        List<EsFilterField> filterFieldList = this.getFilters();
        SortField[] sortField = this.getSortField();
        List<Map<String, Object>> dataList = this.queryDimensionDataWithOrigin(filterFieldList, sortField, -1, -1);
        this.handleResult(dataList, this.replaceAliasMap);
        return DimensionData.convertToDimensionDataMap(dataList, (String[])((String[])this.complexObjCont.getComplexObjFieldInfoList().stream().map(HRComplexObjFieldInfo::getAlias).toArray(String[]::new)), (List)this.getComplexObjCont().getSortFieldInfoList());
    }

    @Override
    public long queryDataCount(int start, int limit) {
        EsDistinctResultVo esDistinctResultVo;
        List<EsFilterField> filters = this.getFilters();
        List groupFieldList = this.complexObjCont.getGroupFieldList();
        List<String> distinctFieldList = this.getDistinctFieldList(groupFieldList, Maps.newHashMap());
        Map afterKey = null;
        int count = 0;
        while ((esDistinctResultVo = CENTER_ES_STORAGE.distinctQueryCount(this.complexObjCont.getEsIndex(), filters, distinctFieldList, afterKey)) != null) {
            count += esDistinctResultVo.getCount();
            afterKey = esDistinctResultVo.getAfterKey();
            if (esDistinctResultVo.getCount() >= 10000) continue;
            break;
        }
        return count;
    }

    @Override
    protected EsResultVo queryData(String[] selectFields, List<EsFilterField> filters, SortField[] sortFields, int start, int limit, Object[] objSortValues) {
        LOGGER.info("DimEsQueryService_queryData_objSortValues:{}", objSortValues);
        if (sortFields.length == 0) {
            sortFields = new SortField[]{new SortField("id", true)};
        }
        return this.queryFromDbByTuple(start, limit, selectFields, filters, sortFields);
    }

    private List<String> getDistinctFieldList(List<HRComplexObjFieldInfo> groupFieldList, Map<String, String> replaceAliasMap) {
        Object[] selectFields = this.getSelectFields(groupFieldList, replaceAliasMap);
        return Lists.newArrayList((Object[])selectFields);
    }

    private List<Map<String, Object>> queryDimensionDataWithOrigin(List<EsFilterField> filterFieldList, SortField[] sortField, int start, int limit) {
        List groupFieldList = this.complexObjCont.getGroupFieldList();
        List<String> distinctFieldList = this.getDistinctFieldList(groupFieldList, this.replaceAliasMap);
        Map afterKeyMap = this.complexObjCont.getAfterKeyMap();
        Map afterKey = null;
        if (afterKeyMap != null) {
            afterKey = (Map)afterKeyMap.get(start);
        } else {
            afterKeyMap = Maps.newHashMapWithExpectedSize((int)64);
            this.complexObjCont.setAfterKeyMap(afterKeyMap);
        }
        LOGGER.info("DimEsQueryService_queryDimensionDataWithOrigin_afterKeyMap:{}", (Object)afterKeyMap);
        EsDistinctResultVo esDistinctResultVo = CENTER_ES_STORAGE.distinctQuery(this.complexObjCont.getEsIndex(), filterFieldList, distinctFieldList, limit, afterKey, sortField);
        this.formatDate(groupFieldList, esDistinctResultVo, this.replaceAliasMap);
        if (start != -1) {
            afterKeyMap.put(start + limit, esDistinctResultVo.getAfterKey());
        }
        return esDistinctResultVo.getDataList();
    }

    private EsResultVo queryFromDbByTuple(int start, int limit, String[] selectFields, List<EsFilterField> filterFieldList, SortField[] sortField) {
        LOGGER.info("DimEsQueryService queryFromDbByTuple:start:{},limit:{}", (Object)start, (Object)limit);
        List extQFilterList = null;
        try {
            Object[] objSortValues = null;
            QuerySegment querySegment = this.complexObjCont.getQuerySegment();
            if (querySegment == null) {
                if (start >= 0 && limit > 0 && CollectionUtils.isEmpty((Collection)(extQFilterList = this.getDimQFilterList(filterFieldList, sortField, start, limit)))) {
                    LOGGER.info("DimEsQuery Dim is empty");
                    EsResultVo resultVo = new EsResultVo();
                    resultVo.setResultData((List)Lists.newArrayList());
                    return resultVo;
                }
                long detailCount = super.queryDataCount(-1, -1);
                LOGGER.info("DimEsQuery detailCount:{}", (Object)detailCount);
                if (detailCount > (long)(limit * 3) && detailCount > 99999L) {
                    querySegment = new QuerySegment(detailCount, 99999);
                    querySegment.setExtQFilterList(extQFilterList);
                }
            } else if (querySegment.hasNext()) {
                objSortValues = querySegment.getObjSortValues();
                querySegment.nextStart();
                extQFilterList = querySegment.getExtQFilterList();
            } else {
                LOGGER.error("DimEsQuery QuerySegment no next page data");
                EsResultVo resultVo = new EsResultVo();
                resultVo.setResultData((List)Lists.newArrayList());
                return resultVo;
            }
            this.complexObjCont.setQuerySegment(querySegment);
            ArrayList allFilterFieldList = Lists.newArrayListWithExpectedSize((int)filterFieldList.size());
            allFilterFieldList.addAll(filterFieldList);
            if (extQFilterList != null) {
                for (QFilter qFilter : extQFilterList) {
                    EsFilterField esFilterField = EsQueryUtil.convertQFilter(qFilter);
                    allFilterFieldList.add(esFilterField);
                }
            }
            EsResultVo resultVo = ES_STORAGE.searchAfter(this.complexObjCont.getEsIndex(), "t_data", selectFields, (List)allFilterFieldList, sortField, true, 0, 99999, objSortValues);
            if (querySegment != null) {
                querySegment.setObjSortValues(resultVo.getObjSortValues());
            }
            this.filterByDimTuple(resultVo.getResultData());
            return resultVo;
        }
        catch (KDBizException kdBizException) {
            if (kdBizException.getErrorCode().getCode().equals(ComplexConstant.NO_QUERY.getCode())) {
                LOGGER.error(kdBizException.getMessage());
                EsResultVo resultVo = new EsResultVo();
                resultVo.setResultData((List)Lists.newArrayList());
                return resultVo;
            }
            LOGGER.error((Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"Es\u67e5\u8be2\u6267\u884c\u5931\u8d25", (String)"DimEsQueryService_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
    }

    private void filterByDimTuple(List<Map<String, Object>> listDB) {
        Object dimVal;
        StringBuilder allDimStb;
        if (CollectionUtils.isEmpty(this.dimListMap)) {
            return;
        }
        Set<String> dimFieldAliasSet = this.dimListMap.get(0).keySet();
        HashSet<String> allDimStbCache = new HashSet<String>(16);
        for (Map<String, Object> dimData : this.dimListMap) {
            allDimStb = new StringBuilder();
            for (String dimFieldName : dimFieldAliasSet) {
                dimVal = dimData.get(dimFieldName);
                allDimStb.append(dimFieldName).append(dimVal);
            }
            allDimStbCache.add(allDimStb.toString());
        }
        Iterator<Map<String, Object>> iterator = listDB.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            allDimStb = new StringBuilder();
            for (String dimFieldName : dimFieldAliasSet) {
                dimVal = next.get(dimFieldName);
                allDimStb.append(dimFieldName).append(dimVal);
            }
            if (allDimStbCache.contains(allDimStb.toString())) continue;
            iterator.remove();
        }
    }

    private List<QFilter> getDimQFilterList(List<EsFilterField> filterFieldList, SortField[] sortField, int start, int limit) {
        int esLimit = this.complexObjCont.getEsLimit();
        if (limit == esLimit + 1) {
            this.dimListMap = this.queryDimensionDataWithOrigin(filterFieldList, sortField, start, esLimit);
            List<Map<String, Object>> oneMore = this.queryDimensionDataWithOrigin(filterFieldList, sortField, start + esLimit, 1);
            this.dimListMap.addAll(oneMore);
        } else {
            this.dimListMap = this.queryDimensionDataWithOrigin(filterFieldList, sortField, start, limit);
        }
        List queryFieldList = this.complexObjCont.getGroupFieldList();
        Map<String, DataTypeEnum> fieldAliasMap = queryFieldList.stream().collect(Collectors.toMap(hf -> {
            String alias = hf.getAlias();
            return ReportEsServiceHelper.replaceSpecChar(alias);
        }, HRComplexObjFieldInfo::getDataType, (x, y) -> x));
        HashMap<String, HashSet<Object>> dimDataMap = new HashMap<String, HashSet<Object>>(16);
        HashSet<String> nvlValFieldSet = new HashSet<String>(16);
        for (Map<String, Object> dimData : this.dimListMap) {
            for (String fieldAlias : fieldAliasMap.keySet()) {
                Object dataVal = dimData.get(fieldAlias);
                if (dataVal == null) {
                    nvlValFieldSet.add(fieldAlias);
                    continue;
                }
                HashSet<Object> dataList = (HashSet<Object>)dimDataMap.get(fieldAlias);
                if (dataList == null) {
                    dataList = new HashSet<Object>(16);
                }
                dataList.add(dataVal);
                if (dataVal instanceof String && "".equals(dataVal)) {
                    dataList.add(" ");
                }
                dimDataMap.put(fieldAlias, dataList);
            }
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        for (Map.Entry dimDataEntry : dimDataMap.entrySet()) {
            String fieldAlias;
            fieldAlias = (String)dimDataEntry.getKey();
            Set value = (Set)dimDataEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)value)) {
                qFilterList.add(new QFilter(fieldAlias, "is null", null));
                nvlValFieldSet.remove(fieldAlias);
                continue;
            }
            HashSet dbValSet = new HashSet(value.size());
            dbValSet.addAll(value);
            QFilter qFilter = new QFilter(fieldAlias, "in", dbValSet);
            if (nvlValFieldSet.contains(fieldAlias)) {
                qFilter.or(new QFilter(fieldAlias, "is null", null));
            }
            qFilterList.add(qFilter);
        }
        LOGGER.info("DimEsQueryService_getDimQFilterList:{}", qFilterList);
        return qFilterList;
    }

    private void formatDate(List<HRComplexObjFieldInfo> groupFieldList, EsDistinctResultVo esDistinctResultVo, Map<String, String> replaceAliasMap) {
        Map<String, DataTypeEnum> dataTypeEnumMap = groupFieldList.stream().filter(gf -> DataTypeEnum.DATETIME.equals((Object)gf.getDataType()) && !gf.getAlias().contains("!")).collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, HRComplexObjFieldInfo::getDataType));
        if (!dataTypeEnumMap.isEmpty()) {
            for (Map map : esDistinctResultVo.getDataList()) {
                for (Map.Entry entry : map.entrySet()) {
                    String alias = replaceAliasMap.get(entry.getKey());
                    if (!dataTypeEnumMap.containsKey(alias) || !(entry.getValue() instanceof Long)) continue;
                    Instant instant = Instant.ofEpochMilli((Long)entry.getValue());
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, this.UTC);
                    String format = localDateTime.format(this.DF);
                    map.put(entry.getKey(), format);
                }
            }
        }
    }
}

