/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsStorageFactory;
import kd.hr.hbp.business.service.query.es.storage.highlevel.EsStorageImpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.center.es.RptCenterEsStorage;
import kd.hr.hrptmc.business.center.query.EsQueryService;
import kd.hr.hrptmc.business.center.query.util.EsQueryUtil;
import kd.hr.hrptmc.business.center.servicehelper.ReportEsServiceHelper;
import kd.hr.hrptmc.common.constant.center.ReportCenterConstants;
import kd.hr.hrptmc.common.model.center.EsF7QueryParam;
import kd.hr.hrptmc.common.model.center.EsF7QueryResult;
import kd.hr.hrptmc.common.model.center.es.EsDistinctResultVo;

public class EsF7QueryService
implements ReportCenterConstants {
    private static final Log LOGGER = LogFactory.getLog(EsQueryService.class);
    private static EsStorage ES_STORAGE = EsStorageFactory.getStorage((String)"hr");
    private static final RptCenterEsStorage CENTER_ES_STORAGE = new RptCenterEsStorage();
    private static final String[] SELECT_FIELDS = new String[]{"id", "number", "name", "name_l", "type", "baseDataNum", "fieldalias"};

    public EsF7QueryService() {
        if (ES_STORAGE == null) {
            ES_STORAGE = new EsStorageImpl("hr");
        }
    }

    public List<EsF7QueryResult> queryF7Result(EsF7QueryParam esF7QueryParam) {
        LOGGER.info("EsF7QueryParam:{}", (Object)esF7QueryParam);
        String baseDataNum = esF7QueryParam.getBaseDataNum();
        String keyWord = esF7QueryParam.getKeyWord();
        List<EsFilterField> filterFieldList = this.getFilterList(esF7QueryParam);
        String lang = RequestContext.get().getLang().name();
        EsFilterField searchFilter = this.getSearchFilter(keyWord, lang);
        if (searchFilter != null) {
            filterFieldList.add(searchFilter);
        }
        LOGGER.info("queryF7Result_filterFieldList:{}", filterFieldList);
        EsResultVo resultVo = ES_STORAGE.query(esF7QueryParam.getBaseDataEsIndex(), "t_data", SELECT_FIELDS, filterFieldList, null, true, 0, 9999);
        List dataList = resultVo.getResultData();
        ArrayList esF7QueryResultList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)dataList.size());
        for (Map map : dataList) {
            Object id = map.get("id");
            idSet.add(id);
            esF7QueryResultList.add(this.getResult(map, lang));
        }
        HashSet queryIdSet = Sets.newHashSetWithExpectedSize((int)idSet.size());
        String bdDefaultValue = esF7QueryParam.getBdDefaultValue();
        this.addQueryId(bdDefaultValue, idSet, queryIdSet);
        String value = esF7QueryParam.getValue();
        this.addQueryId(value, idSet, queryIdSet);
        if (!queryIdSet.isEmpty()) {
            EsFilterField esFilter = new EsFilterField(null, "baseDataNum", "=", new Object[]{baseDataNum});
            esFilter.and(new EsFilterField(null, "id", "in", new Object[]{queryIdSet}));
            EsResultVo defResultVo = ES_STORAGE.query(esF7QueryParam.getBaseDataEsIndex(), "t_data", SELECT_FIELDS, (List)Lists.newArrayList((Object[])new EsFilterField[]{esFilter}), null, true, 0, 9999);
            for (Map map : defResultVo.getResultData()) {
                esF7QueryResultList.add(this.getResult(map, lang));
            }
        }
        return esF7QueryResultList;
    }

    public List<EsF7QueryResult> queryF7Result(List<EsF7QueryParam> esF7QueryParamList) {
        LOGGER.info("EsF7QueryParamList:{}", esF7QueryParamList);
        ArrayList batchQueryF7QueryResults = Lists.newArrayListWithExpectedSize((int)9999);
        for (EsF7QueryParam esF7QueryParam : esF7QueryParamList) {
            List<EsF7QueryResult> esF7QueryResults = this.queryF7Result(esF7QueryParam);
            batchQueryF7QueryResults.addAll(esF7QueryResults);
        }
        return batchQueryF7QueryResults;
    }

    public List<EsF7QueryResult> queryF7ResultByGroup(EsF7QueryParam esF7QueryParam) {
        LOGGER.info("EsF7QueryParam:{}", (Object)esF7QueryParam);
        String fieldAlias = esF7QueryParam.getFieldAlias();
        int lastIndexOf = fieldAlias.lastIndexOf(".");
        String idAlias = fieldAlias.substring(0, lastIndexOf) + ".id";
        String newIdAlias = ReportEsServiceHelper.replaceSpecChar(idAlias);
        ArrayList filterFieldList = Lists.newArrayListWithExpectedSize((int)4);
        String bdFilterRange = esF7QueryParam.getBdFilterRange();
        if (!HRStringUtils.isEmpty((String)bdFilterRange)) {
            String[] split = bdFilterRange.split(",");
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)split.length);
            for (String id : split) {
                if (HRStringUtils.isEmpty((String)id)) continue;
                idList.add(id);
            }
            filterFieldList.add(new EsFilterField(newIdAlias, "in", idList.toArray()));
        }
        if (esF7QueryParam.getqFilter() != null) {
            this.convertQFilterKey(esF7QueryParam.getqFilter(), newIdAlias);
            EsFilterField esFilterField = EsQueryUtil.convertQFilter(esF7QueryParam.getqFilter());
            filterFieldList.add(esFilterField);
        }
        String keyWord = esF7QueryParam.getKeyWord();
        String newFieldAlias = ReportEsServiceHelper.replaceSpecChar(fieldAlias);
        String otherBaseDataField = this.getOtherBaseDataField(fieldAlias);
        String newOtherBaseDataFieldAlias = ReportEsServiceHelper.replaceSpecChar(otherBaseDataField);
        if (HRStringUtils.isNotEmpty((String)keyWord)) {
            EsFilterField esFilter = new EsFilterField(null, newFieldAlias, "like", new Object[]{'%' + keyWord + '%'});
            esFilter.or(new EsFilterField(null, newOtherBaseDataFieldAlias, "like", new Object[]{'%' + keyWord + '%'}));
            filterFieldList.add(esFilter);
        }
        EsDistinctResultVo esDistinctResultVo = CENTER_ES_STORAGE.distinctQuery(esF7QueryParam.getBaseDataEsIndex(), filterFieldList, Lists.newArrayList((Object[])new String[]{newIdAlias, newFieldAlias, newOtherBaseDataFieldAlias}), 9999, null, null);
        List dataList = esDistinctResultVo.getDataList();
        ArrayList esF7QueryResultList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        boolean isNumber = fieldAlias.endsWith(".number");
        for (Map map : dataList) {
            String name;
            String number;
            if (isNumber) {
                number = (String)map.get(newFieldAlias);
                name = (String)map.get(newOtherBaseDataFieldAlias);
            } else {
                number = (String)map.get(newOtherBaseDataFieldAlias);
                name = (String)map.get(newFieldAlias);
            }
            esF7QueryResultList.add(new EsF7QueryResult(map.get(newIdAlias), number, new LocaleString(name), esF7QueryParam.getBaseDataNum(), fieldAlias, "0"));
        }
        return esF7QueryResultList;
    }

    private EsF7QueryResult getResult(Map<String, Object> map, String lang) {
        Object id = map.get("id");
        String number = (String)map.get("number");
        Map langNameMap = (Map)map.get("name_l");
        String name = (String)map.get("name");
        String baseDataNumber = (String)map.get("baseDataNum");
        String dbFieldAlias = (String)map.get("fieldalias");
        String type = (String)map.get("type");
        LocaleString nameLang = new LocaleString();
        if (langNameMap == null || HRStringUtils.isEmpty((String)((String)langNameMap.get(lang)))) {
            nameLang.setLocaleValue(name);
        } else {
            for (Map.Entry entry : langNameMap.entrySet()) {
                nameLang.put((String)entry.getKey(), entry.getValue());
            }
        }
        return new EsF7QueryResult(id, number, nameLang, baseDataNumber, dbFieldAlias, type);
    }

    private List<EsFilterField> getFilterList(EsF7QueryParam esF7QueryParam) {
        String baseDataNum = esF7QueryParam.getBaseDataNum();
        QFilter qFilter = esF7QueryParam.getqFilter();
        String fieldAlias = esF7QueryParam.getFieldAlias();
        ArrayList filterFieldList = Lists.newArrayListWithExpectedSize((int)4);
        if ("0".equals(esF7QueryParam.getType())) {
            filterFieldList.add(new EsFilterField(null, "baseDataNum", "=", new Object[]{baseDataNum}));
        } else {
            filterFieldList.add(new EsFilterField(null, "fieldalias", "=", new Object[]{fieldAlias}));
        }
        String bdFilterRange = esF7QueryParam.getBdFilterRange();
        this.addValueFilter(bdFilterRange, filterFieldList);
        if (qFilter != null) {
            EsFilterField esFilterField = EsQueryUtil.convertQFilter(qFilter);
            filterFieldList.add(esFilterField);
        }
        return filterFieldList;
    }

    private EsFilterField getSearchFilter(String keyWord, String lang) {
        if (HRStringUtils.isNotEmpty((String)keyWord)) {
            EsFilterField esFilter = new EsFilterField(null, "number", "like", new Object[]{'%' + keyWord + '%'});
            EsFilterField esFilter2 = new EsFilterField(null, "name_l." + lang, "like", new Object[]{'%' + keyWord + '%'});
            EsFilterField esFilter3 = new EsFilterField(null, "name", "like", new Object[]{'%' + keyWord + '%'});
            esFilter3.and(new EsFilterField("name_l." + lang, "is null", new Object[0]));
            esFilter.or(esFilter2);
            esFilter.or(esFilter3);
            return esFilter;
        }
        return null;
    }

    private void addValueFilter(String idValueStr, List<EsFilterField> filterFieldList) {
        if (!HRStringUtils.isEmpty((String)idValueStr)) {
            String[] split = idValueStr.split(",");
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)split.length);
            for (String id : split) {
                if (HRStringUtils.isEmpty((String)id)) continue;
                idList.add(id);
            }
            filterFieldList.add(new EsFilterField("id", "in", idList.toArray()));
        }
    }

    private void addQueryId(String value, Set<Object> dbIdSet, Set<String> queryIdSet) {
        if (!HRStringUtils.isEmpty((String)value)) {
            String[] split;
            for (String id : split = value.split(",")) {
                if (HRStringUtils.isEmpty((String)id) || dbIdSet.contains(id)) continue;
                queryIdSet.add(id);
            }
        }
    }

    private void addQueryId(String value, String baseDataNum, Map<String, Set<Object>> idBaseDataNumMap, Map<String, Set<Object>> outRangeFilterMap) {
        if (!HRStringUtils.isEmpty((String)value)) {
            String[] split = value.split(",");
            Set<Object> idSet = idBaseDataNumMap.get(baseDataNum);
            for (String id : split) {
                if (HRStringUtils.isEmpty((String)id) || idSet != null && idSet.contains(id)) continue;
                Set<Object> filterIdSet = outRangeFilterMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)split.length));
                filterIdSet.add(id);
                outRangeFilterMap.put(baseDataNum, filterIdSet);
            }
        }
    }

    private String getOtherBaseDataField(String fieldAlias) {
        String pre = fieldAlias.substring(0, fieldAlias.lastIndexOf("."));
        String otherAlias = fieldAlias.endsWith(".name") ? pre + ".number" : pre + ".name";
        return otherAlias;
    }

    private void convertQFilterKey(QFilter qFilter, String newIdAlias) {
        qFilter.__setProperty(newIdAlias);
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestQFilter = nest.getFilter();
            this.convertQFilterKey(nestQFilter, newIdAlias);
        }
    }
}

