/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.datatype.StringType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.util.BaseDataLoadUtil;
import kd.hr.hbp.business.service.complexobj.util.EntityFieldTransfer;
import kd.hr.hbp.business.service.complexobj.util.SplitDateByDBTransFunction;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsStorageFactory;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hrptmc.business.center.query.util.EsQueryUtil;
import kd.hr.hrptmc.business.center.servicehelper.ReportEsServiceHelper;
import kd.hr.hrptmc.business.common.DataSetTransUtil;

public class EsQueryService {
    private static final Log LOGGER = LogFactory.getLog(EsQueryService.class);
    public static final int MAX_QUERY_COUNT = 99999;
    protected static EsStorage ES_STORAGE = EsStorageFactory.getStorage((String)"hr");
    protected final HRComplexObjContext complexObjCont;
    protected final SplitDateByDBTransFunction splitDateByDBTransFunction = new SplitDateByDBTransFunction();

    public EsQueryService(HRComplexObjContext complexObjCont) {
        this.complexObjCont = complexObjCont;
    }

    public HRComplexObjContext getComplexObjCont() {
        return this.complexObjCont;
    }

    public DataSet query4DataSet() {
        List<Map<String, Object>> dataList = this.query4ListMap();
        List<Field> fieldList = this.getFieldList();
        return DataSetTransUtil.listToDataset(dataList, fieldList);
    }

    public DataSet query4DataSet(int start, int limit) {
        List<Map<String, Object>> dataList = this.query4ListMap(start, limit);
        List<Field> fieldList = this.getFieldList();
        return DataSetTransUtil.listToDataset(dataList, fieldList);
    }

    @ExcludeFromJacocoGeneratedReport
    public List<Map<String, Object>> query4ListMap(int start, int limit) {
        List<EsFilterField> filters = this.getFilters();
        List complexObjFieldInfoList = this.complexObjCont.getComplexObjFieldInfoList();
        HashMap replaceAliasMap = Maps.newHashMapWithExpectedSize((int)complexObjFieldInfoList.size());
        String[] selectFields = this.getSelectFields(complexObjFieldInfoList, replaceAliasMap);
        SortField[] sortFields = this.getSortField();
        Map objSortValueMap = this.complexObjCont.getObjSortValueMap();
        Object[] objSortValues = null;
        if (objSortValueMap != null) {
            objSortValues = (Object[])objSortValueMap.get(start);
        } else {
            objSortValueMap = Maps.newHashMapWithExpectedSize((int)64);
            this.complexObjCont.setObjSortValueMap(objSortValueMap);
        }
        if (start > 0 && objSortValues == null) {
            return Lists.newArrayList();
        }
        EsResultVo resultVo = this.queryData(selectFields, filters, sortFields, start, limit, objSortValues);
        List dataList = resultVo.getResultData();
        if (resultVo.getObjSortValues() != null) {
            Object[] objectArray = objSortValues = resultVo.getObjSortValues().length == 0 ? null : resultVo.getObjSortValues();
        }
        if (start != -1) {
            int esLimit = this.complexObjCont.getEsLimit();
            if (limit == esLimit + 1) {
                objSortValueMap.put(start + esLimit, objSortValues);
            } else {
                objSortValueMap.put(start + limit, objSortValues);
            }
        }
        this.handleResult(dataList, replaceAliasMap);
        return dataList;
    }

    public List<Map<String, Object>> query4ListMap() {
        List<Map<String, Object>> dataList;
        int start = 0;
        ArrayList allDataList = Lists.newArrayListWithExpectedSize((int)128);
        while (!(dataList = this.query4ListMap(start, 99999)).isEmpty()) {
            allDataList.addAll(dataList);
            if (dataList.size() < 99999) break;
            start += 99999;
        }
        return allDataList;
    }

    @ExcludeFromJacocoGeneratedReport
    public long queryDataCount(int start, int limit) {
        List<EsFilterField> filters = this.getFilters();
        int count = ES_STORAGE.getCount(this.complexObjCont.getEsIndex(), "t_data", filters);
        if (limit != -1 && limit < count) {
            return limit;
        }
        return count;
    }

    protected void handleResult(List<Map<String, Object>> dataList, Map<String, String> replaceAliasMap) {
        this.addRowNum(dataList);
        this.backAlias(dataList, replaceAliasMap);
        if (!this.complexObjCont.isTransferField()) {
            EntityFieldTransfer entityFieldTransfer = new EntityFieldTransfer(new KSqlParser(this.complexObjCont), this.complexObjCont);
            List fieldInfoList = entityFieldTransfer.transfer((Map)Maps.newHashMap(), (Set)Sets.newHashSet(), (Set)Sets.newHashSet());
            BaseDataLoadUtil.dataTransfer(dataList, (List)fieldInfoList, (List)this.complexObjCont.getComplexObjFieldInfoList(), (HRComplexObjContext)this.complexObjCont);
        }
    }

    protected EsResultVo queryData(String[] selectFields, List<EsFilterField> filters, SortField[] sortFields, int start, int limit, Object[] objSortValues) {
        EsResultVo resultVo;
        int esLimit;
        LOGGER.info("EsQueryService_queryData_objSortValues:{}", objSortValues);
        if (sortFields.length == 0) {
            sortFields = new SortField[]{new SortField("id", true)};
        }
        if (limit == (esLimit = this.complexObjCont.getEsLimit()) + 1) {
            resultVo = ES_STORAGE.searchAfter(this.complexObjCont.getEsIndex(), "t_data", selectFields, filters, sortFields, true, start, esLimit, objSortValues);
            EsResultVo resultVo1 = ES_STORAGE.searchAfter(this.complexObjCont.getEsIndex(), "t_data", selectFields, filters, sortFields, true, start + esLimit, 1, resultVo.getObjSortValues());
            resultVo.getResultData().addAll(resultVo1.getResultData());
        } else {
            resultVo = ES_STORAGE.searchAfter(this.complexObjCont.getEsIndex(), "t_data", selectFields, filters, sortFields, true, start, limit, objSortValues);
        }
        return resultVo;
    }

    protected String[] getSelectFields(List<HRComplexObjFieldInfo> complexObjFieldInfoList, Map<String, String> replaceAliasMap) {
        return (String[])complexObjFieldInfoList.stream().map(hf -> {
            String alias = hf.getAlias();
            if (alias.contains(".")) {
                String newAlias = ReportEsServiceHelper.replaceSpecChar(alias);
                replaceAliasMap.put(newAlias, alias);
                return newAlias;
            }
            return alias;
        }).distinct().toArray(String[]::new);
    }

    protected List<EsFilterField> getFilters() {
        List qFilterList = this.complexObjCont.getQfilterList();
        ArrayList esFilterFieldList = Lists.newArrayListWithExpectedSize((int)qFilterList.size());
        for (QFilter qFilter : qFilterList) {
            if ("1".equals((qFilter = qFilter.trans((Function)this.splitDateByDBTransFunction)).getProperty())) {
                List nests = qFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    EsFilterField esFilterField = EsQueryUtil.convertQFilter(nest.getFilter());
                    esFilterFieldList.add(esFilterField);
                }
                continue;
            }
            EsFilterField esFilterField = EsQueryUtil.convertQFilter(qFilter);
            esFilterFieldList.add(esFilterField);
        }
        return esFilterFieldList;
    }

    protected SortField[] getSortField() {
        List sortFieldInfoList = this.complexObjCont.getSortFieldInfoList();
        SortField[] sortFields = new SortField[sortFieldInfoList.size()];
        for (int i = 0; i < sortFieldInfoList.size(); ++i) {
            SortFieldInfo sortFieldInfo = (SortFieldInfo)sortFieldInfoList.get(i);
            String fieldAlias = sortFieldInfo.getFieldAlias();
            int index = this.indexDateSplitWithDate(fieldAlias, Maps.newHashMap());
            if (index != -1) {
                fieldAlias = fieldAlias.substring(0, index);
            }
            String newProKey = ReportEsServiceHelper.replaceSpecChar(fieldAlias);
            sortFields[i] = new SortField(newProKey, SortFieldInfo.SORTORD_ASC.equalsIgnoreCase(sortFieldInfo.getSortord()));
        }
        return sortFields;
    }

    private void addRowNum(List<Map<String, Object>> dataList) {
        int index = 0;
        for (Map<String, Object> map : dataList) {
            map.put("rptdbsortidx", index++);
        }
    }

    private List<Field> getFieldList() {
        List complexObjFieldInfoList = this.complexObjCont.getComplexObjFieldInfoList();
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)complexObjFieldInfoList.size());
        HashSet aliasSet = Sets.newHashSetWithExpectedSize((int)complexObjFieldInfoList.size());
        for (HRComplexObjFieldInfo hrComplexObjFieldInfo : complexObjFieldInfoList) {
            if (!aliasSet.add(hrComplexObjFieldInfo.getAlias())) continue;
            Field field = new Field(hrComplexObjFieldInfo.getAlias(), this.convert2DataType(hrComplexObjFieldInfo.getDataType(), this.complexObjCont.isTransferField()));
            fieldList.add(field);
        }
        return fieldList;
    }

    private DataType convert2DataType(DataTypeEnum dataTypeEnum, boolean isTransferField) {
        StringType dataType;
        switch (dataTypeEnum) {
            case STRING: 
            case LOCALESTRING: {
                dataType = DataType.StringType;
                break;
            }
            case LONG: {
                dataType = DataType.LongType;
                break;
            }
            case INTEGER: {
                dataType = DataType.IntegerType;
                break;
            }
            case BOOLEAN: {
                if (!isTransferField) {
                    dataType = DataType.StringType;
                    break;
                }
                dataType = DataType.BooleanType;
                break;
            }
            case DATETIME: {
                if (!isTransferField) {
                    dataType = DataType.StringType;
                    break;
                }
                dataType = DataType.DateType;
                break;
            }
            case BIGDECIMAL: {
                dataType = DataType.BigDecimalType;
                break;
            }
            default: {
                dataType = null;
            }
        }
        return dataType;
    }

    private void backAlias(List<Map<String, Object>> dataList, Map<String, String> replaceAliasMap) {
        for (Map.Entry<String, String> entry : replaceAliasMap.entrySet()) {
            String newAlias = entry.getKey();
            String originAlias = entry.getValue();
            for (Map<String, Object> map : dataList) {
                Object remove = map.remove(newAlias);
                map.put(originAlias, remove);
            }
        }
    }

    protected int indexDateSplitWithDate(String fieldAlias, Map<String, SplitDateTypeEnum> dateSplitWithDateMap) {
        int index = fieldAlias.indexOf("!");
        if (index != -1) {
            SplitDateTypeEnum splitDateTypeEnum = null;
            if (fieldAlias.contains(SplitDateTypeEnum.SN_YEAR.getKey())) {
                splitDateTypeEnum = SplitDateTypeEnum.SN_YEAR;
            } else if (fieldAlias.contains(SplitDateTypeEnum.FN_YEAR.getKey())) {
                splitDateTypeEnum = SplitDateTypeEnum.FN_YEAR;
            } else if (fieldAlias.contains(SplitDateTypeEnum.SN_YEAR_QUARTER.getKey())) {
                splitDateTypeEnum = SplitDateTypeEnum.SN_YEAR_QUARTER;
            } else if (fieldAlias.contains(SplitDateTypeEnum.FN_YEAR_QUARTER.getKey())) {
                splitDateTypeEnum = SplitDateTypeEnum.FN_YEAR_QUARTER;
            } else if (fieldAlias.contains(SplitDateTypeEnum.SN_YEAR_MONTH.getKey())) {
                splitDateTypeEnum = SplitDateTypeEnum.SN_YEAR_MONTH;
            } else if (fieldAlias.contains(SplitDateTypeEnum.FN_YEAR_MONTH.getKey())) {
                splitDateTypeEnum = SplitDateTypeEnum.FN_YEAR_MONTH;
            } else if (fieldAlias.contains(SplitDateTypeEnum.FN_YEAR_MONTH_DAY.getKey())) {
                splitDateTypeEnum = SplitDateTypeEnum.FN_YEAR_MONTH_DAY;
            }
            if (splitDateTypeEnum != null) {
                dateSplitWithDateMap.put(fieldAlias, splitDateTypeEnum);
                return index;
            }
        }
        return -1;
    }
}

