/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.utils;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.center.utils.ReportCenterUtil;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeValueBo;

public class ReportCenterAdminOrgFilterUtil {
    private static final Log LOGGER = LogFactory.getLog(ReportCenterAdminOrgFilterUtil.class);

    public static List<QFilter> getShareAndMySubscribeAdminOrgQFilter(FilterBo filterBo, Map<String, Object> customParams) {
        String openFrom = (String)customParams.get("openFrom");
        Object versionTime = customParams.get("versionTime");
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        if (!HRStringUtils.equals((String)openFrom, (String)"share") && !HRStringUtils.equals((String)openFrom, (String)"mySubscribe")) {
            return qFilters;
        }
        if (HRStringUtils.equals((String)filterBo.getFilterType(), (String)FilterType.ADMIN_ORG.getValue())) {
            qFilters.addAll(ReportCenterAdminOrgFilterUtil.getAdminOrgQFilters(openFrom, versionTime));
            QFilter adminOrgPermQFilter = ReportCenterAdminOrgFilterUtil.getAdminOrgPermQFilter(filterBo, customParams);
            if (adminOrgPermQFilter != null) {
                qFilters.add(adminOrgPermQFilter);
            }
        }
        return qFilters;
    }

    public static void setShareAndMySubscribeAdminOrgStructParams(ListShowParameter f7ShowParameter, String architectureId, String fieldAlias, Map<String, Object> customParams) {
        Map adminOrgF7PermQFilterMap;
        Map qFilterMap;
        String adminOrgF7PermQFilterStr = (String)customParams.get(ReportCenterUtil.PARAM_ADMIN_ORG_F7_PERM_QFILTER);
        ArrayList structIds = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)adminOrgF7PermQFilterStr) && (qFilterMap = (Map)(adminOrgF7PermQFilterMap = (Map)SerializationUtils.fromJsonString((String)adminOrgF7PermQFilterStr, Map.class)).get(fieldAlias)) != null) {
            structIds.addAll(qFilterMap.keySet().stream().map(Long::parseLong).collect(Collectors.toList()));
            f7ShowParameter.setCustomParam("subscribeOrShareAdminOrgF7PermQFilters", (Object)SerializationUtils.toJsonString((Object)qFilterMap));
        }
        LOGGER.info("setShareAndMySubscribeAdminOrgStructParams getStructIds= {}", (Object)structIds);
        f7ShowParameter.setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString((Object)structIds));
        f7ShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"report_pre_org_field");
        f7ShowParameter.setCustomParam("currentAdminOrgStruct", (Object)architectureId);
        f7ShowParameter.setFormId("hrptmc_orgpermtreelistf7");
        f7ShowParameter.setBillFormId("hrptmc_adminorghr");
    }

    private static QFilter getAdminOrgPermQFilter(FilterBo filterBo, Map<String, Object> customParams) {
        Map<String, QFilter> baseDataPermQFilter;
        String baseDataPermQFilterStr = (String)customParams.get(ReportCenterUtil.PARAM_BASE_DATA_PERM_QFTILER);
        if (HRStringUtils.isNotEmpty((String)baseDataPermQFilterStr) && (baseDataPermQFilter = ReportCenterUtil.getBaseDataF7PermQFilters(baseDataPermQFilterStr)) != null) {
            QFilter qFilter = baseDataPermQFilter.get(filterBo.getFieldAlias());
            if (qFilter != null && HRStringUtils.equals((String)qFilter.getProperty(), (String)"id")) {
                qFilter.__setProperty("boid");
            }
            return qFilter;
        }
        return null;
    }

    public static List<QFilter> getAdminOrgQFilters(String openFrom, Object versionTime) {
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        if (!HRStringUtils.equals((String)openFrom, (String)"share") && !HRStringUtils.equals((String)openFrom, (String)"mySubscribe") || versionTime == null) {
            return qFilters;
        }
        try {
            Date versionTimeDate;
            if (versionTime instanceof String) {
                try {
                    versionTimeDate = HRDateTimeUtils.parseDate((String)((String)versionTime));
                }
                catch (ParseException ex) {
                    LOGGER.error("handleAdminOrgHisF7 parseDate error: ", (Throwable)ex);
                    return qFilters;
                }
            } else {
                versionTimeDate = (Date)versionTime;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(versionTimeDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE));
            qFilters.add(new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toList())));
            qFilters.add(new QFilter("bsed", "<=", (Object)calendar.getTime()));
            qFilters.add(new QFilter("bsled", ">=", (Object)calendar.getTime()));
        }
        catch (Exception exception) {
            LOGGER.error("ReportCenterAdminOrgFilterUtil getAdminOrgQFilters:", (Throwable)exception);
        }
        return qFilters;
    }

    public static Set<Object> getAdminOrgBoIds(FilterBo filterBo, Set<Object> ids) {
        if (!filterBo.getHisData() || !HRStringUtils.equals((String)filterBo.getFilterType(), (String)FilterType.ADMIN_ORG.getValue())) {
            return ids;
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObjectCollection boDys = adminOrgHelper.queryOriginalCollection("boid", new QFilter[]{new QFilter("id", "in", ids)});
        return boDys.stream().map(dy -> dy.get("boid")).collect(Collectors.toSet());
    }

    public static Object getAdminOrgBoId(FilterBo filterBo, Object id) {
        if (!filterBo.getHisData() || !HRStringUtils.equals((String)filterBo.getFilterType(), (String)FilterType.ADMIN_ORG.getValue())) {
            return id;
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject boDy = adminOrgHelper.queryOriginalOne("boid", new QFilter[]{new QFilter("id", "=", id)});
        if (boDy != null) {
            return boDy.get("boid");
        }
        return id;
    }

    public static Object getAdminOrgBoId(Object id) {
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject boDy = adminOrgHelper.queryOriginalOne("boid", new QFilter[]{new QFilter("id", "=", id)});
        if (boDy != null) {
            return boDy.get("boid");
        }
        return id;
    }

    public static List<Long> getAdminOrgBoIds(List<Long> ids) {
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObjectCollection boDys = adminOrgHelper.queryOriginalCollection("boid", new QFilter[]{new QFilter("id", "in", ids)});
        if (boDys.isEmpty()) {
            return ids;
        }
        return boDys.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
    }

    public static String getAdminOrgBoIdForQueryScheme(QuerySchemeValueBo querySchemeValueBo, String baseDataId) {
        try {
            String baseDataNum = querySchemeValueBo.getQuerySchemeFieldBo().getBaseDataNum();
            if (!HRStringUtils.equals((String)"haos_adminorghr", (String)baseDataNum) || HRStringUtils.isEmpty((String)baseDataId)) {
                return baseDataId;
            }
            HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
            if (baseDataId.contains(",")) {
                List ids = Arrays.stream(baseDataId.split(",")).filter(HRStringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
                DynamicObjectCollection boDys = adminOrgHelper.queryOriginalCollection("boid", new QFilter[]{new QFilter("id", "in", ids)});
                return boDys.stream().map(dy -> dy.getString("boid")).collect(Collectors.joining(","));
            }
            DynamicObject boDy = adminOrgHelper.queryOriginalOne("boid", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(baseDataId))});
            if (boDy != null) {
                return boDy.getString("boid");
            }
            return baseDataId;
        }
        catch (Exception exception) {
            LOGGER.error("ReportCenterAdminOrgFilterUtil getAdminOrgBoIdForQueryScheme error: ", (Throwable)exception);
            return baseDataId;
        }
    }

    public static void switchReportSchemeAdminOrgData(List<QuerySchemeBo> schemeBos, Map<String, Object> formShowPrams) {
        if (schemeBos == null || schemeBos.isEmpty()) {
            return;
        }
        try {
            List querySchemeValueBos = schemeBos.stream().flatMap(schemeBo -> schemeBo.getQuerySchemeList().stream()).filter(queryScheme -> HRStringUtils.equals((String)queryScheme.getQuerySchemeFieldBo().getBaseDataNum(), (String)"haos_adminorghr")).collect(Collectors.toList());
            if (querySchemeValueBos.isEmpty()) {
                return;
            }
            String openFrom = (String)formShowPrams.get("openFrom");
            if (HRStringUtils.equals((String)"reportCenter", (String)openFrom) || HRStringUtils.equals((String)"subscribe", (String)openFrom)) {
                for (QuerySchemeValueBo querySchemeValueBo : querySchemeValueBos) {
                    ReportCenterAdminOrgFilterUtil.handleSchemeAdminOrgDataForBo(querySchemeValueBo);
                }
            } else if (HRStringUtils.equals((String)"share", (String)openFrom) || HRStringUtils.equals((String)"mySubscribe", (String)openFrom)) {
                Date versionTime = ReportCenterUtil.getVersionTime(formShowPrams);
                for (QuerySchemeValueBo querySchemeValueBo : querySchemeValueBos) {
                    ReportCenterAdminOrgFilterUtil.handleSchemeAdminOrgDataForVersion(querySchemeValueBo, versionTime);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportCenterUtil switchReportSchemeAdminOrgData error:", (Throwable)exception);
        }
    }

    private static void handleSchemeAdminOrgDataForBo(QuerySchemeValueBo querySchemeValueBo) {
        String baseDataId = querySchemeValueBo.getBaseDataId();
        if (HRStringUtils.isEmpty((String)baseDataId)) {
            return;
        }
        String newBaseDataId = baseDataId;
        String newName = querySchemeValueBo.getName();
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        if (baseDataId.contains(",")) {
            List ids = Arrays.stream(baseDataId.split(",")).filter(HRStringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
            DynamicObjectCollection boDys = adminOrgHelper.queryOriginalCollection("boid, name", new QFilter[]{new QFilter("id", "in", ids)});
            if (!boDys.isEmpty()) {
                newBaseDataId = boDys.stream().map(dy -> dy.getString("boid")).collect(Collectors.joining(","));
                newName = boDys.stream().map(dy -> dy.getString("name")).collect(Collectors.joining(","));
            }
        } else {
            DynamicObject boDy = adminOrgHelper.queryOriginalOne("boid, name", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(baseDataId))});
            if (boDy != null) {
                newBaseDataId = boDy.getString("boid");
                newName = boDy.getString("name");
            }
        }
        querySchemeValueBo.setName(newName);
        querySchemeValueBo.setValue(newBaseDataId);
        querySchemeValueBo.setBaseDataId(newBaseDataId);
    }

    private static void handleSchemeAdminOrgDataForVersion(QuerySchemeValueBo querySchemeValueBo, Date versionTime) {
        String baseDataId = querySchemeValueBo.getBaseDataId();
        if (HRStringUtils.isEmpty((String)baseDataId)) {
            return;
        }
        String newBaseDataId = baseDataId;
        String newName = querySchemeValueBo.getName();
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        qFilters.add(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        qFilters.add(new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toList())));
        qFilters.add(new QFilter("bsed", "<=", (Object)versionTime));
        qFilters.add(new QFilter("bsled", ">=", (Object)versionTime));
        if (baseDataId.contains(",")) {
            List ids = Arrays.stream(baseDataId.split(",")).filter(HRStringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
            qFilters.add(new QFilter("boid", "in", ids));
            DynamicObjectCollection boDys = adminOrgHelper.queryOriginalCollection("id, name", qFilters.toArray(new QFilter[0]));
            if (!boDys.isEmpty()) {
                newBaseDataId = boDys.stream().map(dy -> dy.getString("id")).collect(Collectors.joining(","));
                newName = boDys.stream().map(dy -> dy.getString("name")).collect(Collectors.joining(","));
            }
        } else {
            qFilters.add(new QFilter("boid", "=", (Object)Long.parseLong(baseDataId)));
            DynamicObject boDy = adminOrgHelper.queryOriginalOne("id, name", (Object)qFilters);
            if (boDy != null) {
                newBaseDataId = boDy.getString("id");
                newName = boDy.getString("name");
            }
        }
        querySchemeValueBo.setName(newName);
        querySchemeValueBo.setValue(newBaseDataId);
        querySchemeValueBo.setBaseDataId(newBaseDataId);
    }
}

