/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hrptmc.common.constant.dataextract.DataStoreLogConstants;

public class DataStoreLogService
implements DataStoreLogConstants {
    private static final Log LOGGER = LogFactory.getLog(DataStoreLogService.class);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrptmc_dataextractlog");
    private final Long id;
    private final boolean isReport;
    private DynamicObject log;

    public DataStoreLogService(Long id, boolean isReport) {
        this.id = id;
        this.isReport = isReport;
        this.log = this.getLog();
    }

    private DynamicObject getLog() {
        QFilter qFilter = this.isReport ? new QFilter("report", "=", (Object)this.id) : new QFilter("anobj", "=", (Object)this.id);
        qFilter.and(new QFilter("status", "=", (Object)"0"));
        DynamicObject[] dynamicObjects = SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        List logList = Arrays.stream(dynamicObjects).sorted((x1, x2) -> x2.getDate("starttime").compareTo(x1.getDate("starttime"))).collect(Collectors.toList());
        if (!logList.isEmpty()) {
            return (DynamicObject)logList.get(0);
        }
        return null;
    }

    public void insertLog(String entityNum, String tableName) {
        DynamicObject log = this.initLog();
        log.set("entitynumber", (Object)entityNum);
        log.set("tablename", (Object)tableName);
        SERVICE_HELPER.saveOne(log);
        this.log = log;
    }

    public void updateCount(int count) {
        if (this.log != null) {
            String idKey = this.isReport ? "freportid" : "fanobjid";
            String updateSql = "update t_hrptmc_dataextractlog set fcount = fcount + ?, fmodifytime = ? where " + idKey + "= ? and fstatus = '0'";
            Object[] params = new Object[]{count, new Date(), this.id};
            ThreadPools.executeOnce((String)"DataStoreLogService_updateCount", () -> HRDBUtil.execute((DBRoute)new DBRoute("hmp"), (String)updateSql, (Object[])params));
        }
    }

    public void end() {
        if (this.log != null) {
            this.log.set("status", (Object)"1");
            this.log.set("traceid", (Object)RequestContext.get().getTraceId());
            this.finish(this.log);
        }
    }

    public void stop() {
        if (this.log != null) {
            this.log.set("status", (Object)"3");
            this.finish(this.log);
        }
    }

    public void error(String msg) {
        if (this.log == null) {
            this.log = this.initLog();
        }
        this.log.set("status", (Object)"2");
        this.log.set("errmsg", (Object)msg);
        this.log.set("traceid", (Object)RequestContext.get().getTraceId());
        ThreadPools.executeOnce((String)"DataStoreLogService_error", () -> this.finish(this.log));
    }

    private void finish(DynamicObject log) {
        Date date = new Date();
        Date startTime = log.getDate("starttime");
        int costTime = (int)((date.getTime() - startTime.getTime()) / 1000L);
        log.set("endtime", (Object)date);
        log.set("costtime", (Object)costTime);
        SERVICE_HELPER.saveOne(log);
    }

    private DynamicObject initLog() {
        DynamicObject log = SERVICE_HELPER.generateEmptyDynamicObject();
        if (this.isReport) {
            log.set("report", (Object)this.id);
            log.set("type", (Object)"1");
        } else {
            log.set("anobj", (Object)this.id);
            log.set("type", (Object)"0");
        }
        log.set("starttime", (Object)new Date());
        log.set("createtime", log.get("starttime"));
        log.set("status", (Object)"0");
        return log;
    }
}

