/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore;

import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.datastore.metadata.util.RptDataStoreUtil;
import kd.hr.hrptmc.business.datastore.model.BatchQueryAndSaveDataBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;
import kd.hr.hrptmc.business.datastore.queryservice.ReportDataExtractQueryService;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repdesign.datastore.FieldDataStoreBO;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;

public interface IDataStoreService {
    public static final Log LOGGER = LogFactory.getLog(IDataStoreService.class);
    public static final char[] RANDOM_CHAR = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final SecureRandom RANDOM = new SecureRandom();
    public static final Integer MAX_SIZE = 100000;

    public boolean beforeExecute();

    public void execute();

    public void endExecute();

    public void endSyn();

    public void batchSynData(List<Object> var1);

    public String getMainEntityNumber();

    public String generateEntityNumPre();

    default public String generateEntityNum() {
        String entityNum = this.generateEntityNumPre() + this.genRandomPwd();
        if (this.isEntityNumExist(entityNum)) {
            return this.generateEntityNum();
        }
        return entityNum;
    }

    default public String generateTableName(String entityNum) {
        return "t_" + entityNum;
    }

    default public String genRandomPwd() {
        int maxNum = 36;
        int count = 0;
        StringBuilder pwd = new StringBuilder();
        while (count < 8) {
            int i = Math.abs(RANDOM.nextInt(maxNum));
            if (i < 0 || i >= RANDOM_CHAR.length) continue;
            pwd.append(RANDOM_CHAR[i]);
            ++count;
        }
        return pwd.toString();
    }

    default public void setUserId() {
        String userId = RequestContext.get().getUserId();
        if (userId == null) {
            RequestContext.get().setUserId("1");
        }
    }

    default public boolean isWarningDtsConfig(String entityNum, String mappingRule) {
        String sql = "SELECT FSTATUS,FENTITYNUMBER,FMAPPINGRULE FROM T_DTS_DATASYNCCONFIG WHERE FENTITYNUMBER = ? AND FMAPPINGRULE = ?";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"IDataStoreService#getDtsConfigStatus", (DBRoute)new DBRoute("sys"), (String)sql, (Object[])new Object[]{entityNum, mappingRule});
        if (dataSet.isEmpty()) {
            return true;
        }
        String status = null;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            status = row.getString("FSTATUS");
        }
        dataSet.close();
        return HRStringUtils.equals((String)"working", status) || HRStringUtils.equals((String)"prepareError", (String)status);
    }

    default public boolean isEntityNumExist(String entityNum) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entitymeta");
        return serviceHelper.isExists(new QFilter("number", "=", (Object)entityNum));
    }

    default public int batchQueryAndSaveData(BatchQueryAndSaveDataBo bo) {
        long anObjId = bo.getAnObjId();
        long reportId = bo.getReportId();
        HRBaseServiceHelper newServiceHelper = bo.getNewServiceHelper();
        ReportDataExtractQueryService queryService = bo.getQueryService();
        FieldDataStoreBO dataStoreBO = bo.getDataStoreBO();
        int start = bo.getStart();
        int limit = bo.getLimit();
        List<QFilter> newQFilterList = bo.getNewQFilterList();
        long time0 = System.currentTimeMillis();
        ReportResult reportResult = reportId != 0L ? queryService.queryDetailData(anObjId, reportId, dataStoreBO.getStoreFieldInfoList(), start, limit, newQFilterList) : queryService.queryDetailData(anObjId, bo.getFilterStoreFieldListByAno(), start, limit, newQFilterList);
        long time1 = System.currentTimeMillis();
        LOGGER.info("IDataStoreService_batchSynData_singleQuery_time:{},start:{},limit:{}", new Object[]{time1 - time0, start, limit});
        List<CalResult> calResultList = reportResult.getCalResultList();
        List<FieldInfo> storeFieldList = dataStoreBO.getStoreFieldInfoList();
        Map<String, FieldInfo> rep2AnoMapping = storeFieldList.stream().collect(Collectors.toMap(FieldInfo::getNumberAlias, sf -> sf));
        DynamicObjectCollection saveCol = new DynamicObjectCollection();
        for (CalResult calResult : calResultList) {
            DynamicObject row = newServiceHelper.generateEmptyDynamicObject();
            Row rowData = calResult.getRowData();
            for (Map.Entry<String, RptMetaFieldMap> entry : bo.getMappingFieldMap().entrySet()) {
                String key = entry.getKey();
                RptMetaFieldMap value = entry.getValue();
                String fieldControlType = value.getFieldControlType();
                String metaFieldNumber = value.getMetaFieldNumber();
                String fieldAlias = value.getFieldAlias();
                Object newValue = null;
                if (ReportDataStoreServiceHelper.isBaseData(fieldAlias, fieldControlType)) {
                    metaFieldNumber = metaFieldNumber.substring(0, metaFieldNumber.lastIndexOf(".id"));
                    newValue = rowData.get(key);
                } else if (key.endsWith("\u03b9index")) {
                    FieldInfo sortIndexField = rep2AnoMapping.get(key);
                    Map<Object, Integer> idMap = bo.getCustomSortMap().get(sortIndexField.getRowFieldId());
                    if (idMap != null) {
                        String numberAliasKey = key.substring(0, key.length() - 6);
                        FieldInfo sortOriginField = rep2AnoMapping.get(numberAliasKey);
                        if (FieldComplexType.BASE_DATA.getValue().equals(sortOriginField.getComplexType())) {
                            numberAliasKey = numberAliasKey.substring(0, numberAliasKey.lastIndexOf(".")) + ".id";
                        }
                        newValue = idMap.get(rowData.get(numberAliasKey));
                    }
                } else {
                    newValue = ReportDataStoreServiceHelper.convertValue(fieldAlias, rowData.get(key));
                }
                row.set(metaFieldNumber, newValue);
            }
            saveCol.add((Object)row);
        }
        newServiceHelper.save(saveCol);
        long time2 = System.currentTimeMillis();
        LOGGER.info("IDataStoreService_batchSynData_singleSave_time:{}", (Object)(time2 - time1));
        return calResultList.size();
    }

    default public List<FieldInfo> getEntityIdFieldList(long anoId, List<RptMetaFieldMap> rptMetaFieldMapList, String mainEntityNum) {
        List<RptMetaFieldMap> joinEntityIdFieldMap = RptDataStoreUtil.getJoinEntityIdFieldMap(anoId, rptMetaFieldMapList);
        ArrayList entityIdFieldList = Lists.newArrayListWithExpectedSize((int)rptMetaFieldMapList.size());
        for (RptMetaFieldMap rptMetaFieldMap : joinEntityIdFieldMap) {
            String fieldAlias = rptMetaFieldMap.getFieldAlias();
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setNumber(fieldAlias);
            fieldInfo.setNumberAlias(fieldInfo.getNumber());
            fieldInfo.setName(new LocaleString(fieldAlias));
            fieldInfo.setDisplayName(fieldInfo.getName());
            String tableFieldType = rptMetaFieldMap.getTableFieldType();
            if (ReportDataStoreType.BIGINT.getType().equals(tableFieldType)) {
                fieldInfo.setValueType(DataTypeEnum.LONG.getDataTypeKey());
            } else {
                fieldInfo.setValueType(DataTypeEnum.STRING.getDataTypeKey());
            }
            fieldInfo.setFieldPath(fieldAlias);
            ReportDataStoreServiceHelper.setType(fieldInfo);
            int index = fieldAlias.lastIndexOf(".id");
            String entityNum = index == -1 ? mainEntityNum : fieldAlias.substring(0, index);
            fieldInfo.setEntityNumber(entityNum);
            entityIdFieldList.add(fieldInfo);
        }
        return entityIdFieldList;
    }
}

