/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore.metadata.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.model.report.DayTypeEnum;
import kd.hr.hbp.common.model.report.MonthTypeEnum;
import kd.hr.hbp.common.model.report.QuarterTypeEnum;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldMaxLengthService;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.business.datastore.metadata.model.RptEntityMetaFieldContent;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.model.DataStoreTableBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class RptMetaFieldTransferUtil {
    private static final Log LOGGER = LogFactory.getLog(RptMetaFieldTransferUtil.class);

    public static List<RptEntityMetaFieldContent.ComboItemContent> comboItemsToComboItemContents(List<ValueMapItem> comboItems) {
        AtomicInteger index = new AtomicInteger();
        return comboItems.stream().map(item -> {
            RptEntityMetaFieldContent.ComboItemContent comboItemContent = new RptEntityMetaFieldContent.ComboItemContent();
            comboItemContent.setCaption(item.getName().getLocaleValue());
            comboItemContent.setIndex(index.getAndIncrement());
            comboItemContent.setValue(item.getValue());
            return comboItemContent;
        }).collect(Collectors.toList());
    }

    public static List<RptEntityMetaFieldContent.ComboItemContent> anObjEnumItemsToComboItemContents(List<AnObjEnumFieldHandler.AnObjEnumItem> enumItems) {
        AtomicInteger index = new AtomicInteger();
        return enumItems.stream().map(item -> {
            RptEntityMetaFieldContent.ComboItemContent comboItemContent = new RptEntityMetaFieldContent.ComboItemContent();
            comboItemContent.setCaption(item.getName().getLocaleValue());
            comboItemContent.setIndex(index.getAndIncrement());
            comboItemContent.setValue(item.getValue());
            return comboItemContent;
        }).collect(Collectors.toList());
    }

    public static List<RptEntityMetaFieldContent> fieldInfoToEntityMetaFields(int index, long anObjId, List<FieldInfo> reportFieldInfoList, List<RptMetaFieldMap> metaFieldMapList) {
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>(reportFieldInfoList);
        Set<String> joinEntityIdFields = RptMetaFieldTransferUtil.addJoinEntityIdFieldForReport(anObjId, fieldInfoList);
        RptMetaFieldTransferUtil.handleRepeatReportField(fieldInfoList);
        List<FieldInfo> repeatFieldList = RptMetaFieldTransferUtil.getRepeatFieldList(fieldInfoList);
        RptMetaFieldTransferUtil.addBaseDataIdFieldForReport(fieldInfoList, mainEntityTypeUtil);
        String[] idStrArr = ID.genStringIds((int)fieldInfoList.size());
        ArrayList metaFieldList = Lists.newArrayListWithCapacity((int)fieldInfoList.size());
        AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(anObjId, mainEntityTypeUtil);
        Map<String, Integer> calFieldMaxLenMap = CalculateFieldMaxLengthService.getInstance().getCalFieldMaxLenForAnObj(anObjId);
        String userTimeZone = DateTimeFieldTimeZoneUtil.getUserTimeZone();
        int idIndex = 0;
        for (FieldInfo fieldInfo : fieldInfoList) {
            RptEntityMetaFieldContent fieldContent;
            String fieldNumber = "field" + index;
            String fieldName = "f" + fieldNumber;
            if (fieldInfo.getNumber().endsWith(".id") || HRStringUtils.equals((String)fieldInfo.getNumber(), (String)"id")) {
                fieldInfo.setControlType(FieldControlType.BASE_DATA.getValue());
            }
            if (fieldInfo.getNumber().startsWith("RPTDIMCOUNT_")) {
                fieldInfo.setControlType(FieldControlType.INTEGER.getValue());
            }
            String id = idStrArr[idIndex];
            String fieldSrc = fieldInfo.getFieldSrc();
            if (HRStringUtils.equals((String)fieldSrc, (String)"0")) {
                QueryFieldBo queryFieldBo = RptMetaFieldTransferUtil.fieldInfoToQueryField(fieldInfo, userTimeZone, mainEntityTypeUtil);
                RptMetaFieldTransferUtil.handleReportDateSplitField(queryFieldBo);
                boolean isJoinEntityIdField = joinEntityIdFields.contains(queryFieldBo.getFieldAlias());
                fieldContent = RptMetaFieldTransferUtil.getFieldContentByQueryField(id, fieldNumber, fieldName, queryFieldBo, isJoinEntityIdField, enumFieldHandler, mainEntityTypeUtil);
                metaFieldList.add(fieldContent);
            } else {
                if (!HRStringUtils.equals((String)fieldSrc, (String)"1")) continue;
                CalculateFieldBo calculateFieldBo = RptMetaFieldTransferUtil.fieldInfoToCalculateField(fieldInfo);
                fieldContent = RptMetaFieldTransferUtil.getFieldContentByCalculateFieldBo(id, fieldNumber, fieldName, calculateFieldBo, calFieldMaxLenMap);
                metaFieldList.add(fieldContent);
            }
            if (fieldInfo.getNumber().endsWith(".id") || HRStringUtils.equals((String)fieldInfo.getNumber(), (String)"id")) {
                fieldNumber = fieldNumber + ".id";
            }
            RptMetaFieldMap rptMetaFieldMap = new RptMetaFieldMap(fieldInfo.getNumber(), fieldInfo.getNumberAlias(), fieldNumber, fieldContent.getFieldName(), fieldContent.getMaxLength(), fieldContent.getControlType(), RptMetaFieldTransferUtil.getFieldType(fieldContent).getType());
            metaFieldMapList.add(rptMetaFieldMap);
            ++index;
            ++idIndex;
        }
        RptMetaFieldTransferUtil.setRepeatFieldMap(repeatFieldList, metaFieldMapList);
        return metaFieldList;
    }

    private static void handleRepeatReportField(List<FieldInfo> reportFieldInfoList) {
        HashSet numberAliasSet = Sets.newHashSetWithExpectedSize((int)reportFieldInfoList.size());
        HashSet fieldAliasSet = Sets.newHashSetWithExpectedSize((int)reportFieldInfoList.size());
        Iterator<FieldInfo> iterator = reportFieldInfoList.iterator();
        while (iterator.hasNext()) {
            boolean fieldAliasRepeat;
            FieldInfo next = iterator.next();
            String numberAlias = next.getNumberAlias();
            String number = next.getNumber();
            boolean numberAliasRepeat = !numberAliasSet.add(numberAlias);
            boolean bl = fieldAliasRepeat = !fieldAliasSet.add(number);
            if (!numberAliasRepeat || !fieldAliasRepeat) continue;
            iterator.remove();
        }
    }

    private static void handleReportDateSplitField(QueryFieldBo queryFieldBo) {
        if (queryFieldBo.getFieldAlias().contains("!")) {
            String[] dateSplit = queryFieldBo.getFieldAlias().split("!");
            SplitDateTypeEnum splitDateType = SplitDateTypeEnum.getEnum((String)dateSplit[1]);
            HashMap allEnum = Maps.newHashMapWithExpectedSize((int)10);
            switch (splitDateType) {
                case SN_QUARTER: 
                case FN_QUARTER: {
                    List allEnumData = QuarterTypeEnum.getAllEnumData((boolean)true);
                    allEnumData.forEach(enumVal -> allEnum.put(enumVal, QuarterTypeEnum.getEnum((String)enumVal)));
                    break;
                }
                case SN_MONTH: 
                case FN_MONTH: {
                    List allEnumData = MonthTypeEnum.getAllEnumData((boolean)true);
                    allEnumData.forEach(enumVal -> allEnum.put(enumVal, MonthTypeEnum.getEnum((String)enumVal)));
                    break;
                }
                case SN_DAY: 
                case FN_DAY: {
                    List allEnumData = DayTypeEnum.getAllEnumData((boolean)true);
                    allEnumData.forEach(enumVal -> allEnum.put(enumVal, DayTypeEnum.getEnum((String)enumVal)));
                    break;
                }
            }
            if (!allEnum.isEmpty()) {
                RptMetaFieldTransferUtil.setQueryFieldToEnumType(queryFieldBo, allEnum.entrySet().stream().map(entry -> new ValueMapItem("", (String)entry.getKey(), new LocaleString((String)entry.getValue()))).collect(Collectors.toList()));
            }
        }
    }

    private static void setQueryFieldToEnumType(QueryFieldBo queryFieldBo, List<ValueMapItem> comboItems) {
        queryFieldBo.setControlType(FieldControlType.COMBO.getValue());
        queryFieldBo.setValueType(DataTypeEnum.STRING.getDataTypeKey());
        queryFieldBo.setData(SerializationUtils.toJsonString(comboItems));
    }

    public static List<RptEntityMetaFieldContent> anObjQueryFieldsToEntityMetaFields(int index, long anObjId, List<QueryFieldBo> queryFieldBoList, List<RptMetaFieldMap> metaFieldMapList) {
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        RptMetaFieldTransferUtil.addBaseDataIdFieldForAnObj(queryFieldBoList);
        Set<String> joinEntityIdFieldAliasSet = RptMetaFieldTransferUtil.addJoinEntityIdFieldForAnObj(anObjId, queryFieldBoList);
        String[] idStrArr = ID.genStringIds((int)queryFieldBoList.size());
        ArrayList metaFieldList = Lists.newArrayListWithCapacity((int)queryFieldBoList.size());
        int idIndex = 0;
        AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(Long.parseLong(queryFieldBoList.get(0).getAnObjId()), mainEntityTypeUtil);
        for (QueryFieldBo queryFieldBo : queryFieldBoList) {
            String fieldNumber = "field" + index;
            String fieldName = "f" + fieldNumber;
            if (queryFieldBo.getFieldAlias().endsWith(".id") || HRStringUtils.equals((String)queryFieldBo.getFieldAlias(), (String)"id")) {
                queryFieldBo.setControlType(FieldControlType.BASE_DATA.getValue());
            }
            String id = idStrArr[idIndex];
            boolean isJoinEntityIdField = joinEntityIdFieldAliasSet.contains(queryFieldBo.getFieldAlias());
            RptEntityMetaFieldContent fieldContent = RptMetaFieldTransferUtil.getFieldContentByQueryField(id, fieldNumber, fieldName, queryFieldBo, isJoinEntityIdField, enumFieldHandler, mainEntityTypeUtil);
            metaFieldList.add(fieldContent);
            if (queryFieldBo.getFieldAlias().endsWith(".id") || HRStringUtils.equals((String)queryFieldBo.getFieldAlias(), (String)"id")) {
                fieldNumber = fieldNumber + ".id";
            }
            RptMetaFieldMap rptMetaFieldMap = new RptMetaFieldMap(queryFieldBo.getFieldAlias(), null, fieldNumber, fieldContent.getFieldName(), fieldContent.getMaxLength(), fieldContent.getControlType(), RptMetaFieldTransferUtil.getFieldType(fieldContent).getType());
            metaFieldMapList.add(rptMetaFieldMap);
            ++index;
            ++idIndex;
        }
        return metaFieldList;
    }

    public static ReportDataStoreType getFieldType(RptEntityMetaFieldContent entityMetaField) {
        FieldControlType fieldControlType = FieldControlType.getFieldControlTypeByValue((String)entityMetaField.getControlType());
        ReportDataStoreType dataStoreType = null;
        switch (fieldControlType) {
            case LARGE_TEXT: {
                dataStoreType = ReportDataStoreType.TEXT;
                break;
            }
            case TEXT: 
            case MUL_LANG_TEXT: {
                dataStoreType = ReportDataStoreType.NVARCHAR;
                break;
            }
            case COMBO: 
            case MUL_COMBO: {
                dataStoreType = ReportDataStoreType.VARCHAR;
                break;
            }
            case INTEGER: 
            case TIME: {
                dataStoreType = ReportDataStoreType.INT;
                break;
            }
            case AMOUNT: 
            case DECIMAL: {
                dataStoreType = ReportDataStoreType.DECIMAL;
                break;
            }
            case DATE: 
            case DATE_TIME: {
                dataStoreType = ReportDataStoreType.DATETIME;
                break;
            }
            case CHECKBOX: {
                dataStoreType = ReportDataStoreType.CHAR;
                break;
            }
            case BIGINT: {
                dataStoreType = ReportDataStoreType.BIGINT;
                break;
            }
            case HIS_BASE_DATA: 
            case ORG: 
            case USER: 
            case ADDRESS: 
            case ADMIN_DIVISION: 
            case BASE_DATA: {
                if (HRStringUtils.equals((String)entityMetaField.getBaseDataIdType(), (String)"string")) {
                    dataStoreType = ReportDataStoreType.VARCHAR;
                    break;
                }
                dataStoreType = ReportDataStoreType.BIGINT;
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a%s\u3002", (String)"RptMetaFieldTransferUtil_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldControlType.getValue()));
            }
        }
        return dataStoreType;
    }

    private static QueryFieldBo fieldInfoToQueryField(FieldInfo fieldInfo, String userTimeZone, MainEntityTypeUtil mainEntityTypeUtil) {
        QueryFieldBo queryFieldBo = new QueryFieldBo();
        queryFieldBo.setFieldAlias(fieldInfo.getNumber());
        queryFieldBo.setFieldPath(fieldInfo.getFieldPath());
        queryFieldBo.setBaseDataNum(fieldInfo.getBaseDataNum());
        LocaleString fieldName = fieldInfo.getDisplayName() == null ? fieldInfo.getName() : fieldInfo.getDisplayName();
        fieldName = fieldName == null ? new LocaleString(fieldInfo.getNumber()) : fieldName;
        queryFieldBo.setFieldName(fieldName);
        queryFieldBo.setValueType(fieldInfo.getValueType());
        queryFieldBo.setComplexType(fieldInfo.getComplexType());
        queryFieldBo.setControlType(fieldInfo.getControlType());
        queryFieldBo.setEntityNumber(fieldInfo.getEntityNumber());
        if (HRStringUtils.equals((String)queryFieldBo.getControlType(), (String)FieldControlType.DATE_TIME.getValue())) {
            TimeZoneInfo timeZoneInfo = DateTimeFieldTimeZoneUtil.getTimeZoneInfo(queryFieldBo.getEntityNumber(), queryFieldBo.getFieldAlias(), userTimeZone, mainEntityTypeUtil);
            queryFieldBo.setTimeZoneInfo(timeZoneInfo);
        }
        return queryFieldBo;
    }

    private static CalculateFieldBo fieldInfoToCalculateField(FieldInfo fieldInfo) {
        CalculateFieldBo calculateFieldBo = new CalculateFieldBo();
        calculateFieldBo.setFieldNumber(fieldInfo.getNumber());
        calculateFieldBo.setFieldName(fieldInfo.getDisplayName());
        calculateFieldBo.setValueType(fieldInfo.getValueType());
        calculateFieldBo.setControlType(fieldInfo.getControlType());
        calculateFieldBo.setGroupField(Boolean.valueOf(fieldInfo.getGroupField()));
        return calculateFieldBo;
    }

    private static RptEntityMetaFieldContent getFieldContentByQueryField(String id, String fieldNumber, String fieldName, QueryFieldBo queryFieldBo, boolean isJoinEntityIdField, AnObjEnumFieldHandler enumFieldHandler, MainEntityTypeUtil mainEntityTypeUtil) {
        RptEntityMetaFieldContent fieldContent = null;
        FieldControlType controlType = FieldControlType.getFieldControlTypeByValue((String)queryFieldBo.getControlType());
        switch (controlType) {
            case TEXT: {
                int fieldMaxLength = RptMetaFieldTransferUtil.getFieldMaxLength(queryFieldBo, mainEntityTypeUtil);
                if (fieldMaxLength == 0) {
                    fieldContent = RptEntityMetaFieldContent.getLargeTextFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, "a");
                    break;
                }
                String suffix = fieldMaxLength >= 1000 ? "a" : "";
                fieldContent = RptEntityMetaFieldContent.getTextFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, fieldMaxLength, suffix);
                break;
            }
            case MUL_LANG_TEXT: {
                int fieldMaxLength = RptMetaFieldTransferUtil.getFieldMaxLength(queryFieldBo, mainEntityTypeUtil);
                fieldContent = RptEntityMetaFieldContent.getMulLenTextFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, fieldMaxLength);
                break;
            }
            case LARGE_TEXT: {
                fieldContent = RptEntityMetaFieldContent.getLargeTextFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, "a");
                break;
            }
            case INTEGER: {
                fieldContent = RptEntityMetaFieldContent.getIntegerFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case BIGINT: {
                fieldContent = RptEntityMetaFieldContent.getLongFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case AMOUNT: 
            case DECIMAL: {
                fieldContent = RptEntityMetaFieldContent.getDecimalFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case DATE: {
                fieldContent = RptEntityMetaFieldContent.getDateFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case DATE_TIME: {
                fieldContent = RptEntityMetaFieldContent.getDateTimeFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, queryFieldBo.getTimeZoneInfo().getTimeZoneTransType());
                break;
            }
            case TIME: {
                fieldContent = RptEntityMetaFieldContent.getTimeFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case COMBO: {
                List<RptEntityMetaFieldContent.ComboItemContent> comboItemContents = RptMetaFieldTransferUtil.getComboItemContents(queryFieldBo, enumFieldHandler);
                int fieldMaxLength = RptMetaFieldTransferUtil.getFieldMaxLength(queryFieldBo, mainEntityTypeUtil);
                fieldContent = RptEntityMetaFieldContent.getComboFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, fieldMaxLength, comboItemContents);
                break;
            }
            case MUL_COMBO: {
                List<RptEntityMetaFieldContent.ComboItemContent> comboItemContents = RptMetaFieldTransferUtil.getComboItemContents(queryFieldBo, enumFieldHandler);
                int fieldMaxLength = RptMetaFieldTransferUtil.getFieldMaxLength(queryFieldBo, mainEntityTypeUtil);
                fieldContent = RptEntityMetaFieldContent.getMulComboFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, fieldMaxLength, comboItemContents);
                break;
            }
            case CHECKBOX: {
                fieldContent = RptEntityMetaFieldContent.getCheckBoxFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case HIS_BASE_DATA: 
            case ORG: 
            case USER: 
            case ADDRESS: 
            case ADMIN_DIVISION: 
            case BASE_DATA: {
                if (HRStringUtils.isEmpty((String)queryFieldBo.getBaseDataNum()) || HRStringUtils.isEmpty((String)queryFieldBo.getBaseDataIdType())) {
                    Map baseDataMap = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)queryFieldBo.getEntityNumber(), (String)queryFieldBo.getFieldAlias(), (MainEntityTypeUtil)mainEntityTypeUtil);
                    queryFieldBo.setBaseDataNum((String)baseDataMap.get("baseDataNum"));
                    queryFieldBo.setBaseDataIdType((String)baseDataMap.get("pkType"));
                }
                String suffix = isJoinEntityIdField ? "a" : "";
                fieldName = fieldName + "id";
                fieldContent = RptEntityMetaFieldContent.getBaseDataFieldContent(id, fieldNumber, queryFieldBo.getFieldName().getLocaleValue(), fieldName, queryFieldBo.getBaseDataNum(), queryFieldBo.getBaseDataIdType(), suffix);
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a%s\u3002", (String)"RptMetaFieldTransferUtil_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), controlType.getValue()));
            }
        }
        return fieldContent;
    }

    private static List<RptEntityMetaFieldContent.ComboItemContent> getComboItemContents(QueryFieldBo queryFieldBo, AnObjEnumFieldHandler enumFieldHandler) {
        List<RptEntityMetaFieldContent.ComboItemContent> comboItemContents;
        String data = queryFieldBo.getData();
        if (HRStringUtils.isNotEmpty((String)data)) {
            List comboItems = SerializationUtils.fromJsonStringToList((String)data, ValueMapItem.class);
            comboItemContents = RptMetaFieldTransferUtil.comboItemsToComboItemContents(comboItems);
        } else if (enumFieldHandler != null) {
            List<AnObjEnumFieldHandler.AnObjEnumItem> enumItems = enumFieldHandler.getEnumItems((QueryFieldCommonBo)queryFieldBo);
            comboItemContents = RptMetaFieldTransferUtil.anObjEnumItemsToComboItemContents(enumItems);
        } else {
            throw new KDBizException("enum field data is null. field alias: " + queryFieldBo.getFieldAlias());
        }
        return comboItemContents;
    }

    public static List<RptEntityMetaFieldContent> calculateFieldsToEntityMetaFields(int index, long anObjId, List<CalculateFieldBo> calculateFieldBoList, List<RptMetaFieldMap> metaFieldMapList) {
        calculateFieldBoList.removeIf(calculateFieldBo -> calculateFieldBo.getSelected() == null || calculateFieldBo.getSelected() == false || HRStringUtils.equals((String)"summary", (String)calculateFieldBo.getCalMethod()));
        String[] idStrArr = ID.genStringIds((int)calculateFieldBoList.size());
        ArrayList metaFieldList = Lists.newArrayListWithCapacity((int)calculateFieldBoList.size());
        Map<String, Integer> calFieldMaxLenMap = CalculateFieldMaxLengthService.getInstance().getCalFieldMaxLenForAnObj(anObjId);
        int idIndex = 0;
        for (CalculateFieldBo calculateFieldBo2 : calculateFieldBoList) {
            String fieldNumber = "field" + index;
            String fieldName = "f" + fieldNumber;
            String id = idStrArr[idIndex];
            RptEntityMetaFieldContent fieldContent = RptMetaFieldTransferUtil.getFieldContentByCalculateFieldBo(id, fieldNumber, fieldName, calculateFieldBo2, calFieldMaxLenMap);
            metaFieldList.add(fieldContent);
            RptMetaFieldMap rptMetaFieldMap = new RptMetaFieldMap(calculateFieldBo2.getFieldNumber(), null, fieldNumber, fieldName, fieldContent.getMaxLength(), fieldContent.getControlType(), RptMetaFieldTransferUtil.getFieldType(fieldContent).getType());
            metaFieldMapList.add(rptMetaFieldMap);
            ++index;
            ++idIndex;
        }
        return metaFieldList;
    }

    private static RptEntityMetaFieldContent getFieldContentByCalculateFieldBo(String id, String fieldNumber, String fieldName, CalculateFieldBo calculateFieldBo, Map<String, Integer> calFieldMaxLenMap) {
        String valueType = calculateFieldBo.getValueType();
        DataTypeEnum valueTypeEnum = DataTypeEnum.of((String)valueType);
        RptEntityMetaFieldContent fieldContent = null;
        switch (valueTypeEnum) {
            case STRING: {
                Integer maxLen = calFieldMaxLenMap.get(calculateFieldBo.getFieldNumber());
                if (maxLen == null || maxLen < 500) {
                    maxLen = 500;
                }
                if (maxLen > 2000) {
                    fieldContent = RptEntityMetaFieldContent.getLargeTextFieldContent(id, fieldNumber, calculateFieldBo.getFieldName().getLocaleValue(), fieldName, "");
                    break;
                }
                fieldContent = RptEntityMetaFieldContent.getTextFieldContent(id, fieldNumber, calculateFieldBo.getFieldName().getLocaleValue(), fieldName, maxLen, "");
                break;
            }
            case INTEGER: {
                fieldContent = RptEntityMetaFieldContent.getIntegerFieldContent(id, fieldNumber, calculateFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case LONG: {
                fieldContent = RptEntityMetaFieldContent.getLongFieldContent(id, fieldNumber, calculateFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case BIGDECIMAL: {
                fieldContent = RptEntityMetaFieldContent.getDecimalFieldContent(id, fieldNumber, calculateFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            case DATETIME: {
                fieldContent = RptEntityMetaFieldContent.getDateFieldContent(id, fieldNumber, calculateFieldBo.getFieldName().getLocaleValue(), fieldName);
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a%s\u3002", (String)"RptMetaFieldTransferUtil_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), valueType));
            }
        }
        return fieldContent;
    }

    public static List<RptEntityMetaFieldContent> pivotIndexesToEntityMetaFields(int index, List<PivotIndexFieldBo> analysePivotIndexes, List<RptMetaFieldMap> metaFieldMapList) {
        String[] idStrArr = ID.genStringIds((int)analysePivotIndexes.size());
        ArrayList metaFieldList = Lists.newArrayListWithCapacity((int)analysePivotIndexes.size());
        int idIndex = 0;
        for (PivotIndexFieldBo pivotIndexBo : analysePivotIndexes) {
            String fieldNumber = "field" + index;
            String fieldName = "f" + fieldNumber;
            String id = idStrArr[idIndex];
            RptEntityMetaFieldContent fieldContent = RptEntityMetaFieldContent.getDecimalFieldContent(id, fieldNumber, pivotIndexBo.getFieldName().getLocaleValue(), fieldName);
            metaFieldList.add(fieldContent);
            RptMetaFieldMap rptMetaFieldMap = new RptMetaFieldMap(pivotIndexBo.getFieldAlias(), null, fieldNumber, fieldName, fieldContent.getMaxLength(), fieldContent.getControlType(), RptMetaFieldTransferUtil.getFieldType(fieldContent).getType());
            metaFieldMapList.add(rptMetaFieldMap);
            ++index;
            ++idIndex;
        }
        return metaFieldList;
    }

    public static List<RptEntityMetaFieldContent> groupFieldsToEntityMetaFields(int index, List<AnObjGroupField> groupFields, List<RptMetaFieldMap> metaFieldMapList) {
        String[] idStrArr = ID.genStringIds((int)groupFields.size());
        ArrayList metaFieldList = Lists.newArrayListWithCapacity((int)groupFields.size());
        int idIndex = 0;
        for (AnObjGroupField groupField : groupFields) {
            String fieldNumber = "field" + index;
            String fieldName = "f" + fieldNumber;
            String id = idStrArr[idIndex];
            RptEntityMetaFieldContent fieldContent = RptEntityMetaFieldContent.getTextFieldContent(id, fieldNumber, groupField.getName().getLocaleValue(), fieldName, 500, "");
            metaFieldList.add(fieldContent);
            RptMetaFieldMap rptMetaFieldMap = new RptMetaFieldMap(groupField.getNumber(), null, fieldNumber, fieldName, fieldContent.getMaxLength(), fieldContent.getControlType(), RptMetaFieldTransferUtil.getFieldType(fieldContent).getType());
            metaFieldMapList.add(rptMetaFieldMap);
            ++index;
            ++idIndex;
        }
        return metaFieldList;
    }

    public static Set<String> addJoinEntityIdFieldForReport(long anObjId, List<FieldInfo> fieldInfoList) {
        HashSet newIdAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        List<JoinEntityBo> joinEntityBos = AnalyseObjectService.getInstance().queryAndAssembleJoinEntities(anObjId);
        for (JoinEntityBo joinEntityBo : joinEntityBos) {
            String entityAlias = joinEntityBo.getEntityAlias();
            FieldInfo fieldInfo = new FieldInfo();
            if (HRStringUtils.equals((String)joinEntityBo.getType(), (String)"main")) {
                fieldInfo.setNumber("id");
            } else {
                fieldInfo.setNumber(entityAlias + "." + "id");
            }
            fieldInfo.setNumberAlias(fieldInfo.getNumber());
            fieldInfo.setControlType(FieldControlType.BIGINT.getValue());
            fieldInfo.setValueType(DataTypeEnum.LONG.getDataTypeKey());
            fieldInfo.setEntityNumber(joinEntityBo.getEntityNumber());
            fieldInfo.setBaseDataNum(joinEntityBo.getEntityNumber());
            fieldInfo.setComplexType(FieldComplexType.NORMAL.getValue());
            fieldInfo.setFieldSrc("0");
            fieldInfo.setType("2");
            fieldInfo.setName(new LocaleString(fieldInfo.getNumber()));
            fieldInfo.setDisplayName(fieldInfo.getName());
            fieldInfo.setFieldPath(fieldInfo.getNumber());
            fieldInfoList.add(fieldInfo);
            newIdAliasSet.add(fieldInfo.getNumber());
        }
        return newIdAliasSet;
    }

    private static Set<String> addJoinEntityIdFieldForAnObj(long anObjId, List<QueryFieldBo> queryFieldBoList) {
        HashSet newIdAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        List<JoinEntityBo> joinEntityBos = AnalyseObjectService.getInstance().queryAndAssembleJoinEntities(anObjId);
        for (JoinEntityBo joinEntityBo : joinEntityBos) {
            QueryFieldBo queryFieldBo = new QueryFieldBo();
            String entityAlias = joinEntityBo.getEntityAlias();
            if (HRStringUtils.equals((String)joinEntityBo.getType(), (String)"main")) {
                queryFieldBo.setFieldAlias("id");
            } else {
                queryFieldBo.setFieldAlias(entityAlias + "." + "id");
            }
            if (queryFieldBoList.stream().anyMatch(fieldBo -> HRStringUtils.equals((String)fieldBo.getFieldAlias(), (String)queryFieldBo.getFieldAlias()))) continue;
            queryFieldBo.setFieldName(new LocaleString(queryFieldBo.getFieldAlias()));
            queryFieldBo.setValueType(DataTypeEnum.LONG.getDataTypeKey());
            queryFieldBo.setComplexType(FieldComplexType.NORMAL.getValue());
            queryFieldBo.setControlType(FieldControlType.BIGINT.getValue());
            String entityNumber = entityAlias.contains("\u03b4") ? entityAlias.substring(0, entityAlias.indexOf("\u03b4")) : entityAlias;
            queryFieldBo.setEntityNumber(entityNumber);
            queryFieldBoList.add(queryFieldBo);
            newIdAliasSet.add(queryFieldBo.getFieldAlias());
        }
        return newIdAliasSet;
    }

    private static List<FieldInfo> getRepeatFieldList(List<FieldInfo> reportFieldInfoList) {
        ArrayList repeatFieldInfoList = Lists.newArrayListWithCapacity((int)16);
        HashSet fieldAliasSet = Sets.newHashSetWithExpectedSize((int)reportFieldInfoList.size());
        Iterator<FieldInfo> iterator = reportFieldInfoList.iterator();
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = iterator.next();
            if (fieldAliasSet.add(fieldInfo.getNumber())) continue;
            repeatFieldInfoList.add(fieldInfo);
            iterator.remove();
        }
        return repeatFieldInfoList;
    }

    public static void addBaseDataIdFieldForReport(List<FieldInfo> reportFieldInfoList, MainEntityTypeUtil mainEntityTypeUtil) {
        ArrayList idFieldInfoList = Lists.newArrayListWithCapacity((int)16);
        for (FieldInfo fieldInfo : reportFieldInfoList) {
            if (!RptMetaFieldTransferUtil.isBaseDataNameOrNum(fieldInfo.getComplexType(), fieldInfo.getNumber())) continue;
            String idFieldAlias = fieldInfo.getNumber().substring(0, fieldInfo.getNumber().lastIndexOf(".") + 1) + "id";
            if (idFieldInfoList.stream().anyMatch(idFieldInfo -> HRStringUtils.equals((String)idFieldInfo.getNumber(), (String)idFieldAlias)) || reportFieldInfoList.stream().anyMatch(field -> HRStringUtils.equals((String)field.getNumber(), (String)idFieldAlias))) continue;
            FieldInfo idFieldInfo2 = new FieldInfo();
            idFieldInfo2.setNumber(idFieldAlias);
            idFieldInfo2.setNumberAlias(idFieldAlias);
            idFieldInfo2.setName(new LocaleString(idFieldAlias));
            idFieldInfo2.setDisplayName(new LocaleString(idFieldAlias));
            idFieldInfo2.setBaseDataNum(fieldInfo.getBaseDataNum());
            idFieldInfo2.setControlType(FieldControlType.BASE_DATA.getValue());
            ISimpleProperty primaryKey = mainEntityTypeUtil.getMainEntityType(fieldInfo.getBaseDataNum()).getPrimaryKey();
            String valueType = primaryKey.getPropertyType() == String.class ? DataTypeEnum.STRING.getDataTypeKey() : DataTypeEnum.LONG.getDataTypeKey();
            idFieldInfo2.setValueType(valueType);
            idFieldInfo2.setComplexType(fieldInfo.getComplexType());
            idFieldInfo2.setEntityNumber(fieldInfo.getEntityNumber());
            idFieldInfo2.setFieldPath(idFieldAlias);
            idFieldInfoList.add(idFieldInfo2);
        }
        reportFieldInfoList.addAll(idFieldInfoList);
    }

    private static void addBaseDataIdFieldForAnObj(List<QueryFieldBo> queryFieldBoList) {
        ArrayList idQueryFieldBoList = Lists.newArrayListWithCapacity((int)16);
        for (QueryFieldBo queryFieldBo : queryFieldBoList) {
            if (!RptMetaFieldTransferUtil.isBaseDataNameOrNum(queryFieldBo.getComplexType(), queryFieldBo.getFieldAlias())) continue;
            String idFieldAlias = queryFieldBo.getFieldAlias().substring(0, queryFieldBo.getFieldAlias().lastIndexOf(".") + 1) + "id";
            if (idQueryFieldBoList.stream().anyMatch(idFieldBo -> HRStringUtils.equals((String)idFieldBo.getFieldAlias(), (String)idFieldAlias)) || queryFieldBoList.stream().anyMatch(queryField -> HRStringUtils.equals((String)queryField.getFieldAlias(), (String)idFieldAlias))) continue;
            QueryFieldBo idFieldBo2 = new QueryFieldBo();
            idFieldBo2.setFieldAlias(idFieldAlias);
            idFieldBo2.setFieldName(new LocaleString(idFieldAlias));
            idFieldBo2.setBaseDataNum(queryFieldBo.getBaseDataNum());
            idFieldBo2.setValueType(queryFieldBo.getValueType());
            idFieldBo2.setControlType(FieldControlType.BASE_DATA.getValue());
            idFieldBo2.setComplexType(queryFieldBo.getComplexType());
            idFieldBo2.setBaseDataIdType(queryFieldBo.getBaseDataIdType());
            idFieldBo2.setEntityNumber(queryFieldBo.getEntityNumber());
            idQueryFieldBoList.add(idFieldBo2);
        }
        queryFieldBoList.addAll(idQueryFieldBoList);
    }

    private static boolean isBaseDataNameOrNum(String complexType, String fieldAlias) {
        return !fieldAlias.startsWith("RPTDIMCOUNT_") && AnalyseObjectUtil.isBaseDataType((String)complexType) && (fieldAlias.endsWith(".name") || fieldAlias.endsWith(".number"));
    }

    private static void setRepeatFieldMap(List<FieldInfo> repeatFieldList, List<RptMetaFieldMap> metaFieldMapList) {
        Map metaFieldMap = metaFieldMapList.stream().collect(Collectors.toMap(RptMetaFieldMap::getFieldAlias, Function.identity(), (k1, k2) -> k1));
        for (FieldInfo fieldInfo : repeatFieldList) {
            RptMetaFieldMap rptMetaFieldMap = (RptMetaFieldMap)metaFieldMap.get(fieldInfo.getNumber());
            if (rptMetaFieldMap == null) continue;
            RptMetaFieldMap newMetaFieldMap = new RptMetaFieldMap(fieldInfo.getNumber(), fieldInfo.getNumberAlias(), rptMetaFieldMap.getMetaFieldNumber(), rptMetaFieldMap.getTableFieldName(), rptMetaFieldMap.getFieldLength(), rptMetaFieldMap.getFieldControlType(), rptMetaFieldMap.getTableFieldType());
            metaFieldMapList.add(newMetaFieldMap);
        }
    }

    private static int getFieldMaxLength(QueryFieldBo queryFieldBo, MainEntityTypeUtil mainEntityTypeUtil) {
        String tableName;
        String dbRouteKey;
        if (queryFieldBo.getFieldAlias().contains("!")) {
            return 20;
        }
        IDataEntityProperty property = AnalyseObjectUtil.parseFieldAliasGetProperty((String)queryFieldBo.getEntityNumber(), (String)queryFieldBo.getFieldAlias(), (MainEntityTypeUtil)mainEntityTypeUtil);
        int maxLength = 0;
        if (property instanceof TextProp && (maxLength = ((TextProp)property).getMaxLenth()) == 0) {
            return 0;
        }
        String fieldName = property.getAlias();
        if (property.getParent() instanceof RefEntityType) {
            dbRouteKey = property.getParent().getDBRouteKey();
            tableName = property.getParent().getAlias();
        } else {
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(queryFieldBo.getEntityNumber());
            tableName = mainEntityType.getAlias();
            dbRouteKey = mainEntityType.getDBRouteKey();
        }
        DataStoreTableBo dataStoreTableBo = new DataStoreTableBo();
        dataStoreTableBo.setTableName(tableName);
        dataStoreTableBo.setDbRoute(new DBRoute(dbRouteKey));
        PhysicalTableHandler handler = new PhysicalTableHandler(dataStoreTableBo);
        int varcharFieldMaxLength = handler.getVarcharFieldMaxLength(fieldName);
        if (varcharFieldMaxLength == 0) {
            return maxLength;
        }
        return varcharFieldMaxLength;
    }
}

