/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore.physicaltable;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.physicaltable.constants.PhysicalTableConstants;
import kd.hr.hrptmc.business.datastore.physicaltable.model.DataStoreTableBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.repdesign.datastore.IndexBo;

public class PhysicalTableHandler
implements PhysicalTableConstants {
    private static final Log LOGGER = LogFactory.getLog(PhysicalTableHandler.class);
    private final DataStoreTableBo dataStoreTableBo;

    public PhysicalTableHandler(DataStoreTableBo dataStoreTableBo) {
        this.dataStoreTableBo = dataStoreTableBo;
        if (dataStoreTableBo == null) {
            throw new KDBizException("dataStoreTableBo is null.");
        }
        if (HRStringUtils.isEmpty((String)dataStoreTableBo.getTableName())) {
            throw new KDBizException("tableName is null.");
        }
        if (dataStoreTableBo.getDbRoute() == null) {
            throw new KDBizException("dbRoute is null.");
        }
        if (HRStringUtils.isEmpty((String)this.dataStoreTableBo.getPkIndexName())) {
            this.dataStoreTableBo.setPkIndexName(this.generatePKIndexName(this.dataStoreTableBo.getTableName()));
        }
    }

    public void createTable() {
        String fields = this.getMainTableField();
        if (HRDBUtil.exitsTable((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)this.dataStoreTableBo.getTableName())) {
            LOGGER.info("PhysicalTableHandler createTable: table %s isExist, remove first.", (Object)this.dataStoreTableBo.getTableName());
            this.doDeleteTable(this.dataStoreTableBo.getTableName());
        }
        LOGGER.info("PhysicalTableHandler createTable tableName: {}, fields: {}", (Object)this.dataStoreTableBo.getTableName(), (Object)fields);
        this.doCreateTable(this.dataStoreTableBo.getTableName(), fields);
        this.createPkIndex("FID", this.dataStoreTableBo.getPkIndexName(), this.dataStoreTableBo.getTableName());
        this.generateMulLanTable();
        this.generateSplitTable();
    }

    private void generateMulLanTable() {
        String mulLanFields = this.getMulLanFields();
        if (HRStringUtils.isEmpty((String)mulLanFields)) {
            return;
        }
        String mulLanTableName = this.dataStoreTableBo.getTableName() + "_L";
        String sql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') CREATE TABLE %s (FPKID VARCHAR(18) DEFAULT ' ' NOT NULL,FID BIGINT DEFAULT 0 NOT NULL,FLOCALEID VARCHAR(10) DEFAULT ' ' NOT NULL,%s);", mulLanTableName, mulLanTableName, mulLanFields);
        LOGGER.info("PhysicalTableHandler generateMulLanTable sql: {}", (Object)sql);
        Object[] params = new Object[]{};
        HRDBUtil.execute((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)sql, (Object[])params);
        String mulLanPkIndexName = this.generatePKIndexName(mulLanTableName);
        this.createPkIndex("FPKID", mulLanPkIndexName, mulLanTableName);
        String indexName = this.generateMulLanTableIndexName(mulLanTableName);
        this.createIndex(indexName, mulLanTableName, "FID", "FLOCALEID");
    }

    private void generateSplitTable() {
        Map<String, String> splitTableFields = this.getSplitTableFields();
        if (splitTableFields.isEmpty()) {
            return;
        }
        splitTableFields.forEach((splitTableSuffix, fields) -> {
            String splitTableName = this.dataStoreTableBo.getTableName() + "_" + splitTableSuffix;
            String pkIndexName = this.generatePKIndexName(splitTableName);
            LOGGER.info("PhysicalTableHandler createSplitTable tableName: {}, fields: {}", (Object)splitTableName, fields);
            if (HRDBUtil.exitsTable((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)splitTableName)) {
                LOGGER.info("PhysicalTableHandler generateSplitTable: table %s isExist, remove first.", (Object)splitTableName);
                this.doDeleteTable(splitTableName);
            }
            this.doCreateTable(splitTableName, (String)fields);
            this.createPkIndex("FID", pkIndexName, splitTableName);
        });
    }

    private void doCreateTable(String tableName, String fields) {
        String createTableSql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') CREATE TABLE %s (FID BIGINT DEFAULT 0 NOT NULL,%s);", tableName, tableName, fields);
        Object[] params = new Object[]{};
        LOGGER.info("PhysicalTableHandler doCreateTable sql: {}", (Object)createTableSql);
        HRDBUtil.execute((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)createTableSql, (Object[])params);
    }

    public void deleteTable(char ... splitTableSuffix) {
        this.doDeleteTable(this.dataStoreTableBo.getTableName());
        this.doDeleteTable(this.dataStoreTableBo.getTableName() + "_L");
        if (splitTableSuffix != null) {
            for (char tableSuffix : splitTableSuffix) {
                this.doDeleteTable(this.dataStoreTableBo.getTableName() + "_" + tableSuffix);
            }
        }
    }

    private void doDeleteTable(String tableName) {
        String deleteTableSql = String.format("IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') DROP TABLE %s ;", tableName, tableName);
        Object[] params = new Object[]{};
        LOGGER.info("PhysicalTableHandler deleteTable sql: {}", (Object)deleteTableSql);
        HRDBUtil.execute((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)deleteTableSql, (Object[])params);
    }

    public void createIndex(List<IndexBo> indexBoList) {
        for (IndexBo indexBo : indexBoList) {
            this.createIndex(indexBo.getIndexName(), indexBo.getTableName(), indexBo.getFieldNames());
        }
    }

    public void createIndex(String indexName, String tableName, String ... fieldNames) {
        CharSequence[] tempNames;
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)tableName) || null == fieldNames || 0 == fieldNames.length) {
            return;
        }
        if (fieldNames.length > 5) {
            tempNames = new String[5];
            System.arraycopy(fieldNames, 0, tempNames, 0, 5);
        } else {
            tempNames = fieldNames;
        }
        String createIndexSql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", indexName, indexName, tableName, String.join((CharSequence)", ", tempNames));
        Object[] params = new Object[]{};
        LOGGER.info("PhysicalTableHandler createIndex sql: {}", (Object)createIndexSql);
        HRDBUtil.execute((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)createIndexSql, (Object[])params);
    }

    private void createPkIndex(String pkName, String pkIndexName, String tableName) {
        String createPKIndexSql = String.format("EXEC P_ALTERPK '%s', '%s', '%s', '1';", pkIndexName, tableName, pkName);
        Object[] params = new Object[]{};
        LOGGER.info("PhysicalTableHandler createPkIndex sql: {}", (Object)createPKIndexSql);
        HRDBUtil.execute((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)createPKIndexSql, (Object[])params);
    }

    private String getMainTableField() {
        StringBuilder fieldSb = new StringBuilder();
        this.dataStoreTableBo.getStoreFields().stream().filter(field -> HRStringUtils.isEmpty((String)field.getSplitTableSuffix())).forEach(field -> fieldSb.append(field).append(","));
        return fieldSb.substring(0, fieldSb.length() - 1);
    }

    private Map<String, String> getSplitTableFields() {
        HashMap splitTableFieldMsgMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, List<ReportDataStoreFieldBo>> splitTableFieldMap = this.dataStoreTableBo.getStoreFields().stream().filter(field -> HRStringUtils.isNotEmpty((String)field.getSplitTableSuffix())).collect(Collectors.groupingBy(ReportDataStoreFieldBo::getSplitTableSuffix));
        splitTableFieldMap.forEach((splitTableSuffix, fieldBoList) -> {
            StringBuilder fieldSb = new StringBuilder();
            fieldBoList.forEach(field -> fieldSb.append(field).append(","));
            splitTableFieldMsgMap.put(splitTableSuffix, fieldSb.substring(0, fieldSb.length() - 1));
        });
        return splitTableFieldMsgMap;
    }

    private String getMulLanFields() {
        StringBuilder fieldSb = new StringBuilder();
        this.dataStoreTableBo.getStoreFields().stream().filter(ReportDataStoreFieldBo::isMulLanField).forEach(field -> fieldSb.append(field).append(","));
        if (fieldSb.length() > 0) {
            return fieldSb.substring(0, fieldSb.length() - 1);
        }
        return null;
    }

    private String generatePKIndexName(String tableName) {
        String tableNameSuffix = tableName.substring(2);
        return "PK_" + tableNameSuffix;
    }

    private String generateMulLanTableIndexName(String mulLanTableName) {
        String tableNameSuffix = mulLanTableName.substring(2);
        return "IDX_" + tableNameSuffix;
    }

    public int getVarcharFieldMaxLength(String fieldName) {
        String finalFieldName = fieldName.toLowerCase(Locale.ROOT);
        try {
            String sql = this.tableDefinitionSql(this.dataStoreTableBo.getTableName(), finalFieldName);
            LOGGER.info("PhysicalTableHandler getVarcharFieldMaxLength sql: {}", (Object)sql);
            Object[] params = new Object[]{};
            return (Integer)HRDBUtil.query((DBRoute)this.dataStoreTableBo.getDbRoute(), (String)sql, (Object[])params, resultSet -> {
                int maxLength = 0;
                while (resultSet.next()) {
                    maxLength = resultSet.getInt("lengthvar");
                }
                if (maxLength == 0) {
                    LOGGER.info("PhysicalTableHandler getVarcharFieldMaxLength maxLength is 0, tableName: {}, fieldName: {}", (Object)this.dataStoreTableBo.getTableName(), (Object)finalFieldName);
                } else if (maxLength > 2000) {
                    maxLength = 2000;
                }
                return maxLength;
            });
        }
        catch (Exception exception) {
            LOGGER.error("PhysicalTableHandler getVarcharFieldMaxLength error, tableName: {}, fieldName: {}", new Object[]{this.dataStoreTableBo.getTableName(), fieldName, exception});
            return 50;
        }
    }

    private String tableDefinitionSql(String tableName, String fieldName) throws KDBizException {
        String sql;
        DBInstance dbInstance = this.getDbInstance(this.dataStoreTableBo.getDbRoute());
        if (dbInstance == null) {
            throw new KDBizException("dbInstance is null.");
        }
        String dbType = dbInstance.getDbtype();
        if ("0".equals(dbType) || "16".equals(dbType) || "21".equals(dbType)) {
            String select = "select t.COLUMN_NAME, t.DATA_LENGTH AS lengthvar ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' AND t.COLUMN_NAME = '" + fieldName.toUpperCase() + "'";
            sql = "/*dialect*/" + select + from + where;
        } else if ("1".equals(dbType)) {
            String select = "SELECT a.attname,a.attlen AS length,a.atttypmod AS lengthvar ";
            String from = "FROM pg_class c,pg_attribute a LEFT OUTER JOIN pg_description b ON a.attrelid=b.objoid AND a.attnum = b.objsubid,pg_type t ";
            String where = "WHERE c.relname = '" + tableName.toLowerCase() + "' and a.attnum > 0 and a.attrelid = c.oid and a.atttypid = t.oid and a.attname = '" + fieldName + "'";
            sql = "/*dialect*/" + select + from + where;
        } else if ("2".equals(dbType) || "22".equals(dbType)) {
            String select = "SELECT COLUMN_NAME, character_maximum_length AS lengthvar ";
            String from = "FROM information_schema.COLUMNS ";
            String where = "WHERE TABLE_SCHEMA='" + dbInstance.getDBInsatnce() + "' AND TABLE_NAME= '" + tableName + "' AND COLUMN_NAME = '" + fieldName + "'";
            sql = "/*dialect*/" + select + from + where;
        } else if ("3".equals(dbType)) {
            String select = "select t.COLUMN_NAME, t.DATA_LENGTH AS lengthvar ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' and t.COLUMN_NAME = '" + fieldName + "'";
            sql = "/*dialect*/" + select + from + where;
        } else if ("6".equals(dbType)) {
            String select = "select CHARACTER_MAXIMUM_LENGTH AS lengthvar,CHARACTER_OCTET_LENGTH ";
            String from = "from INFORMATION_SCHEMA.COLUMNS ";
            String where = "where table_name = '" + tableName + "' and COLUMN_NAME = '" + fieldName + "'";
            sql = "/*dialect*/" + select + from + where;
        } else if ("14".equals(dbType)) {
            sql = this.getLikePgTableSQL(tableName, fieldName);
        } else if ("15".equals(dbType)) {
            sql = this.getLikePgTableSQL(tableName, fieldName);
        } else if ("17".equals(dbType) || "19".equals(dbType)) {
            String select = "SELECT COLUMN_NAME, character_maximum_length AS lengthvar ";
            String from = "FROM information_schema.COLUMNS ";
            String where = "WHERE TABLE_SCHEMA='" + dbInstance.getDBInsatnce() + "' AND TABLE_NAME= '" + tableName + "' AND COLUMN_NAME = '" + fieldName + "'";
            sql = "/*dialect*/" + select + from + where;
        } else if ("18".equals(dbType)) {
            String select = "SELECT COLS.DATA_LENGTH AS lengthvar FROM COLS WHERE TABLE_NAME = UPPER('" + tableName + "') AND COLS.Column_Name = UPPER('" + fieldName + "')";
            sql = "/*dialect*/" + select;
        } else if ("20".equals(dbType)) {
            String select = "select t.COLUMN_NAME, t.DATA_LENGTH AS lengthvar ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' and t.COLUMN_NAME = '" + fieldName.toUpperCase() + "'";
            sql = "/*dialect*/" + select + from + where;
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8be5\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (String)"", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), dbType));
        }
        return sql;
    }

    private String getLikePgTableSQL(String tableName, String fieldName) {
        String select = "SELECT a.attname,a.attlen AS length,a.atttypmod AS lengthvar ";
        String from = "FROM pg_class c,pg_attribute a LEFT OUTER JOIN pg_description b ON a.attrelid=b.objoid AND a.attnum = b.objsubid,pg_type t ";
        String where = "WHERE c.relname = '" + tableName.toLowerCase() + "' and a.attnum > 0 and a.attrelid = c.oid and a.atttypid = t.oid and a.attname = '" + fieldName + "'";
        return "/*dialect*/" + select + from + where;
    }

    private DBInstance getDbInstance(DBRoute route) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String tenantId = requestContext.getTenantId();
        Account correctAccount = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        return this.getDataBaseInstance(correctAccount, route.getRouteKey());
    }

    private DBInstance getDataBaseInstance(Account account, String routeKey) {
        List dbInstanceList = account.getDBInstanceList();
        DBInstance returnInstance = null;
        if (!StringUtils.isEmpty((CharSequence)routeKey) && !CollectionUtils.isEmpty((Collection)dbInstanceList)) {
            for (DBInstance instance : dbInstanceList) {
                if (!routeKey.equalsIgnoreCase(instance.getRouteKey())) continue;
                returnInstance = instance;
                if (!"1".equals(instance.getReadOnly())) continue;
                break;
            }
        }
        return returnInstance;
    }

    public DataStoreTableBo getDataStoreTableBo() {
        return this.dataStoreTableBo;
    }
}

