/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore.physicaltable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.metadata.model.RptEntityMetaFieldContent;
import kd.hr.hrptmc.business.datastore.metadata.model.RptFormMetadataContent;
import kd.hr.hrptmc.business.datastore.metadata.util.RptMetaFieldTransferUtil;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.model.DataStoreTableBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;

public class RptPhysicalTableHandlerCreator {
    private static final Log LOGGER = LogFactory.getLog(RptPhysicalTableHandlerCreator.class);

    public static PhysicalTableHandler getHandler(RptFormMetadataContent formMetadataContent) {
        DataStoreTableBo dataStoreTableBo = RptPhysicalTableHandlerCreator.adapterToDataStoreTableBo(formMetadataContent);
        return new PhysicalTableHandler(dataStoreTableBo);
    }

    private static DataStoreTableBo adapterToDataStoreTableBo(RptFormMetadataContent formMetadataContent) {
        DataStoreTableBo dataStoreTableBo = new DataStoreTableBo();
        dataStoreTableBo.setTableName(formMetadataContent.getBaseMsg().getTableName());
        dataStoreTableBo.setDbRoute(DBRoute.of((String)formMetadataContent.getBaseMsg().getDbRoute()));
        ArrayList storeFields = Lists.newArrayListWithExpectedSize((int)formMetadataContent.getEntityMetaFields().size());
        List<RptEntityMetaFieldContent> entityMetaFields = formMetadataContent.getEntityMetaFields();
        LOGGER.info("RptPhysicalTableHandlerCreator adapterToDataStoreTableBo fields:{}", entityMetaFields);
        for (RptEntityMetaFieldContent entityMetaField : entityMetaFields) {
            ReportDataStoreFieldBo dataStoreFieldBo = new ReportDataStoreFieldBo();
            dataStoreFieldBo.setFieldName(entityMetaField.getFieldName());
            dataStoreFieldBo.setType(RptMetaFieldTransferUtil.getFieldType(entityMetaField));
            if (HRStringUtils.equals((String)entityMetaField.getBaseDataIdType(), (String)"string")) {
                dataStoreFieldBo.setLength(36);
            } else {
                dataStoreFieldBo.setLength(entityMetaField.getMaxLength());
            }
            RptPhysicalTableHandlerCreator.setFieldProp(dataStoreFieldBo, entityMetaField);
            storeFields.add(dataStoreFieldBo);
        }
        LOGGER.info("RptPhysicalTableHandlerCreator adapterToDataStoreTableBo storeFields:{}", (Object)storeFields);
        dataStoreTableBo.setStoreFields(storeFields);
        return dataStoreTableBo;
    }

    private static void setFieldProp(ReportDataStoreFieldBo fieldBo, RptEntityMetaFieldContent fieldContent) {
        ReportDataStoreType type = fieldBo.getType();
        if (type == null) {
            return;
        }
        switch (type) {
            case CHAR: {
                fieldBo.setDefaultVal("'0'");
                fieldBo.setAllowNull(false);
                break;
            }
            case VARCHAR: {
                fieldBo.setDefaultVal("' '");
                fieldBo.setAllowNull(false);
                fieldBo.setSplitTableSuffix(fieldContent.getSuffix());
                break;
            }
            case NVARCHAR: {
                fieldBo.setDefaultVal("' '");
                fieldBo.setAllowNull(false);
                if (HRStringUtils.equals((String)fieldContent.getControlType(), (String)FieldControlType.MUL_LANG_TEXT.getValue())) {
                    fieldBo.setMulLanField(true);
                }
                fieldBo.setSplitTableSuffix(fieldContent.getSuffix());
                break;
            }
            case TEXT: {
                fieldBo.setDefaultVal(null);
                fieldBo.setAllowNull(true);
                fieldBo.setSplitTableSuffix(fieldContent.getSuffix());
                break;
            }
            case BIGINT: {
                fieldBo.setDefaultVal("0");
                fieldBo.setAllowNull(false);
                fieldBo.setSplitTableSuffix(fieldContent.getSuffix());
                break;
            }
            case INT: 
            case DECIMAL: {
                fieldBo.setDefaultVal("0");
                fieldBo.setAllowNull(false);
                break;
            }
            case DATETIME: {
                fieldBo.setDefaultVal(null);
                fieldBo.setAllowNull(true);
                break;
            }
        }
    }
}

