/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore.queryservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;

public class ReportDataExtractQueryService {
    private static final Log logger = LogFactory.getLog(ReportDataExtractQueryService.class);

    public ReportResult queryDetailData(long anObjId, List<FieldInfo> storeFieldList, int start, int limit, List<QFilter> qFilterList) {
        return this.queryDetailData(anObjId, 0L, storeFieldList, start, limit, qFilterList);
    }

    public ReportResult queryDetailData(long anObjId, long reportId, List<FieldInfo> storeFieldList, int start, int limit, List<QFilter> qFilterList) {
        ReportResult reportResult;
        try {
            ReportQueryParamInfo reportQueryParamInfo = this.assembleReportQueryParamInfo(anObjId, reportId, storeFieldList, "1", start, limit, qFilterList);
            Class<?> reportQueryUtilClass = Class.forName("kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil");
            Method queryData4DetailMethod = reportQueryUtilClass.getDeclaredMethod("queryData4Detail", ReportQueryParamInfo.class);
            reportResult = (ReportResult)queryData4DetailMethod.invoke(null, reportQueryParamInfo);
        }
        catch (Exception exception) {
            logger.error("ReportQueryService queryDetailDataForReport error: ", (Throwable)exception);
            throw new KDBizException("queryDetailDataForReport error.");
        }
        return reportResult;
    }

    private ReportQueryParamInfo assembleReportQueryParamInfo(long anObjId, long reportId, List<FieldInfo> storeFieldList, String reportType, int start, int limit, List<QFilter> qFilterList) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        logger.info("ReportDataExtractQueryService_assembleReportQueryParamInfo_storeFieldList:{}", storeFieldList);
        List<RowFieldInfo> rowFieldInfoList = this.buildRowFieldInfoList(storeFieldList);
        ReportManageConfigInfo reportManageConfigInfo = this.assembleReportManageConfigInfo(anObjId, reportId, rowFieldInfoList);
        WorkRptInfo workRptInfo = this.assembleWorkRptInfo(reportManageConfigInfo, reportType);
        workRptInfo.setRows(rowFieldInfoList);
        ReportQueryParamInfo reportQueryParamInfo = new ReportQueryParamInfo(reportManageConfigInfo);
        reportQueryParamInfo.setStart(start);
        reportQueryParamInfo.setLimit(limit);
        reportQueryParamInfo.setWhereQFilter(qFilterList);
        reportQueryParamInfo.setTransferField(true);
        reportQueryParamInfo.setDataStore(true);
        return reportQueryParamInfo;
    }

    private ReportManageConfigInfo assembleReportManageConfigInfo(long anObjId, long reportId, List<RowFieldInfo> rowFieldInfoList) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AnObjDetailInfo anObjDetailInfo;
        Object getAnObjDetailMethod;
        ReportManageConfigInfo reportManageConfigInfo = new ReportManageConfigInfo();
        Class<?> rptAnObjUtilClass = Class.forName("kd.hr.hrptmc.formplugin.web.repdesign.util.RptAnObjUtil");
        if (reportId != 0L) {
            getAnObjDetailMethod = rptAnObjUtilClass.getDeclaredMethod("getAnObjDetail", Long.class, Long.class);
            anObjDetailInfo = (AnObjDetailInfo)((Method)getAnObjDetailMethod).invoke(null, anObjId, reportId);
        } else {
            getAnObjDetailMethod = rptAnObjUtilClass.getDeclaredMethod("getAnObjDetail", Long.class);
            anObjDetailInfo = (AnObjDetailInfo)((Method)getAnObjDetailMethod).invoke(null, anObjId);
        }
        for (QueryFieldBo queryField : anObjDetailInfo.getQueryFields()) {
            queryField.setTimeZoneInfo(null);
        }
        ArrayList filterDimFieldInfoList = Lists.newArrayListWithExpectedSize((int)anObjDetailInfo.getDimensionList().size());
        Map<String, FieldInfo> filterFieldInfoMap = rowFieldInfoList.stream().collect(Collectors.toMap(rf -> rf.getGroupName().getNumber(), RowFieldInfo::getGroupName, (k1, k2) -> k1));
        HashSet alreadyAddSet = Sets.newHashSetWithExpectedSize((int)filterFieldInfoMap.size());
        for (DimensionFieldInfo dimensionFieldInfo : anObjDetailInfo.getDimensionList()) {
            FieldInfo fieldInfo = filterFieldInfoMap.get(dimensionFieldInfo.getFieldAlias());
            if (fieldInfo != null) {
                if (!HRStringUtils.equals((String)fieldInfo.getValueType(), (String)dimensionFieldInfo.getValueType())) {
                    dimensionFieldInfo.setValueType(fieldInfo.getValueType());
                }
                filterDimFieldInfoList.add(dimensionFieldInfo);
                alreadyAddSet.add(dimensionFieldInfo.getFieldAlias());
                continue;
            }
            if (dimensionFieldInfo.getFieldAlias().contains("!")) continue;
            filterDimFieldInfoList.add(dimensionFieldInfo);
        }
        for (RowFieldInfo rowFieldInfo : rowFieldInfoList) {
            FieldInfo groupName = rowFieldInfo.getGroupName();
            String complexType = groupName.getComplexType();
            String number = groupName.getNumber();
            if (alreadyAddSet.contains(number) || !"1".equals(groupName.getType()) || !ReportDataStoreServiceHelper.isBaseDataNameOrNum(complexType, number)) continue;
            QueryFieldBo queryFieldBo = ReportDataStoreServiceHelper.fieldInfo2QueryFieldBo(groupName);
            DimensionFieldInfo dimensionFieldInfo = ReportDataExtractQueryService.queryFieldBo2DimensionFieldInfo(queryFieldBo);
            filterDimFieldInfoList.add(dimensionFieldInfo);
        }
        anObjDetailInfo.setDimensionList(filterDimFieldInfoList);
        reportManageConfigInfo.setAssignObj(anObjDetailInfo);
        return reportManageConfigInfo;
    }

    private WorkRptInfo assembleWorkRptInfo(ReportManageConfigInfo reportManageConfigInfo, String reportType) {
        WorkRptInfo workRptInfo = new WorkRptInfo();
        workRptInfo.setShow(true);
        workRptInfo.setWorkRptId(String.valueOf(ORM.create().genLongId("hrptmc_workreport")));
        ReportConfigInfo reportConfigInfo = new ReportConfigInfo(reportType);
        workRptInfo.setReportConfig(reportConfigInfo);
        ArrayList<WorkRptInfo> workRptInfoList = new ArrayList<WorkRptInfo>(1);
        workRptInfoList.add(workRptInfo);
        reportManageConfigInfo.setWorkRpt(workRptInfoList);
        return workRptInfo;
    }

    private List<RowFieldInfo> buildRowFieldInfoList(List<FieldInfo> storeFieldList) {
        return storeFieldList.stream().filter(fieldInfo -> !fieldInfo.getNumber().endsWith("\u03b9index")).map(RowFieldInfo::new).collect(Collectors.toList());
    }

    private static DimensionFieldInfo queryFieldBo2DimensionFieldInfo(QueryFieldBo queryFieldBo) {
        DimensionFieldInfo dimensionFieldInfo = new DimensionFieldInfo();
        dimensionFieldInfo.setFieldId(queryFieldBo.getId());
        dimensionFieldInfo.setFieldName(queryFieldBo.getFieldName());
        dimensionFieldInfo.setFieldAlias(queryFieldBo.getFieldAlias());
        dimensionFieldInfo.setFieldPath(queryFieldBo.getFieldPath());
        dimensionFieldInfo.setValueType(queryFieldBo.getValueType());
        dimensionFieldInfo.setControlType(queryFieldBo.getControlType());
        dimensionFieldInfo.setFieldSrc("0");
        dimensionFieldInfo.setEntityNumber(queryFieldBo.getEntityNumber());
        dimensionFieldInfo.setComplexType(queryFieldBo.getComplexType());
        dimensionFieldInfo.setFieldNumber(queryFieldBo.getFieldNumber());
        dimensionFieldInfo.setData(queryFieldBo.getData());
        dimensionFieldInfo.setTimeZoneInfo(queryFieldBo.getTimeZoneInfo());
        dimensionFieldInfo.setBaseDataNum(queryFieldBo.getBaseDataNum());
        dimensionFieldInfo.setVirtualEntityField(queryFieldBo.isVirtualEntityField());
        return dimensionFieldInfo;
    }
}

