/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.dataup;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;

public class ReportManageDataUpService
implements IUpgradeService {
    private static final int INSERT_LIMIT = 999;
    private static final String rptCountSql = "select count(1) from t_hrptmc_reportmanage";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle txHandle = TX.required();){
            List<Long> tempParamList;
            result.setLog("ReportManageDateUpService--start!");
            DBRoute hmp = new DBRoute("hmp");
            Long rptCount = this.getCount(hmp, rptCountSql);
            if (null == rptCount || 0L == rptCount) {
                result.setLog("No reportManage date!");
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
            Set<Long> paramsSet = this.getRptManageId(hmp, "select rm.fid from t_hrptmc_reportmanage rm left join t_hrptmc_workreport rw on rm.fid = rw.frptmanageid where rw.fid is null");
            if (CollectionUtils.isEmpty(paramsSet)) {
                result.setLog("No data needs to be upgraded!");
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
            ArrayList<Long> paramsList = new ArrayList<Long>(paramsSet);
            int paramSize = paramsList.size();
            int fromIndex = 0;
            while (fromIndex + 999 < paramSize) {
                tempParamList = paramsList.subList(fromIndex, fromIndex + 999);
                this.dataUp(hmp, tempParamList, result);
                fromIndex += 999;
            }
            tempParamList = paramsList.subList(fromIndex, paramSize);
            this.dataUp(hmp, tempParamList, result);
            result.setLog("ReportManageDateUpService--end!");
            result.setSuccess(true);
            result.setEl("warning");
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private void dataUp(DBRoute hmp, List<Long> tempParamList, UpgradeResult result) {
        String rptManageIds = Joiner.on((String)",").join(tempParamList);
        String sql1 = "select fdrillingdrl,frptmanageid from t_hrptmc_reportconfig where frptmanageid in (" + rptManageIds + ")";
        List<Object[]> paramsList1 = this.getRptParamsList1(hmp, sql1);
        String sql = "select fid,frow,fcolumn from t_hrptmc_reportmanage where fid in (" + rptManageIds + ")";
        List<Object[]> paramsList = this.getRptParamsList(hmp, sql);
        if (!CollectionUtils.isEmpty(paramsList1)) {
            result.setLog("update_t_hrptmc_reportmanage_start!");
            String updateSql = "update t_hrptmc_reportmanage set fdrillingdrl = ? where fid = ?";
            this.executeBatch(hmp, updateSql, paramsList1);
            result.setLog("update_t_hrptmc_reportmanage_end!");
        }
        if (!CollectionUtils.isEmpty(paramsList)) {
            result.setLog("update_hrptmc_workrpt_start!");
            String insertSql = "INSERT INTO T_HRPTMC_WORKREPORT(FID,FKEY,FROW,FCOLUMN,FRPTMANAGEID) VALUES (?,1,?,?,?)";
            this.executeBatch(hmp, insertSql, paramsList);
            result.setLog("update_hrptmc_workrpt_end!");
        }
        this.updateWorkRptId(hmp, rptManageIds);
    }

    private void updateWorkRptId(DBRoute dbRoute, String rptManageIds) {
        this.updateWorkRptId(dbRoute, "t_hrptmc_rowfield", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_colfield", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_reportconfig", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_rptdispscm", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_customsort", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_rptcomref", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_dispscmchg", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_userdispscm", "FRPTMANAGEID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_rptjump", "FREPORTID", rptManageIds);
        this.updateWorkRptId(dbRoute, "t_hrptmc_dimmap", "FREPORTID", rptManageIds);
    }

    private void updateWorkRptId(DBRoute dbRoute, String table, String rptManageCol, String rptManageIds) {
        String updateIdSql = "update " + table + " set fworkrptid=" + rptManageCol + " where " + rptManageCol + " in (" + rptManageIds + ")";
        HRDBUtil.execute((DBRoute)dbRoute, (String)updateIdSql, null);
    }

    private Set<Long> getRptManageId(DBRoute dbRoute, String sql) {
        HashSet paramsList = new HashSet(999);
        return (Set)DB.query((DBRoute)dbRoute, (String)sql, rs -> {
            while (rs.next()) {
                paramsList.add(rs.getLong(1));
            }
            return paramsList;
        });
    }

    private List<Object[]> getRptParamsList1(DBRoute dbRoute, String sql) {
        ArrayList paramsList = new ArrayList(999);
        return (List)DB.query((DBRoute)dbRoute, (String)sql, rs -> {
            while (rs.next()) {
                Object[] params = new Object[]{rs.getString(1), rs.getLong(2)};
                paramsList.add(params);
            }
            return paramsList;
        });
    }

    private List<Object[]> getRptParamsList(DBRoute dbRoute, String sql) {
        ArrayList paramsList = new ArrayList(999);
        return (List)DB.query((DBRoute)dbRoute, (String)sql, rs -> {
            while (rs.next()) {
                Object[] params = new Object[]{rs.getLong(1), rs.getString(2), rs.getString(3), rs.getLong(1)};
                paramsList.add(params);
            }
            return paramsList;
        });
    }

    private void executeBatch(DBRoute dbRoute, String sql, List<Object[]> paramList) {
        List<Object[]> tempParamList;
        int paramSize = paramList.size();
        int fromIndex = 0;
        while (fromIndex + 999 < paramSize) {
            tempParamList = paramList.subList(fromIndex, fromIndex + 999);
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)sql, tempParamList);
            fromIndex += 999;
        }
        tempParamList = paramList.subList(fromIndex, paramSize);
        HRDBUtil.executeBatch((DBRoute)dbRoute, (String)sql, tempParamList);
    }

    private Long getCount(DBRoute dbRoute, String sql) {
        return (Long)HRDBUtil.query((DBRoute)dbRoute, (String)sql, (Object[])new Object[0], rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return null;
        });
    }
}

