/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.mvc.export.ExcelWriter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hrptmc.business.exp.HReportConfExpEntityConf;
import kd.hr.hrptmc.business.exp.util.ExpCommonUtil;
import kd.hr.hrptmc.common.model.exp.ExpEntityBo;
import kd.hr.hrptmc.common.util.GzipCompress;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class HReportConfExpWriter
extends ExcelWriter {
    private final Font originalFont;
    private int excelCellMaxinum = Short.MAX_VALUE;
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
    private final Map<String, Integer> columnIdxMap = new HashMap<String, Integer>(16);
    private final Map<String, Integer> maxColumnMap = new HashMap<String, Integer>(16);
    private static final char MULILANG_SPLIT = '.';
    private static final char SHEET_COLUMN_SPLIT = '#';

    public HReportConfExpWriter() {
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.originalFont = this.wb.createFont();
        this.originalFont.setFontHeightInPoints((short)12);
        this.originalFont.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"HReportConfExpWriter_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
    }

    public void genData(String sheetName, ExpEntityBo expEntityBo) {
        SXSSFSheet sheet = this.wb.getSheet(sheetName);
        int curRowNum = sheet.getLastRowNum() + 1;
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Map data = expEntityBo.getDataRecursion();
        for (Map.Entry entry : data.entrySet()) {
            Integer colIdx;
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            String field = sheetName + '#' + key;
            if (val instanceof OrmLocaleValue) {
                OrmLocaleValue localeValue = (OrmLocaleValue)val;
                for (EnabledLang enabledLang : enabledLangList) {
                    String mulField = field + '.' + enabledLang.getNumber();
                    Integer colIdx2 = this.columnIdxMap.get(mulField);
                    if (colIdx2 == null) continue;
                    this.addCellRegion((Sheet)sheet, curRowNum, colIdx2).setCellValue(localeValue.get((Object)enabledLang.getNumber()));
                }
                continue;
            }
            if (val instanceof Map || val instanceof Collection) {
                colIdx = this.columnIdxMap.get(field);
                if (colIdx == null) continue;
                String jsonString = SerializationUtils.toJsonString(val);
                if (jsonString.length() >= this.excelCellMaxinum) {
                    jsonString = GzipCompress.compressToString((String)jsonString);
                }
                this.addCellRegion((Sheet)sheet, curRowNum, colIdx).setCellValue(jsonString);
                continue;
            }
            colIdx = this.columnIdxMap.get(field);
            if (colIdx == null) continue;
            String cellVal = "";
            if (val != null) {
                cellVal = val.toString();
            }
            if (cellVal.length() >= this.excelCellMaxinum) {
                cellVal = GzipCompress.compressToString((String)cellVal);
            }
            this.addCellRegion((Sheet)sheet, curRowNum, colIdx).setCellValue(cellVal);
        }
        if (MapUtils.isNotEmpty((Map)data)) {
            Integer maxColumnIdx = this.maxColumnMap.get(sheetName);
            for (int i = 0; i < maxColumnIdx; ++i) {
                this.addCellRegion((Sheet)sheet, curRowNum, i);
            }
        }
    }

    private Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell;
        Row row = sheet.getRow(rowIndex);
        if (null == row) {
            row = sheet.createRow(rowIndex);
        }
        if (null == (cell = row.getCell(colIndex))) {
            cell = row.createCell(colIndex);
        }
        XSSFCellStyle columnStyle = (XSSFCellStyle)this.wb.createCellStyle();
        columnStyle.setDataFormat(this.wb.createDataFormat().getFormat("@"));
        this.setCommonStyle((CellStyle)columnStyle);
        columnStyle.setFont(this.originalFont);
        columnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        columnStyle.setAlignment(HorizontalAlignment.LEFT);
        cell.setCellStyle((CellStyle)columnStyle);
        return cell;
    }

    public void genSheetAndTitle(String sheetName, HReportConfExpEntityConf expEntityConf) {
        List<HReportConfExpEntityConf> list;
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        String entityNumber = expEntityConf.getEntityNumber();
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
        List<String> fieldList = expEntityConf.getFieldList();
        int idx = 0;
        for (String string : fieldList) {
            DynamicProperty property = entityType.getProperty(string);
            LocaleString displayName = property.getDisplayName();
            String title = "";
            if (displayName == null) {
                if (string.equals("id")) {
                    title = ResManager.loadKDString((String)"\u5185\u7801", (String)"HReportConfExpWriter_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
                }
            } else {
                title = displayName.getLocaleValue();
            }
            if (property instanceof MuliLangTextProp) {
                for (EnabledLang enabledLang : enabledLangList) {
                    String mulField = string + '.' + enabledLang.getNumber();
                    String mulTitle = title + '.' + enabledLang.getName();
                    this.setTitleCell(sheet, idx, mulField, mulTitle);
                    ++idx;
                }
                continue;
            }
            this.setTitleCell(sheet, idx, string, title);
            ++idx;
        }
        List<HReportConfExpEntityConf> one2OneConfList = expEntityConf.getOne2OneConfList();
        if (one2OneConfList != null) {
            for (HReportConfExpEntityConf one2OneConf : one2OneConfList) {
                this.setTitleCell(sheet, idx, one2OneConf.getEntityNumber(), one2OneConf.getEntityDesc());
                ++idx;
            }
        }
        if ((list = expEntityConf.getOne2ManyConfList()) != null) {
            for (HReportConfExpEntityConf one2ManyConf : list) {
                this.setTitleCell(sheet, idx, one2ManyConf.getEntityNumber(), one2ManyConf.getEntityDesc());
                ++idx;
            }
        }
        this.maxColumnMap.put(sheetName, idx);
    }

    private void setTitleCell(SXSSFSheet sheet, int colIdx, String fieldNum, String title) {
        sheet.setColumnWidth(colIdx, 3840);
        Cell numberRowCell = this.addCellRegion((Sheet)sheet, 0, colIdx);
        numberRowCell.setCellStyle(this.getHeadCellStyle());
        numberRowCell.setCellValue(fieldNum);
        Cell titleRowCell = this.addCellRegion((Sheet)sheet, 1, colIdx);
        titleRowCell.setCellStyle(this.getHeadCellStyle());
        titleRowCell.setCellValue(title);
        this.columnIdxMap.put(sheet.getSheetName() + '#' + fieldNum, colIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            this.wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ExpCommonUtil.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (this.wb != null) {
                this.wb.dispose();
                this.wb.close();
            }
        }
    }

    private CellStyle getHeadCellStyle() {
        XSSFCellStyle headColumnStyle = (XSSFCellStyle)this.wb.createCellStyle();
        this.setCommonStyle((CellStyle)headColumnStyle);
        headColumnStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    private void setCommonStyle(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }
}

