/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp.complexconvert;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprList;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.Operator;
import kd.bos.formula.excel.Paren;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.service.AbstractFunctionExecuteService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exp.complexconvert.BaseComplexPropConvert;
import kd.hr.hrptmc.business.exp.util.FieldAliasParseUtil;
import kd.hr.hrptmc.common.model.exp.RptRefComplexPropBo;

public class ComplexExprConvert
extends BaseComplexPropConvert {
    private static final Log LOGGER = LogFactory.getLog(ComplexExprConvert.class);
    private final Set<Character> specialChar = Stream.of(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('$')).collect(Collectors.toSet());
    private final Set<String> specialStr = Stream.of("true", "false", "and", "or", "null", "NULL").collect(Collectors.toSet());
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");

    @Override
    public void transBdPropData(String mainEntityNumber, Map<String, String> relEntityMap, Map<String, Object> data, RptRefComplexPropBo refComplexPropBo) {
        String fieldValStoreField = refComplexPropBo.getFieldValStoreField();
        String runExprStr = (String)data.get(fieldValStoreField);
        if (HRStringUtils.isEmpty((String)runExprStr)) {
            return;
        }
        try {
            HashMap varMap = Maps.newHashMapWithExpectedSize((int)16);
            this.parseExpr(runExprStr, varMap);
            for (Map.Entry varEntry : varMap.entrySet()) {
                String newVar = (String)varEntry.getKey();
                String originVar = (String)varEntry.getValue();
                runExprStr = runExprStr.replace(originVar, newVar);
            }
            Expr expr = AbstractFunctionExecuteService.getExpr((String)runExprStr);
            StringBuilder runExprSb = new StringBuilder(expr.toString());
            this.handleExpr(expr, runExprSb, varMap, mainEntityNumber, relEntityMap);
            String finalRunExpr = runExprSb.toString();
            for (Map.Entry varEntry : varMap.entrySet()) {
                String originVar = (String)varEntry.getKey();
                String newVar = (String)varEntry.getValue();
                finalRunExpr = finalRunExpr.replace(originVar, newVar);
            }
            finalRunExpr = finalRunExpr.replace("'\"", "\"");
            finalRunExpr = finalRunExpr.replace("\"'", "\"");
            data.put(fieldValStoreField, finalRunExpr);
        }
        catch (Exception e) {
            LOGGER.error("BaseComplexPropConvert expr convert error:", (Throwable)e);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u89e3\u6790\u5931\u8d25:%s\u3002", (String)"ComplexExprConvert_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), runExprStr));
        }
    }

    private void handleExpr(Expr expr, StringBuilder runExpr, Map<String, String> varMap, String mainEntityNumber, Map<String, String> relEntityMap) {
        Expr expr1;
        if (expr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)expr;
            Operator operator = binaryExpr.getOperator();
            Expr left = binaryExpr.getLeft();
            Expr right = binaryExpr.getRight();
            String exprProp = varMap.get(left.toString());
            if ((HRStringUtils.equals((String)operator.getName(), (String)"=") || HRStringUtils.equals((String)operator.getName(), (String)"!=")) && HRStringUtils.isNotEmpty((String)exprProp)) {
                String fieldAlias = exprProp.replace("$", "");
                String baseDataNum = FieldAliasParseUtil.getBdPropEntityNumber(mainEntityNumber, relEntityMap, fieldAlias, this.entityTypeUtil);
                String value = right.toString();
                if (baseDataNum != null && HRStringUtils.isNotEmpty((String)value) && !"NULL".equalsIgnoreCase(value)) {
                    String bdUniqueKey = this.transBdPksToUks(baseDataNum, value);
                    if (bdUniqueKey == null) {
                        return;
                    }
                    String origin = left + " " + operator.getName() + " " + value;
                    String runExprStr = runExpr.toString().replace(origin, left + " " + operator.getName() + " \"" + bdUniqueKey + "\"");
                    runExpr.replace(0, runExpr.length(), runExprStr);
                }
            }
            this.handleExpr(left, runExpr, varMap, mainEntityNumber, relEntityMap);
            this.handleExpr(right, runExpr, varMap, mainEntityNumber, relEntityMap);
        } else if (expr instanceof ExprList) {
            ExprList exprList = (ExprList)expr;
            if (exprList.list != null) {
                for (Expr expr12 : exprList.list) {
                    this.handleExpr(expr12, runExpr, varMap, mainEntityNumber, relEntityMap);
                }
            }
        } else if (expr instanceof FunCall) {
            FunCall funCall = (FunCall)expr;
            if (funCall.getParams() != null) {
                for (Expr expr13 : funCall.getParams()) {
                    this.handleExpr(expr13, runExpr, varMap, mainEntityNumber, relEntityMap);
                }
            }
        } else if (expr instanceof Paren && (expr1 = ((Paren)expr).getExpr()) != null) {
            this.handleExpr(expr1, runExpr, varMap, mainEntityNumber, relEntityMap);
        }
    }

    private void parseExpr(String expr, Map<String, String> varMap) {
        boolean isQuotation = false;
        boolean isField = false;
        int varCount = 1;
        char[] exprArr = expr.toCharArray();
        StringBuilder fieldSb = new StringBuilder();
        for (char chr : exprArr) {
            if (this.specialChar.contains(Character.valueOf(chr))) {
                if (isField && chr != '$') {
                    fieldSb.append(chr);
                }
                if (chr == '$') {
                    boolean bl = isField = !isField;
                }
                if (chr == '\"') {
                    boolean bl = isQuotation = !isQuotation;
                }
                if (fieldSb.length() <= 0) continue;
                if (!isField && (chr == '(' || isQuotation || this.specialStr.contains(fieldSb.toString()) || NUMBER_PATTERN.matcher(fieldSb.toString()).matches())) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                if (chr != '$') continue;
                String newFieldNum = "$" + fieldSb + "$";
                varMap.put("var" + varCount++, newFieldNum);
                fieldSb = new StringBuilder();
                isField = false;
                continue;
            }
            if (isQuotation) continue;
            fieldSb.append(chr);
        }
    }
}

