/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.filesource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.datastore.physicaltable.model.AnObjFileSourceDataStoreTableBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.filesource.ReportFileSourceImportInfo;
import kd.hr.hrptmc.common.constant.filesource.ReportFileSourceConstants;

public class FileSourceTableMsgService
implements ReportFileSourceConstants {
    private final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_filesourcetable");
    private static volatile FileSourceTableMsgService service = null;

    private FileSourceTableMsgService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSourceTableMsgService getInstance() {
        if (service != null) return service;
        Class<FileSourceTableMsgService> clazz = FileSourceTableMsgService.class;
        synchronized (FileSourceTableMsgService.class) {
            if (service != null) return service;
            service = new FileSourceTableMsgService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void saveTableMsg(ReportFileSourceImportInfo importInfo) {
        AnObjFileSourceDataStoreTableBo dataStoreTableBo = importInfo.getDataStoreTableBo();
        DynamicObject tableDy = this.helper.generateEmptyDynamicObject();
        tableDy.set("tablename", (Object)dataStoreTableBo.getTableName());
        tableDy.set("anobj", (Object)importInfo.getCreateAnObjService().getAnObjDy());
        tableDy.set("virtualobj", (Object)importInfo.getCreateVirtualEntityService().getVirtualObjDy());
        DynamicObjectCollection fields = tableDy.getDynamicObjectCollection("fields");
        for (ReportDataStoreFieldBo storeField : dataStoreTableBo.getStoreFields()) {
            DynamicObject fieldDy = this.helper.generateEmptyEntryDynamicObject("fields");
            fieldDy.set("fieldname", (Object)storeField.getFieldName());
            fieldDy.set("displayname", (Object)storeField.getFieldDisplayName());
            fields.add((Object)fieldDy);
        }
        this.helper.saveOne(tableDy);
    }

    public void deleteTableMsg(String tableName) {
        this.helper.deleteByFilter(new QFilter[]{new QFilter("tablename", "=", (Object)tableName)});
    }

    public DynamicObject queryTableMsgDy(String tableName) {
        return this.helper.loadDynamicObject(new QFilter("tablename", "=", (Object)tableName));
    }

    public DynamicObject queryTableMsgDy(long anObjId) {
        return this.helper.loadDynamicObject(new QFilter("anobj", "=", (Object)anObjId));
    }

    public String queryTableName(long anObjId) {
        DynamicObject tableMsgDy = this.helper.queryOriginalOne("tablename", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        if (tableMsgDy == null) {
            return null;
        }
        return tableMsgDy.getString("tablename");
    }

    public AnObjFileSourceDataStoreTableBo queryTableMsgBoByVirtualObj(long virtualObjId) {
        DynamicObject tableMsgDy = this.helper.loadDynamicObject(new QFilter("virtualobj", "=", (Object)virtualObjId));
        if (tableMsgDy == null) {
            return null;
        }
        return this.getDataStoreTableBo(tableMsgDy);
    }

    public AnObjFileSourceDataStoreTableBo queryTableMsgBoByAnObj(long anObjId) {
        DynamicObject tableMsgDy = this.helper.loadDynamicObject(new QFilter("anobj", "=", (Object)anObjId));
        if (tableMsgDy == null) {
            return null;
        }
        return this.getDataStoreTableBo(tableMsgDy);
    }

    private AnObjFileSourceDataStoreTableBo getDataStoreTableBo(DynamicObject tableMsgDy) {
        AnObjFileSourceDataStoreTableBo dataStoreTableBo = new AnObjFileSourceDataStoreTableBo();
        dataStoreTableBo.setTableName(tableMsgDy.getString("tablename"));
        dataStoreTableBo.setVirtualObjId(tableMsgDy.getDynamicObject("virtualobj").getLong("id"));
        dataStoreTableBo.setAnObjId(tableMsgDy.getDynamicObject("anobj").getLong("id"));
        ArrayList dataStoreFields = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection fieldCol = tableMsgDy.getDynamicObjectCollection("fields");
        for (DynamicObject fieldDy : fieldCol) {
            ReportDataStoreFieldBo fieldBo = new ReportDataStoreFieldBo();
            fieldBo.setFieldName(fieldDy.getString("fieldname"));
            fieldBo.setFieldDisplayName(fieldDy.getString("displayname"));
            dataStoreFields.add(fieldBo);
        }
        dataStoreTableBo.setStoreFields(dataStoreFields);
        return dataStoreTableBo;
    }
}

