/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.filesource;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.datastore.physicaltable.FileSourceCreateTableHandlerCreator;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.model.AnObjFileSourceDataStoreTableBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;
import kd.hr.hrptmc.business.filesource.FileSourceTableMsgService;
import kd.hr.hrptmc.business.filesource.ReportFileSourceImportInfo;
import kd.hr.hrptmc.common.constant.filesource.ReportFileSourceConstants;
import org.apache.commons.lang.RandomStringUtils;

public class ReportFileSourceService
implements ReportFileSourceConstants {
    private static final String tableNamePrefix = "t_hrptmc_fs";
    public static final String fieldNamePrefix = "field";
    private static final Log LOGGER = LogFactory.getLog(ReportFileSourceService.class);
    private static volatile ReportFileSourceService service = null;
    private final HRBaseServiceHelper enumHelper = new HRBaseServiceHelper("hrptmc_filesourceenum");

    private ReportFileSourceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportFileSourceService getInstance() {
        if (service != null) return service;
        Class<ReportFileSourceService> clazz = ReportFileSourceService.class;
        synchronized (ReportFileSourceService.class) {
            if (service != null) return service;
            service = new ReportFileSourceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public String getTableName(Long reportId) {
        if (reportId == null) {
            return null;
        }
        HRBaseServiceHelper reportManageHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = reportManageHelper.queryOriginalOne("anobjid", (Object)reportId);
        if (reportDy == null) {
            return null;
        }
        return FileSourceTableMsgService.getInstance().queryTableName(reportDy.getLong("anobjid"));
    }

    public void clearFileSourceDataForReportSave(String tableName, DynamicObject currentReportDy) {
        if (HRStringUtils.isEmpty((String)tableName)) {
            return;
        }
        DynamicObject tableMsg = FileSourceTableMsgService.getInstance().queryTableMsgDy(tableName);
        if (tableMsg == null) {
            this.dropTableAndClearData(tableName);
            return;
        }
        long anObjId = tableMsg.getDynamicObject("anobj").getLong("id");
        if (anObjId != currentReportDy.getDynamicObject("anobjid").getLong("id")) {
            this.dropTableAndClearData(tableName);
        }
    }

    public void clearFileSourceDataForReport(String reportNum, String tableName) {
        if (HRStringUtils.isEmpty((String)tableName)) {
            return;
        }
        HRBaseServiceHelper reportHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = reportHelper.queryOriginalOne("anobjid", new QFilter[]{new QFilter("number", "=", (Object)reportNum)});
        if (reportDy == null) {
            this.dropTableAndClearData(tableName);
            return;
        }
        DynamicObject tableMsg = FileSourceTableMsgService.getInstance().queryTableMsgDy(tableName);
        if (tableMsg == null) {
            this.dropTableAndClearData(tableName);
            return;
        }
        long anObjId = tableMsg.getDynamicObject("anobj").getLong("id");
        if (anObjId != reportDy.getLong("anobjid")) {
            this.dropTableAndClearData(tableName);
        }
    }

    public void clearFileSourceDataForNewReport(String tableName, boolean isNewReport, String option) {
        boolean clear;
        if (HRStringUtils.isEmpty((String)tableName)) {
            return;
        }
        boolean bl = clear = isNewReport && !HRStringUtils.equals((String)option, (String)"ok");
        if (clear) {
            this.dropTableAndClearData(tableName);
        }
    }

    public void dropTableAndClearData(String tableName) {
        DynamicObject tableMsgDy = FileSourceTableMsgService.getInstance().queryTableMsgDy(tableName);
        if (tableMsgDy != null) {
            this.dropTableAndClearData(tableMsgDy);
        }
    }

    public void dropTableAndClearData(Long anObjId) {
        DynamicObject tableMsgDy = FileSourceTableMsgService.getInstance().queryTableMsgDy(anObjId);
        if (tableMsgDy != null) {
            this.dropTableAndClearData(tableMsgDy);
        }
    }

    private void dropTableAndClearData(DynamicObject tableMsgDy) {
        String tableName = tableMsgDy.getString("tablename");
        long anObjDyId = tableMsgDy.getDynamicObject("anobj").getLong("id");
        DynamicObject anObjDy = AnalyseObjectService.getInstance().loadAnObjDy(anObjDyId);
        DynamicObject virtualObjDy = tableMsgDy.getDynamicObject("virtualobj");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                FileSourceTableMsgService.getInstance().deleteTableMsg(tableName);
                OperationServiceImpl opImpl = new OperationServiceImpl();
                OperateOption operateOption = OperateOption.create();
                OperationResult operationResult = opImpl.localInvokeOperation("delete", new DynamicObject[]{anObjDy}, operateOption);
                if (!operationResult.isSuccess()) {
                    throw new Exception("del anObj fail");
                }
                HRBaseServiceHelper virtualEntityHelper = new HRBaseServiceHelper("hrptmc_virtualentity");
                virtualEntityHelper.deleteByFilter(new QFilter[]{new QFilter("number", "=", (Object)virtualObjDy.getString("number"))});
                ReportFileSourceService.getInstance().deleteEnums(tableName);
                PhysicalTableHandler tableHandler = FileSourceCreateTableHandlerCreator.getHandler(new AnObjFileSourceDataStoreTableBo(tableName));
                tableHandler.deleteTable(new char[0]);
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
                txHandle.markRollback();
            }
        }
    }

    public AnObjFileSourceDataStoreTableBo createTable(ReportFileSourceImportInfo importInfo) {
        List<ReportDataStoreFieldBo> fields = importInfo.getFields();
        String tableName = this.generateTableName();
        AnObjFileSourceDataStoreTableBo dataStoreTableBo = new AnObjFileSourceDataStoreTableBo();
        dataStoreTableBo.setTableName(tableName);
        dataStoreTableBo.setStoreFields(fields);
        PhysicalTableHandler tableHandler = FileSourceCreateTableHandlerCreator.getHandler(dataStoreTableBo);
        tableHandler.createTable();
        importInfo.setTableName(tableName);
        importInfo.setTableHandler(tableHandler);
        return dataStoreTableBo;
    }

    private String generateTableName() {
        String randomStr;
        String tableName;
        do {
            randomStr = RandomStringUtils.randomAlphanumeric((int)10);
            randomStr = randomStr.toLowerCase();
        } while (this.tableIsExist(tableName = tableNamePrefix + randomStr));
        return tableName;
    }

    private boolean tableIsExist(String tableName) {
        return HRDBUtil.exitsTable((DBRoute)new DBRoute("hmp"), (String)tableName);
    }

    public String getFieldName(int index) {
        return fieldNamePrefix + index;
    }

    public Object[] buildInsertData(JSONObject rowData, long id, ReportFileSourceImportInfo rowMsg) {
        Object[] values = new Object[rowMsg.getFields().size() + 1];
        values[0] = id;
        int index = 0;
        for (ReportDataStoreFieldBo field : rowMsg.getFields()) {
            JSONObject data = rowData.getJSONObject(field.getFieldName());
            if (field.getType() == ReportDataStoreType.NVARCHAR) {
                String stringData = data.getString("stringData");
                if (HRStringUtils.isEmpty((String)stringData)) {
                    stringData = " ";
                }
                values[index + 1] = stringData;
            } else {
                Object originData = data.get((Object)"originData");
                if (originData == null && field.getType() == ReportDataStoreType.DECIMAL) {
                    originData = 0.0;
                }
                values[index + 1] = originData;
            }
            ++index;
        }
        return values;
    }

    public void insertData(String tableName, List<Object[]> values, ReportFileSourceImportInfo rowMsg) {
        ArrayList fieldNameList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList placeHolders = Lists.newArrayListWithExpectedSize((int)10);
        fieldNameList.add("FID");
        placeHolders.add("?");
        for (ReportDataStoreFieldBo field : rowMsg.getFields()) {
            fieldNameList.add(field.getFieldName());
            placeHolders.add("?");
        }
        String insertSql = String.format("INSERT INTO %s(%s) VALUES (%s)", tableName, String.join((CharSequence)",", fieldNameList), String.join((CharSequence)",", placeHolders));
        LOGGER.info("ReportFileSourceService insertData sql: {}", (Object)insertSql);
        LOGGER.info("ReportFileSourceService insertData values: {}", values.stream().map(Arrays::toString).collect(Collectors.toList()));
        HRDBUtil.executeBatch((DBRoute)new DBRoute("hmp"), (String)insertSql, values);
    }

    public Set<String> saveEnums(Set<String> enumFields, ReportFileSourceImportInfo importInfo) {
        String tableName = importInfo.getTableName();
        HashMap enumFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ReportDataStoreFieldBo field : importInfo.getFields()) {
            if (!enumFields.contains(field.getFieldName()) || field.getType() != ReportDataStoreType.VARCHAR && field.getType() != ReportDataStoreType.CHAR && field.getType() != ReportDataStoreType.NVARCHAR) continue;
            String querySql = String.format("SELECT COUNT(DISTINCT %s) FROM %s", field.getFieldName(), tableName);
            LOGGER.info("ReportFileSourceService count enums sql: {}", (Object)querySql);
            int count = (Integer)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)querySql, (Object[])new Object[0], resultSet -> {
                int result = 0;
                while (resultSet.next()) {
                    result = (int)resultSet.getLong(1);
                }
                return result;
            });
            if (count >= 1000) continue;
            enumFieldMap.put(field.getFieldName(), Sets.newHashSetWithExpectedSize((int)16));
        }
        enumFieldMap.forEach((fieldName, enumItems) -> {
            String querySql = String.format("SELECT %s FROM %s", fieldName, tableName);
            HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)querySql, (Object[])new Object[0], resultSet -> {
                while (resultSet.next()) {
                    enumItems.add(resultSet.getString(1));
                }
                return null;
            });
        });
        DynamicObjectCollection enums = new DynamicObjectCollection();
        enumFieldMap.forEach((fieldName, enumItems) -> {
            for (String enumItem : enumItems) {
                DynamicObject enumDy = this.enumHelper.generateEmptyDynamicObject();
                enumDy.set("tablename", (Object)tableName);
                enumDy.set("fieldname", fieldName);
                enumDy.set("enum", (Object)enumItem);
                enums.add((Object)enumDy);
            }
        });
        this.enumHelper.save(enums);
        return enumFieldMap.keySet();
    }

    public void deleteEnums(String tableName) {
        this.enumHelper.deleteByFilter(new QFilter[]{new QFilter("tablename", "=", (Object)tableName)});
    }

    public DynamicObjectCollection queryEnums(String tableName) {
        return this.enumHelper.queryOriginalCollection("id, fieldname, enum", new QFilter[]{new QFilter("tablename", "=", (Object)tableName)});
    }
}

