/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.xml.sax.SAXException;

public class HReportImportFailedSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(HReportImportFailedSheetHandler.class);
    private static final String COLOR = "color";
    protected SXSSFWorkbook book;
    protected Map<String, CellStyle> styles = Maps.newHashMapWithExpectedSize((int)16);
    protected ImportLogger importLogger;
    protected FileService service;
    protected ImportContext ctx;
    protected SheetHandler.ParsedRow currentRow;
    private final Map<String, SXSSFSheet> sheets = Maps.newHashMapWithExpectedSize((int)16);
    protected int cursorRow;
    private boolean hasErrorCol;
    protected final int ERR_ROW_COUNT = 5000;
    private final Map<String, ImportLogger> importLoggerMap;

    public HReportImportFailedSheetHandler(ImportContext ctx, ImportLogger importLogger, FileService service, Map<String, ImportLogger> importLoggerMap) {
        this.setInterrupt(false);
        this.ctx = ctx;
        this.importLogger = importLogger;
        this.service = service;
        importLogger.getDelRows().sort(Comparator.comparingInt(obj -> obj[0]));
        this.importLoggerMap = importLoggerMap;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(1000);
                this.book.setCompressTempFiles(true);
            }
            sheet = this.book.createSheet(row.getSheetName());
            sheet.setColumnWidth(0, 10000);
            this.sheets.put(row.getSheetName(), sheet);
            this.cursorRow = 0;
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        this.handleWorkSheet(sheet, currRowNum);
    }

    protected void handleWorkSheet(SXSSFSheet sheet, int currRowNum) {
        if (currRowNum == 1) {
            SXSSFRow nameRow = this.getRow(sheet, currRowNum);
            SXSSFCell cell = nameRow.createCell(0);
            cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"HReportImportFailedSheetHandler_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        } else if (currRowNum > 1) {
            this.getLogStr(sheet, currRowNum);
        }
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            this.putSXSSFSheet(sheet, this.cursorRow, entry);
        }
        ++this.cursorRow;
    }

    protected void putSXSSFSheet(SXSSFSheet sheet, int currRowNum, Map.Entry<Integer, String> entry) {
        String fmt;
        JSONObject styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
        int cellIndex = this.countIndex(entry.getKey());
        SXSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(++cellIndex);
        CellStyle customCellStyle = this.getCellStyle(styleObj);
        if (customCellStyle != null) {
            sxssfCell.setCellStyle(customCellStyle);
        }
        if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
            try {
                sxssfCell.setCellValue(new BigDecimal(entry.getValue()).doubleValue());
            }
            catch (NumberFormatException e) {
                sxssfCell.setCellValue(entry.getValue());
            }
        } else {
            sxssfCell.setCellValue(entry.getValue());
        }
    }

    protected boolean getLogStr(SXSSFSheet sheet, int currRowNum) {
        String sheetName = sheet.getSheetName();
        String entityName = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        ImportLogger logger = this.importLoggerMap.get(entityName);
        if (logger == null) {
            return false;
        }
        List logs = (List)logger.getLogCache().get(currRowNum);
        if (logs == null) {
            return false;
        }
        if (!logs.isEmpty()) {
            String mergeLogStr;
            if (currRowNum <= 5000) {
                StringBuilder sb = new StringBuilder();
                for (ImportLogger.ImportLog importLog : logs) {
                    sb.append(importLog).append(System.lineSeparator());
                    if (sb.length() <= 4000) continue;
                    sb.replace(3997, 4000, "...").setLength(4000);
                    break;
                }
                mergeLogStr = sb.toString();
            } else {
                mergeLogStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u884c\u6570\u636e\u3002", (String)"HReportImportFailedSheetHandler_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
            }
            SXSSFCell cell = this.getRow(sheet, this.cursorRow).createCell(0);
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            cell.setCellStyle(this.getCellStyle(styleObj));
            cell.setCellValue(mergeLogStr);
            return true;
        }
        return false;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.setInterrupt(false);
        Set sheetNames = this.getSheetNames();
        sheetNames.remove(this.getSheetName());
        if (!sheetNames.isEmpty()) {
            return;
        }
        this.handleErrorFile();
    }

    protected void handleErrorFile() {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.book.write((OutputStream)os);
            byte[] data = os.toByteArray();
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            LocalDate now = LocalDate.now();
            String name = this.ctx.getListName() + "_" + String.format(Locale.ROOT, "%02d%02d", now.getMonthValue(), now.getDayOfMonth()) + ".xlsx";
            String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_%s\u3002", (String)"HReportImportFailedSheetHandler_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), name).replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
            String url = tempFile.saveAsUrl(fileName, data, data.length);
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)this.ctx.getAppId(), (String)(this.ctx.getBillFormId() + UUID.randomUUID().toString()), (String)fileName);
            url = this.service.upload(new FileItem(fileName, path, tempFile.getInputStream(url)));
            this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)url));
        }
        catch (Exception exp) {
            throw new KDBizException((Throwable)exp, new ErrorCode("", exp instanceof KDBizException ? exp.getMessage() : ResManager.loadKDString((String)"\u9519\u8bef\u6570\u636e\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"HReportImportFailedSheetHandler_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            try {
                if (this.book != null) {
                    this.book.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            this.ctx = null;
            this.sheets.clear();
            this.book = null;
            this.importLogger = null;
        }
    }

    protected SXSSFRow getRow(SXSSFSheet sheet, int intdexRow) {
        SXSSFRow row = sheet.getRow(intdexRow);
        if (row == null) {
            row = sheet.createRow(intdexRow);
        }
        return row;
    }

    protected CellStyle getCellStyle(JSONObject style) {
        String defaultFmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short backGround = style.getShort("bg");
        Short titleColor = style.getShort(COLOR);
        String styleStr = String.format(Locale.ROOT, "%s_-_%d_-_%d_-_%s", defaultFmt, backGround, titleColor, align);
        CellStyle customCellStyle = this.styles.get(styleStr);
        if (customCellStyle == null) {
            customCellStyle = HReportImportFailedSheetHandler.getCellStyle(defaultFmt, backGround, titleColor, styleStr, this.styles, this.book);
        }
        return customCellStyle;
    }

    protected int countIndex(int index) {
        if (this.hasErrorCol) {
            return index;
        }
        return ++index;
    }

    public static CellStyle getCellStyle(String fmt, Short bg, Short color, String styleStr, Map<String, CellStyle> styles, SXSSFWorkbook book) {
        CellStyle cellStyle = book.createCellStyle();
        styles.put(styleStr, cellStyle);
        cellStyle.setDataFormat(book.createDataFormat().getFormat(fmt));
        if (bg != null) {
            cellStyle.setFillForegroundColor(bg.shortValue());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (color != null) {
            Font font = book.createFont();
            font.setColor(color.shortValue());
            cellStyle.setFont(font);
        }
        return cellStyle;
    }
}

