/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.log.ModifyDirtyManager;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.imp.HRReportDynamicObjectUtils;
import kd.hr.hrptmc.business.imp.HReportImportFailedSheetHandler;
import kd.hr.hrptmc.business.imp.HReportImportLister;
import kd.hr.hrptmc.business.imp.HReportImportSheetHandler;
import kd.hr.hrptmc.business.imp.HReportImportUtil;
import kd.hr.hrptmc.business.imp.model.ReportImportBaseDataBo;
import kd.hr.hrptmc.business.imp.model.ReportImportDetailVo;
import kd.hr.hrptmc.business.imp.service.AnalyseObjectImportService;
import kd.hr.hrptmc.business.imp.service.BusServiceImportService;
import kd.hr.hrptmc.business.imp.service.CustomSortImportService;
import kd.hr.hrptmc.business.imp.service.PreIndexImportService;
import kd.hr.hrptmc.business.imp.service.QueryFieldImportService;
import kd.hr.hrptmc.business.imp.service.ReportImportBaseDataIdService;
import kd.hr.hrptmc.business.imp.service.ReportManageImportService;
import kd.hr.hrptmc.business.imp.service.WorkSheetImportService;
import kd.hr.hrptmc.business.imp.validator.AnalyseObjectImportValidator;
import kd.hr.hrptmc.business.imp.validator.BusServiceImportValidator;
import kd.hr.hrptmc.business.imp.validator.PreIndexImportValidator;
import kd.hr.hrptmc.business.imp.validator.ReportManageImportValidator;
import kd.hr.hrptmc.business.repdesign.task.ReportParConfSchService;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;
import kd.hr.hrptmc.common.util.HRImpDuplicateData;
import org.jetbrains.annotations.NotNull;

public class HReportImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(HReportImportPlugin.class);
    private final ModifyDirtyManager modifyDirtyManager = new ModifyDirtyManager();
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"HReportImportLister", (int)2, (int)2);
    public Object syncLock = new Object();
    private final AnalyseObjectImportService analyseService = new AnalyseObjectImportService();
    private final BusServiceImportService busImportService = new BusServiceImportService();
    private final PreIndexImportService indexImportService = new PreIndexImportService();
    private final ReportManageImportService manageImportService = new ReportManageImportService();
    private final QueryFieldImportService queryFieldImportService = new QueryFieldImportService();
    private final CustomSortImportService customSortImportService = new CustomSortImportService();
    private final WorkSheetImportService workSheetImportService = new WorkSheetImportService();
    private final AnalyseObjectImportValidator analyseObjectValidator = new AnalyseObjectImportValidator();
    private final BusServiceImportValidator busServiceValidator = new BusServiceImportValidator();
    private final PreIndexImportValidator preIndexValidator = new PreIndexImportValidator();
    private final ReportManageImportValidator reportManageValidator = new ReportManageImportValidator();
    private final Map<String, ImportLogger> importLoggerMap = Maps.newHashMap();
    private final Map<String, ReportImportDetailVo> dataCount = Maps.newHashMapWithExpectedSize((int)16);

    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader excelReader = new ExcelReader();
        for (String url : this.ctx.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    excelReader.read(in, (SheetHandler)new HReportImportSheetHandler(this.ctx, url, this.importLoggerMap));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof KDBizException) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), cause.getMessage());
                } else {
                    this.ctx.getLogger(url).log(Integer.valueOf(3), ImportLogger.formatException((Throwable)e));
                }
                LOGGER.error("resolveExcel_error", (Throwable)e);
                JSONObject json = new JSONObject();
                json.put("errCode", (Object)e.getMessage());
                this.ctx.getDataQueue(url).add(new ImportBillData(json, 0, 0));
                this.ctx.setResolveComplete(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importData() {
        try {
            for (String url : this.ctx.getAllUrls()) {
                LinkedBlockingQueue dataQ = this.ctx.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = this.ctx.getLogger(url);
                importLogger.setDelRows(delRows);
                this.fetchBatchQueenData(this.ctx, url, dataQ);
            }
        }
        catch (Exception e) {
            this.handleFailed();
            LOGGER.error("report_importData_error: ", (Throwable)e);
        }
        finally {
            HashMap<String, Object> retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            retdata.put("importLoggerMap", this.importLoggerMap);
            retdata.put("dataCount", this.dataCount);
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                for (Map.Entry<String, ImportLogger> loggerEntry : this.importLoggerMap.entrySet()) {
                    ImportLogger logger = loggerEntry.getValue();
                    total += logger.getTotal();
                    failed += logger.getLogCache().size();
                    HashMap sheetResult = Maps.newHashMapWithExpectedSize((int)2);
                    sheetResult.put("sheetTotal", logger.getTotal());
                    sheetResult.put("sheetFailed", logger.getLogCache().size());
                    retdata.put(loggerEntry.getKey(), sheetResult);
                }
                if (failed <= 0) continue;
                this.outputFailedData(url, this.ctx.getLogger(url));
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            this.ctx.feedbackProgress(100, null, null);
            HReportImportUtil.clearCache();
            this.clearAttachmentFile();
        }
    }

    private void clearAttachmentFile() {
        for (String url : this.ctx.getAllUrls()) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            service.delete(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchBatchQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ) {
        int timeout = 0;
        HashMap allPreData = Maps.newHashMapWithExpectedSize((int)16);
        HashSet allCorrectDataSet = Sets.newHashSetWithExpectedSize((int)16);
        HashMap allExistData = Maps.newHashMapWithExpectedSize((int)16);
        int batchId = 1;
        List<HRImpDuplicateData> dataList = this.parseDuplicateData(conf);
        try {
            this.drainData(conf, url, dataQ, timeout, allPreData, allCorrectDataSet, batchId, dataList);
            if (this.isFailed(allCorrectDataSet)) {
                HReportImportPlugin.feedbackProgressDealWith(conf, this.importLoggerMap);
                return;
            }
            if (HRStringUtils.isNotEmpty((String)this.getSuspendKey(conf))) {
                return;
            }
            HReportImportUtil.queryExistData(allPreData, allExistData);
            this.validateData(allPreData, allExistData);
            if (HRStringUtils.isNotEmpty((String)this.getSuspendKey(conf))) {
                return;
            }
            boolean lock = this.parseBaseDataId(allPreData);
            if (lock) {
                HReportImportLister lister = new HReportImportLister(this);
                threadPool.submit((Callable)lister);
                Object object = this.syncLock;
                synchronized (object) {
                    this.syncLock.wait();
                }
            }
            if (HRStringUtils.isNotEmpty((String)this.getSuspendKey(conf))) {
                return;
            }
            IAppCache appCache = AppCache.get((String)"HRPTMC");
            String baseDataIdStr = (String)appCache.get(HReportImportUtil.getImportCacheKeySuffix("HR_REPORT_IMP_baseDataIdResult"), String.class);
            if (HRStringUtils.isNotEmpty((String)baseDataIdStr)) {
                appCache.remove(HReportImportUtil.getImportCacheKeySuffix("HR_REPORT_IMP_baseDataIdResult"));
                List correctBaseDataBos = JSON.parseArray((String)baseDataIdStr, ReportImportBaseDataBo.class);
                this.correctBaseDataId(allPreData, new HashSet<ReportImportBaseDataBo>(correctBaseDataBos));
            }
            if (this.isFailed(allCorrectDataSet)) {
                HReportImportPlugin.feedbackProgressDealWith(conf, this.importLoggerMap);
                return;
            }
            if (HRStringUtils.isNotEmpty((String)this.getSuspendKey(conf))) {
                return;
            }
            this.saveBatch(allPreData, allExistData, dataList, conf);
        }
        catch (Exception ex) {
            this.handleFailed();
            LOGGER.error("report_fetchBatchQueenData_error: ", (Throwable)ex);
        }
        finally {
            HReportImportPlugin.feedbackProgressDealWith(conf, this.importLoggerMap);
        }
    }

    private boolean parseBaseDataId(Map<String, List<DynamicObject>> allPreData) {
        return this.handleBaseDataId(allPreData, null);
    }

    private void correctBaseDataId(Map<String, List<DynamicObject>> allPreData, Set<ReportImportBaseDataBo> correctedBaseDataIdBos) {
        this.handleBaseDataId(allPreData, correctedBaseDataIdBos);
    }

    private boolean handleBaseDataId(Map<String, List<DynamicObject>> allPreData, Set<ReportImportBaseDataBo> correctedBaseDataIdBos) {
        List<DynamicObject> anObjDys = allPreData.getOrDefault("hrptmc_analyseobject", Lists.newArrayListWithCapacity((int)16));
        List<DynamicObject> allQueryFields = allPreData.getOrDefault("hrptmc_anobjqueryfield", Lists.newArrayListWithCapacity((int)16));
        List<DynamicObject> allEntities = allPreData.getOrDefault("hrptmc_anobjjoinentity", Lists.newArrayListWithCapacity((int)16));
        List<DynamicObject> allEntityRelations = allPreData.getOrDefault("hrptmc_anobjentityrel", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> entityMap = allEntities.stream().collect(Collectors.groupingBy(entityDy -> entityDy.getLong("anobj")));
        Map<Long, List<DynamicObject>> entityRelationMap = allEntityRelations.stream().collect(Collectors.groupingBy(relationDy -> relationDy.getLong("anobj")));
        Map<Long, List<DynamicObject>> queryFieldMap = allQueryFields.stream().collect(Collectors.groupingBy(fieldDy -> fieldDy.getLong("anobj")));
        List<DynamicObject> allCalculateFields = allPreData.getOrDefault("hrptmc_calculatefield", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> anObjCalFieldMap = allCalculateFields.stream().filter(calculateDy -> HRStringUtils.equals((String)calculateDy.getString("source"), (String)"anobj")).collect(Collectors.groupingBy(fieldDy -> fieldDy.getLong("anobj")));
        List<DynamicObject> anObjPivotBoList = allPreData.getOrDefault("hrptmc_anobjpivot", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> anObjPivotMap = anObjPivotBoList.stream().collect(Collectors.groupingBy(anObjPivot -> anObjPivot.getLong("anobj")));
        List<DynamicObject> allGroupFields = allPreData.getOrDefault("hrptmc_anobjgroupfield", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> groupFieldMap = allGroupFields.stream().collect(Collectors.groupingBy(fieldDy -> fieldDy.getLong("anobj")));
        List<DynamicObject> allReportDys = allPreData.getOrDefault("hrptmc_reportmanage", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> reportMap = allReportDys.stream().collect(Collectors.groupingBy(reportDy -> reportDy.getLong("anobjid")));
        List<DynamicObject> allFilterDyList = allPreData.getOrDefault("hrptmc_filter", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> filterMap = allFilterDyList.stream().collect(Collectors.groupingBy(filterDy -> filterDy.getLong("rptmanage")));
        List<DynamicObject> allReportJumpDys = allPreData.getOrDefault("hrptmc_reportjump", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> reportJumpMap = allReportJumpDys.stream().collect(Collectors.groupingBy(reportJumpDy -> reportJumpDy.getLong("report")));
        List<DynamicObject> allCustomSortDyList = allPreData.getOrDefault("hrptmc_customsort", Lists.newArrayListWithCapacity((int)16));
        Map<Long, List<DynamicObject>> customSortMap = allCustomSortDyList.stream().collect(Collectors.groupingBy(customSort -> customSort.getLong("rptmanage")));
        Map<Long, List<DynamicObject>> reportCalFieldMap = allCalculateFields.stream().filter(calculateDy -> HRStringUtils.equals((String)calculateDy.getString("source"), (String)"report")).collect(Collectors.groupingBy(fieldDy -> fieldDy.getLong("report")));
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject anObjDy : anObjDys) {
            long anObjId = anObjDy.getLong("id");
            List<DynamicObject> joinEntityList = entityMap.get(anObjId);
            List<DynamicObject> joinEntityRelations = entityRelationMap.get(anObjId);
            List<DynamicObject> queryFields = queryFieldMap.getOrDefault(anObjId, Lists.newArrayListWithCapacity((int)1));
            List<DynamicObject> anObjCalFields = anObjCalFieldMap.getOrDefault(anObjId, Lists.newArrayListWithCapacity((int)1));
            List<DynamicObject> anObjPivots = anObjPivotMap.getOrDefault(anObjId, Lists.newArrayListWithCapacity((int)1));
            List<DynamicObject> groupFields = groupFieldMap.getOrDefault(anObjId, Lists.newArrayListWithCapacity((int)1));
            ReportImportBaseDataIdService service = new ReportImportBaseDataIdService(anObjDy, queryFields);
            if (correctedBaseDataIdBos != null && !correctedBaseDataIdBos.isEmpty()) {
                service.setCorrectData(true);
                Map baseDataBoMap = correctedBaseDataIdBos.stream().collect(Collectors.groupingBy(ReportImportBaseDataBo::getBaseDataNum, Collectors.toSet()));
                service.getNoMatchedBaseDataBoMap().putAll(baseDataBoMap);
                service.parseAnalyseObject(joinEntityList, joinEntityRelations, anObjCalFields, anObjPivots, groupFields);
            } else {
                resultSet.addAll(service.parseAnalyseObject(joinEntityList, joinEntityRelations, anObjCalFields, anObjPivots, groupFields));
            }
            List<DynamicObject> reportDys = reportMap.getOrDefault(anObjId, Lists.newArrayListWithCapacity((int)1));
            for (DynamicObject reportDy2 : reportDys) {
                long reportId = reportDy2.getLong("id");
                List<DynamicObject> reportCalFields = reportCalFieldMap.getOrDefault(reportId, Lists.newArrayListWithCapacity((int)1));
                List<DynamicObject> filterDys = filterMap.get(reportId);
                List<DynamicObject> reportJumpDys = reportJumpMap.getOrDefault(reportId, Lists.newArrayListWithCapacity((int)1));
                List<DynamicObject> customSortDyList = customSortMap.getOrDefault(reportId, Lists.newArrayListWithCapacity((int)1));
                if (correctedBaseDataIdBos != null && !correctedBaseDataIdBos.isEmpty()) {
                    service.parseReport(reportDy2, reportCalFields, filterDys, reportJumpDys, customSortDyList);
                    continue;
                }
                resultSet.addAll(service.parseReport(reportDy2, reportCalFields, filterDys, reportJumpDys, customSortDyList));
            }
        }
        if (!resultSet.isEmpty()) {
            IAppCache appCache = AppCache.get((String)"HRPTMC");
            appCache.put(HReportImportUtil.getImportCacheKeySuffix("HR_REPORT_IMP_BaseDataId"), (Object)SerializationUtils.toJsonString((Object)resultSet));
            return true;
        }
        return false;
    }

    private void saveLog(List<DynamicObject> saveDataList, List<DynamicObject> updateDataList) {
        try {
            if (saveDataList.size() > 0) {
                this.modifyDirtyManager.init(saveDataList.get(0).getDynamicObjectType(), saveDataList.toArray(new DynamicObject[saveDataList.size()]), "save");
                this.modifyDirtyManager.batchInsertLog(saveDataList.toArray(new DynamicObject[saveDataList.size()]));
            }
            if (updateDataList.size() > 0) {
                this.modifyDirtyManager.init(updateDataList.get(0).getDynamicObjectType(), updateDataList.toArray(new DynamicObject[updateDataList.size()]), "save");
                this.modifyDirtyManager.batchInsertLog(updateDataList.toArray(new DynamicObject[updateDataList.size()]));
            }
        }
        catch (Exception exception) {
            LOGGER.error("report_saveLog_error: ", (Throwable)exception);
        }
    }

    private void validateData(Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData) {
        this.analyseObjectValidator.validate(2, this.ctx, HREXPImpEnum.ANALYSEOBJECT, allPreData, this.importLoggerMap.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()), allExistData);
        this.busServiceValidator.validate(2, this.ctx, HREXPImpEnum.BUSISERVICE, allPreData, this.importLoggerMap.get(HREXPImpEnum.BUSISERVICE.getNumber()), allExistData);
        this.preIndexValidator.validate(2, this.ctx, HREXPImpEnum.PREINDEX, allPreData, this.importLoggerMap.get(HREXPImpEnum.PREINDEX.getNumber()), allExistData);
        this.reportManageValidator.validate(2, this.ctx, HREXPImpEnum.REPORTMANAGE, allPreData, this.importLoggerMap.get(HREXPImpEnum.REPORTMANAGE.getNumber()), allExistData);
    }

    private void saveBatch(Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData, List<HRImpDuplicateData> dataList, ImportContext conf) {
        TXHandle txHandle = TX.requiresNew();
        try {
            Map<Long, Map<String, String>> reportNumAndName = this.getReportNumAndName(allPreData);
            allPreData.entrySet().stream().forEach(entry -> {
                HRBaseServiceHelper helper = new HRBaseServiceHelper((String)entry.getKey());
                List dynamicObjectList = (List)entry.getValue();
                ArrayList saveDataList = Lists.newArrayListWithExpectedSize((int)10);
                ArrayList updateDataList = Lists.newArrayListWithExpectedSize((int)10);
                ArrayList deleteDataList = Lists.newArrayListWithExpectedSize((int)10);
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)10);
                List existDynamicList = (List)allExistData.get(entry.getKey());
                dynamicObjectList.forEach(dynamicObject -> {
                    boolean[] updateFlag = new boolean[]{false};
                    existDynamicList.forEach(data -> {
                        if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_reportpreindex")) {
                            if (data != null && data.containsProperty("report") && dynamicObject != null && data.getDynamicObject("report") != null && data.getDynamicObject("report").getLong("id") == dynamicObject.getLong("report") && data.getDynamicObject("preindex").getLong("id") == dynamicObject.getLong("preindex")) {
                                updateFlag[0] = true;
                            }
                        } else if (data != null && dynamicObject != null && data.getLong("id") == dynamicObject.getLong("id")) {
                            HRReportDynamicObjectUtils.copy(dynamicObject, data, null, null);
                            updateDataList.add(data);
                            updateFlag[0] = true;
                        }
                    });
                    if (!updateFlag[0]) {
                        if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_commonsort")) {
                            if (!ids.contains(dynamicObject.getLong("id"))) {
                                saveDataList.add(dynamicObject);
                                ids.add(dynamicObject.getLong("id"));
                            }
                        } else {
                            saveDataList.add(dynamicObject);
                        }
                    }
                });
                if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjgroupfield")) {
                    deleteDataList.addAll(existDynamicList.stream().filter(data -> !updateDataList.stream().anyMatch(data1 -> HRStringUtils.equalsIgnoreCase((String)data1.getString("number"), (String)data.getString("number")))).map(data -> data.getLong("id")).collect(Collectors.toSet()));
                } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_calculatefield")) {
                    deleteDataList.addAll(existDynamicList.stream().filter(data -> !updateDataList.stream().anyMatch(data1 -> HRStringUtils.equalsIgnoreCase((String)data1.getString("number"), (String)data.getString("number")))).map(data -> data.getLong("id")).collect(Collectors.toSet()));
                } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjqueryfield")) {
                    deleteDataList.addAll(existDynamicList.stream().filter(data -> !updateDataList.stream().anyMatch(data1 -> HRStringUtils.equalsIgnoreCase((String)data1.getString("fieldalias"), (String)data.getString("fieldalias")))).map(data -> data.getLong("id")).collect(Collectors.toSet()));
                } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjsidebar")) {
                    deleteDataList.addAll(existDynamicList.stream().filter(data -> !updateDataList.stream().anyMatch(data1 -> data1.getLong("id") == data.getLong("id"))).map(data -> data.getLong("id")).collect(Collectors.toSet()));
                } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjpivot")) {
                    deleteDataList.addAll(existDynamicList.stream().filter(data -> !updateDataList.stream().anyMatch(data1 -> data1.getLong("id") == data.getLong("id"))).map(data -> data.getLong("id")).collect(Collectors.toSet()));
                } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_customsort")) {
                    deleteDataList.addAll(existDynamicList.stream().filter(data -> !updateDataList.stream().anyMatch(data1 -> data1.getLong("id") == data.getLong("id"))).map(data -> data.getLong("id")).collect(Collectors.toSet()));
                } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_reportjump")) {
                    deleteDataList.addAll(existDynamicList.stream().filter(data -> !updateDataList.stream().anyMatch(data1 -> data1.getLong("id") == data.getLong("id"))).map(data -> data.getLong("id")).collect(Collectors.toSet()));
                }
                if (deleteDataList.size() > 0) {
                    helper.delete(deleteDataList.toArray());
                }
                this.checkDuplicateRelateData(conf, (String)entry.getKey(), dataList, saveDataList, updateDataList, allPreData);
                if (saveDataList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
                }
                if (updateDataList.size() > 0) {
                    helper.save(updateDataList.toArray(new DynamicObject[0]));
                }
                this.buildDataCount(conf, (String)entry.getKey(), dataList, saveDataList, updateDataList);
                if (HRStringUtils.equalsIgnoreCase((String)conf.getBillFormId(), (String)((String)entry.getKey()))) {
                    this.saveLog(saveDataList, updateDataList);
                }
                if ("hrptmc_paramconfig".equals(entry.getKey())) {
                    this.handleParamConfig((Map.Entry<String, List<DynamicObject>>)entry, reportNumAndName);
                }
            });
            this.deleteCoverData(allPreData, allExistData);
        }
        catch (Exception ex) {
            txHandle.markRollback();
            LOGGER.error("report_import_saveBatch_error: ", (Throwable)ex);
            this.handleSaveFailed();
            throw ex;
        }
        finally {
            if (!this.dataCount.containsKey(conf.getBillFormId())) {
                this.buildDuplicateCount(conf, conf.getBillFormId(), dataList);
            }
            txHandle.close();
        }
    }

    private void deleteCoverData(Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData) {
        allExistData.entrySet().forEach(data -> {
            if (!allPreData.containsKey(data.getKey())) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper((String)data.getKey());
                if (((List)data.getValue()).size() > 0) {
                    helper.delete(((List)data.getValue()).stream().map(data1 -> data1.getLong("id")).toArray());
                }
            }
        });
    }

    private boolean checkDuplicateRelateData(ImportContext conf, String entryNumber, List<HRImpDuplicateData> dataList, List<DynamicObject> saveDataList, List<DynamicObject> updateDataList, Map<String, List<DynamicObject>> allPreData) {
        String importType = (String)conf.getOption().get("importtype");
        if (HREXPImpEnum.getSheetByNumber((String)entryNumber) != null && !HRStringUtils.equalsIgnoreCase((String)conf.getBillFormId(), (String)entryNumber) && dataList.size() > 0 && HRStringUtils.equalsIgnoreCase((String)"1", (String)importType)) {
            List<DynamicObject> reportManageList;
            int sourceCount = updateDataList.size();
            if (HRStringUtils.equalsIgnoreCase((String)entryNumber, (String)HREXPImpEnum.ANALYSEOBJECT.getNumber())) {
                reportManageList = allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber());
                boolean flag = updateDataList.removeIf(data -> CollectionUtils.isEmpty((Collection)reportManageList) || !reportManageList.stream().anyMatch(data1 -> data1.getLong("anobjid") == data.getLong("id")));
                if (!flag) {
                    List<DynamicObject> preIndexList = allPreData.get(HREXPImpEnum.PREINDEX.getNumber());
                    updateDataList.removeIf(data -> CollectionUtils.isEmpty((Collection)preIndexList) || !preIndexList.stream().anyMatch(data1 -> data1.getLong("anobj") == data.getLong("id")));
                }
            } else if (HRStringUtils.equalsIgnoreCase((String)entryNumber, (String)HREXPImpEnum.PREINDEX.getNumber())) {
                reportManageList = allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber());
                List<DynamicObject> preIndexList = allPreData.get("hrptmc_reportpreindex");
                updateDataList.removeIf(data -> CollectionUtils.isEmpty((Collection)reportManageList) || !reportManageList.stream().anyMatch(data1 -> data1.getLong("id") == (CollectionUtils.isEmpty((Collection)preIndexList) ? null : preIndexList.stream().map(data2 -> {
                    if (data.getLong("id") == data2.getLong("preindex")) {
                        return data2.getLong("report");
                    }
                    return null;
                }).findAny().get()).longValue()));
            } else if (HRStringUtils.equalsIgnoreCase((String)entryNumber, (String)HREXPImpEnum.BUSISERVICE.getNumber())) {
                List<DynamicObject> preIndexList = allPreData.get(HREXPImpEnum.PREINDEX.getNumber());
                updateDataList.removeIf(data -> CollectionUtils.isEmpty((Collection)preIndexList) || !preIndexList.stream().anyMatch(data1 -> data1.getLong("service") == data.getLong("id")));
            }
            if (sourceCount != updateDataList.size()) {
                ReportImportDetailVo vo = new ReportImportDetailVo();
                vo.setEntryNumber(entryNumber);
                vo.setInsertSucceed(saveDataList.size());
                vo.setUpdateSucceed(updateDataList.size());
                vo.setFailed(sourceCount - updateDataList.size());
                vo.setErrMsg(ResManager.loadKDString((String)"\u91cd\u590d\u6570\u636e\u5ffd\u7565", (String)"HReportImportPlugin_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                vo.setTotal(vo.getFailed() + vo.getInsertSucceed() + vo.getUpdateSucceed());
                this.dataCount.put(entryNumber, vo);
            }
        }
        return false;
    }

    private void buildDuplicateCount(ImportContext conf, String entryNumber, List<HRImpDuplicateData> dataList) {
        if (HREXPImpEnum.getSheetByNumber((String)entryNumber) != null) {
            ReportImportDetailVo vo = new ReportImportDetailVo();
            vo.setEntryNumber(entryNumber);
            String importType = (String)conf.getOption().get("importtype");
            if (HRStringUtils.equalsIgnoreCase((String)conf.getBillFormId(), (String)entryNumber) && dataList.size() > 0 && HRStringUtils.equalsIgnoreCase((String)"1", (String)importType)) {
                vo.setFailed(dataList.size());
                vo.setErrMsg(ResManager.loadKDString((String)"\u91cd\u590d\u6570\u636e\u5ffd\u7565", (String)"HReportImportPlugin_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
            vo.setTotal(vo.getFailed());
            this.dataCount.put(entryNumber, vo);
        }
    }

    private void buildDataCount(ImportContext conf, String entryNumber, List<HRImpDuplicateData> dataList, List<DynamicObject> saveDataList, List<DynamicObject> updateDataList) {
        if (HREXPImpEnum.getSheetByNumber((String)entryNumber) != null && !this.dataCount.containsKey(entryNumber)) {
            ReportImportDetailVo vo = new ReportImportDetailVo();
            vo.setEntryNumber(entryNumber);
            vo.setInsertSucceed(saveDataList.size());
            vo.setUpdateSucceed(updateDataList.size());
            String importType = (String)conf.getOption().get("importtype");
            if (HRStringUtils.equalsIgnoreCase((String)conf.getBillFormId(), (String)entryNumber) && dataList.size() > 0 && HRStringUtils.equalsIgnoreCase((String)"1", (String)importType)) {
                vo.setFailed(dataList.size());
                vo.setErrMsg(ResManager.loadKDString((String)"\u91cd\u590d\u6570\u636e\u5ffd\u7565", (String)"HReportImportPlugin_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
            vo.setTotal(vo.getFailed() + vo.getInsertSucceed() + vo.getUpdateSucceed());
            this.dataCount.put(entryNumber, vo);
        }
    }

    private String getSuspendKey(ImportContext conf) {
        IAppCache appCache = AppCache.get((String)"HRPTMC");
        String key = "IMPT_SUSPEND_" + conf.getBillFormId() + "_" + conf.getLogId();
        return (String)appCache.get(key, String.class);
    }

    private void drainData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ, int timeout, Map<String, List<DynamicObject>> allPreData, Set<Object> allCorrectDataSet, int batchId, List<HRImpDuplicateData> dataList) throws Exception {
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 5 || HRStringUtils.isNotEmpty((String)this.getSuspendKey(conf)))) {
            ArrayList<ImportBillData> rowDatas = new ArrayList<ImportBillData>();
            int lastLeftCount = rowDatas.size();
            int needCount = 500 - lastLeftCount;
            if (rowDatas.isEmpty() && needCount > 0) {
                ImportBillData rowdata = dataQ.poll(10L, TimeUnit.SECONDS);
                if (rowdata == null || rowdata.isEmpty()) {
                    if (rowDatas.isEmpty()) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info(conf.getBillFormId() + "...read...null");
                        }
                        ++timeout;
                        continue;
                    }
                } else {
                    rowDatas.add(rowdata);
                    dataQ.drainTo(rowDatas, needCount);
                    rowDatas.removeIf(ImportBillData::isEmpty);
                }
            }
            timeout = 0;
            if (rowDatas.size() > 0) {
                this.importBatchData(conf.getBillFormId(), rowDatas, conf.getOption(), allPreData, allCorrectDataSet, batchId, dataList);
                ++batchId;
            }
            rowDatas.clear();
        }
    }

    @NotNull
    private List<HRImpDuplicateData> parseDuplicateData(ImportContext conf) {
        List<Object> dataList = Lists.newArrayListWithExpectedSize((int)10);
        if (conf.getOption().containsKey("duplicateDataSet")) {
            JSONArray duplicateDataSet = (JSONArray)conf.getOption().get("duplicateDataSet");
            dataList = duplicateDataSet.stream().map(obj -> (HRImpDuplicateData)SerializationUtils.fromJsonString((String)((JSON)obj).toJSONString(), HRImpDuplicateData.class)).collect(Collectors.toList());
        }
        return dataList;
    }

    private void importBatchData(String billFormId, List<ImportBillData> rowdatas, Map<String, Object> option, Map<String, List<DynamicObject>> allPreData, Set<Object> allCorrectDataSet, int batchId, List<HRImpDuplicateData> dataList) throws Exception {
        if (rowdatas.get(0).getData().containsKey((Object)"errCode")) {
            throw new Exception((String)rowdatas.get(0).getData().get((Object)"errCode"));
        }
        String importType = (String)option.get("importtype");
        for (ImportBillData billData : rowdatas) {
            JSONObject rowJson = billData.getData();
            int rowNum = rowJson.getIntValue("rownum");
            String sheetNum = rowJson.getString("sheetNum");
            JSONObject rowData = rowJson.getJSONObject("data");
            String dataNumber = rowData.getString("number");
            ImportLogger importLogger = this.importLoggerMap.get(sheetNum);
            HREXPImpEnum impEnum = HREXPImpEnum.getByNumber((String)sheetNum);
            if (HRStringUtils.equalsIgnoreCase((String)sheetNum, (String)billFormId) && this.checkDuplicateImport(importType, dataList, rowNum, dataNumber, importLogger, allCorrectDataSet)) continue;
            switch (Objects.requireNonNull(impEnum)) {
                case ANALYSEOBJECT: {
                    this.analyseService.build(rowNum, impEnum, rowData, importLogger, allPreData, (Long)this.ctx.getLogId());
                    break;
                }
                case BUSISERVICE: {
                    this.busImportService.build(rowNum, impEnum, rowData, importLogger, allPreData, (Long)this.ctx.getLogId());
                    break;
                }
                case PREINDEX: {
                    this.indexImportService.build(rowNum, impEnum, rowData, importLogger, allPreData, (Long)this.ctx.getLogId());
                    break;
                }
                case REPORTMANAGE: {
                    this.manageImportService.build(rowNum, impEnum, rowData, importLogger, allPreData, (Long)this.ctx.getLogId());
                    break;
                }
                case QUERYFIELD: {
                    this.queryFieldImportService.build(rowNum, impEnum, rowData, importLogger, allPreData, (Long)this.ctx.getLogId());
                    break;
                }
                case CUSTOMSORT: {
                    this.customSortImportService.build(rowNum, impEnum, rowData, importLogger, allPreData, (Long)this.ctx.getLogId());
                    break;
                }
                case WORKREPORT: {
                    this.workSheetImportService.build(rowNum, impEnum, rowData, importLogger, allPreData, (Long)this.ctx.getLogId());
                    break;
                }
            }
        }
        if (this.isFailed(allCorrectDataSet)) {
            return;
        }
    }

    private boolean checkDuplicateImport(String importType, List<HRImpDuplicateData> dataList, int rowNum, String dataNumber, ImportLogger importLogger, Set<Object> allCorrectDataSet) {
        if (dataList.size() > 0 && HRStringUtils.equalsIgnoreCase((String)"1", (String)importType) && dataList.stream().anyMatch(data -> HRStringUtils.equalsIgnoreCase((String)data.getDistNumber(), (String)dataNumber))) {
            String msg = String.format(ResManager.loadKDString((String)"\u5ffd\u7565\u5bfc\u5165:%s\u3002", (String)"HReportImportPlugin_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), dataNumber);
            importLogger.log(Integer.valueOf(rowNum), msg);
            allCorrectDataSet.add(rowNum);
            return true;
        }
        return false;
    }

    public static void feedbackProgressDealWith(ImportContext conf, Map<String, ImportLogger> importLoggerMap) {
        if (importLoggerMap == null || importLoggerMap.size() == 0) {
            return;
        }
        int failNum = 0;
        int total = 0;
        int done = 0;
        for (Map.Entry<String, ImportLogger> loggerEntry : importLoggerMap.entrySet()) {
            ImportLogger logger = loggerEntry.getValue();
            failNum += logger.getLogCache().size();
            total += logger.getTotal();
            done += logger.getDelRows().size() + logger.getLogCache().size();
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info(String.format(Locale.ROOT, "----import %s --batch", logger.getSrcFile()));
        }
        int result = 0;
        if (total != 0) {
            result = Math.round((float)done * 1.0f / (float)total * 100.0f);
        }
        conf.feedbackProgress(result == 100 ? 99 : result, total, failNum);
        LOGGER.info(String.format(Locale.ROOT, "--batch--succeed=%d--failed=%d", total - failNum, total));
    }

    private void outputFailedData(String url, ImportLogger importLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new HReportImportFailedSheetHandler(this.ctx, importLogger, service, this.importLoggerMap));
        }
        catch (Exception e) {
            importLogger.log(Integer.valueOf(0), (Throwable)e);
        }
    }

    private boolean isFailed(Set<Object> allCorrectDataSet) {
        boolean isFailed = false;
        for (Map.Entry<String, ImportLogger> entry : this.importLoggerMap.entrySet()) {
            ImportLogger logger = entry.getValue();
            if (logger.getLogCache().size() <= 0 || logger.getLogCache().size() <= allCorrectDataSet.size()) continue;
            isFailed = true;
            break;
        }
        return isFailed;
    }

    private void handleFailed() {
        this.importLoggerMap.forEach((key, importLogger) -> {
            Map logCache = importLogger.getLogCache();
            for (int i = 2; i < importLogger.getTotal() + 2; ++i) {
                if (logCache.get(i) != null && !((List)logCache.get(i)).isEmpty()) continue;
                importLogger.log(Integer.valueOf(i), ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38", (String)"HReportImportPlugin_7", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
        });
    }

    private void handleSaveFailed() {
        this.importLoggerMap.forEach((key, importLogger) -> {
            Map logCache = importLogger.getLogCache();
            for (int i = 2; i < importLogger.getTotal() + 2; ++i) {
                if (logCache.get(i) != null && !((List)logCache.get(i)).isEmpty()) continue;
                importLogger.log(Integer.valueOf(i), ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5f02\u5e38", (String)"HReportImportPlugin_6", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
        });
    }

    private void handleSchedule(DynamicObject[] dyn) {
        ReportParConfSchService service = new ReportParConfSchService();
        service.handleSchedule(dyn);
    }

    private Map<Long, Map<String, String>> getReportNumAndName(Map<String, List<DynamicObject>> allPreData) {
        HashMap reportNumAndName;
        List<DynamicObject> reportManageList = allPreData.get("hrptmc_reportmanage");
        if (!CollectionUtils.isEmpty(reportManageList)) {
            reportNumAndName = Maps.newHashMapWithExpectedSize((int)reportManageList.size());
            for (DynamicObject dynamicObject : reportManageList) {
                HashMap numAndName = Maps.newHashMapWithExpectedSize((int)2);
                String number = dynamicObject.getString("number");
                String name = dynamicObject.getString("name");
                numAndName.put("number", number);
                numAndName.put("name", name);
                reportNumAndName.put(dynamicObject.getLong("id"), numAndName);
            }
        } else {
            reportNumAndName = Maps.newHashMap();
        }
        return reportNumAndName;
    }

    private void handleParamConfig(Map.Entry<String, List<DynamicObject>> entry, Map<Long, Map<String, String>> reportNumAndName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hrptmc_reportmanage");
        for (DynamicObject dynamicObject : entry.getValue()) {
            long rptId = dynamicObject.getLong("report");
            Map<String, String> numAndNameMap = reportNumAndName.get(rptId);
            if (numAndNameMap == null) continue;
            DynamicObject rpt = (DynamicObject)type.createInstance();
            rpt.set("id", (Object)rptId);
            rpt.set("number", (Object)numAndNameMap.get("number"));
            rpt.set("name", (Object)numAndNameMap.get("name"));
            dynamicObject.set("report", (Object)rpt);
        }
        this.handleSchedule(entry.getValue().toArray(new DynamicObject[0]));
    }
}

