/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.orm.util.CollectionUtils;

public class HReportImportSheetHandler
extends SheetHandler {
    private final ImportContext conf;
    private final String url;
    private final LinkedBlockingQueue<ImportBillData> dataQueue;
    private int lastStartRowNum = 0;
    private final ImportLogger importLogger;
    private SheetHandler.ParsedRow currentRow;
    private final Map<String, ImportLogger> importLoggerMap;
    public Map<String, Map<Integer, String>> sheetHeadEntityMap = Maps.newHashMapWithExpectedSize((int)16);

    public HReportImportSheetHandler(ImportContext conf, String path, Map<String, ImportLogger> importLoggerMap) {
        this.conf = conf;
        this.url = path;
        this.dataQueue = this.conf.getDataQueue(this.url);
        this.importLogger = this.conf.getLogger(this.url);
        this.importLoggerMap = importLoggerMap;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        this.importLogger.setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.parseSheetHead(row);
            this.initImportLoggerMap(row);
        } else if (currRowNum > 1) {
            JSONObject rowEntity = new JSONObject();
            if (!this.hasErrorLine(row)) {
                JSONObject rowObj = new JSONObject();
                this.parseRowData(row, rowEntity);
                rowObj.put("data", (Object)rowEntity);
                rowObj.put("rownum", (Object)currRowNum);
                String sheetName = this.getSheetName();
                rowObj.put("sheetNum", (Object)sheetName.substring(sheetName.indexOf(35) + 1).trim());
                this.addBillData(new ImportBillData(rowObj, currRowNum, currRowNum + 1));
            }
        }
    }

    private void initImportLoggerMap(SheetHandler.ParsedRow row) {
        String sheetName = row.getSheetName();
        String entityNum = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        this.importLoggerMap.put(entityNum, new ImportLogger());
    }

    private void parseSheetHead(SheetHandler.ParsedRow row) {
        String sheetName = row.getSheetName();
        String entityNum = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        this.sheetHeadEntityMap.put(entityNum, row.getData());
    }

    private void parseRowData(SheetHandler.ParsedRow row, JSONObject rowEntity) {
        String sheetName = row.getSheetName();
        String entityNum = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        this.handleRowDataForJson(row, rowEntity, this.sheetHeadEntityMap.get(entityNum));
    }

    private void handleRowDataForJson(SheetHandler.ParsedRow row, JSONObject rowEntity, Map<Integer, String> headMap) {
        for (Map.Entry<Integer, String> headEntry : headMap.entrySet()) {
            Integer idx = headEntry.getKey();
            String num = headEntry.getValue();
            if (num.contains(".")) {
                String multiKey = num.substring(0, num.indexOf(46));
                JSONArray multiLans = (JSONArray)rowEntity.getOrDefault((Object)multiKey, (Object)new JSONArray());
                JSONObject lanObj = new JSONObject();
                lanObj.put("lan", (Object)num.substring(num.indexOf(46) + 1));
                lanObj.put("value", row.getData().get(idx));
                multiLans.add((Object)lanObj);
                rowEntity.put(multiKey, (Object)multiLans);
                continue;
            }
            rowEntity.put(num, row.getData().get(idx));
        }
    }

    public void endDocument() {
        this.setInterrupt(false);
        Set sheetNames = this.getSheetNames();
        String sheetName = this.getSheetName();
        sheetNames.remove(sheetName);
        String entityName = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        ImportLogger importLogger = this.importLoggerMap.get(entityName);
        importLogger.setTotal(Math.max(this.currentRow.getRowNum() - 1, 0));
        if (sheetNames.size() == 0) {
            this.setInterrupt(true);
            int currRowNum = this.currentRow.getRowNum();
            this.conf.setResolveComplete(this.url);
            if (this.lastStartRowNum == 0 || currRowNum - this.lastStartRowNum >= 500) {
                this.conf.feedbackProgress(0, this.conf.getLogger(this.url), null);
            }
        }
    }

    private boolean hasErrorLine(SheetHandler.ParsedRow row) {
        Set errorExcelLineSet = this.importLogger.getLogCache().keySet();
        return !CollectionUtils.isEmpty(errorExcelLineSet) && errorExcelLineSet.contains(row.getRowNum());
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"HReportImportSheetHandler_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"HReportImportSheetHandler_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 500) {
            this.conf.feedbackProgress(0, this.conf.getLogger(this.url), null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }
}

