/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp.pre;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exp.HReportConfExpEntityConfHolder;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;
import kd.hr.hrptmc.common.constant.expimp.HRExpImpConstants;
import kd.hr.hrptmc.common.util.HRImpDuplicateData;

public class HReportPreImportSheetHandler
extends SheetHandler {
    private final ImportContext conf;
    private final String url;
    private SheetHandler.ParsedRow currentRow;
    private final ImportLogger importLogger;
    private Map<String, ImportLogger> importLoggerMap;
    public Map<String, Map<Integer, String>> sheetHeadEntityMap = Maps.newHashMapWithExpectedSize((int)16);
    private int nameHeadIndex = 0;
    private List<HRImpDuplicateData> originNumberList;

    public HReportPreImportSheetHandler(ImportContext conf, String path, Map<String, ImportLogger> importLoggerMap, List<HRImpDuplicateData> originNumberList) {
        this.conf = conf;
        this.url = path;
        this.importLoggerMap = importLoggerMap;
        this.originNumberList = originNumberList;
        this.importLogger = this.conf.getLogger(this.url);
        this.importLoggerMap = importLoggerMap;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        this.importLogger.setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.parseSheetHead(row);
            this.initImportLoggerMap(row);
            this.checkSheetHead(row);
        } else if (currRowNum > 1) {
            this.parseRowData(row);
        }
    }

    private void checkSheetHead(SheetHandler.ParsedRow row) {
        String msg = null;
        String sheetName = row.getSheetName();
        String entityNum = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        Map headMap = row.getData();
        if (headMap.get(0) == null || !HRStringUtils.equalsIgnoreCase((String)((String)HRExpImpConstants.sheet_hrptmc_analyseobject_head.get(0)), (String)((String)headMap.get(0)))) {
            throw new KDBizException(ResManager.loadKDString((String)"Excel\u5185\u5bb9\u4e0d\u5408\u6cd5\u3002", (String)"HReportPreImportSheetHandler_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        msg = this.checkHeadKey(HReportConfExpEntityConfHolder.getExpSheetHead(HREXPImpEnum.getByNumber((String)entityNum)), headMap);
        if (HRStringUtils.isNotEmpty((String)msg)) {
            this.importLoggerMap.get(entityNum).log(Integer.valueOf(row.getRowNum()), msg);
            return;
        }
    }

    private String checkHeadKey(List<String> headKeys, Map<Integer, String> headMap) {
        AtomicReference msg = new AtomicReference();
        headKeys.stream().forEach(head -> {
            AtomicBoolean flag = new AtomicBoolean(false);
            flag.set(headMap.entrySet().stream().anyMatch(data -> {
                String headStr;
                if (HRStringUtils.equalsIgnoreCase((String)head, (String)((String)data.getValue()).trim())) {
                    return true;
                }
                return HRStringUtils.isNotEmpty((String)((String)data.getValue())) && ((String)data.getValue()).contains(".") && HRStringUtils.equalsIgnoreCase((String)head, (String)(headStr = ((String)data.getValue()).trim().substring(0, ((String)data.getValue()).indexOf(46))));
            }));
            if (!flag.get()) {
                msg.set(String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u5b57\u6bb5\uff1a\u201c%s\u201d\u3002", (String)"HReportPreImportSheetHandler_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), head));
                return;
            }
        });
        headMap.entrySet().stream().forEach(data -> {
            if (HRStringUtils.equalsIgnoreCase((String)"name.zh_CN", (String)((String)data.getValue()))) {
                this.nameHeadIndex = (Integer)data.getKey();
                return;
            }
        });
        return (String)msg.get();
    }

    private void initImportLoggerMap(SheetHandler.ParsedRow row) {
        String sheetName = row.getSheetName();
        String entityNum = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        this.importLoggerMap.put(entityNum, new ImportLogger());
    }

    private void parseSheetHead(SheetHandler.ParsedRow row) {
        String sheetName = row.getSheetName();
        String entityNum = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        if (HRStringUtils.isEmpty((String)entityNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"Sheet\u540d\u79f0\u4e0d\u5408\u6cd5\u3002", (String)"HReportPreImportSheetHandler_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        this.sheetHeadEntityMap.put(entityNum, row.getData());
    }

    private void parseRowData(SheetHandler.ParsedRow row) {
        String sheetName = row.getSheetName();
        String msg = null;
        String entityNum = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        HRImpDuplicateData data = new HRImpDuplicateData();
        String dataId = row.get(Integer.valueOf(0));
        String dataNumber = row.get(Integer.valueOf(1));
        String dataName = row.get(Integer.valueOf(this.nameHeadIndex));
        if (HRStringUtils.isEmpty((String)dataId)) {
            msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5185\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5f97\u5bfc\u5165", (String)"HReportPreImportSheetHandler_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), dataNumber);
        }
        if (HRStringUtils.isEmpty((String)dataNumber)) {
            msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5f97\u5bfc\u5165", (String)"HReportPreImportSheetHandler_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), dataNumber);
        }
        if (HRStringUtils.isEmpty((String)dataName)) {
            msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u540d\u79f0\u4e3a\u7a7a\uff0c\u4e0d\u5f97\u5bfc\u5165", (String)"HReportPreImportSheetHandler_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), dataNumber);
        }
        if (HRStringUtils.isNotEmpty(msg)) {
            this.importLoggerMap.get(entityNum).log(Integer.valueOf(row.getRowNum()), msg);
            return;
        }
        if (HRStringUtils.equalsIgnoreCase((String)entityNum, (String)this.conf.getBillFormId())) {
            data.setId(dataId);
            data.setNumber(dataNumber);
            data.setName(dataName);
            this.originNumberList.add(data);
        }
    }

    public void endDocument() {
        this.setInterrupt(false);
        Set sheetNames = this.getSheetNames();
        String sheetName = this.getSheetName();
        sheetNames.remove(sheetName);
        String entityName = sheetName.substring(sheetName.indexOf(35) + 1).trim();
        ImportLogger importLogger = this.importLoggerMap.get(entityName);
        if (importLogger == null || this.currentRow == null) {
            this.setInterrupt(true);
        } else {
            importLogger.setTotal(Math.max(this.currentRow.getRowNum() - 1, 0));
            if (sheetNames.size() == 0) {
                this.setInterrupt(true);
            }
        }
    }
}

