/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exp.HReportConfExpEntityConfHolder;
import kd.hr.hrptmc.business.imp.HReportImportUtil;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;
import kd.hr.hrptmc.common.util.GzipCompress;

public abstract class AbstractImportService {
    private static final Log LOG = LogFactory.getLog(AbstractImportService.class);
    protected HRBaseServiceHelper helper;
    protected Long logId;

    public void save(DynamicObject[] dobjs) {
        this.helper.save(dobjs);
    }

    public void build(int rowNum, HREXPImpEnum impEnum, JSONObject rowData, ImportLogger importLogger, Map<String, List<DynamicObject>> allPreData, Long logId) {
        this.logId = logId;
        List<Object> objectList = Lists.newArrayListWithCapacity((int)10);
        if (allPreData.containsKey(impEnum.getNumber())) {
            objectList = allPreData.get(impEnum.getNumber());
        }
        DynamicObject dynamicObject = this.helper.generateEmptyDynamicObject();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)impEnum.getNumber());
        rowData.keySet().stream().forEach(key -> {
            boolean subEntityFlag = true;
            for (IDataEntityProperty prop : mainEntityType.getProperties()) {
                if (!HRStringUtils.equalsIgnoreCase((String)key, (String)prop.getName())) continue;
                HReportImportUtil.initDynamicObjValues(rowNum, dynamicObject, prop, importLogger, rowData, false);
                subEntityFlag = false;
            }
            this.buildSubEntity(rowNum, rowData, importLogger, allPreData, (String)key, subEntityFlag);
        });
        HRBaseUtils.setSysField((DynamicObject)dynamicObject);
        objectList.add(dynamicObject);
        allPreData.put(impEnum.getNumber(), objectList);
    }

    protected void buildSubEntity(int rowNum, JSONObject rowData, ImportLogger importLogger, Map<String, List<DynamicObject>> allPreData, String key, boolean subEntityFlag) {
        String gzipCompressedStr;
        String json;
        if (subEntityFlag && rowData.containsKey((Object)key) && !HRStringUtils.equalsIgnoreCase((String)"[]", (String)(json = GzipCompress.decompressFromString((String)(gzipCompressedStr = rowData.getString(key))))) && !HRStringUtils.equalsIgnoreCase((String)"{}", (String)json)) {
            Map<String, Set<String>> jsonEntityKey = HReportConfExpEntityConfHolder.getJsonEntityKey(HREXPImpEnum.REPORTMANAGE);
            ArrayList objectList = allPreData.get(key);
            if (objectList == null) {
                objectList = Lists.newArrayListWithCapacity((int)10);
            }
            ArrayList finalObjectList = objectList;
            JSONArray jSONArray = this.getJSONArray(json);
            if (jSONArray != null) {
                this.buildSubJsonArr(rowNum, importLogger, allPreData, key, jsonEntityKey, finalObjectList, jSONArray);
                allPreData.put(key, finalObjectList);
                return;
            }
            JSONObject jsonObject = this.getJSONObject(json);
            if (jsonObject != null) {
                this.parseJsonObject(rowNum, importLogger, key, finalObjectList, jsonObject);
                allPreData.put(key, finalObjectList);
                this.buildSubEntity(rowNum, importLogger, allPreData, key, jsonEntityKey, jsonObject);
                return;
            }
        }
    }

    private void buildSubJsonArr(int rowNum, ImportLogger importLogger, Map<String, List<DynamicObject>> allPreData, String key, Map<String, Set<String>> jsonEntityKey, List<DynamicObject> finalObjectList, JSONArray jSONArray) {
        if (jSONArray == null) {
            return;
        }
        jSONArray.stream().forEach(jsonObject -> {
            if (jsonObject instanceof JSONArray) {
                JSONArray jSONArraySub = (JSONArray)jsonObject;
                this.buildSubJsonArr(rowNum, importLogger, allPreData, key, jsonEntityKey, finalObjectList, jSONArraySub);
            } else if (jsonObject instanceof JSONObject) {
                this.parseJsonObject(rowNum, importLogger, key, finalObjectList, (JSONObject)jsonObject);
                this.buildSubEntity(rowNum, importLogger, allPreData, key, jsonEntityKey, (JSONObject)jsonObject);
            }
        });
    }

    private void buildSubEntity(int rowNum, ImportLogger importLogger, Map<String, List<DynamicObject>> allPreData, String key, Map<String, Set<String>> jsonEntityKey, JSONObject jsonObject) {
        if (!jsonEntityKey.containsKey(key)) {
            return;
        }
        Set<String> entityKey = jsonEntityKey.get(key);
        entityKey.forEach(data -> {
            JSONArray jSONArray;
            String entityJson = jsonObject.getString(data);
            List objectList1 = (List)allPreData.get(data);
            if (objectList1 == null) {
                objectList1 = Lists.newArrayListWithCapacity((int)10);
            }
            if ((jSONArray = this.getJSONArray(entityJson)) != null) {
                List finalObjectList = objectList1;
                jSONArray.stream().forEach(jsonObject2 -> this.parseJsonObject(rowNum, importLogger, (String)data, finalObjectList, (JSONObject)jsonObject2));
                allPreData.put((String)data, objectList1);
                return;
            }
            JSONObject jsonObject22 = this.getJSONObject(entityJson);
            if (jsonObject22 != null) {
                this.parseJsonObject(rowNum, importLogger, (String)data, objectList1, jsonObject22);
                allPreData.put((String)data, objectList1);
                return;
            }
        });
    }

    private JSONArray getJSONArray(String json) {
        JSONArray jSONArray = null;
        try {
            jSONArray = JSONArray.parseArray((String)json);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        return jSONArray;
    }

    private JSONObject getJSONObject(String json) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)json);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        return jsonObject;
    }

    private void parseJsonObject(int rowNum, ImportLogger importLogger, String key, List<DynamicObject> finalObjectList, JSONObject object) {
        MainEntityType subEntityType = EntityMetadataCache.getDataEntityType((String)key);
        DynamicObject dataEntity = (DynamicObject)subEntityType.createInstance();
        for (IDataEntityProperty prop : subEntityType.getProperties()) {
            if (!object.containsKey((Object)prop.getName())) continue;
            HReportImportUtil.initDynamicObjValues(rowNum, dataEntity, prop, importLogger, object, false);
        }
        if (dataEntity.containsProperty("creator") && dataEntity.containsProperty("modifier")) {
            HRBaseUtils.setSysField((DynamicObject)dataEntity);
        }
        finalObjectList.add(dataEntity);
    }
}

