/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprList;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.Operator;
import kd.bos.formula.excel.Paren;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.function.service.AbstractFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.imp.model.BaseDataFromFunctionEnum;
import kd.hr.hrptmc.business.imp.model.ReportImportBaseDataBo;
import kd.hr.hrptmc.business.repdesign.enums.ParamTypeEnum;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleMapInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleRuleInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;

public class ReportImportBaseDataIdService
implements AnalyseObjectConstants {
    private final Map<String, String> fieldBaseDataMap = Maps.newHashMapWithExpectedSize((int)16);
    private final MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
    private final Set<Character> specialChar = Stream.of(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('$')).collect(Collectors.toSet());
    private final Set<String> specialStr = Stream.of("true", "false", "and", "or", "null", "NULL").collect(Collectors.toSet());
    private static final Pattern numberPattern = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");
    private final Map<String, Set<ReportImportBaseDataBo>> noMatchedBaseDataBoMap = Maps.newHashMapWithExpectedSize((int)16);
    private DynamicObject anObjDy;
    private List<DynamicObject> queryFields;
    private boolean correctData = false;
    private static final String BOS_ORG = "bos_org";

    public ReportImportBaseDataIdService(DynamicObject anObjDy, List<DynamicObject> queryFields) {
        this.anObjDy = anObjDy;
        this.queryFields = queryFields;
    }

    public Set<ReportImportBaseDataBo> parseAnalyseObject(List<DynamicObject> joinEntityList, List<DynamicObject> joinEntityRelations, List<DynamicObject> anObjCalFields, List<DynamicObject> anObjPivots, List<DynamicObject> anObjGroupFields) {
        this.parseAnObjJoinCondition(joinEntityList, joinEntityRelations);
        this.parseAnObjDataFilter(this.anObjDy, this.queryFields);
        this.parseAnObjPivot(anObjPivots, this.queryFields);
        this.parseAnObjGroupField(this.queryFields, anObjGroupFields);
        this.parseAnObjCalculateField(anObjCalFields, this.queryFields);
        return this.noMatchedBaseDataBoMap.values().stream().flatMap(Collection::stream).filter(baseDataBo -> baseDataBo.getNameMatched() == false || baseDataBo.getNumberMatched() == false).collect(Collectors.toSet());
    }

    public Set<ReportImportBaseDataBo> parseReport(DynamicObject reportDy, List<DynamicObject> reportCalFields, List<DynamicObject> filterDyList, List<DynamicObject> reportJumpDys, List<DynamicObject> customSortDyList) {
        this.parseReportCreateOrg(reportDy);
        this.parseReportDataFilter(reportDy, this.queryFields);
        this.parseReportCalculateField(reportCalFields, this.queryFields);
        this.parseReportFilter(filterDyList, this.queryFields);
        this.parseReportJumpConfig(reportJumpDys, this.queryFields);
        this.parseReportConditionFormat(reportDy);
        this.parseReportCustomSort(customSortDyList);
        return this.noMatchedBaseDataBoMap.values().stream().flatMap(Collection::stream).filter(baseDataBo -> baseDataBo.getNameMatched() == false || baseDataBo.getNumberMatched() == false).collect(Collectors.toSet());
    }

    public void resetAnObjAndQueryFields(DynamicObject anObjDy, List<DynamicObject> queryFields) {
        this.anObjDy = anObjDy;
        this.queryFields = queryFields;
    }

    public void parseReportCreateOrg(DynamicObject reportDy) {
        DynamicObject createOrg = reportDy.getDynamicObject("createorg");
        if (createOrg == null || createOrg.getLong("id") != 0L) {
            return;
        }
        Set<Object> baseDataBos = Sets.newHashSetWithExpectedSize((int)16);
        if (!this.isCorrectData()) {
            String name = createOrg.getString("name");
            String string = createOrg.getString("number");
            ReportImportBaseDataBo baseDataBo = new ReportImportBaseDataBo(BOS_ORG, string, name, BaseDataFromFunctionEnum.RPT_CREATE_ORG);
            baseDataBos.add(baseDataBo);
            Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.getOrDefault(BOS_ORG, Sets.newHashSetWithExpectedSize((int)16));
            allBaseDataBos.addAll(baseDataBos);
            this.noMatchedBaseDataBoMap.putIfAbsent(BOS_ORG, allBaseDataBos);
            this.setBaseDataBoValue(BOS_ORG, baseDataBos);
        } else {
            baseDataBos = this.noMatchedBaseDataBoMap.getOrDefault(BOS_ORG, Sets.newHashSetWithExpectedSize((int)16));
        }
        for (ReportImportBaseDataBo reportImportBaseDataBo : baseDataBos) {
            if (reportImportBaseDataBo.getCurrentId() == null || !reportImportBaseDataBo.getNumberMatched().booleanValue() || !reportImportBaseDataBo.getNameMatched().booleanValue()) continue;
            createOrg.set("id", reportImportBaseDataBo.getCurrentId());
        }
    }

    public void parseAnObjJoinCondition(List<DynamicObject> joinEntityList, List<DynamicObject> joinEntityRelations) {
        Map<Long, DynamicObject> joinEntityMap = joinEntityList.stream().collect(Collectors.toMap(entity -> entity.getLong("id"), Function.identity()));
        this.parseJoinConditionBaseDataId(joinEntityRelations, joinEntityMap, false);
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        this.parseJoinConditionBaseDataId(joinEntityRelations, joinEntityMap, true);
    }

    private void parseJoinConditionBaseDataId(List<DynamicObject> joinEntityRelations, Map<Long, DynamicObject> joinEntityMap, boolean replaceId) {
        if (CollectionUtils.isEmpty(joinEntityRelations)) {
            return;
        }
        for (DynamicObject relationDy : joinEntityRelations) {
            DynamicObjectCollection conditions = relationDy.getDynamicObjectCollection("joinconditions");
            long entityId = relationDy.getLong("entityid");
            String entityNumber = joinEntityMap.get(entityId).getString("entitynumber");
            long joinEntityId = relationDy.getLong("joinentityid");
            String joinEntityNumber = joinEntityMap.get(joinEntityId).getString("entitynumber");
            for (DynamicObject condition : conditions) {
                boolean keyIsStringType;
                String entityNum;
                String fieldAlias = condition.getString("leftprop");
                String rightType = condition.getString("rightproptype");
                if (!fieldAlias.endsWith(".id") || !HRStringUtils.equals((String)rightType, (String)"value")) continue;
                String rightValue = condition.getString("rightpropval");
                String fieldEntityNum = fieldAlias.contains(".") ? (HRStringUtils.equals((String)(entityNum = fieldAlias.split("\\.")[0]), (String)joinEntityNumber) ? joinEntityNumber : entityNumber) : entityNumber;
                String baseDataNum = this.getBaseDataNum(fieldEntityNum, fieldAlias);
                boolean bl = keyIsStringType = this.entityTypeUtil.getMainEntityType(baseDataNum).getPrimaryKey().getPropertyType() == String.class;
                if (replaceId) {
                    Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.get(baseDataNum);
                    if (allBaseDataBos == null) continue;
                    String newObjectStr = this.replaceBaseDataIds(rightValue, allBaseDataBos, BaseDataFromFunctionEnum.ANOBJ_JOIN_CONDITION);
                    if (keyIsStringType) {
                        List idStrList = Arrays.stream(newObjectStr.split(",")).collect(Collectors.toList());
                        idStrList = idStrList.stream().map(id -> "'" + id + "'").collect(Collectors.toList());
                        newObjectStr = String.join((CharSequence)",", idStrList);
                    }
                    condition.set("rightpropval", (Object)newObjectStr);
                    continue;
                }
                if (keyIsStringType && rightValue.contains("'")) {
                    List idStrList = Arrays.stream(rightValue.split(",")).collect(Collectors.toList());
                    idStrList = idStrList.stream().map(id -> id.substring(1, id.length() - 1)).collect(Collectors.toList());
                    rightValue = String.join((CharSequence)",", idStrList);
                }
                Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, rightValue, BaseDataFromFunctionEnum.ANOBJ_JOIN_CONDITION);
                Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
                allBaseDataBos.addAll(baseDataBos);
                this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, allBaseDataBos);
            }
        }
    }

    public void parseAnObjDataFilter(DynamicObject anObjDy, List<DynamicObject> queryFields) {
        String dataFilter = anObjDy.getString("datafilter");
        dataFilter = this.parseDataFilter(dataFilter, queryFields, BaseDataFromFunctionEnum.ANOBJ_DATA_FILTER);
        anObjDy.set("datafilter", (Object)dataFilter);
    }

    public void parseAnObjPivot(List<DynamicObject> anObjPivots, List<DynamicObject> queryFields) {
        Set<ReportImportBaseDataBo> baseDataBos;
        if (anObjPivots == null || anObjPivots.isEmpty()) {
            return;
        }
        String dim = anObjPivots.get(0).getString("pivotdim");
        Map queryFieldMap = queryFields.stream().collect(Collectors.toMap(field -> field.getString("fieldalias"), Function.identity()));
        DynamicObject queryFieldDy = (DynamicObject)queryFieldMap.get(dim);
        if (queryFieldDy == null || HRStringUtils.equals((String)queryFieldDy.getString("controltype"), (String)FieldControlType.COMBO.getValue()) || HRStringUtils.equals((String)queryFieldDy.getString("controltype"), (String)FieldControlType.MUL_COMBO.getValue())) {
            return;
        }
        List<String> dimValues = anObjPivots.stream().map(pivot -> pivot.getString("pivotdimval")).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        String baseDataNum = this.getBaseDataNum(queryFieldDy.getString("entitynumber"), dim);
        if (!this.isCorrectData()) {
            Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
            baseDataBos = this.getBaseDataBos(baseDataNum, dimValues, BaseDataFromFunctionEnum.ANOBJ_PIVOT);
            allBaseDataBos.addAll(baseDataBos);
            this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, allBaseDataBos);
            this.setBaseDataBoValue(baseDataNum, baseDataBos);
        } else {
            baseDataBos = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
        }
        for (DynamicObject anObjPivot : anObjPivots) {
            String pivotDimVal = anObjPivot.getString("pivotdimval");
            if (!HRStringUtils.isNotEmpty((String)pivotDimVal)) continue;
            String newObjectStr = this.replaceBaseDataIds(pivotDimVal, baseDataBos, BaseDataFromFunctionEnum.ANOBJ_PIVOT);
            anObjPivot.set("pivotdimval", (Object)newObjectStr);
        }
    }

    public void parseAnObjGroupField(List<DynamicObject> queryFields, List<DynamicObject> anObjGroupFields) {
        Map<Long, DynamicObject> queryFieldMap = queryFields.stream().collect(Collectors.toMap(field -> field.getLong("id"), Function.identity()));
        this.parseAnObjPivotGroupFieldBaseDataId(queryFieldMap, anObjGroupFields, false);
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        this.parseAnObjPivotGroupFieldBaseDataId(queryFieldMap, anObjGroupFields, true);
    }

    private void parseAnObjPivotGroupFieldBaseDataId(Map<Long, DynamicObject> queryFieldMap, List<DynamicObject> anObjGroupFields, boolean replaceId) {
        if (!replaceId && this.isCorrectData()) {
            return;
        }
        for (DynamicObject anObjGroupField : anObjGroupFields) {
            DynamicObjectCollection groupEntry = anObjGroupField.getDynamicObjectCollection("group");
            long queryFieldId = anObjGroupField.getLong("anobjfield");
            DynamicObject queryFieldDy = queryFieldMap.get(queryFieldId);
            String fieldAlias = queryFieldDy.getString("fieldalias");
            String controlType = queryFieldDy.getString("controltype");
            String complexType = queryFieldDy.getString("complextype");
            String valueType = queryFieldDy.getString("valuetype");
            String groupFieldType = AnObjGroupFieldService.getInstance().getDependQueryFieldTyp(fieldAlias, valueType, complexType, controlType);
            String baseDataNum = this.getBaseDataNum(queryFieldDy.getString("entitynumber"), fieldAlias);
            StringBuilder objectIdSb = new StringBuilder();
            for (DynamicObject groupItemDy : groupEntry) {
                String condition = groupItemDy.getString("itemcondition");
                if (HRStringUtils.isEmpty((String)condition) || !HRStringUtils.equals((String)groupFieldType, (String)"baseData")) continue;
                if (replaceId) {
                    Set<ReportImportBaseDataBo> baseDataBoSet = this.noMatchedBaseDataBoMap.get(baseDataNum);
                    if (baseDataBoSet == null) continue;
                    String newObjectStr = this.replaceBaseDataIds(condition, baseDataBoSet, BaseDataFromFunctionEnum.ANOBJ_GROUP_FIELD);
                    groupItemDy.set("itemcondition", (Object)newObjectStr);
                    continue;
                }
                objectIdSb.append(condition).append(",");
            }
            if (objectIdSb.length() == 0) continue;
            String objectIdStr = objectIdSb.substring(0, objectIdSb.length() - 1);
            Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, objectIdStr, BaseDataFromFunctionEnum.ANOBJ_GROUP_FIELD);
            Set<ReportImportBaseDataBo> baseDataBoSet = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
            baseDataBoSet.addAll(baseDataBos);
            this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, baseDataBoSet);
        }
    }

    public void parseAnObjCalculateField(List<DynamicObject> anObjCalFields, List<DynamicObject> queryFields) {
        this.parseCalculateFields(anObjCalFields, queryFields, BaseDataFromFunctionEnum.ANOBJ_CAL_FIELD);
    }

    public void parseReportDataFilter(DynamicObject reportDy, List<DynamicObject> anObjQueryFields) {
        String dataFilter = reportDy.getString("datafilter");
        dataFilter = this.parseDataFilter(dataFilter, anObjQueryFields, BaseDataFromFunctionEnum.RPT_DATA_FILTER);
        reportDy.set("datafilter", (Object)dataFilter);
    }

    public void parseReportCalculateField(List<DynamicObject> reportCalFields, List<DynamicObject> queryFields) {
        this.parseCalculateFields(reportCalFields, queryFields, BaseDataFromFunctionEnum.RPT_CAL_FIELD);
    }

    public void parseReportJumpConfig(List<DynamicObject> reportJumpDys, List<DynamicObject> queryFields) {
        if (reportJumpDys == null || reportJumpDys.isEmpty()) {
            return;
        }
        Set<String> baseDataQueryFieldAlias = this.getBaseDataQueryFields(queryFields, false);
        Map<String, DynamicObject> queryFieldMap = queryFields.stream().collect(Collectors.toMap(field -> field.getString("fieldalias"), Function.identity()));
        this.parseReportJumpBaseDataId(reportJumpDys, queryFieldMap, baseDataQueryFieldAlias, false);
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        this.parseReportJumpBaseDataId(reportJumpDys, queryFieldMap, baseDataQueryFieldAlias, true);
    }

    private void parseReportJumpBaseDataId(List<DynamicObject> reportJumpDys, Map<String, DynamicObject> queryFieldMap, Set<String> baseDataQueryFieldAlias, boolean replaceId) {
        if (!replaceId && this.isCorrectData()) {
            return;
        }
        for (DynamicObject reportJumpDy : reportJumpDys) {
            DynamicObjectCollection jumpRuleEntry = reportJumpDy.getDynamicObjectCollection("jumpruleentry");
            for (DynamicObject jumpRuleDy : jumpRuleEntry) {
                String type = jumpRuleDy.getString("type");
                String sourceValue = null;
                String targetValue = jumpRuleDy.getString("targetfield");
                if (HRStringUtils.equals((String)type, (String)"value")) {
                    sourceValue = jumpRuleDy.getString("sourcefield");
                }
                if (sourceValue == null || !baseDataQueryFieldAlias.contains(targetValue)) continue;
                DynamicObject queryFieldDy = queryFieldMap.get(targetValue);
                String baseDataNum = this.getBaseDataNum(queryFieldDy.getString("entitynumber"), targetValue);
                if (replaceId) {
                    Set<ReportImportBaseDataBo> baseDataBoSet = this.noMatchedBaseDataBoMap.get(baseDataNum);
                    if (baseDataBoSet == null) continue;
                    String newObjectStr = this.replaceBaseDataIds(sourceValue, baseDataBoSet, BaseDataFromFunctionEnum.RPT_JUMP);
                    jumpRuleDy.set("sourcefield", (Object)newObjectStr);
                    continue;
                }
                Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, sourceValue, BaseDataFromFunctionEnum.RPT_JUMP);
                Set<ReportImportBaseDataBo> baseDataBoSet = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
                baseDataBoSet.addAll(baseDataBos);
                this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, baseDataBoSet);
            }
        }
    }

    public void parseReportConditionFormat(DynamicObject reportDy) {
        String rowStr = reportDy.getString("row");
        String colStr = reportDy.getString("column");
        List rows = Lists.newArrayListWithCapacity((int)16);
        List columns = Lists.newArrayListWithCapacity((int)16);
        if (HRStringUtils.isNotEmpty((String)rowStr)) {
            rows = SerializationUtils.fromJsonStringToList((String)rowStr, RowFieldInfo.class);
        }
        if (HRStringUtils.isNotEmpty((String)colStr)) {
            columns = SerializationUtils.fromJsonStringToList((String)colStr, FieldInfo.class);
        }
        for (RowFieldInfo row : rows) {
            if (HRStringUtils.equals((String)row.getMergeType(), (String)"1")) {
                this.recursive(row._getChildFields(), field -> this.parseReportFieldInfoForStyle((FieldInfo)field, this.noMatchedBaseDataBoMap, false));
                continue;
            }
            this.parseReportFieldInfoForStyle(row.getGroupName(), this.noMatchedBaseDataBoMap, false);
        }
        for (FieldInfo col : columns) {
            this.parseReportFieldInfoForStyle(col, this.noMatchedBaseDataBoMap, false);
        }
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        for (RowFieldInfo row : rows) {
            if (HRStringUtils.equals((String)row.getMergeType(), (String)"1")) {
                this.recursive(row._getChildFields(), field -> this.parseReportFieldInfoForStyle((FieldInfo)field, this.noMatchedBaseDataBoMap, true));
                continue;
            }
            this.parseReportFieldInfoForStyle(row.getGroupName(), this.noMatchedBaseDataBoMap, true);
        }
        for (FieldInfo col : columns) {
            this.parseReportFieldInfoForStyle(col, this.noMatchedBaseDataBoMap, true);
        }
        reportDy.set("row", (Object)SerializationUtils.toJsonString(rows));
        reportDy.set("column", (Object)SerializationUtils.toJsonString(columns));
    }

    public void parseReportFilter(List<DynamicObject> filterDyList, List<DynamicObject> queryFields) {
        if (filterDyList == null || filterDyList.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> queryFieldMap = queryFields.stream().collect(Collectors.toMap(field -> field.getLong("id"), Function.identity()));
        this.parseReportFilterBaseDataId(filterDyList, queryFieldMap, false);
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        this.parseReportFilterBaseDataId(filterDyList, queryFieldMap, true);
    }

    private void parseReportFilterBaseDataId(List<DynamicObject> filterDyList, Map<Long, DynamicObject> queryFieldMap, boolean replaceId) {
        if (!replaceId && this.isCorrectData()) {
            return;
        }
        for (DynamicObject filterDy : filterDyList) {
            String filterRangeStr;
            DynamicObject queryFieldDy;
            String filterType = filterDy.getString("filtertype");
            if (!HRStringUtils.equals((String)filterType, (String)FilterType.BASE_DATA.getValue()) && !HRStringUtils.equals((String)filterType, (String)FilterType.ADMIN_ORG.getValue()) || (queryFieldDy = queryFieldMap.get(filterDy.getLong("anobjfield"))) == null) continue;
            String entityNumber = queryFieldDy.getString("entitynumber");
            String fieldAlias = queryFieldDy.getString("fieldalias");
            String baseDataNum = this.getBaseDataNum(entityNumber, fieldAlias);
            String defaultValueStr = filterDy.getString("bddefaultvalue");
            if (HRStringUtils.isNotEmpty((String)defaultValueStr)) {
                if (replaceId) {
                    Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.get(baseDataNum);
                    if (allBaseDataBos == null) continue;
                    String newObjectStr = this.replaceBaseDataIds(defaultValueStr, allBaseDataBos, BaseDataFromFunctionEnum.RPT_FILTER_DEFAULT);
                    filterDy.set("bddefaultvalue", (Object)newObjectStr);
                } else {
                    Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, defaultValueStr, BaseDataFromFunctionEnum.RPT_FILTER_DEFAULT);
                    Set<ReportImportBaseDataBo> baseDataBoSet = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
                    baseDataBoSet.addAll(baseDataBos);
                    this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, baseDataBoSet);
                }
            }
            if (!HRStringUtils.isNotEmpty((String)(filterRangeStr = filterDy.getString("bdfilterrange")))) continue;
            if (replaceId) {
                Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.get(baseDataNum);
                if (allBaseDataBos == null) continue;
                String newObjectStr = this.replaceBaseDataIds(filterRangeStr, allBaseDataBos, BaseDataFromFunctionEnum.RPT_FILTER_CHOOSE);
                filterDy.set("bdfilterrange", (Object)newObjectStr);
                continue;
            }
            Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, filterRangeStr, BaseDataFromFunctionEnum.RPT_FILTER_CHOOSE);
            Set<ReportImportBaseDataBo> baseDataBoSet = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
            baseDataBoSet.addAll(baseDataBos);
            this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, baseDataBoSet);
        }
    }

    public void parseReportCustomSort(List<DynamicObject> customSortDyList) {
        if (customSortDyList == null || customSortDyList.isEmpty()) {
            return;
        }
        this.parseReportCustomSortBaseDataId(customSortDyList, false);
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        this.parseReportCustomSortBaseDataId(customSortDyList, true);
    }

    public void parseReportCustomSortBaseDataId(List<DynamicObject> customSortDyList, boolean replaceId) {
        if (!replaceId && this.isCorrectData()) {
            return;
        }
        for (DynamicObject sortDy : customSortDyList) {
            String fieldType = sortDy.getString("fieldtype");
            if (!HRStringUtils.equals((String)fieldType, (String)"basedata")) continue;
            DynamicObjectCollection idCol = sortDy.getDynamicObjectCollection("entryentity");
            List<String> baseDataStrList = idCol.stream().map(idDy -> idDy.getString("string")).collect(Collectors.toList());
            String baseDataNum = sortDy.getString("entitynumber");
            if (replaceId) {
                Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.get(baseDataNum);
                if (allBaseDataBos == null) continue;
                String idType = sortDy.getString("valuetype");
                for (DynamicObject row : idCol) {
                    String newObjectStr;
                    String originNumberName = row.getString("string");
                    if (HRStringUtils.equals((String)originNumberName, (String)(newObjectStr = this.replaceBaseDataIds(originNumberName, allBaseDataBos, BaseDataFromFunctionEnum.RPT_CUS_SORT)))) continue;
                    if (HRStringUtils.equals((String)idType, (String)"long")) {
                        long longId = Long.parseLong(newObjectStr);
                        row.set("long", (Object)longId);
                        row.set("string", null);
                        continue;
                    }
                    row.set("string", (Object)newObjectStr);
                }
                continue;
            }
            Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, baseDataStrList, BaseDataFromFunctionEnum.RPT_CUS_SORT);
            Set<ReportImportBaseDataBo> baseDataBoSet = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
            baseDataBoSet.addAll(baseDataBos);
            this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, baseDataBoSet);
        }
    }

    private void parseReportFieldInfoForStyle(FieldInfo field, Map<String, Set<ReportImportBaseDataBo>> allBaseDataBoMap, boolean replaceId) {
        if (!replaceId && this.isCorrectData()) {
            return;
        }
        String entityNumber = field.getEntityNumber();
        String fieldAlias = field.getNumber();
        List<ReportStyleMapInfo> styleMaps = field.getStyleMaps();
        if (styleMaps == null) {
            return;
        }
        for (ReportStyleMapInfo styleMap : styleMaps) {
            String value;
            ReportStyleRuleInfo ruleInfo = styleMap.getR();
            String pt = ruleInfo.getPt();
            if (!HRStringUtils.equals((String)pt, (String)ParamTypeEnum.BASEDATA.getType()) && !HRStringUtils.equals((String)pt, (String)ParamTypeEnum.ADMINORG.getType()) || HRStringUtils.isEmpty((String)(value = ruleInfo.getV()))) continue;
            String baseDataNum = this.getBaseDataNum(entityNumber, fieldAlias);
            if (replaceId) {
                Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.get(baseDataNum);
                if (allBaseDataBos == null) continue;
                List ids = (List)SerializationUtils.fromJsonString((String)value, List.class);
                value = String.join((CharSequence)",", ids);
                String newObjectStr = this.replaceBaseDataIds(value, allBaseDataBos, BaseDataFromFunctionEnum.RPT_CONDITION_FORMAT);
                newObjectStr = SerializationUtils.toJsonString(Arrays.stream(newObjectStr.split(",")).collect(Collectors.toList()));
                ruleInfo.setV(newObjectStr);
                continue;
            }
            List ids = (List)SerializationUtils.fromJsonString((String)value, List.class);
            Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, ids, BaseDataFromFunctionEnum.RPT_CONDITION_FORMAT);
            Set<ReportImportBaseDataBo> baseDataBoSet = allBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
            baseDataBoSet.addAll(baseDataBos);
            allBaseDataBoMap.putIfAbsent(baseDataNum, baseDataBoSet);
        }
    }

    private void recursive(List<FieldInfo> fields, Consumer<FieldInfo> consumer) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (FieldInfo children : fields) {
            if (!"0".equals(children.getType())) {
                consumer.accept(children);
            }
            if (!CollectionUtils.isNotEmpty(children.getFields())) continue;
            this.recursive(children.getFields(), consumer);
        }
    }

    private Set<String> getBaseDataQueryFields(List<DynamicObject> queryFields, boolean onlyIdField) {
        if (onlyIdField) {
            return queryFields.stream().filter(queryField -> queryField.getString("fieldalias").endsWith(".id")).map(queryField -> queryField.getString("fieldalias")).collect(Collectors.toSet());
        }
        return queryFields.stream().filter(queryField -> AnalyseObjectUtil.isBaseDataType((String)queryField.getString("complextype")) || queryField.getString("fieldalias").endsWith(".id")).map(queryField -> queryField.getString("fieldalias")).collect(Collectors.toSet());
    }

    private String parseDataFilter(String dataFilter, List<DynamicObject> queryFields, BaseDataFromFunctionEnum fromFunction) {
        if (HRStringUtils.isEmpty((String)dataFilter)) {
            return dataFilter;
        }
        Map<String, DynamicObject> queryFieldMap = queryFields.stream().collect(Collectors.toMap(field -> field.getString("fieldalias"), Function.identity()));
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
        this.parseDataFilterBaseDataId(conditionInfo, queryFieldMap, fromFunction, false);
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        this.parseDataFilterBaseDataId(conditionInfo, queryFieldMap, fromFunction, true);
        return SerializationUtils.toJsonString((Object)conditionInfo);
    }

    private void parseDataFilterBaseDataId(RuleConditionInfo conditionInfo, Map<String, DynamicObject> queryFieldMap, BaseDataFromFunctionEnum fromFunction, boolean replaceId) {
        if (!replaceId && this.isCorrectData()) {
            return;
        }
        for (ConditionInfo info : conditionInfo.getConditionList()) {
            DynamicObject queryFieldDy2;
            String fieldAlias = info.getParam();
            for (DynamicObject queryFieldDy2 : this.queryFields) {
                QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
                queryFieldCommonBo.setEntityNumber(queryFieldDy2.getString("entitynumber"));
                queryFieldCommonBo.setFieldAlias(queryFieldDy2.getString("fieldalias"));
                queryFieldCommonBo.setFieldPath(queryFieldDy2.getString("fieldpath"));
                if (!queryFieldCommonBo.getHRFilterParam().equals(fieldAlias)) continue;
                fieldAlias = queryFieldCommonBo.getFieldAlias();
                break;
            }
            String paramType = info.getParamType();
            queryFieldDy2 = queryFieldMap.get(fieldAlias);
            String objectStr = info.getValue();
            if (!HRStringUtils.equals((String)paramType, (String)"dynamicObject") || !HRStringUtils.isNotEmpty((String)objectStr)) continue;
            String baseDataNum = this.getBaseDataNum(queryFieldDy2.getString("entitynumber"), fieldAlias);
            if (replaceId) {
                Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.get(baseDataNum);
                if (allBaseDataBos == null) continue;
                String newObjectStr = this.replaceBaseDataIds(objectStr, allBaseDataBos, fromFunction);
                info.setValue(newObjectStr);
                continue;
            }
            Set<ReportImportBaseDataBo> baseDataBos = this.getBaseDataBos(baseDataNum, objectStr, fromFunction);
            Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
            allBaseDataBos.addAll(baseDataBos);
            this.noMatchedBaseDataBoMap.putIfAbsent(baseDataNum, allBaseDataBos);
        }
    }

    private String replaceBaseDataIds(String originBasDataStr, Set<ReportImportBaseDataBo> baseDataBos, BaseDataFromFunctionEnum getFromFunction) {
        for (ReportImportBaseDataBo baseDataBo : baseDataBos) {
            ArrayList baseDataStrList = Lists.newArrayListWithCapacity((int)16);
            if (originBasDataStr.contains(",")) {
                baseDataStrList.addAll(Arrays.stream(originBasDataStr.split(",")).collect(Collectors.toList()));
            } else {
                baseDataStrList.add(originBasDataStr);
            }
            for (String baseDataStr : baseDataStrList) {
                if (!baseDataBo.getNumberMatched().booleanValue() || !baseDataBo.getNameMatched().booleanValue() || baseDataBo.getFromFunction() != getFromFunction || baseDataBo.getCurrentId() == null || !HRStringUtils.equals((String)baseDataStr, (String)baseDataBo.getOriginNumberAndName())) continue;
                String originNumberAndName = baseDataBo.getOriginNumberAndName();
                originBasDataStr = originBasDataStr.replace(originNumberAndName, baseDataBo.getCurrentId().toString());
            }
        }
        return originBasDataStr;
    }

    private String replaceBaseDataId(String originBasDataStr, Set<ReportImportBaseDataBo> baseDataBos) {
        for (ReportImportBaseDataBo baseDataBo : baseDataBos) {
            String originNumberAndName = baseDataBo.getOriginNumberAndName();
            if (!baseDataBo.getNumberMatched().booleanValue() || !baseDataBo.getNameMatched().booleanValue() || baseDataBo.getCurrentId() == null || !HRStringUtils.equals((String)originBasDataStr, (String)originNumberAndName)) continue;
            String idType = baseDataBo.getIdType();
            if (HRStringUtils.equals((String)idType, (String)"long")) {
                return baseDataBo.getCurrentId().toString();
            }
            return "\"" + baseDataBo.getCurrentId().toString() + "\"";
        }
        return originBasDataStr;
    }

    private String getBaseDataNum(String entityNum, String fieldAlias) {
        String baseDataNum = this.fieldBaseDataMap.get(fieldAlias);
        if (baseDataNum == null) {
            baseDataNum = AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)entityNum, (String)fieldAlias, (MainEntityTypeUtil)this.entityTypeUtil);
            this.fieldBaseDataMap.put(fieldAlias, baseDataNum);
        }
        return baseDataNum;
    }

    private Set<ReportImportBaseDataBo> getBaseDataBos(String baseDataNum, String objectStr, BaseDataFromFunctionEnum fromFunction) {
        if (HRStringUtils.isEmpty((String)objectStr)) {
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        List<String> baseDataStrList = Arrays.stream(objectStr.split(",")).collect(Collectors.toList());
        return this.getBaseDataBos(baseDataNum, baseDataStrList, fromFunction);
    }

    private Set<ReportImportBaseDataBo> getBaseDataBos(String baseDataNum, List<String> baseDataStrList, BaseDataFromFunctionEnum fromFunction) {
        HashSet baseDataBos = Sets.newHashSetWithExpectedSize((int)16);
        for (String baseDataStr : baseDataStrList) {
            if (!baseDataStr.contains("\u03b5")) continue;
            String[] split = baseDataStr.split("\u03b5");
            String number = split[0];
            String name = split[1];
            ReportImportBaseDataBo baseDataBo = new ReportImportBaseDataBo(baseDataNum, number, name, fromFunction);
            baseDataBos.add(baseDataBo);
        }
        return baseDataBos;
    }

    private void setBaseDataBoValue(String baseDataNum, Set<ReportImportBaseDataBo> baseDataBos) {
        if (this.isCorrectData()) {
            return;
        }
        List numbers = baseDataBos.stream().filter(bo -> bo.getNumberMatched() == null || bo.getNameMatched() == null).map(ReportImportBaseDataBo::getOriginNumber).collect(Collectors.toList());
        if (numbers.isEmpty()) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseDataNum);
        Map allFields = EntityMetadataCache.getDataEntityType((String)baseDataNum).getAllFields();
        QFilter[] qFilters = allFields.containsKey("boid") && allFields.containsKey("iscurrentversion") ? new QFilter[]{new QFilter("number", "in", numbers), new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE)} : new QFilter[]{new QFilter("number", "in", numbers)};
        DynamicObjectCollection loadDys = helper.queryOriginalCollection("id,number,name", qFilters);
        Map loadMap = loadDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (k1, k2) -> k1));
        for (ReportImportBaseDataBo baseDataBo : baseDataBos) {
            if (!numbers.contains(baseDataBo.getOriginNumber())) continue;
            DynamicObject loadDy = (DynamicObject)loadMap.get(baseDataBo.getOriginNumber());
            if (loadDy == null) {
                baseDataBo.setNumberMatched(false);
                baseDataBo.setNameMatched(false);
                continue;
            }
            if (!HRStringUtils.equals((String)loadDy.getString("name"), (String)baseDataBo.getOriginName())) {
                baseDataBo.setNumberMatched(true);
                baseDataBo.setNameMatched(false);
                baseDataBo.setCurrentName(loadDy.getString("name"));
                baseDataBo.setCurrentId(loadDy.get("id"));
                baseDataBo.setIdType(this.getDynamicObjectIdType(loadDy));
                continue;
            }
            baseDataBo.setNumberMatched(true);
            baseDataBo.setNameMatched(true);
            baseDataBo.setCurrentId(loadDy.get("id"));
            baseDataBo.setIdType(this.getDynamicObjectIdType(loadDy));
        }
    }

    private String getDynamicObjectIdType(DynamicObject dynamicObject) {
        return dynamicObject.get("id") instanceof String ? "string" : "long";
    }

    private void parseCalculateFields(List<DynamicObject> calFields, List<DynamicObject> queryFields, BaseDataFromFunctionEnum fromFunction) {
        Map<String, DynamicObject> queryFieldMap = queryFields.stream().collect(Collectors.toMap(field -> field.getString("fieldalias"), Function.identity()));
        Set<String> baseDataFields = this.getBaseDataQueryFields(queryFields, true);
        this.parseCalculateFieldBaseDataId(calFields, baseDataFields, queryFieldMap, fromFunction, false);
        this.noMatchedBaseDataBoMap.forEach(this::setBaseDataBoValue);
        this.parseCalculateFieldBaseDataId(calFields, baseDataFields, queryFieldMap, fromFunction, true);
    }

    private void parseCalculateFieldBaseDataId(List<DynamicObject> calFields, Set<String> baseDataFields, Map<String, DynamicObject> queryFieldMap, BaseDataFromFunctionEnum fromFunction, boolean replaceId) {
        if (!replaceId && this.isCorrectData()) {
            return;
        }
        for (DynamicObject calField : calFields) {
            String newVar;
            String originVar;
            String originVar2;
            String newVar2;
            DynamicObjectCollection refFieldEntry = calField.getDynamicObjectCollection("reffieldentry");
            List refBaseDataFields = refFieldEntry.stream().filter(refField -> HRStringUtils.equals((String)refField.getString("reftype"), (String)"entityfield") && baseDataFields.contains(refField.getString("reffieldalias"))).collect(Collectors.toList());
            if (refBaseDataFields.isEmpty()) continue;
            HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject baseDataField : refBaseDataFields) {
                String fieldAlias = baseDataField.getString("reffieldalias");
                DynamicObject queryFieldDy = queryFieldMap.get(fieldAlias);
                Iterator baseDataNum = this.getBaseDataNum(queryFieldDy.getString("entitynumber"), fieldAlias);
                baseDataMap.put(fieldAlias, baseDataNum);
            }
            HashMap viewVarMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap runVarMap = Maps.newHashMapWithExpectedSize((int)16);
            String runExprStr = calField.getString("expr");
            String viewExprStr = calField.getString("viewexpr");
            this.parseExpr(viewExprStr, viewVarMap);
            this.parseExpr(runExprStr, runVarMap);
            for (Map.Entry varEntry : viewVarMap.entrySet()) {
                newVar2 = (String)varEntry.getKey();
                originVar2 = (String)varEntry.getValue();
                viewExprStr = viewExprStr.replace(originVar2, newVar2);
            }
            for (Map.Entry varEntry : runVarMap.entrySet()) {
                newVar2 = (String)varEntry.getKey();
                originVar2 = (String)varEntry.getValue();
                runExprStr = runExprStr.replace(originVar2, newVar2);
            }
            Expr expr = AbstractFunctionExecuteService.getExpr((String)runExprStr);
            Expr viewExpr = AbstractFunctionExecuteService.getExpr((String)viewExprStr);
            StringBuilder viewExprSb = new StringBuilder(viewExpr.toString());
            StringBuilder runExprSb = new StringBuilder(expr.toString());
            this.handleExpr(viewExpr, viewExprSb, runExprSb, viewVarMap, runVarMap, baseDataMap, this.noMatchedBaseDataBoMap, fromFunction, replaceId);
            if (!replaceId) continue;
            String finalViewExpr = viewExprSb.toString();
            String finalRunExpr = runExprSb.toString();
            for (Map.Entry varEntry : viewVarMap.entrySet()) {
                originVar = (String)varEntry.getKey();
                newVar = (String)varEntry.getValue();
                finalViewExpr = finalViewExpr.replace(originVar, newVar);
            }
            for (Map.Entry varEntry : runVarMap.entrySet()) {
                originVar = (String)varEntry.getKey();
                newVar = (String)varEntry.getValue();
                finalRunExpr = finalRunExpr.replace(originVar, newVar);
            }
            finalViewExpr = finalViewExpr.replace("'\"", "\"");
            finalViewExpr = finalViewExpr.replace("\"'", "\"");
            finalRunExpr = finalRunExpr.replace("'\"", "\"");
            finalRunExpr = finalRunExpr.replace("\"'", "\"");
            calField.set("expr", (Object)finalRunExpr);
            calField.set("viewexpr", (Object)finalViewExpr);
        }
    }

    private void parseExpr(String expr, Map<String, String> varMap) {
        boolean isQuotation = false;
        boolean isField = false;
        int varCount = 1;
        char[] exprArr = expr.toCharArray();
        StringBuilder fieldSb = new StringBuilder();
        for (char chr : exprArr) {
            if (this.specialChar.contains(Character.valueOf(chr))) {
                if (isField && chr != '$') {
                    fieldSb.append(chr);
                }
                if (chr == '$') {
                    boolean bl = isField = !isField;
                }
                if (chr == '\"') {
                    boolean bl = isQuotation = !isQuotation;
                }
                if (fieldSb.length() <= 0) continue;
                if (!isField && (chr == '(' || isQuotation || this.specialStr.contains(fieldSb.toString()) || numberPattern.matcher(fieldSb.toString()).matches())) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                if (chr != '$') continue;
                String newFieldNum = "$" + fieldSb + "$";
                varMap.put("var" + varCount++, newFieldNum);
                fieldSb = new StringBuilder();
                isField = false;
                continue;
            }
            if (isQuotation) continue;
            fieldSb.append(chr);
        }
    }

    private void handleExpr(Expr viewExpr, StringBuilder viewExprSb, StringBuilder runExprSb, Map<String, String> viewVarMap, Map<String, String> runVarMap, Map<String, String> baseDataMap, Map<String, Set<ReportImportBaseDataBo>> allBaseDataBoMap, BaseDataFromFunctionEnum fromFunction, boolean replaceId) {
        Expr expr1;
        if (viewExpr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)viewExpr;
            Operator operator = binaryExpr.getOperator();
            Expr left = binaryExpr.getLeft();
            Expr right = binaryExpr.getRight();
            if (HRStringUtils.equals((String)operator.getName(), (String)"=") || HRStringUtils.equals((String)operator.getName(), (String)"!=")) {
                String var = viewVarMap.get(left.toString());
                if (var.contains("$") && ((var = var.substring(1, var.length() - 1)).endsWith(".name") || var.endsWith(".number"))) {
                    var = var.substring(0, var.lastIndexOf(".")) + ".id";
                }
                String baseDataNum = baseDataMap.get(var);
                String value = right.toString();
                if (baseDataNum != null && HRStringUtils.isNotEmpty((String)value) && value.startsWith("'") && value.endsWith("'")) {
                    String newValue = value.substring(2, value.length() - 2);
                    if (replaceId) {
                        Set<ReportImportBaseDataBo> allBaseDataBos = this.noMatchedBaseDataBoMap.get(baseDataNum);
                        if (allBaseDataBos == null) {
                            return;
                        }
                        String baseDataId = this.replaceBaseDataId(newValue, allBaseDataBos);
                        if (HRStringUtils.equals((String)baseDataId, (String)newValue)) {
                            return;
                        }
                        String origin = left + " " + operator.getName() + " " + value;
                        String viewExprStr = viewExprSb.toString().replace(origin, left + " " + operator.getName() + " " + baseDataId);
                        viewExprSb.replace(0, viewExprSb.length(), viewExprStr);
                        String runExprStr = runExprSb.toString().replace(origin, left + " " + operator.getName() + " " + baseDataId);
                        runExprSb.replace(0, runExprSb.length(), runExprStr);
                    } else {
                        String[] split = newValue.split("\u03b5");
                        String number = split[0];
                        String name = split[1];
                        ReportImportBaseDataBo baseDataBo = new ReportImportBaseDataBo(baseDataNum, number, name, fromFunction);
                        Set<ReportImportBaseDataBo> baseDataBos = allBaseDataBoMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)16));
                        baseDataBos.add(baseDataBo);
                        allBaseDataBoMap.putIfAbsent(baseDataNum, baseDataBos);
                    }
                }
            }
            this.handleExpr(left, viewExprSb, runExprSb, viewVarMap, runVarMap, baseDataMap, allBaseDataBoMap, fromFunction, replaceId);
            this.handleExpr(right, viewExprSb, runExprSb, viewVarMap, runVarMap, baseDataMap, allBaseDataBoMap, fromFunction, replaceId);
        } else if (viewExpr instanceof ExprList) {
            ExprList exprList = (ExprList)viewExpr;
            if (exprList.list != null) {
                for (Expr expr12 : exprList.list) {
                    this.handleExpr(expr12, viewExprSb, runExprSb, viewVarMap, runVarMap, baseDataMap, allBaseDataBoMap, fromFunction, replaceId);
                }
            }
        } else if (viewExpr instanceof FunCall) {
            FunCall funCall = (FunCall)viewExpr;
            if (funCall.getParams() != null) {
                for (Expr expr13 : funCall.getParams()) {
                    this.handleExpr(expr13, viewExprSb, runExprSb, viewVarMap, runVarMap, baseDataMap, allBaseDataBoMap, fromFunction, replaceId);
                }
            }
        } else if (viewExpr instanceof Paren && (expr1 = ((Paren)viewExpr).getExpr()) != null) {
            this.handleExpr(expr1, viewExprSb, runExprSb, viewVarMap, runVarMap, baseDataMap, allBaseDataBoMap, fromFunction, replaceId);
        }
    }

    public Map<String, Set<ReportImportBaseDataBo>> getNoMatchedBaseDataBoMap() {
        return this.noMatchedBaseDataBoMap;
    }

    public boolean isCorrectData() {
        return this.correctData;
    }

    public void setCorrectData(boolean correctData) {
        this.correctData = correctData;
    }
}

