/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp.validator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;

public abstract class AbstractImportValidator {
    private static final Log LOG = LogFactory.getLog(AbstractImportValidator.class);

    public boolean validate(int rowHeadNum, ImportContext ctx, HREXPImpEnum impEnum, Map<String, List<DynamicObject>> allPreData, ImportLogger importLogger, Map<String, List<DynamicObject>> allExistData) {
        List<DynamicObject> dynamicObjects = allPreData.get(impEnum.getNumber());
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return true;
        }
        this.validateImpl(rowHeadNum, ctx, impEnum, allPreData, allExistData, importLogger);
        return true;
    }

    public abstract boolean validateImpl(int var1, ImportContext var2, HREXPImpEnum var3, Map<String, List<DynamicObject>> var4, Map<String, List<DynamicObject>> var5, ImportLogger var6);

    public boolean validateSysField(String propField) {
        return HRStringUtils.equalsIgnoreCase((String)"id", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"disabler", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"disabledate", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"creator", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"createtime", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"modifier", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"modifytime", (String)propField) || propField.endsWith("_id") || HRStringUtils.equalsIgnoreCase((String)"isv", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"index", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"initbatch", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"initstatus", (String)propField) || HRStringUtils.equalsIgnoreCase((String)"version", (String)propField);
    }

    public void checkEntryProperties(DynamicObject dynamicObject1, DynamicObject dynamicObject, DynamicObjectType entryType, AtomicBoolean subFlag) {
        entryType.getProperties().forEach(prop -> {
            if (this.validateSysField(prop.getName())) {
                return;
            }
            if ("multilanguagetext".equalsIgnoreCase(prop.getName())) {
                return;
            }
            String tmpPropValue1 = dynamicObject1.containsProperty(prop.getName()) && dynamicObject1.get(prop.getName()) != null ? dynamicObject1.get(prop.getName()) : "";
            DynamicObjectCollection dynamicObject1Collection = null;
            if (tmpPropValue1 instanceof DynamicObject) {
                tmpPropValue1 = dynamicObject1.getDynamicObject(prop.getName()).getString("id");
            } else if (tmpPropValue1 instanceof DynamicObjectCollection) {
                dynamicObject1Collection = dynamicObject1.getDynamicObjectCollection(prop.getName());
            }
            String tmpPropValue2 = dynamicObject.containsProperty(prop.getName()) && dynamicObject1.get(prop.getName()) != null ? dynamicObject.get(prop.getName()) : "";
            DynamicObjectCollection dynamicObjectCollection = null;
            if (tmpPropValue2 instanceof DynamicObject) {
                tmpPropValue2 = dynamicObject.getDynamicObject(prop.getName()).getString("id");
            } else if (tmpPropValue2 instanceof DynamicObjectCollection) {
                dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(prop.getName());
            }
            if (dynamicObject1Collection != null && dynamicObjectCollection != null && dynamicObject1Collection.size() == dynamicObjectCollection.size()) {
                for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                    this.checkEntryProperties((DynamicObject)dynamicObject1Collection.get(i), (DynamicObject)dynamicObjectCollection.get(i), ((DynamicObject)dynamicObjectCollection.get(i)).getDynamicObjectType(), subFlag);
                }
            } else if (this.checkCollectionEqual(dynamicObject1Collection, dynamicObjectCollection)) {
                subFlag.set(false);
            } else if (!HRStringUtils.equalsIgnoreCase((String)String.valueOf(tmpPropValue1), (String)String.valueOf(tmpPropValue2))) {
                subFlag.set(false);
            }
        });
    }

    private boolean checkCollectionEqual(DynamicObjectCollection dynamicObject1Collection, DynamicObjectCollection dynamicObjectCollection) {
        return dynamicObject1Collection != null && dynamicObjectCollection == null || dynamicObject1Collection == null && dynamicObjectCollection != null || dynamicObject1Collection != null && dynamicObjectCollection != null && dynamicObject1Collection.size() != dynamicObjectCollection.size();
    }

    public void checkProperties(DynamicObject dynamicObject1, DynamicObject dynamicObject, DynamicObjectType entryType, AtomicBoolean subFlag) {
        entryType.getProperties().forEach(prop -> {
            String tmpPropValue2;
            String tmpPropValue1;
            if (this.validateSysField(prop.getName())) {
                return;
            }
            if ("multilanguagetext".equalsIgnoreCase(prop.getName())) {
                return;
            }
            String string = tmpPropValue1 = dynamicObject1.containsProperty(prop.getName()) && dynamicObject1.get(prop.getName()) != null ? dynamicObject1.get(prop.getName()) : "";
            if (tmpPropValue1 instanceof DynamicObject) {
                tmpPropValue1 = dynamicObject1.getDynamicObject(prop.getName()).getString("id");
            } else if (tmpPropValue1 instanceof DynamicObjectCollection) {
                return;
            }
            String string2 = tmpPropValue2 = dynamicObject.containsProperty(prop.getName()) && dynamicObject1.get(prop.getName()) != null ? dynamicObject.get(prop.getName()) : "";
            if (tmpPropValue2 instanceof DynamicObject) {
                tmpPropValue2 = dynamicObject.getDynamicObject(prop.getName()).getString("id");
            } else if (tmpPropValue2 instanceof DynamicObjectCollection) {
                return;
            }
            if (!HRStringUtils.equalsIgnoreCase((String)String.valueOf(tmpPropValue1), (String)String.valueOf(tmpPropValue2))) {
                subFlag.set(false);
                return;
            }
        });
    }

    public boolean checkEntityMetadata(String number) {
        boolean checkFlag = false;
        try {
            if (HRStringUtils.isNotEmpty((String)number) && EntityMetadataCache.getDataEntityType((String)number) != null) {
                checkFlag = true;
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        return checkFlag;
    }
}

