/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.imp.validator.AbstractImportValidator;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;

public class AnalyseObjectImportValidator
extends AbstractImportValidator {
    private static final Log LOGGER = LogFactory.getLog(AnalyseObjectImportValidator.class);

    @Override
    public boolean validateImpl(int rowHeadNum, ImportContext ctx, HREXPImpEnum impEnum, Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData, ImportLogger importLogger) {
        ArrayList importQueryFields;
        List<DynamicObject> existDynamicObjects = allExistData.get(impEnum.getNumber());
        List<DynamicObject> dynamicObjects = allPreData.get(impEnum.getNumber());
        List<DynamicObject> importJoinEntity = allPreData.get("hrptmc_anobjjoinentity");
        if (CollectionUtils.isEmpty(importJoinEntity)) {
            return true;
        }
        if (this.checkEntry(dynamicObjects, importJoinEntity, rowHeadNum, importLogger)) {
            return true;
        }
        ArrayList importEntityRel = allPreData.get("hrptmc_anobjentityrel");
        if (CollectionUtils.isEmpty(importEntityRel)) {
            importEntityRel = Lists.newArrayListWithCapacity((int)1);
        }
        List<DynamicObject> updateJoinEntity = allExistData.get("hrptmc_anobjjoinentity");
        ArrayList updateEntityRel = allExistData.get("hrptmc_anobjentityrel");
        if (CollectionUtils.isEmpty(updateEntityRel)) {
            updateEntityRel = Lists.newArrayListWithCapacity((int)1);
        }
        if (CollectionUtils.isEmpty(importQueryFields = allPreData.get("hrptmc_anobjqueryfield"))) {
            importQueryFields = Lists.newArrayListWithCapacity((int)1);
        }
        List<DynamicObject> existQueryFieldList = allExistData.get("hrptmc_anobjqueryfield");
        HashMap existPreIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap existReportManageMap = Maps.newHashMapWithExpectedSize((int)16);
        this.buildExistData(existPreIndexMap, existReportManageMap, dynamicObjects);
        this.buildImportData(existPreIndexMap, existReportManageMap, allPreData);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            block16: {
                try {
                    Set<String> existFieldAlias;
                    DynamicObject analyseObject = dynamicObjects.get(i);
                    Boolean isTemplate = (Boolean)ctx.getOption().get("anObjIsTemplate");
                    String objType = analyseObject.getString("objecttype");
                    if (isTemplate != null && isTemplate.booleanValue()) {
                        if (!HRStringUtils.equals((String)objType, (String)"template")) {
                            importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6a21\u677f\u7c7b\u578b\u7684\u5206\u6790\u5bf9\u8c61\u3002", (String)"AnalyseObjectImportValidator_10", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                            continue;
                        }
                    } else if (HRStringUtils.equals((String)objType, (String)"template")) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u6a21\u677f\u7c7b\u578b\u7684\u5206\u6790\u5bf9\u8c61\u3002", (String)"AnalyseObjectImportValidator_11", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        continue;
                    }
                    Set<DynamicObject> importObject = importJoinEntity.stream().filter(obj -> analyseObject.getLong("id") == obj.getLong("anobj")).collect(Collectors.toSet());
                    Set<DynamicObject> importObjectRel = importEntityRel.stream().filter(obj -> analyseObject.getLong("id") == obj.getLong("anobj")).collect(Collectors.toSet());
                    Set<DynamicObject> queryJoinEntity = updateJoinEntity.stream().filter(obj -> obj.getDynamicObject("anobj") != null && analyseObject.getLong("id") == obj.getDynamicObject("anobj").getLong("id")).collect(Collectors.toSet());
                    Set<DynamicObject> queryEntityRel = updateEntityRel.stream().filter(obj -> obj.getDynamicObject("anobj") != null && analyseObject.getLong("id") == obj.getDynamicObject("anobj").getLong("id")).collect(Collectors.toSet());
                    if (this.checkDynamicObject(importObject, queryJoinEntity) && (existPreIndexMap.containsValue(analyseObject.getLong("id")) || existReportManageMap.containsValue(analyseObject.getLong("id")))) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u4f53\u53d1\u751f\u53d8\u5316\u3002", (String)"AnalyseObjectImportValidator_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        continue;
                    }
                    if (this.checkDynamicObject(importObjectRel, queryEntityRel) && (existPreIndexMap.containsValue(analyseObject.getLong("id")) || existReportManageMap.containsValue(analyseObject.getLong("id")))) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u5df2\u53d1\u751f\u53d8\u5316\u3002", (String)"AnalyseObjectImportValidator_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        continue;
                    }
                    Set<String> importFieldAlias = importQueryFields.stream().map(obj -> {
                        if (analyseObject.getLong("id") == obj.getLong("anobj")) {
                            return obj.getString("fieldalias");
                        }
                        return null;
                    }).collect(Collectors.toSet());
                    if (!this.checkImportFieldAlias(importQueryFields, importFieldAlias, existFieldAlias = existQueryFieldList.stream().map(obj -> {
                        if (obj.getDynamicObject("anobj") != null && analyseObject.getLong("id") == obj.getDynamicObject("anobj").getLong("id")) {
                            return obj.getString("fieldalias");
                        }
                        return null;
                    }).collect(Collectors.toSet()))) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u6240\u9009\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AnalyseObjectImportValidator_9", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        continue;
                    }
                    Set<String> usedFieldAlias = AnalyseObjectService.getInstance().getRefByReportFieldAliasList(analyseObject.getLong("id"));
                    if (usedFieldAlias.size() == 0) continue;
                    usedFieldAlias.removeAll(importFieldAlias);
                    List<DynamicObject> preAnObjPivot = allPreData.get("hrptmc_anobjpivot");
                    if (CollectionUtils.isNotEmpty(preAnObjPivot)) {
                        this.buildPivotIndexNumber(preAnObjPivot.stream().filter(data -> analyseObject.getLong("id") == data.getLong("anobj")).collect(Collectors.toList()), usedFieldAlias);
                    }
                    LinkedHashSet otherFields = Sets.newLinkedHashSetWithExpectedSize((int)16);
                    this.buildOtherFields(analyseObject, otherFields, allPreData, allExistData);
                    usedFieldAlias.removeAll(otherFields);
                    if (usedFieldAlias.size() <= 0 || !existPreIndexMap.containsValue(analyseObject.getLong("id")) && !existReportManageMap.containsValue(analyseObject.getLong("id"))) break block16;
                    importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u5b57\u6bb5\u5df2\u88ab\u5f15\u7528", (String)"AnalyseObjectImportValidator_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                }
                catch (Exception ex) {
                    LOGGER.error("\u5206\u6790\u5bf9\u8c61\u6821\u9a8c\u5f02\u5e38:{}", (Object)(rowHeadNum + i), (Object)ex);
                    importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u6821\u9a8c\u5f02\u5e38\u3002", (String)"AnalyseObjectImportValidator_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                    break;
                }
            }
            importLogger.getDelRows().add(new int[]{rowHeadNum + i, rowHeadNum + i});
        }
        return false;
    }

    private boolean checkImportFieldAlias(List<DynamicObject> importQueryFields, Set<String> importFieldAlias, Set<String> existFieldAlias) {
        HashSet tmpFieldAlias = Sets.newHashSetWithExpectedSize((int)importFieldAlias.size());
        tmpFieldAlias.addAll(importFieldAlias);
        tmpFieldAlias.removeAll(existFieldAlias);
        if (tmpFieldAlias.size() == 0 || importQueryFields.size() == 0) {
            return true;
        }
        AtomicBoolean flag = new AtomicBoolean(true);
        try {
            List<DynamicObject> tmpQueryFields = importQueryFields.stream().filter(data -> tmpFieldAlias.stream().anyMatch(data1 -> HRStringUtils.equalsIgnoreCase((String)data1, (String)data.getString("fieldalias")))).collect(Collectors.toList());
            tmpQueryFields.forEach(data -> {
                if (HRStringUtils.isEmpty((String)data.getString("fieldalias"))) {
                    return;
                }
                if (data.getString("fieldalias").endsWith(".id")) {
                    return;
                }
                if (AnalyseObjectUtil.parseFieldAliasGetProperty((String)data.getString("entitynumber"), (String)data.getString("fieldalias"), (MainEntityTypeUtil)new MainEntityTypeUtil()) == null) {
                    flag.set(false);
                    return;
                }
            });
        }
        catch (Exception exception) {
            flag.set(false);
        }
        return flag.get();
    }

    private boolean checkConditionInfoEqual(List<ConditionInfo> importExpressList, List<ConditionInfo> existExpressList) {
        return CollectionUtils.isEmpty(importExpressList) && CollectionUtils.isNotEmpty(existExpressList) || CollectionUtils.isNotEmpty(importExpressList) && CollectionUtils.isEmpty(existExpressList) || CollectionUtils.isNotEmpty(importExpressList) && CollectionUtils.isNotEmpty(existExpressList) && importExpressList.size() != existExpressList.size();
    }

    private boolean checkConditionEqual(List<ConditionExpressInfo> importExpressList, List<ConditionExpressInfo> existExpressList) {
        return CollectionUtils.isEmpty(importExpressList) && CollectionUtils.isNotEmpty(existExpressList) || CollectionUtils.isNotEmpty(importExpressList) && CollectionUtils.isEmpty(existExpressList) || CollectionUtils.isNotEmpty(importExpressList) && CollectionUtils.isNotEmpty(existExpressList) && importExpressList.size() != existExpressList.size();
    }

    private boolean checkDataFilter(DynamicObject analyseObject, DynamicObject existDy) {
        String existDataFilter;
        String importDataFilter = analyseObject.getString("datafilter");
        if (HRStringUtils.equalsIgnoreCase((String)importDataFilter, (String)(existDataFilter = existDy.getString("datafilter")))) {
            return true;
        }
        RuleConditionInfo importConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)importDataFilter, RuleConditionInfo.class);
        RuleConditionInfo existConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)existDataFilter, RuleConditionInfo.class);
        if (!HRStringUtils.equalsIgnoreCase((String)importConditionInfo.getConditionExpressStr(), (String)existConditionInfo.getConditionExpressStr()) || !HRStringUtils.equalsIgnoreCase((String)importConditionInfo.getConditionExpressType(), (String)existConditionInfo.getConditionExpressType())) {
            return false;
        }
        List importExpressList = importConditionInfo.getConditionExpressList();
        List existExpressList = existConditionInfo.getConditionExpressList();
        if (CollectionUtils.isNotEmpty((Collection)importExpressList) && CollectionUtils.isNotEmpty((Collection)existExpressList) && importExpressList.size() == existExpressList.size()) {
            for (int i = 0; i < existExpressList.size(); ++i) {
                ConditionExpressInfo importExpress = (ConditionExpressInfo)importExpressList.get(i);
                ConditionExpressInfo existExpress = (ConditionExpressInfo)existExpressList.get(i);
                if (HRStringUtils.equalsIgnoreCase((String)importExpress.getLeftBracket(), (String)existExpress.getLeftBracket()) && HRStringUtils.equalsIgnoreCase((String)importExpress.getLogical(), (String)existExpress.getLogical()) && HRStringUtils.equalsIgnoreCase((String)importExpress.getName(), (String)existExpress.getName()) && HRStringUtils.equalsIgnoreCase((String)importExpress.getRightBracket(), (String)existExpress.getRightBracket())) continue;
                return false;
            }
        } else if (this.checkConditionEqual(importExpressList, existExpressList)) {
            return false;
        }
        List importConditionList = importConditionInfo.getConditionList();
        List existConditionList = existConditionInfo.getConditionList();
        if (CollectionUtils.isNotEmpty((Collection)importExpressList) && CollectionUtils.isNotEmpty((Collection)existExpressList) && importExpressList.size() == existExpressList.size()) {
            for (int i = 0; i < existConditionList.size(); ++i) {
                if (!this.checkConditionInfoEqual((ConditionInfo)existConditionList.get(i), (ConditionInfo)importConditionList.get(i))) continue;
                return false;
            }
        } else if (this.checkConditionInfoEqual(importConditionList, existConditionList)) {
            return false;
        }
        return true;
    }

    private boolean checkConditionInfoEqual(ConditionInfo existCondition, ConditionInfo importCondition) {
        return !HRStringUtils.equalsIgnoreCase((String)existCondition.getDateFormat(), (String)importCondition.getDateFormat()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getDisplayParam(), (String)importCondition.getDisplayParam()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getDisplayValue(), (String)importCondition.getDisplayValue()) || existCondition.getIndex() != importCondition.getIndex() || !HRStringUtils.equalsIgnoreCase((String)existCondition.getName(), (String)importCondition.getName()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getObjectNumber(), (String)importCondition.getObjectNumber()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getOperators(), (String)importCondition.getOperators()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getParam(), (String)importCondition.getParam()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getParamType(), (String)importCondition.getParamType()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getValueDataType(), (String)importCondition.getValueDataType()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getValueDateFormat(), (String)importCondition.getValueDateFormat()) || !HRStringUtils.equalsIgnoreCase((String)existCondition.getValueType(), (String)importCondition.getValueType()) || existCondition.isTarget() != importCondition.isTarget();
    }

    private void buildPivotIndexNumber(List<DynamicObject> preAnObjPivot, Set<String> usedFieldAlias) {
        if (CollectionUtils.isEmpty(preAnObjPivot)) {
            return;
        }
        usedFieldAlias.removeAll(AnalyseObjectService.getInstance().generatePivotIndexNumber(preAnObjPivot.toArray(new DynamicObject[preAnObjPivot.size()])));
    }

    private void buildOtherFields(DynamicObject analyseObject, Set<String> otherFields, Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData) {
        List<DynamicObject> groupFieldObjects;
        List<DynamicObject> calFieldObjects = allPreData.get("hrptmc_calculatefield");
        if (CollectionUtils.isNotEmpty(calFieldObjects)) {
            calFieldObjects.stream().forEach(data -> {
                if (data.getLong("anobj") == analyseObject.getLong("id") && data.getBoolean("isselected")) {
                    otherFields.add(data.getString("number"));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(groupFieldObjects = allPreData.get("hrptmc_anobjgroupfield"))) {
            groupFieldObjects.stream().forEach(data -> {
                if (data.getLong("anobj") == analyseObject.getLong("id")) {
                    otherFields.add(data.getString("number"));
                }
            });
        }
    }

    private void buildExistData(Map<Long, Long> existPreIndexMap, Map<Long, Long> existReportManageMap, List<DynamicObject> dynamicObjects) {
        List idList = dynamicObjects.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
        QFilter preIndexFilter = new QFilter("anobj", "in", idList);
        DynamicObject[] existPreIndexData = BusinessDataServiceHelper.load((String)HREXPImpEnum.PREINDEX.getNumber(), (String)"id,anobj", (QFilter[])new QFilter[]{preIndexFilter});
        if (existPreIndexData != null) {
            Arrays.stream(existPreIndexData).forEach(data -> {
                Long cfr_ignored_0 = existPreIndexMap.put(data.getLong("id"), data.getDynamicObject("anobj") != null ? Long.valueOf(data.getDynamicObject("anobj").getLong("id")) : null);
            });
        }
        QFilter reportManageFilter = new QFilter("anobjid", "in", idList);
        DynamicObject[] existReportManage = BusinessDataServiceHelper.load((String)HREXPImpEnum.REPORTMANAGE.getNumber(), (String)"id,anobjid", (QFilter[])new QFilter[]{reportManageFilter});
        if (existReportManage != null) {
            Arrays.stream(existReportManage).forEach(data -> existReportManageMap.put(data.getLong("id"), data.getDynamicObject("anobjid").getLong("id")));
        }
    }

    private void buildImportData(Map<Long, Long> existPreIndexMap, Map<Long, Long> existReportManageMap, Map<String, List<DynamicObject>> allPreData) {
        List<DynamicObject> importReportManage;
        List<DynamicObject> importPreIndex = allPreData.get(HREXPImpEnum.PREINDEX.getNumber());
        if (importPreIndex != null) {
            importPreIndex.forEach(data -> {
                if (existPreIndexMap.containsValue(data.getLong("anobj"))) {
                    existPreIndexMap.remove(data.getLong("id"));
                }
            });
        }
        if ((importReportManage = allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber())) != null) {
            importReportManage.forEach(data -> {
                if (existReportManageMap.containsValue(data.getLong("anobjid"))) {
                    existReportManageMap.remove(data.getLong("id"));
                }
            });
        }
    }

    private boolean checkDynamicObject(Set<DynamicObject> importObject, Set<DynamicObject> queryObject) {
        boolean flag = false;
        if (importObject.size() != queryObject.size()) {
            return true;
        }
        for (DynamicObject dynamicObject : queryObject) {
            for (DynamicObject dynamicObject1 : importObject) {
                if (dynamicObject.getLong("id") != dynamicObject1.getLong("id")) continue;
                DynamicObjectType entryType = dynamicObject.getDynamicObjectType();
                AtomicBoolean subFlag = new AtomicBoolean(true);
                if (HRStringUtils.equalsIgnoreCase((String)"hrptmc_anobjentityrel", (String)entryType.getName())) {
                    this.checkEntryProperties(dynamicObject1, dynamicObject, entryType, subFlag);
                } else {
                    this.checkProperties(dynamicObject1, dynamicObject, entryType, subFlag);
                }
                if (subFlag.get()) break;
                flag = true;
                break;
            }
            if (!flag) continue;
            break;
        }
        return flag;
    }

    private boolean checkEntry(List<DynamicObject> dynamicObjects, List<DynamicObject> importJoinEntity, int rowHeadNum, ImportLogger importLogger) {
        AtomicBoolean flag = new AtomicBoolean(false);
        int i = 0;
        while (i < dynamicObjects.size()) {
            DynamicObject analyseObject = dynamicObjects.get(i);
            int finalI = i++;
            importJoinEntity.stream().forEach(data -> {
                if (analyseObject.getLong("id") == data.getLong("anobj") && !this.checkEntityMetadata(data.getString("entitynumber"))) {
                    importLogger.log(Integer.valueOf(rowHeadNum + finalI), ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u5173\u8054\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"AnalyseObjectImportValidator_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                    flag.set(true);
                }
            });
        }
        return flag.get();
    }
}

