/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp.validator;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.imp.validator.AbstractImportValidator;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;

public class PreIndexImportValidator
extends AbstractImportValidator {
    private static final Log LOGGER = LogFactory.getLog(PreIndexImportValidator.class);

    private void buildUsedPreIndex(Set<Long> existReportManageIndex, Set<Long> importReportIndex, Set<Long> queryReportManageId, Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData, List<DynamicObject> dynamicObjects) {
        List<DynamicObject> importPreIndex = allPreData.get("hrptmc_reportpreindex");
        importReportIndex.addAll(importPreIndex != null ? (Collection)importPreIndex.stream().map(data -> data.getLong("preindex")).collect(Collectors.toSet()) : Sets.newHashSetWithExpectedSize((int)0));
        List<DynamicObject> existReportManage = allExistData.get("hrptmc_reportpreindex");
        existReportManageIndex.addAll(existReportManage != null ? (Collection)existReportManage.stream().map(data -> data.getDynamicObject("preindex") != null ? Long.valueOf(data.getDynamicObject("preindex").getLong("id")) : null).collect(Collectors.toSet()) : Sets.newHashSetWithExpectedSize((int)0));
        List idList = dynamicObjects.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
        QFilter preIndexFilter = new QFilter("preindex", "in", idList);
        DynamicObject[] getReportManage = BusinessDataServiceHelper.load((String)"hrptmc_reportpreindex", (String)"id,report,preindex", (QFilter[])new QFilter[]{preIndexFilter});
        existReportManageIndex.addAll(getReportManage != null ? (Collection)Arrays.stream(getReportManage).map(data -> data.getDynamicObject("preindex") != null ? Long.valueOf(data.getDynamicObject("preindex").getLong("id")) : null).collect(Collectors.toSet()) : Sets.newHashSetWithExpectedSize((int)0));
        queryReportManageId.addAll(getReportManage != null ? (Collection)Arrays.stream(getReportManage).map(data -> data.getDynamicObject("report") != null ? Long.valueOf(data.getDynamicObject("report").getLong("id")) : null).collect(Collectors.toSet()) : Sets.newHashSetWithExpectedSize((int)0));
    }

    private DynamicObject[] buildUsedDimMap(Set<Long> existReportManageIndex, List<DynamicObject> dynamicObjects) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_dimmap");
        List idList = dynamicObjects.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
        QFilter reportFilter = new QFilter("report", "in", existReportManageIndex);
        QFilter preIndexFilter = new QFilter("preindex", "in", idList);
        return helper.loadDynamicObjectArray(new QFilter[]{preIndexFilter, reportFilter});
    }

    @Override
    public boolean validateImpl(int rowHeadNum, ImportContext ctx, HREXPImpEnum impEnum, Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData, ImportLogger importLogger) {
        List<DynamicObject> dynamicObjects = allPreData.get(impEnum.getNumber());
        List<DynamicObject> existDynamicObjects = allExistData.get(impEnum.getNumber());
        if (CollectionUtils.isEmpty(existDynamicObjects)) {
            return true;
        }
        HashSet existReportManageIndex = Sets.newHashSetWithExpectedSize((int)16);
        HashSet importReportIndex = Sets.newHashSetWithExpectedSize((int)16);
        HashSet queryReportManageId = Sets.newHashSetWithExpectedSize((int)16);
        this.buildUsedPreIndex(existReportManageIndex, importReportIndex, queryReportManageId, allPreData, allExistData, dynamicObjects);
        existReportManageIndex.removeAll(importReportIndex);
        existReportManageIndex.remove(null);
        importReportIndex.remove(null);
        if (existReportManageIndex.size() == 0) {
            return true;
        }
        DynamicObject[] dimMaps = this.buildUsedDimMap(queryReportManageId, dynamicObjects);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            try {
                DynamicObject dynamicObject1 = dynamicObjects.get(i);
                for (DynamicObject dynamicObject : existDynamicObjects) {
                    if (dynamicObject.getLong("id") != dynamicObject1.getLong("id") || !existReportManageIndex.contains(dynamicObject.getLong("id"))) continue;
                    DynamicObjectType entryType = dynamicObject1.getDynamicObjectType();
                    AtomicBoolean subFlag = new AtomicBoolean(true);
                    this.checkProperties(dynamicObject1, dynamicObject, entryType, subFlag);
                    if (!subFlag.get()) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u5df2\u88ab\u62a5\u8868\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PreIndexImportValidator_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        break;
                    }
                    DynamicObjectCollection entryCollection = dynamicObject.getDynamicObjectCollection("entryentity_col");
                    DynamicObjectCollection entryImportCollection = dynamicObject1.getDynamicObjectCollection("entryentity_col");
                    Set querySet = entryCollection.stream().map(queryEntry -> queryEntry.getString("colfrom") + queryEntry.getString("colnumber") + queryEntry.getString("colname") + queryEntry.getString("coltype") + "\u03b5" + queryEntry.getString("isrequired1")).collect(Collectors.toSet());
                    Set importSet = entryImportCollection.stream().map(importEntry -> importEntry.getString("colfrom") + importEntry.getString("colnumber") + importEntry.getString("colname") + importEntry.getString("coltype") + "\u03b5" + importEntry.getString("isrequired1")).collect(Collectors.toSet());
                    HashSet tmpSet = new HashSet(querySet.size());
                    tmpSet.addAll(querySet);
                    querySet.removeAll(importSet);
                    if (querySet.size() > 0 && querySet.stream().anyMatch(set -> HRStringUtils.equalsIgnoreCase((String)"true", (String)set.split("\u03b5")[1]))) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u6307\u6807\u5b57\u6bb5\u4fe1\u606f\u53d1\u751f\u53d8\u5316\u3002", (String)"PreIndexImportValidator_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        break;
                    }
                    if (querySet.size() > 0) {
                        AtomicBoolean dimFlag = new AtomicBoolean(true);
                        List<DynamicObject> dimMapObjects = Arrays.stream(dimMaps).filter(data -> data.getDynamicObject("preindex").getLong("id") == dynamicObject1.getLong("id")).collect(Collectors.toList());
                        dimMapObjects.forEach(obj -> {
                            DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
                            if (entryEntity.stream().anyMatch(entry -> entryCollection.stream().anyMatch(entry2 -> HRStringUtils.equalsIgnoreCase((String)entry2.getString("colnumber"), (String)entry.getString("preindexparam"))))) {
                                dimFlag.set(false);
                            }
                        });
                        if (!dimFlag.get()) {
                            importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u6307\u6807\u5b57\u6bb5\u4fe1\u606f\u53d1\u751f\u53d8\u5316\u3002", (String)"PreIndexImportValidator_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                            break;
                        }
                    }
                    importSet.removeAll(tmpSet);
                    if (importSet.size() > 0 && importSet.stream().anyMatch(set -> HRStringUtils.equalsIgnoreCase((String)"true", (String)set.split("\u03b5")[1]))) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u6307\u6807\u5b57\u6bb5\u4fe1\u606f\u53d1\u751f\u53d8\u5316\u3002", (String)"PreIndexImportValidator_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        break;
                    }
                    DynamicObjectCollection entryParamCollection = dynamicObject.getDynamicObjectCollection("entryentity_param");
                    DynamicObjectCollection importParamCollection = dynamicObject1.getDynamicObjectCollection("entryentity_param");
                    Set queryParamSet = entryParamCollection.stream().map(queryEntry -> (queryEntry.containsProperty("selparam") ? Long.valueOf(queryEntry.getDynamicObject("selparam").getLong("id")) : "") + "\u03b5" + (queryEntry.containsProperty("isrequired") ? queryEntry.getString("isrequired") : "false")).collect(Collectors.toSet());
                    Set importParamSet = importParamCollection.stream().map(importEntry -> (importEntry.containsProperty("selparam") ? importEntry.getString("selparam") : "") + "\u03b5" + (importEntry.containsProperty("isrequired") ? importEntry.getString("isrequired") : "false")).collect(Collectors.toSet());
                    HashSet tmp2Set = new HashSet(queryParamSet.size());
                    tmp2Set.addAll(queryParamSet);
                    queryParamSet.removeAll(importParamSet);
                    if (queryParamSet.size() > 0 && queryParamSet.stream().anyMatch(set -> HRStringUtils.equalsIgnoreCase((String)"true", (String)set.split("\u03b5")[1]))) {
                        importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u6307\u6807\u670d\u52a1\u53c2\u6570\u53d1\u751f\u53d8\u5316\u3002", (String)"PreIndexImportValidator_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                        break;
                    }
                    if (queryParamSet.size() > 0) {
                        AtomicBoolean dimFlag = new AtomicBoolean(true);
                        List<DynamicObject> dimMapObjects = Arrays.stream(dimMaps).filter(data -> data.getDynamicObject("preindex").getLong("id") == dynamicObject1.getLong("id")).collect(Collectors.toList());
                        dimMapObjects.forEach(obj -> {
                            DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
                            if (entryEntity.stream().anyMatch(entry -> entryParamCollection.stream().anyMatch(entry2 -> HRStringUtils.equalsIgnoreCase((String)entry2.getString("paramnumber"), (String)entry.getString("preindexparam"))))) {
                                dimFlag.set(false);
                            }
                        });
                        if (!dimFlag.get()) {
                            importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u6307\u6807\u670d\u52a1\u53c2\u6570\u53d1\u751f\u53d8\u5316\u3002", (String)"PreIndexImportValidator_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                            break;
                        }
                    }
                    importParamSet.removeAll(tmp2Set);
                    if (importParamSet.size() <= 0 || !importParamSet.stream().anyMatch(set -> HRStringUtils.equalsIgnoreCase((String)"true", (String)set.split("\u03b5")[1]))) break;
                    importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u6307\u6807\u670d\u52a1\u53c2\u6570\u53d1\u751f\u53d8\u5316\u3002", (String)"PreIndexImportValidator_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.error("\u9884\u7f6e\u6307\u6807\u6821\u9a8c\u5f02\u5e38:{}", (Object)(rowHeadNum + i), (Object)ex);
                importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u9884\u7f6e\u6307\u6807\u6821\u9a8c\u5f02\u5e38\u3002", (String)"PreIndexImportValidator_10", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                break;
            }
            importLogger.getDelRows().add(new int[]{rowHeadNum + i, rowHeadNum + i});
        }
        return false;
    }
}

