/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.preindex;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hrptmc.business.preindex.model.PresetIndexServiceParam;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;

public interface IPresetIndexCallHandler {
    public List<Object> call(PresetIndexServiceParam var1);

    default public List<QFilter> rebuildParamByDimMap(List<QFilter> paramList, DimMapBo dimMap) {
        if (CollectionUtils.isEmpty(paramList)) {
            return paramList;
        }
        List dimMapEntryBos = dimMap.getDimMapEntryBos();
        for (DimMapEntryBo dimMapEntryBo : dimMapEntryBos) {
            String paramRule = dimMapEntryBo.getParamRule();
            if ("-".equals(paramRule)) continue;
            for (QFilter qFilter : paramList) {
                this.handleDateQFilter(dimMapEntryBo, qFilter, paramList);
            }
        }
        return paramList;
    }

    default public void handleDateQFilter(DimMapEntryBo dimMapEntryBo, QFilter qFilter, List<QFilter> paramList) {
        String dimNumber = dimMapEntryBo.getDimNumber();
        String preIndexParam = dimMapEntryBo.getPreIndexParam();
        String paramRule = dimMapEntryBo.getParamRule();
        List nests = qFilter.getNests(true);
        if (nests.size() == 0) {
            return;
        }
        Iterator nestIterator = nests.iterator();
        Date realDate = new Date();
        Date startDate = new Date();
        Date endDate = new Date();
        boolean isEndDate = false;
        while (nestIterator.hasNext()) {
            QFilter currQfilter = ((QFilter.QFilterNest)nestIterator.next()).getFilter();
            String property = currQfilter.getProperty();
            if (!StringUtils.equals((CharSequence)dimNumber, (CharSequence)property)) continue;
            if (isEndDate) {
                endDate = (Date)currQfilter.getValue();
                nestIterator.remove();
                qFilter.clearNests();
                for (QFilter.QFilterNest nest : nests) {
                    qFilter.addFirstNest(nest.getFilter(), nest.getOp());
                }
                break;
            }
            startDate = (Date)currQfilter.getValue();
            currQfilter.__setProperty(preIndexParam);
            currQfilter.__setCP("=");
            isEndDate = true;
        }
        int amount = 0;
        if ("20".equals(paramRule)) {
            realDate = startDate;
        } else if ("30".equals(paramRule)) {
            realDate = endDate;
        } else if ("40".equals(paramRule)) {
            amount = -1;
            realDate = startDate;
        } else if ("50".equals(paramRule)) {
            amount = 1;
            realDate = endDate;
        }
        dimNumber = dimMapEntryBo.getPreIndexParam();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(realDate);
        calendar.add(5, amount);
        Date finalDate = calendar.getTime();
        for (QFilter qFilter2 : paramList) {
            List nests2 = qFilter2.getNests(true);
            if (nests2.size() == 0) continue;
            for (QFilter.QFilterNest qFilterNest : nests2) {
                QFilter currQfilter = qFilterNest.getFilter();
                String property = currQfilter.getProperty();
                if (!StringUtils.equals((CharSequence)dimNumber, (CharSequence)property)) continue;
                currQfilter.__setValue((Object)finalDate);
            }
        }
    }
}

