/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.preindex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.preindex.IPresetIndexCallHandler;
import kd.hr.hrptmc.business.preindex.PresetIndexServiceHelper;
import kd.hr.hrptmc.business.preindex.model.PresetIndexServiceParam;
import kd.hr.hrptmc.business.repcalculate.RepCalculateService;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;
import org.apache.commons.lang3.SerializationUtils;

public class PresetIndexCallAnObjHandler
implements IPresetIndexCallHandler,
PresetIndexConstants {
    private static final Log LOGGER = LogFactory.getLog(PresetIndexCallAnObjHandler.class);
    private final PresetIndexServiceHelper serviceHelper = new PresetIndexServiceHelper();

    @Override
    public List<Object> call(PresetIndexServiceParam params) {
        String presetIndexNumber = params.getPresetIndexNumber();
        DynamicObject presetIndex = this.serviceHelper.getPresetIndexByNumber(presetIndexNumber);
        String calMethod = presetIndex.getString("calmethod");
        String target = presetIndex.getString("target");
        Long anObjId = presetIndex.getLong("anobj.id");
        String targetFrom = presetIndex.getString("targetfrom");
        List<CalculateFieldBo> calculateFieldBos = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(anObjId, false);
        DimMapBo currDimMap = params.getDimMap();
        List<ReportField> rowList = params.getRowList();
        List<ReportField> newRowList = this.rebuildReportFieldwList(calculateFieldBos, rowList, currDimMap);
        List<ReportField> columnList = params.getColumnList();
        List<ReportField> newColumnList = this.rebuildReportFieldwList(calculateFieldBos, columnList, currDimMap);
        List<QFilter> paramList = params.getParamList();
        List<QFilter> newParamList = this.rebuildParamList(paramList, currDimMap);
        List<Object[]> valueList = params.getValueList();
        ReportCalculateInfo reportCalculateInfo = this.genSummaryReportConfigInfo(newRowList, newColumnList, calMethod, target, anObjId, targetFrom, calculateFieldBos);
        reportCalculateInfo.setqFilterList(newParamList);
        AdminOrgSummaryInfo adminOrgSummaryInfo = params.getAdminOrgSummaryInfo();
        reportCalculateInfo.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
        RepCalculateService calculateService = new RepCalculateService(reportCalculateInfo);
        DataSet dataSet = calculateService.calculate(-1, -1);
        return this.buildRspTargetValues(dataSet, newRowList, newColumnList, valueList, calMethod, target);
    }

    private List<QFilter> rebuildParamList(List<QFilter> paramList, DimMapBo currDimMap) {
        if (null == paramList) {
            return new ArrayList<QFilter>(1);
        }
        ArrayList<QFilter> copyParamList = new ArrayList<QFilter>(paramList.size());
        for (QFilter qFilter : paramList) {
            if (qFilter == null) continue;
            QFilter copy = qFilter.copy();
            copyParamList.add(copy);
        }
        paramList = this.rebuildParamByDimMap(copyParamList, currDimMap);
        return paramList;
    }

    private List<ReportField> rebuildReportFieldwList(List<CalculateFieldBo> calculateFieldBos, List<ReportField> rowList, DimMapBo currDimMap) {
        if (null == rowList) {
            return new ArrayList<ReportField>(1);
        }
        ArrayList<ReportField> cloneRowList = new ArrayList<ReportField>(rowList.size());
        Map dimMapEntryBoMap = currDimMap.getDimMapEntryBos().stream().collect(Collectors.toMap(DimMapEntryBo::getDimNumber, Function.identity()));
        Map calBoMap = calculateFieldBos.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, Function.identity()));
        rowList.forEach(row -> {
            if (row instanceof LatitudeField) {
                LatitudeField latRow = (LatitudeField)row;
                DimMapEntryBo dimMap = (DimMapEntryBo)dimMapEntryBoMap.get(latRow.getFieldAlias());
                if (dimMap == null) {
                    LatitudeField cloneRow = (LatitudeField)SerializationUtils.clone((Serializable)latRow);
                    cloneRowList.add(cloneRow);
                    return;
                }
                String mapFieldAlias = dimMap.getPreIndexParam();
                LatitudeField cloneRow = (LatitudeField)SerializationUtils.clone((Serializable)latRow);
                cloneRow.setPropFullPath(mapFieldAlias);
                cloneRow.setUniqueKey(mapFieldAlias);
                cloneRow.setFieldAlias(mapFieldAlias);
                cloneRowList.add(cloneRow);
            } else if (row instanceof AggregateIndexField) {
                AggregateIndexField latRow = (AggregateIndexField)row;
                DimMapEntryBo dimMap = (DimMapEntryBo)dimMapEntryBoMap.get(latRow.getFieldAlias());
                if (dimMap == null) {
                    AggregateIndexField cloneRow = (AggregateIndexField)SerializationUtils.clone((Serializable)latRow);
                    cloneRowList.add(cloneRow);
                    return;
                }
                String mapFieldAlias = dimMap.getPreIndexParam();
                CalculateFieldBo calculateFieldBo = (CalculateFieldBo)calBoMap.get(mapFieldAlias);
                if (calculateFieldBo != null) {
                    AggregateIndexField cloneRow = (AggregateIndexField)SerializationUtils.clone((Serializable)latRow);
                    cloneRow.setFieldAlias(mapFieldAlias);
                    cloneRow.setUniqueKey(mapFieldAlias);
                    cloneRowList.add(cloneRow);
                }
            }
        });
        return cloneRowList;
    }

    private List<QFilter> rebuildQFilter(List<QFilter> qFilters, List<ReportField> newRowList, List<ReportField> newColumnList, List<QFilter> newParamList, List<Object[]> valueList, AdminOrgSummaryInfo adminOrgSummaryInfo) {
        QFilter qFilter;
        HashSet<Object> dimNameSet;
        String dimName;
        LatitudeField latitudeField;
        if (null == qFilters) {
            qFilters = new ArrayList<QFilter>(16);
        }
        if (!CollectionUtils.isEmpty(newParamList)) {
            qFilters.addAll(newParamList);
        }
        int idx = 0;
        for (ReportField field : newRowList) {
            if (!(field instanceof LatitudeField)) continue;
            latitudeField = (LatitudeField)field;
            dimName = latitudeField.getPropFullPath();
            if (dimName.endsWith(".id")) {
                ++idx;
                continue;
            }
            if (adminOrgSummaryInfo != null && HRStringUtils.equals((String)dimName, (String)adminOrgSummaryInfo.getAdminOrgFieldAlias())) {
                ++idx;
                continue;
            }
            dimNameSet = new HashSet();
            for (Object[] value : valueList) {
                dimNameSet.add(value[idx]);
            }
            qFilter = new QFilter(dimName, "in", dimNameSet);
            qFilters.add(qFilter);
            ++idx;
        }
        for (ReportField reportField : newColumnList) {
            latitudeField = (LatitudeField)reportField;
            dimName = latitudeField.getPropFullPath();
            dimNameSet = new HashSet<Object>();
            for (Object[] value : valueList) {
                dimNameSet.add(value[idx]);
            }
            qFilter = new QFilter(dimName, "in", dimNameSet);
            qFilters.add(qFilter);
            ++idx;
        }
        return qFilters;
    }

    private List<Object> buildRspTargetValues(DataSet dataSet, List<ReportField> newRowList, List<ReportField> newColumnList, List<Object[]> valueList, String calMethod, String target) {
        int i;
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        String[] columnFieldArr = new String[fields.length];
        for (int i2 = 0; i2 < fields.length; ++i2) {
            columnFieldArr[i2] = fields[i2].getName();
        }
        List<Map<String, Object>> maps = this.dataSetToListMap(columnFieldArr, dataSet);
        Object[] dimNames = new Object[newRowList.size() + newColumnList.size()];
        for (i = 0; i < newRowList.size(); ++i) {
            dimNames[i] = newRowList.get(i);
        }
        for (i = 0; i < newColumnList.size(); ++i) {
            dimNames[i + newRowList.size()] = newColumnList.get(i);
        }
        ArrayList<Object> rspTargetValues = new ArrayList<Object>(newRowList.size() + newColumnList.size());
        for (Object[] dimValues : valueList) {
            Object targetValue = PresetIndexCallAnObjHandler.calTargetValue(dimNames, dimValues, maps, calMethod, target);
            rspTargetValues.add(targetValue);
        }
        return rspTargetValues;
    }

    private List<Map<String, Object>> dataSetToListMap(String[] columnFieldArr, DataSet dataSet) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try (DataSet copy = dataSet.copy();){
            while (copy.hasNext()) {
                Row rs = copy.next();
                HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
                for (String fieldName : columnFieldArr) {
                    Object val = rs.get(fieldName);
                    resultMap.put(fieldName, val);
                }
                resultList.add(resultMap);
            }
        }
        return resultList;
    }

    private static Object calTargetValue(Object[] dimNames, Object[] dimValues, List<Map<String, Object>> maps, String calMethod, String target) {
        Object targetValue = null;
        for (Map<String, Object> currMap : maps) {
            boolean allEqual = true;
            for (int j = 0; j < dimValues.length; ++j) {
                Object dimName = dimNames[j];
                Object dimValue = dimValues[j];
                Object dbDimValue = currMap.get(((ReportField)dimName).getUniqueKey());
                if (dbDimValue instanceof OrmLocaleValue) {
                    if (ObjectUtils.nullSafeEquals((Object)dimValue, (Object)((OrmLocaleValue)dbDimValue).getLocaleValue())) continue;
                    allEqual = false;
                    break;
                }
                if (ObjectUtils.nullSafeEquals((Object)dimValue, (Object)dbDimValue)) continue;
                allEqual = false;
                break;
            }
            if (!allEqual) continue;
            targetValue = currMap.get(target);
            break;
        }
        return targetValue;
    }

    private ReportCalculateInfo genSummaryReportConfigInfo(List<ReportField> newRowList, List<ReportField> newColumnList, String calMethod, String target, Long anObjId, String targetFrom, List<CalculateFieldBo> calculateFieldBos) {
        String fieldType;
        ReportCalculateInfo calculateInfo = new ReportCalculateInfo();
        calculateInfo.setAnObjRelId(anObjId);
        calculateInfo.setReportType("0");
        ArrayList<ReportField> reportFields = new ArrayList<ReportField>();
        reportFields.addAll(newRowList);
        reportFields.addAll(newColumnList);
        ArrayList<EntityPropField> rowFieldList = new ArrayList<EntityPropField>();
        QFilter anObjIdFilter = new QFilter("anobj", "=", (Object)anObjId);
        QFilter targetFilter = new QFilter("number", "=", (Object)target);
        QFilter[] qFilters = new QFilter[]{anObjIdFilter, targetFilter};
        HRBaseServiceHelper calHelper = new HRBaseServiceHelper("hrptmc_calculatefield");
        DynamicObject calDy = calHelper.queryOriginalOne("valuetype", qFilters);
        if (calDy != null) {
            fieldType = calDy.getString("valuetype");
        } else {
            targetFilter = new QFilter("fieldalias", "=", (Object)target);
            HRBaseServiceHelper qryHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
            QFilter[] qFilters2 = new QFilter[]{anObjIdFilter, targetFilter};
            DynamicObject qryDy = qryHelper.queryOriginalOne("valuetype", qFilters2);
            fieldType = qryDy != null ? qryDy.getString("valuetype") : DataTypeEnum.BIGDECIMAL.getDataTypeKey();
        }
        if ("10".equals(targetFrom)) {
            Map calFieldMap = calculateFieldBos.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, Function.identity()));
            CalculateFieldBo calculateFieldBo = (CalculateFieldBo)calFieldMap.get(target);
            ArrayList aggregateIndexFields = Lists.newArrayListWithCapacity((int)10);
            HashSet refQueryFields = Sets.newHashSetWithExpectedSize((int)16);
            aggregateIndexFields.add(this.calculateFieldBo2AggregateIndexField(calMethod, calculateFieldBo, refQueryFields, false));
            for (CalculateFieldBo refCalculateField : calculateFieldBo.getRefCalculateFields()) {
                this.transferCalculateField(calMethod, refCalculateField, aggregateIndexFields, refQueryFields);
            }
            rowFieldList.addAll(aggregateIndexFields);
            if (!refQueryFields.isEmpty()) {
                List<QueryFieldBo> queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
                for (QueryFieldBo queryFieldBo : queryFieldBos) {
                    if (!refQueryFields.contains(queryFieldBo.getFieldAlias())) continue;
                    EntityPropField entityPropField = this.queryFieldBo2EntityPropField(queryFieldBo);
                    entityPropField.setDependField(true);
                    rowFieldList.add(entityPropField);
                }
            }
        } else if ("20".equals(targetFrom)) {
            EntityPrimitiveIndexField entityPrimitiveIndexField = new EntityPrimitiveIndexField();
            entityPrimitiveIndexField.setUniqueKey(target);
            entityPrimitiveIndexField.setFieldAlias(target);
            entityPrimitiveIndexField.setPropFullPath(target);
            entityPrimitiveIndexField.setFieldType(fieldType);
            if ("20".equals(calMethod)) {
                entityPrimitiveIndexField.setCalcFunction("avg");
            } else {
                entityPrimitiveIndexField.setCalcFunction("sum");
            }
            rowFieldList.add(entityPrimitiveIndexField);
        }
        reportFields.addAll(rowFieldList);
        calculateInfo.setRowFieldList(reportFields);
        return calculateInfo;
    }

    private void transferCalculateField(String calMethod, CalculateFieldBo calculateFieldBo, List<AggregateIndexField> aggregateIndexFields, Set<String> refQueryFields) {
        List refCalculateFields = calculateFieldBo.getRefCalculateFields();
        for (CalculateFieldBo refCalculateField : refCalculateFields) {
            this.transferCalculateField(calMethod, refCalculateField, aggregateIndexFields, refQueryFields);
        }
        aggregateIndexFields.add(this.calculateFieldBo2AggregateIndexField(calMethod, calculateFieldBo, refQueryFields, true));
    }

    private AggregateIndexField calculateFieldBo2AggregateIndexField(String calMethod, CalculateFieldBo calculateFieldBo, Set<String> refQueryFields, boolean isDepend) {
        AggregateIndexField aggregateIndexField = new AggregateIndexField();
        if (!isDepend) {
            aggregateIndexField.setUniqueKey(calculateFieldBo.getFieldNumber());
            if ("20".equals(calMethod)) {
                aggregateIndexField.setCalcFunction("avg");
            } else {
                aggregateIndexField.setCalcFunction("sum");
            }
        }
        aggregateIndexField.setFieldAlias(calculateFieldBo.getFieldNumber());
        aggregateIndexField.setFieldType(calculateFieldBo.getValueType());
        aggregateIndexField.setCalcFormulaInfo(calculateFieldBo.getExpr());
        aggregateIndexField.setDependField(isDepend);
        HashSet<String> dependentFieldSet = new HashSet<String>(calculateFieldBo.getRefEntityFields());
        dependentFieldSet.addAll(calculateFieldBo.getRefCalculateFields().stream().map(CalculateFieldBo::getFieldNumber).collect(Collectors.toList()));
        dependentFieldSet.addAll(calculateFieldBo.getRefEntityFields());
        refQueryFields.addAll(calculateFieldBo.getRefEntityFields());
        aggregateIndexField.setDependentFieldSet(dependentFieldSet);
        return aggregateIndexField;
    }

    private EntityPropField queryFieldBo2EntityPropField(QueryFieldBo queryFieldBo) {
        if (AnalyseObjectService.getInstance().isIndexField(queryFieldBo.getValueType())) {
            return this.queryFieldBo2EntityPrimitiveIndexField(queryFieldBo);
        }
        return this.queryFieldBo2LatitudeField(queryFieldBo);
    }

    private EntityPrimitiveIndexField queryFieldBo2EntityPrimitiveIndexField(QueryFieldBo queryFieldBo) {
        EntityPrimitiveIndexField entityPrimitiveIndexField = new EntityPrimitiveIndexField();
        entityPrimitiveIndexField.setFieldAlias(queryFieldBo.getFieldAlias());
        entityPrimitiveIndexField.setFieldType(queryFieldBo.getValueType());
        entityPrimitiveIndexField.setPropFullPath(queryFieldBo.getFieldPath());
        entityPrimitiveIndexField.setPropName(queryFieldBo.getFieldName().getLocaleValue());
        return entityPrimitiveIndexField;
    }

    private LatitudeField queryFieldBo2LatitudeField(QueryFieldBo queryFieldBo) {
        LatitudeField latitudeField = new LatitudeField();
        latitudeField.setFieldAlias(queryFieldBo.getFieldAlias());
        latitudeField.setFieldType(queryFieldBo.getValueType());
        latitudeField.setPropFullPath(queryFieldBo.getFieldPath());
        latitudeField.setPropName(queryFieldBo.getFieldName().getLocaleValue());
        return latitudeField;
    }
}

