/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.publish;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.publish.GenMetaDataHelper;
import kd.hr.hrptmc.business.repdesign.ReportManageService;

public class HRReportPublishDyFormControlService {
    private static final Log log = LogFactory.getLog(HRReportPublishDyFormControlService.class);

    public void addDynamicFormControl(long reportManageId) {
        HRBaseServiceHelper entityObject;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("id,name,number,publishstatus", (Object)reportManageId);
        if (reportDy == null) {
            return;
        }
        String publishStatus = reportDy.getString("publishstatus");
        if (!HRStringUtils.equals((String)publishStatus, (String)"A")) {
            return;
        }
        String number = reportDy.getString("number");
        Map<String, Map<String, String>> permissionField = ReportManageService.getPermFieldNumberMapNoSubEnum(reportManageId);
        DynamicObject dynFormCtrl = (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"get", (Object[])new Object[]{number});
        if (dynFormCtrl == null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl");
            dynFormCtrl = serviceHelper.generateEmptyDynamicObject();
            entityObject = new HRBaseServiceHelper("bos_entityobject");
            DynamicObject dynamicObject = entityObject.queryOne("", (Object)number);
            dynFormCtrl.set("entitytype", (Object)dynamicObject);
            this.setAppId(dynFormCtrl, number);
        }
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)permissionField.size());
        for (Map map : permissionField.values()) {
            if (map.get("baseDataNum") == null) continue;
            numberList.add(map.get("baseDataNum"));
        }
        entityObject = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] dynamicObjectArray = entityObject.query("id", new QFilter[]{new QFilter("id", "in", (Object)numberList)});
        Map<String, DynamicObject> boMap = Arrays.stream(dynamicObjectArray).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
        DynamicObjectCollection entryEntity = dynFormCtrl.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        for (Map.Entry<String, Map<String, String>> stringMapEntry : permissionField.entrySet()) {
            String key = stringMapEntry.getKey();
            Map<String, String> value = stringMapEntry.getValue();
            DynamicObject entryDyna = new DynamicObject(dynamicObjectType);
            entryDyna.set("propkey", (Object)key);
            entryDyna.set("propname", (Object)value.get("name"));
            if (value.get("baseDataNum") != null) {
                entryDyna.set("bdtype", (Object)boMap.get(value.get("baseDataNum")));
                String baseDataNum = value.get("baseDataNum");
                if (HRStringUtils.equals((String)baseDataNum, (String)"bos_org")) {
                    entryDyna.set("bucafunc", (Object)value.get("bucafunc"));
                }
            }
            entryDyna.set("issyspreset", (Object)"0");
            entryEntity.add((Object)entryDyna);
        }
        OperationResult result = permissionField.size() == 0 ? (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"remove", (Object[])new Object[]{number}) : (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"save", (Object[])new Object[]{dynFormCtrl});
        if (result.isSuccess()) {
            log.info("removeDynamicFormControl success,number:{} ", (Object)reportManageId);
        } else {
            log.error("removeDynamicFormControl fail,", (Object)result.toString());
        }
    }

    private void setAppId(DynamicObject dynFormCtrl, String number) {
        Map map;
        Map lastestMetadata = MetadataDao.loadDesignerMetadata((String)GenMetaDataHelper.getMetaIdByNumber(number));
        if (lastestMetadata == null) {
            return;
        }
        Map entitymeta = (Map)lastestMetadata.get("entitymeta");
        if (entitymeta == null) {
            return;
        }
        ArrayList items = (ArrayList)entitymeta.get("Items");
        if (items != null && items.size() > 0 && (map = (Map)items.get(0)) != null) {
            Map permissionDimension = (Map)map.get("PermissionDimension");
            if (permissionDimension.get("PublishApps") == null) {
                return;
            }
            String publishApps = (String)permissionDimension.get("PublishApps");
            List objects = SerializationUtils.fromJsonStringToList((String)publishApps, String.class);
            if (CollectionUtils.isEmpty((Collection)objects)) {
                return;
            }
            String appId = (String)objects.get(0);
            dynFormCtrl.set("app", (Object)appId);
        }
    }

    public void removeDynamicFormControl(Long reportManageId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("id,name,number", (Object)reportManageId);
        String number = reportDy.getString("number");
        OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"remove", (Object[])new Object[]{number});
        if (result.isSuccess()) {
            log.info("removeDynamicFormControl success,number:{} ", (Object)number);
        } else {
            log.error("removeDynamicFormControl fail,number:{} ", (Object)number);
        }
    }
}

