/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.publish;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.entity.AppMenuInfo;
import kd.hr.hrptmc.business.publish.GenMetaDataHelper;
import kd.hr.hrptmc.business.publish.HRReportPublishDyFormControlService;
import kd.hr.hrptmc.common.constant.publish.HRPublishConstants;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class HRReportPublishMenuService
implements HRPublishConstants {
    private static final Log log = LogFactory.getLog(HRReportPublishMenuService.class);
    private String metaNumber;
    private String metaName;

    public HRReportPublishMenuService(String metaNumber, String metaName) {
        this.metaNumber = metaNumber;
        this.metaName = metaName;
    }

    @SdkInternal
    public String checkBeforeSave(long reportId) {
        String msg = this.checkNumberAndName();
        if (msg != null) {
            return msg;
        }
        if (!this.isReportExistById(reportId) && this.isMetaExist(this.metaNumber)) {
            return ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u5b58\u5728\u5143\u6570\u636e\u3002\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u68c0\u67e5\u76f8\u5e94\u5143\u6570\u636e\uff0c\u6216\u91cd\u65b0\u8f93\u5165\u3002", (String)"HRReportPublishMenuService_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]);
        }
        return null;
    }

    public Map<String, Object> newOrEditMeta(String appId) {
        String bizAppId = "2VKJ94YEM7AU";
        String currentIsv = GenMetaDataHelper.getCurrentIsv();
        if (!"kingdee".equals(currentIsv)) {
            String selectProps = "id,isv,number,inheritpath";
            QFilter inheritPathFilter = new QFilter("inheritpath", "like", (Object)"%2VKJ94YEM7AU%");
            QFilter isvFilter = new QFilter("isv", "=", (Object)currentIsv);
            DynamicObject[] dynObjects = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selectProps, (QFilter[])new QFilter[]{inheritPathFilter, isvFilter});
            if (dynObjects != null && dynObjects.length > 0) {
                DynamicObject appExdDy = HRReportPublishMenuService.getAppExdDy(dynObjects);
                if (appExdDy != null) {
                    bizAppId = appExdDy.getString("id");
                }
            } else {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u975e\u91d1\u8776\u5f00\u53d1\u5546\uff0c\u8bf7\u5148\u6269\u5c55HR\u62a5\u8868\u7ba1\u7406\u5e94\u7528\uff0c\u521b\u5efa\u6269\u5c55\u5e94\u7528\u3002", (String)"HRReportPublishMenuService_6", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), new Object[0]));
            }
        }
        return this.newOrEditMeta(appId, bizAppId);
    }

    private Map<String, Object> newOrEditMeta(String appId, String bizAppId) {
        Map<String, Object> result;
        if (!this.isMetaExist(this.metaNumber)) {
            log.info("\u521b\u5efa\u62a5\u8868\u5143\u6570\u636e newMeta ");
            result = GenMetaDataHelper.createMetaAndSave(this.metaNumber, this.metaName, "DynamicFormModel", "2TM0OXNJ06ZJ", "2X2B7629C+X1", bizAppId, appId);
        } else {
            log.info("\u7f16\u8f91\u62a5\u8868\u5143\u6570\u636e editMeta ");
            Map content = MetadataDao.loadDesignerMetadata((String)GenMetaDataHelper.getMetaIdByNumber(this.metaNumber));
            Map formMeta = (Map)content.get("formmeta");
            String metaIsv = (String)formMeta.get("Isv");
            String curIsv = AppUtils.getDeveloperInfo();
            if (curIsv.equals(metaIsv)) {
                result = GenMetaDataHelper.editMetadata(this.metaNumber, this.metaName, appId);
            } else {
                String extMetaNumber = DevportalUtil.autoIsvNumber((String)this.metaNumber);
                if (this.isMetaExist(extMetaNumber)) {
                    result = GenMetaDataHelper.editMetadata(extMetaNumber, this.metaName, appId);
                } else {
                    String parentId = GenMetaDataHelper.getMetaIdByNumber(this.metaNumber);
                    result = GenMetaDataHelper.createExtMetaAndSave(extMetaNumber, this.metaName, "DynamicFormModel", parentId, "2X2B7629C+X1", bizAppId, appId);
                }
            }
        }
        return result;
    }

    @SdkInternal
    public Map<String, Object> publish(Map<String, Object> chooseData) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        String currentIsv = GenMetaDataHelper.getCurrentIsv();
        String cloudId = (String)chooseData.get("cloudid");
        String appId = (String)chooseData.get("appid");
        String level = (String)chooseData.get("level");
        result.put("success", Boolean.TRUE);
        AppMenuInfo appMenuInfo = new AppMenuInfo();
        appMenuInfo.setMenuName(this.metaName);
        appMenuInfo.setFormId((String)chooseData.get("formId"));
        appMenuInfo.setFormName(this.metaName);
        appMenuInfo.setFormNumber(this.metaNumber);
        appMenuInfo.setDescription("");
        appMenuInfo.setSeq(0);
        appMenuInfo.setVectorValue("");
        appMenuInfo.setShortCutEntrance("");
        appMenuInfo.setPermissionId("");
        appMenuInfo.setCaption("");
        appMenuInfo.setParameter("");
        appMenuInfo.setParameterType("FormShowParameter");
        appMenuInfo.setOpenType("MainNewTabPage");
        if ("kingdee".equals(currentIsv)) {
            appMenuInfo.setBizAppId(appId);
            this.publishToMenu(chooseData, result, appId, level, appMenuInfo);
        } else {
            QFilter isvFilter;
            if (StringUtils.isBlank((CharSequence)currentIsv)) {
                result.put("success", Boolean.FALSE);
                result.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5546\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"HRReportPublishMenuService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                return result;
            }
            QFilter appIdFilter = new QFilter("id", "=", (Object)appId);
            QFilter qFilter = new QFilter("isv", "=", (Object)currentIsv);
            DynamicObject[] appObjs1 = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"isv", (QFilter[])new QFilter[]{appIdFilter, qFilter});
            if (appObjs1 != null && appObjs1.length > 0) {
                appMenuInfo.setBizAppId(appId);
                this.publishToMenu(chooseData, result, appId, level, appMenuInfo);
                return result;
            }
            String selProp = "id,isv,number,inheritpath";
            QFilter inheritPathFilter = new QFilter("inheritpath", "like", (Object)("%" + appId + "%"));
            DynamicObject[] appObjs = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selProp, (QFilter[])new QFilter[]{inheritPathFilter, isvFilter = new QFilter("isv", "=", (Object)currentIsv)});
            if (appObjs != null && appObjs.length > 0) {
                DynamicObject appExdDy = HRReportPublishMenuService.getAppExdDy(appObjs);
                if (appExdDy != null) {
                    String extendAppId = appExdDy.getString("id");
                    appMenuInfo.setBizAppId(extendAppId);
                    this.publishToMenu(chooseData, result, extendAppId, level, appMenuInfo);
                }
            } else {
                String extendAppId;
                appObjs = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selProp, (QFilter[])new QFilter[]{inheritPathFilter});
                DynamicObject appExdDy = HRReportPublishMenuService.getAppExdDy(appObjs);
                String toExdAppId = appId;
                if (appExdDy != null && StringUtils.isNotBlank((CharSequence)appExdDy.getString("id"))) {
                    toExdAppId = appExdDy.getString("id");
                }
                if ((extendAppId = GenMetaDataHelper.createExtendApp(cloudId, toExdAppId)) != null) {
                    appMenuInfo.setBizAppId(extendAppId);
                    this.publishToMenu(chooseData, result, extendAppId, level, appMenuInfo);
                } else {
                    result.put("success", Boolean.FALSE);
                    result.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5546\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"HRReportPublishMenuService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    private static DynamicObject getAppExdDy(DynamicObject[] appObjs) {
        if (appObjs != null && appObjs.length > 0) {
            DynamicObject appObjExd = null;
            for (DynamicObject appObjDy : appObjs) {
                if (appObjExd == null) {
                    appObjExd = appObjDy;
                    continue;
                }
                String inheritPathExd = appObjExd.getString("inheritpath");
                String inheritPath = appObjDy.getString("inheritpath");
                if (!StringUtils.isNotBlank((CharSequence)inheritPathExd) || !StringUtils.isNotBlank((CharSequence)inheritPath) || inheritPath.length() <= inheritPathExd.length()) continue;
                appObjExd = appObjDy;
            }
            return appObjExd;
        }
        return null;
    }

    private void publishToMenu(Map<String, Object> chooseData, Map<String, Object> result, String appId, String level, AppMenuInfo appMenuInfo) {
        appMenuInfo.setBizAppId(appId);
        if ("appnode".equals(level)) {
            appMenuInfo.setParentNodeId(appId);
            String newMenuId = GenMetaDataHelper.createAppMenuAndSave(appMenuInfo);
            result.put("menuId", newMenuId);
            result.put("appId", appId);
        } else if ("firmenunode".equals(level)) {
            appMenuInfo.setParentNodeId((String)chooseData.get("menuid"));
            String newMenuId = GenMetaDataHelper.createAppMenuAndSave(appMenuInfo);
            result.put("menuId", newMenuId);
            result.put("appId", appId);
        } else if ("secmenunode".equals(level)) {
            appMenuInfo.setParentNodeId((String)chooseData.get("menuid2"));
            String newMenuId = GenMetaDataHelper.createAppMenuAndSave(appMenuInfo);
            result.put("menuId", newMenuId);
            result.put("appId", appId);
        } else {
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u6216\u83dc\u5355\u8282\u70b9\u3002", (String)"HRReportPublishMenuService_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
    }

    @SdkInternal
    public static Map<String, Object> offline(String menuId, String bizAppId) {
        return GenMetaDataHelper.deleteMenuById(menuId, bizAppId);
    }

    @SdkInternal
    public String checkNumberAndName() {
        StringBuilder errorMsg = GenMetaDataHelper.validateNameAndNumber(this.metaNumber, this.metaName);
        String msg = errorMsg.toString();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        return null;
    }

    private boolean isReportExistByIdAndNumber(long reportId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        QFilter qFilter = new QFilter("number", "=", (Object)this.metaNumber);
        qFilter.and(new QFilter("id", "=", (Object)reportId));
        return helper.isExists(qFilter);
    }

    private boolean isReportExistById(long reportId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        QFilter qFilter = new QFilter("id", "=", (Object)reportId);
        return helper.isExists(qFilter);
    }

    private boolean isMetaExist(String metaNumber) {
        if (StringUtils.isEmpty((CharSequence)metaNumber)) {
            return false;
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        return metaDataUtil.checkNumber(metaNumber.toLowerCase());
    }

    @SdkInternal
    public static void showChooseMenuForm(IFormView formView, String pluginName, String callBackId, String number, String name, String rptManageId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("number", (Object)number);
        showParameter.setCustomParam("name", (Object)name);
        showParameter.setCustomParam("rptManageId", (Object)rptManageId);
        showParameter.setFormId("hrptmc_choosepublishmenu");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(pluginName, callBackId));
        formView.showForm(showParameter);
    }

    @SdkInternal
    public static void publishClosedCallBack(IFormView formView, ClosedCallBackEvent callBackEvent) {
        Map returnData = (Map)callBackEvent.getReturnData();
        if (returnData != null) {
            OperateOption publishOperate = HRReportPublishMenuService.createPublishOperateOption(returnData);
            formView.invokeOperation("publish", publishOperate);
        }
    }

    @SdkInternal
    public static OperateOption createPublishOperateOption(Map<String, Object> returnData) {
        OperateOption publishOperate = OperateOption.create();
        publishOperate.setVariableValue("isChoosePublishMenu", "true");
        publishOperate.setVariableValue("level", (String)returnData.get("level"));
        publishOperate.setVariableValue("cloudid", (String)returnData.get("cloudid"));
        publishOperate.setVariableValue("appid", (String)returnData.get("appid"));
        publishOperate.setVariableValue("menuid", (String)returnData.get("menuid"));
        publishOperate.setVariableValue("menuid2", (String)returnData.get("menuid2"));
        publishOperate.setVariableValue("name", (String)returnData.get("name"));
        publishOperate.setVariableValue("number", (String)returnData.get("number"));
        publishOperate.setVariableValue("rptManageId", (String)returnData.get("rptManageId"));
        return publishOperate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveRptMenuInfo(Map<String, Object> publishMetaResult, long reportManageId) {
        HRBaseServiceHelper menuHelper = new HRBaseServiceHelper("hrptmc_publishmenu");
        DynamicObject publishMenuDy = menuHelper.generateEmptyDynamicObject();
        publishMenuDy.set("menu", publishMetaResult.get("menuId"));
        publishMenuDy.set("menuapp", publishMetaResult.get("appId"));
        publishMenuDy.set("reportmanage", (Object)reportManageId);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        publishMenuDy.set("creator", (Object)currUserId);
        publishMenuDy.set("createtime", (Object)date);
        publishMenuDy.set("modifier", (Object)currUserId);
        publishMenuDy.set("modifytime", (Object)date);
        HRBaseServiceHelper rptHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportManageDy = rptHelper.queryOne("id,publishstatus", (Object)reportManageId);
        reportManageDy.set("publishstatus", (Object)"A");
        boolean isSaved = true;
        try (TXHandle txHandle = TX.requiresNew();){
            menuHelper.saveOne(publishMenuDy);
            rptHelper.saveOne(reportManageDy);
        }
        return isSaved;
    }

    public static Map<String, Object> genDataMate(IFormView view, BeforeDoOperationEventArgs args, AbstractOperate op) {
        Map<String, Object> createMetaResult;
        HRReportPublishMenuService service = new HRReportPublishMenuService(op.getOption().getVariableValue("number"), op.getOption().getVariableValue("name"));
        String currentIsv = GenMetaDataHelper.getCurrentIsv();
        String bizAppId = "2VKJ94YEM7AU";
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5546\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"HRReportPublishMenuService_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            return null;
        }
        if (!"kingdee".equals(currentIsv)) {
            String selProp = "id,isv,number,inheritpath";
            QFilter inheritPathFilter = new QFilter("inheritpath", "like", (Object)"%2VKJ94YEM7AU%");
            QFilter isvFilter = new QFilter("isv", "=", (Object)currentIsv);
            DynamicObject[] appObjs = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selProp, (QFilter[])new QFilter[]{inheritPathFilter, isvFilter});
            if (appObjs != null && appObjs.length > 0) {
                DynamicObject appExdDy = HRReportPublishMenuService.getAppExdDy(appObjs);
                if (appExdDy != null) {
                    bizAppId = appExdDy.getString("id");
                }
            } else {
                String extendAppId = GenMetaDataHelper.createExtendApp("0PEIU203SX4Y", "2VKJ94YEM7AU");
                if (extendAppId != null) {
                    bizAppId = extendAppId;
                } else {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5546\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"HRReportPublishMenuService_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                    return null;
                }
            }
        }
        if ((createMetaResult = service.newOrEditMeta(op.getOption().getVariableValue("appid"), bizAppId)).containsKey("success") && !((Boolean)createMetaResult.get("success")).booleanValue()) {
            args.setCancel(true);
            String errMsg = (String)createMetaResult.get("message");
            view.showErrorNotification(!StringUtils.isEmpty((CharSequence)errMsg) ? errMsg : ResManager.loadKDString((String)"\u62a5\u8868\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRReportPublishMenuService_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            log.error("Save metadata failed!Result:{}", (Object)SerializationUtils.toJsonString(createMetaResult));
            return null;
        }
        return createMetaResult;
    }

    @SdkInternal
    public static boolean doingPublish(IFormView view, BeforeDoOperationEventArgs args, AbstractOperate op) {
        if (op.getOption().tryGetVariableValue("isChoosePublishMenu", new RefObject())) {
            HashMap chooseData = Maps.newHashMapWithExpectedSize((int)16);
            chooseData.put("level", op.getOption().getVariableValue("level"));
            chooseData.put("cloudid", op.getOption().getVariableValue("cloudid"));
            chooseData.put("appid", op.getOption().getVariableValue("appid"));
            chooseData.put("menuid", op.getOption().getVariableValue("menuid"));
            chooseData.put("menuid2", op.getOption().getVariableValue("menuid2"));
            HRReportPublishMenuService service = new HRReportPublishMenuService(op.getOption().getVariableValue("number"), op.getOption().getVariableValue("name"));
            Map<String, Object> createMetaResult = HRReportPublishMenuService.genDataMate(view, args, op);
            if (null == createMetaResult) {
                return true;
            }
            chooseData.put("formId", createMetaResult.get("formid"));
            Map<String, Object> publishMetaResult = service.publish(chooseData);
            if (createMetaResult.containsKey("success") && ((Boolean)publishMetaResult.get("success")).booleanValue()) {
                if (HRReportPublishMenuService.saveRptMenuInfo(publishMetaResult, Long.parseLong(op.getOption().getVariableValue("rptManageId")))) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"HRReportPublishMenuService_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                }
            } else {
                args.setCancel(true);
                String errMsg = (String)publishMetaResult.get("message");
                view.showErrorNotification(!StringUtils.isEmpty((CharSequence)errMsg) ? errMsg : ResManager.loadKDString((String)"\u62a5\u8868\u53d1\u5e03\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRReportPublishMenuService_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    @SdkInternal
    public static boolean checkIsPublish(Object primaryKeyValue) {
        String publishStatus;
        boolean isPublish = false;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("id,name,number,publishstatus", primaryKeyValue);
        if (reportDy != null && "A".equals(publishStatus = reportDy.getString("publishstatus"))) {
            isPublish = true;
        }
        return isPublish;
    }

    @SdkInternal
    public static Boolean[] getPublishStatus(Object primaryKeyValue) {
        Boolean[] publishStatue = new Boolean[]{false, false};
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("id,name,number,publishstatus,publishrptstatus", primaryKeyValue);
        if (reportDy != null) {
            publishStatue[0] = "A".equals(reportDy.getString("publishstatus"));
            publishStatue[1] = "A".equals(reportDy.getString("publishrptstatus"));
        }
        return publishStatue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SdkInternal
    public static boolean doingOffline(Object primaryKeyValue) throws KDBizException {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("id,name,number,publishstatus", primaryKeyValue);
        if (reportDy == null) return true;
        String publishStatus = reportDy.getString("publishstatus");
        if (!"A".equals(publishStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u672a\u53d1\u5e03\uff0c\u65e0\u9700\u4e0b\u7ebf\u3002", (String)"ReportManageList_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        HRBaseServiceHelper menuHelper = new HRBaseServiceHelper("hrptmc_publishmenu");
        QFilter qFilter = new QFilter("reportmanage", "=", primaryKeyValue);
        DynamicObject[] menuDys = menuHelper.query("id,menu,menuapp", qFilter.toArray());
        if (menuDys != null && menuDys.length == 1) {
            String appId;
            String menuId = menuDys[0].getString("menu");
            Map<String, Object> result = HRReportPublishMenuService.offline(menuId, appId = menuDys[0].getString("menuapp"));
            if (!result.containsKey("success") || !((Boolean)result.get("success")).booleanValue()) throw new KDBizException(String.valueOf(result.get("message")));
            menuHelper.deleteByFilter(qFilter.toArray());
            reportDy.set("publishstatus", (Object)"B");
            helper.saveOne(reportDy);
            return true;
        } else if (menuDys != null && menuDys.length > 1) {
            for (DynamicObject menuDy : menuDys) {
                String appId;
                String menuId = menuDy.getString("menu");
                Map<String, Object> result = HRReportPublishMenuService.offline(menuId, appId = menuDy.getString("menuapp"));
                if (!result.containsKey("success") || !((Boolean)result.get("success")).booleanValue()) {
                    throw new KDBizException(String.valueOf(result.get("message")));
                }
                menuHelper.deleteOne((Object)menuDy.getLong("id"));
            }
            reportDy.set("publishstatus", (Object)"B");
            helper.saveOne(reportDy);
            return true;
        } else {
            reportDy.set("publishstatus", (Object)"B");
            helper.saveOne(reportDy);
        }
        return true;
    }

    public static void addDynamicFormControl(long reportManageId) {
        HRReportPublishDyFormControlService hrReportPublishDyFormControlService = new HRReportPublishDyFormControlService();
        hrReportPublishDyFormControlService.addDynamicFormControl(reportManageId);
    }

    public static void removeDynamicFormControl(long reportManageId) {
        HRReportPublishDyFormControlService hrReportPublishDyFormControlService = new HRReportPublishDyFormControlService();
        hrReportPublishDyFormControlService.removeDynamicFormControl(reportManageId);
    }

    public static void updateReportStatusUnpublished(long reportManageId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("id,publishrptstatus", (Object)reportManageId);
        if (reportDy != null) {
            reportDy.set("publishrptstatus", (Object)"B");
            helper.saveOne(reportDy);
        }
    }

    public static void updateReportStatusPublished(long reportManageId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("id,publishrptstatus", (Object)reportManageId);
        if (reportDy != null) {
            reportDy.set("publishrptstatus", (Object)"A");
            helper.saveOne(reportDy);
        }
    }
}

