/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContextOptimizer;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.ReportTimeZoneUtil;
import kd.hr.hrptmc.business.anobj.AnalyseObjectPivotService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.anobj.virtualentity.VirtualEntityService;
import kd.hr.hrptmc.business.center.query.EsQueryConverter;
import kd.hr.hrptmc.business.datastore.metadata.util.RptDataExtractQueryConverter;
import kd.hr.hrptmc.business.repcalculate.CalculateFactory;
import kd.hr.hrptmc.business.repcalculate.CalculateStrategy;
import kd.hr.hrptmc.business.repcalculate.algox.helper.AlgoxJobKeyHelper;
import kd.hr.hrptmc.business.repcalculate.chart.RptChartQueryAdapterFactory;
import kd.hr.hrptmc.business.repcalculate.chart.adapter.AbstractRptChartQueryAdapter;
import kd.hr.hrptmc.business.repcalculate.model.RepQueryConfigBo;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.org.helper.AdminOrgCalHelper;
import kd.hr.hrptmc.business.repcalculate.utils.FilterUtils;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldUtils;
import kd.hr.hrptmc.business.repcalculate.utils.SortFieldUtil;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import kd.hr.hrptmc.common.util.HRReportParamUtils;
import org.apache.commons.collections.CollectionUtils;

public class CalculateContext {
    private final ReportCalculateInfo calculateInfo;
    private HRComplexObjContext complexObjContext;
    private CalculateStrategy calculate;
    private boolean needPage = true;

    public CalculateContext(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        this.paramCheck(calculateInfo);
        this.calculateInfo = calculateInfo;
        this.complexObjContext = complexObjContext;
        this.init(calculateInfo);
    }

    public CalculateContext(ReportCalculateInfo calculateInfo) {
        this.paramCheck(calculateInfo);
        this.calculateInfo = calculateInfo;
        this.init(calculateInfo);
    }

    private void init(ReportCalculateInfo calculateInfo) {
        String anObjQueryScheme;
        for (ReportField reportField : calculateInfo.getRowFieldList()) {
            if (!DataTypeEnum.DATETIME.getDataTypeKey().equals(reportField.getFieldType()) || !reportField.getFieldAlias().contains("!")) continue;
            reportField.setSortord(null);
        }
        RepQueryConfigBo repQueryConfigBo = AnalyseObjectService.getInstance().queryRepQueryConfigBo(calculateInfo.getReportId(), null);
        this.initQueryDataContext(repQueryConfigBo);
        if (repQueryConfigBo.isEnableEntityJoinOptimize()) {
            HRComplexObjContextOptimizer.optimize((HRComplexObjContext)this.complexObjContext);
        }
        if (calculateInfo.isAlgoX()) {
            anObjQueryScheme = "2";
            this.complexObjContext.setQueryScheme("2");
        } else {
            anObjQueryScheme = repQueryConfigBo.getQueryScheme();
        }
        this.complexObjContext.setKSQLDetailOptimize(repQueryConfigBo.isKsqlDetailOptimize());
        this.complexObjContext.setAlgoXOptimizedDimCount(repQueryConfigBo.getAlgoXOptimizedDimCount());
        this.complexObjContext.setAlgoXOptimizeDataCount(repQueryConfigBo.getAlgoXOptimizeDataCount());
        this.complexObjContext.setkSqlCountBatch(repQueryConfigBo.getkSqlCountBatch());
        this.complexObjContext.setkSqlSumBatch(repQueryConfigBo.getkSqlSumBatch());
        this.complexObjContext.setkSqlSumThreshold(repQueryConfigBo.getkSqlSumThreshold());
        this.complexObjContext.setAlgoXDetailOptimize(calculateInfo.isAlgoXDetailOptimize());
        this.calculate = CalculateFactory.getCalculate(anObjQueryScheme, this.complexObjContext, calculateInfo);
        this.complexObjContext.setTransferField(calculateInfo.isTransferField());
        this.complexObjContext.setCurrentUserDateFormat(ReportTimeZoneUtil.getUserDateFormat());
        this.complexObjContext.setCurrentUserDateTimeFormat(ReportTimeZoneUtil.getUserDateTimeFormat());
        this.complexObjContext.setEsQuery(calculateInfo.isEsQuery());
        this.complexObjContext.setEsIndex(calculateInfo.getEsIndex());
        this.complexObjContext.setObjSortValueMap(calculateInfo.getObjSortValueMap());
        this.complexObjContext.setAfterKeyMap(calculateInfo.getAfterKeyMap());
        this.complexObjContext.setEsLimit(calculateInfo.getEsLimit());
        if (calculateInfo.isEsQuery()) {
            if (this.complexObjContext.getkSqlCountBatch() > 10000) {
                this.complexObjContext.setkSqlCountBatch(10000);
            }
            if (this.complexObjContext.getkSqlSumThreshold() > 10000) {
                this.complexObjContext.setkSqlSumThreshold(10000);
            }
        }
    }

    public long count(int start, int limit) {
        return this.calculate.count(-1, -1);
    }

    public DataSet calculate(int start, int limit) {
        if (!this.needPage) {
            start = -1;
            limit = -1;
        }
        return this.calculate.calculate(start, limit);
    }

    public DataSet totalCalculate(int start, int limit) {
        return this.calculate.totalCalculate(-1, -1);
    }

    private void initQueryDataContext(RepQueryConfigBo repQueryConfigBo) {
        List<QFilter> qFilterList;
        Long anObjRelId = this.calculateInfo.getAnObjRelId();
        if (anObjRelId == null || anObjRelId == 0L) {
            return;
        }
        if (this.complexObjContext == null) {
            this.complexObjContext = AnalyseObjectService.getInstance().getComplexObjContextNoQueryField(anObjRelId);
            RptDataExtractQueryConverter.getInstance().clearAnObjDataFilters(this.calculateInfo, this.complexObjContext);
            new EsQueryConverter().clearAnObjDataFilters(this.calculateInfo, this.complexObjContext);
            AbstractRptChartQueryAdapter chartQueryAdapter = RptChartQueryAdapterFactory.getChartQueryAdapter(this.calculateInfo.getChartType());
            if (chartQueryAdapter != null) {
                long dimensionMaxDataCount = chartQueryAdapter.getDimensionMaxDataCount();
                this.complexObjContext.setDimensionMaxDataCount(dimensionMaxDataCount);
            }
        }
        if ((qFilterList = this.calculateInfo.getqFilterList()) != null) {
            this.complexObjContext.getQfilterList().addAll(qFilterList);
        }
        this.neqZeroBatchFit(this.complexObjContext.getQfilterList());
        HashSet<String> transLatitudeSet = new HashSet<String>(16);
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        if (transposeConfigInfoList != null && transposeConfigInfoList.size() > 0) {
            transposeConfigInfoList.forEach(tr -> transLatitudeSet.addAll(tr.getTransposeFieldUniKeyList()));
        }
        this.addBaseDataPkField(transLatitudeSet);
        this.initAdminOrgSummaryInfo();
        this.resetDepSortField(transLatitudeSet, repQueryConfigBo);
        ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(10);
        if ("1".equals(this.calculateInfo.getReportType())) {
            this.initDetailRptQueryField(complexObjFieldInfoList);
        } else {
            this.initSummaryRptQueryField(complexObjFieldInfoList);
        }
        CalculateContext.extractedRepeatField(complexObjFieldInfoList);
        this.complexObjContext.setComplexObjFieldInfoList(complexObjFieldInfoList);
        if (this.complexObjContext.getGroupFieldList().isEmpty()) {
            if ("0".equals(this.calculateInfo.getReportType())) {
                this.needPage = false;
            }
            this.complexObjContext.setQueryMode("1");
        }
        HashSet<String> allTransFieldAlias = new HashSet<String>(16);
        if (transposeConfigInfoList != null && transposeConfigInfoList.size() > 0) {
            transposeConfigInfoList.forEach(tr -> {
                allTransFieldAlias.addAll(tr.getTransposeFieldUniKeyList());
                allTransFieldAlias.addAll(tr.getTransposeValueFieldList().stream().map(ReportField::getUniqueKey).collect(Collectors.toList()));
            });
        }
        SortFieldUtil.initSortField(this.complexObjContext, this.calculateInfo.getRowFieldList(), this.calculateInfo.getReportId(), allTransFieldAlias);
        List<SortFieldInfo> sortFieldInfoList = SortFieldUtil.genSortFieldInfos(this.calculateInfo.getColumnFieldList(), this.calculateInfo.getReportId());
        this.complexObjContext.setColumnSortFieldInfoList(sortFieldInfoList);
        this.superAddJoinCondition();
        this.initVirtualEntityFieldQueryInfo(anObjRelId);
        this.complexObjContext.setAlgoxJobKey(this.calculateInfo.getReportId() != null && this.calculateInfo.getReportId() != 0L ? AlgoxJobKeyHelper.getRepAlgoxJobKeyByReportmanage(this.calculateInfo.getReportId()) : AlgoxJobKeyHelper.getRepAlgoxJobKeyByAnalyseObject(this.calculateInfo.getAnObjRelId()));
        RptDataExtractQueryConverter.getInstance().convertComplexObjContext(this.calculateInfo, this.complexObjContext);
        this.complexObjContext.setEsQuery(this.calculateInfo.isEsQuery());
        this.complexObjContext.setEsIndex(this.calculateInfo.getEsIndex());
    }

    private static void extractedRepeatField(List<HRComplexObjFieldInfo> complexObjFieldInfoList) {
        Set dependFieldList = complexObjFieldInfoList.stream().filter(HRComplexObjFieldInfo::isDependField).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        Set redundancyFields = complexObjFieldInfoList.stream().filter(field -> !field.isDependField() && dependFieldList.contains(field.getAlias())).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        Iterator<HRComplexObjFieldInfo> fieldInfoIterator = complexObjFieldInfoList.iterator();
        for (String alias : redundancyFields) {
            boolean keep = false;
            while (fieldInfoIterator.hasNext()) {
                HRComplexObjFieldInfo next = fieldInfoIterator.next();
                if (keep && next.getAlias().equals(alias)) {
                    fieldInfoIterator.remove();
                }
                if (!next.isDependField() || !next.getAlias().equals(alias)) continue;
                next.setDependField(false);
                keep = true;
            }
        }
    }

    private void addBaseDataPkField(Set<String> transLatitudeSet) {
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        boolean existsBdLatitude = rowFieldList.stream().filter(rpt -> rpt instanceof LatitudeField).filter(rpt -> !transLatitudeSet.contains(rpt.getUniqueKey())).map(rpt -> (LatitudeField)rpt).anyMatch(entityRpt -> FieldComplexType.BASE_DATA == entityRpt.getFieldComplexType() || FieldComplexType.ADMIN_ORG == entityRpt.getFieldComplexType() || FieldComplexType.HIS_BASE_DATA == entityRpt.getFieldComplexType());
        if (!existsBdLatitude) {
            return;
        }
        Set<String> latitudeUKs = rowFieldList.stream().filter(rpt -> rpt instanceof LatitudeField).map(ReportField::getFieldAlias).collect(Collectors.toSet());
        ArrayList copyFieldList = Lists.newArrayListWithExpectedSize((int)rowFieldList.size());
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        HashMap pkIdIndexMap = Maps.newHashMapWithExpectedSize((int)rowFieldList.size());
        for (ReportField reportField : rowFieldList) {
            if (!transLatitudeSet.contains(reportField.getUniqueKey())) {
                ReportFieldUtils.addBaseDataIdField(reportField, mainEntityTypeUtil, latitudeUKs, copyFieldList, pkIdIndexMap);
            }
            copyFieldList.add(reportField);
        }
        this.calculateInfo.setRowFieldList(copyFieldList);
    }

    private void resetDepSortField(Set<String> transLatitudeSet, RepQueryConfigBo repQueryConfigBo) {
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        for (ReportField reportField : rowFieldList) {
            if (!SortEnum.FIELD.getValue().equals(reportField.getSortord())) {
                reportField.setFieldSort(null);
            }
            if (!SortEnum.CUSTOM.getValue().equals(reportField.getSortord())) {
                reportField.setCustomSort(null);
            }
            if (reportField.getSortord() != null) continue;
            reportField.setSortord(SortEnum.NONE.getValue());
        }
        boolean existsFieldSort = rowFieldList.stream().anyMatch(f -> SortEnum.FIELD.getValue().equals(f.getSortord()));
        if (existsFieldSort) {
            ArrayList copyRowFieldList = Lists.newArrayListWithExpectedSize((int)rowFieldList.size());
            HashSet uniqueKeySet = Sets.newHashSetWithExpectedSize((int)rowFieldList.size());
            for (ReportField reportField : rowFieldList) {
                FieldSortInfo fieldSort = reportField.getFieldSort();
                if (fieldSort != null && SortEnum.FIELD.getValue().equals(reportField.getSortord())) {
                    if (transLatitudeSet.contains(reportField.getUniqueKey())) {
                        reportField.setSortord(SortEnum.NONE.getValue());
                    } else if (fieldSort.getNumber().equals(reportField.getFieldAlias())) {
                        reportField.setSortord(fieldSort.getSort());
                    } else if (uniqueKeySet.add(fieldSort.getNumber() + "_sorthelplati")) {
                        LatitudeField latitudeField = new LatitudeField();
                        latitudeField.setFieldAlias(fieldSort.getNumber());
                        latitudeField.setUniqueKey(fieldSort.getNumber() + "_sorthelplati");
                        latitudeField.setFieldType(fieldSort.getFieldType());
                        latitudeField.setPropFullPath(fieldSort.getNumber());
                        latitudeField.setSortord(fieldSort.getSort());
                        latitudeField.setSortSeq(reportField.getSortSeq());
                        latitudeField.setDependField(true);
                        copyRowFieldList.add(latitudeField);
                        if (repQueryConfigBo.isOriginalFieldSort()) {
                            reportField.setSortord(repQueryConfigBo.getDefSortType());
                        } else {
                            reportField.setSortord(SortEnum.NONE.getValue());
                        }
                    }
                }
                copyRowFieldList.add(reportField);
            }
            this.calculateInfo.setRowFieldList(copyRowFieldList);
        }
    }

    private void superAddJoinCondition() {
        Map<String, String> relEntityMap = this.complexObjContext.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        ArrayList<QFilter> mainEntityQFilterList = new ArrayList<QFilter>(10);
        HashMap<String, List<QFilter>> joinConditionMap = new HashMap<String, List<QFilter>>(16);
        List<QFilter> joinQFilterList = this.calculateInfo.getJoinQFilterList();
        for (QFilter qFilter : joinQFilterList) {
            String property = qFilter.getProperty();
            String fieldEntityAlias = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, (String)property);
            if (fieldEntityAlias == null) {
                mainEntityQFilterList.add(qFilter);
                continue;
            }
            List qFilterList = MapCacheUtil.getMapListQFilterVal(joinConditionMap, (String)fieldEntityAlias);
            qFilterList.add(qFilter);
            joinConditionMap.put(fieldEntityAlias, qFilterList);
        }
        this.complexObjContext.getQfilterList().addAll(mainEntityQFilterList);
        this.appendQFilterToJoinCondition(joinConditionMap);
    }

    private void appendQFilterToJoinCondition(Map<String, List<QFilter>> joinConditionMap) {
        for (HRComplexObjJoinRelation joinRelation : this.complexObjContext.getJoinRelationList()) {
            String relEntityAlias = joinRelation.getRelEntityAlias();
            List<QFilter> qFilterList = joinConditionMap.get(relEntityAlias);
            if (CollectionUtils.isEmpty(qFilterList)) continue;
            ArrayList<HRComplexObjConditionRow> appendCondList = new ArrayList<HRComplexObjConditionRow>(10);
            for (QFilter qFilter : qFilterList) {
                String itemVal = QFilterUtilHR.parametertoString((Object)qFilter.getValue());
                HRComplexObjConditionRow row = new HRComplexObjConditionRow(qFilter.getProperty(), itemVal, false);
                row.setCompareOp(qFilter.getCP());
                appendCondList.add(row);
            }
            joinRelation.getCondition().addAll(appendCondList);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void initVirtualEntityFieldQueryInfo(Long anObjRelId) {
        if (!this.complexObjContext.getVirtualEntity().booleanValue()) {
            return;
        }
        StringBuilder servicePath = new StringBuilder();
        VirtualEntityInfo virtualEntityInfo = VirtualEntityService.getInstance().queryAndAssembleVirtualEntityByAnObj(anObjRelId, servicePath);
        this.complexObjContext.setVirtualEntityQueryService(servicePath.toString());
        VirtualEntityQueryParamInfo queryParamInfo = new VirtualEntityQueryParamInfo();
        queryParamInfo.setVirtualEntityInfo(virtualEntityInfo);
        queryParamInfo.setSummaryQueryParamInfo(new SummaryQueryParamInfo(virtualEntityInfo.isSummaryQueryByBatch(), -1, false));
        HashMap reportFieldMap = Maps.newHashMapWithExpectedSize((int)(this.calculateInfo.getRowFieldList().size() + this.calculateInfo.getColumnFieldList().size()));
        if (!this.calculateInfo.getRowFieldList().isEmpty()) {
            reportFieldMap.putAll(this.calculateInfo.getRowFieldList().stream().collect(Collectors.toMap(ReportField::getFieldAlias, field -> field, (x, y) -> x)));
        }
        if (!this.calculateInfo.getColumnFieldList().isEmpty()) {
            reportFieldMap.putAll(this.calculateInfo.getColumnFieldList().stream().collect(Collectors.toMap(ReportField::getFieldAlias, field -> field, (x, y) -> x)));
        }
        List cmpFieldList = this.complexObjContext.getComplexObjFieldInfoList();
        Set groupFieldAlasSet = this.complexObjContext.getGroupFieldList().stream().map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        ArrayList<VirtualFieldInfo> virtualFieldInfoList = new ArrayList<VirtualFieldInfo>(cmpFieldList.size());
        HashSet<String> vrEntityFieldRecord = new HashSet<String>(cmpFieldList.size());
        for (HRComplexObjFieldInfo fieldInfo : cmpFieldList) {
            if (!"1".equals(fieldInfo.getFieldType()) || vrEntityFieldRecord.contains(fieldInfo.getAlias())) continue;
            ReportField reportField = (ReportField)reportFieldMap.get(fieldInfo.getAlias());
            VirtualFieldInfo virtualFieldInfo = new VirtualFieldInfo(Long.valueOf(0L), fieldInfo.getAlias(), "");
            virtualFieldInfo.setFieldPath(fieldInfo.getFullPath());
            virtualFieldInfo.setFieldValueType(fieldInfo.getDataType());
            virtualFieldInfo.setVirtualEntityId(String.valueOf(virtualEntityInfo.getId()));
            virtualFieldInfo.setCommonField(HRStringUtils.isNotEmpty((String)fieldInfo.getFullPath()));
            if (reportField instanceof EntityPropField) {
                virtualFieldInfo.setComplexType(((EntityPropField)reportField).getFieldComplexType());
                virtualFieldInfo.setControlType(((EntityPropField)reportField).getFieldControlType());
            }
            if (groupFieldAlasSet.contains(fieldInfo.getAlias())) {
                virtualFieldInfo.setGroupField(true);
            }
            virtualFieldInfoList.add(virtualFieldInfo);
            vrEntityFieldRecord.add(fieldInfo.getAlias());
        }
        queryParamInfo.setSelectedFieldInfoList(virtualFieldInfoList);
        queryParamInfo.setReportFilterList(this.complexObjContext.getQfilterList());
        LinkedHashMap<String, String> sortFieldsMap = new LinkedHashMap<String, String>(10);
        List<SortFieldInfo> sortFieldInfoList = SortFieldUtil.genSortFieldInfos(this.calculateInfo.getRowFieldList(), this.calculateInfo.getReportId());
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            sortFieldsMap.put(sortFieldInfo.getFieldAlias(), sortFieldInfo.getSortord());
        }
        queryParamInfo.setSortFieldsMap(sortFieldsMap);
        this.complexObjContext.setVirtualEntityQueryParamInfo(queryParamInfo);
    }

    private void initSummaryRptQueryField(List<HRComplexObjFieldInfo> complexObjFieldInfoList) {
        this.complexObjContext.setQueryMode("2");
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        ArrayList<ReportField> latitudeFieldList = new ArrayList<ReportField>();
        ArrayList presetIndexFieldInfoList = new ArrayList();
        List<String> pivotIndexAliasList = this.getPivotIndexAliasList();
        if (rowFieldList != null) {
            rowFieldList.forEach(reportField -> {
                if (reportField instanceof LatitudeField) {
                    HRComplexObjFieldInfo fieldInfo = ReportFieldUtils.entityField2ComplexField((EntityPropField)reportField);
                    complexObjFieldInfoList.add(fieldInfo);
                    latitudeFieldList.add((ReportField)reportField);
                } else if (reportField instanceof EntityPrimitiveIndexField) {
                    HRComplexObjFieldInfo fieldInfo = ReportFieldUtils.entityField2ComplexField((EntityPropField)reportField);
                    if (pivotIndexAliasList.contains(fieldInfo.getAlias())) {
                        fieldInfo.setAnObjPivotIndex(true);
                    }
                    complexObjFieldInfoList.add(fieldInfo);
                } else if (reportField instanceof AggregateIndexField) {
                    AggregateIndexField aggregateIndexField = (AggregateIndexField)reportField;
                    HRComplexObjFieldInfo fieldInfo = ReportFieldUtils.aggregateIndexField2ComplexField(aggregateIndexField);
                    Set refFieldAliasSet = fieldInfo.getRefFieldAliasSet();
                    HashSet refFieldIsAnObjPivotIndexSet = Sets.newHashSetWithExpectedSize((int)refFieldAliasSet.size());
                    for (String refFieldAlias : refFieldAliasSet) {
                        if (!pivotIndexAliasList.contains(refFieldAlias)) continue;
                        refFieldIsAnObjPivotIndexSet.add(refFieldAlias);
                    }
                    fieldInfo.setRefFieldIsAnObjPivotIndexSet((Set)refFieldIsAnObjPivotIndexSet);
                    complexObjFieldInfoList.add(fieldInfo);
                    if (aggregateIndexField.isLatitudeField()) {
                        latitudeFieldList.add((ReportField)reportField);
                    }
                } else if (reportField instanceof PresetIndexField) {
                    HRComplexObjFieldInfo fieldInfo = ReportFieldUtils.presetIndexField2ComplexField((PresetIndexField)reportField);
                    presetIndexFieldInfoList.add(fieldInfo);
                }
            });
        }
        this.complexObjContext.setPresetIndexFieldInfoList(presetIndexFieldInfoList);
        latitudeFieldList.sort(Comparator.comparingInt(ReportField::getFieldSeq));
        HashSet<String> transLatitude = new HashSet<String>(10);
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        if (transposeConfigInfoList != null && transposeConfigInfoList.size() > 0) {
            transposeConfigInfoList.forEach(tr -> transLatitude.addAll(tr.getTransposeFieldUniKeyList()));
        }
        List<HRComplexObjFieldInfo> groupFieldList = ReportFieldUtils.getGroupByComplexObjFieldInfos(latitudeFieldList, transLatitude);
        this.complexObjContext.setGroupFieldList(groupFieldList);
        List<ReportField> columnFieldList = this.calculateInfo.getColumnFieldList();
        if (columnFieldList != null) {
            columnFieldList.stream().filter(reportField -> reportField instanceof LatitudeField).map(obj -> (LatitudeField)obj).map(ReportFieldUtils::entityField2ComplexField).forEach(complexObjFieldInfoList::add);
            long columnAggField = columnFieldList.stream().filter(reportField -> reportField instanceof AggregateIndexField).count();
            if (columnAggField > 0L) {
                this.calculateInfo.setAlgoX(true);
            }
            columnFieldList.stream().filter(reportField -> reportField instanceof AggregateIndexField).map(obj -> (AggregateIndexField)obj).map(ReportFieldUtils::aggregateIndexField2ComplexField).forEach(complexObjFieldInfoList::add);
        }
    }

    private void initDetailRptQueryField(List<HRComplexObjFieldInfo> complexObjFieldInfoList) {
        List<String> pivotIndexAliasList = this.getPivotIndexAliasList();
        ArrayList<ReportField> latitudeFieldList = new ArrayList<ReportField>();
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        ArrayList presetIndexFieldInfoList = Lists.newArrayListWithCapacity((int)10);
        for (ReportField reportField : rowFieldList) {
            HRComplexObjFieldInfo fieldInfo;
            if (reportField instanceof LatitudeField) {
                fieldInfo = ReportFieldUtils.entityField2ComplexField((EntityPropField)reportField);
                complexObjFieldInfoList.add(fieldInfo);
                latitudeFieldList.add(reportField);
                continue;
            }
            if (reportField instanceof EntityPrimitiveIndexField) {
                fieldInfo = ReportFieldUtils.entityField2ComplexField((EntityPrimitiveIndexField)reportField);
                if (pivotIndexAliasList.contains(fieldInfo.getAlias())) {
                    fieldInfo.setAnObjPivotIndex(true);
                }
                complexObjFieldInfoList.add(fieldInfo);
                continue;
            }
            if (reportField instanceof AggregateIndexField) {
                fieldInfo = ReportFieldUtils.aggregateIndexField2ComplexField((AggregateIndexField)reportField);
                Set refFieldAliasSet = fieldInfo.getRefFieldAliasSet();
                HashSet refFieldIsAnObjPivotIndexSet = Sets.newHashSetWithExpectedSize((int)refFieldAliasSet.size());
                for (String refFieldAlias : refFieldAliasSet) {
                    if (!pivotIndexAliasList.contains(refFieldAlias)) continue;
                    refFieldIsAnObjPivotIndexSet.add(refFieldAlias);
                }
                fieldInfo.setRefFieldIsAnObjPivotIndexSet((Set)refFieldIsAnObjPivotIndexSet);
                complexObjFieldInfoList.add(fieldInfo);
                if (!((AggregateIndexField)reportField).isLatitudeField()) continue;
                latitudeFieldList.add(reportField);
                continue;
            }
            if (!(reportField instanceof PresetIndexField)) continue;
            fieldInfo = ReportFieldUtils.presetIndexField2ComplexField((PresetIndexField)reportField);
            presetIndexFieldInfoList.add(fieldInfo);
        }
        this.complexObjContext.setPresetIndexFieldInfoList((List)presetIndexFieldInfoList);
        HashSet<String> transLatitude = new HashSet<String>(10);
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        if (transposeConfigInfoList != null && transposeConfigInfoList.size() > 0) {
            this.complexObjContext.setQueryMode("2");
            transposeConfigInfoList.forEach(tr -> transLatitude.addAll(tr.getTransposeFieldUniKeyList()));
            latitudeFieldList.sort(Comparator.comparingInt(ReportField::getFieldSeq));
            List<HRComplexObjFieldInfo> groupFieldList = this.complexObjContext.getGroupFieldList();
            if (groupFieldList == null || groupFieldList.isEmpty()) {
                groupFieldList = ReportFieldUtils.getGroupByComplexObjFieldInfos(latitudeFieldList, transLatitude);
                this.complexObjContext.setGroupFieldList(groupFieldList);
            }
        }
    }

    private List<String> getPivotIndexAliasList() {
        AnalyseObjectPivotService anObjPivotService;
        ArrayList pivotIndexAliasList = Lists.newArrayListWithCapacity((int)10);
        if (this.calculateInfo.getAnObjPivotService() != null && (anObjPivotService = this.calculateInfo.getAnObjPivotService()) != null) {
            List<IndexFieldInfo> transIndexFieldInfoList = anObjPivotService.getTransIndexFieldInfoList();
            pivotIndexAliasList.addAll(transIndexFieldInfoList.stream().map(AnObjFieldInfo::getFieldAlias).collect(Collectors.toList()));
        }
        return pivotIndexAliasList;
    }

    private void initAdminOrgSummaryInfo() {
        AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        if (adminOrgSummaryInfo != null && (adminOrgSummaryInfo.getTreeShow() || adminOrgSummaryInfo.getIncludeSubOrg() || adminOrgSummaryInfo.getQuerySubLevel() != null)) {
            this.calculateInfo.getCostTimeHelper().nestedStart(false);
            if ("20".equals(HRReportParamUtils.getAdminOrgSummaryTYpe())) {
                adminOrgSummaryInfo.setOnlyGroupOrg(true);
            }
            adminOrgSummaryInfo.resetAdminOrgIds();
            if (CollectionUtils.isEmpty(adminOrgSummaryInfo.getAdminOrgIds())) {
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                adminOrgSummaryInfo.setSelectEmpty(true);
                adminOrgSummaryInfo.addAndClearOldAdminOrgId(rootOrgId);
            }
            if (AdminOrgCalHelper.buildAdminOrgStructure(this.calculateInfo)) {
                this.calculateInfo.getCostTimeHelper().logCost("getAdminOrgData", true, "getAdminOrgData");
                FilterUtils.addFilterAndUnion(this.complexObjContext.getQfilterList(), new QFilter(adminOrgSummaryInfo.getAdminOrgSelectField(), "in", adminOrgSummaryInfo._getQueryOrgIds()));
                Optional<ReportField> optionalAdminIdField = rowFieldList.stream().filter(field -> field.getFieldAlias().equals(adminOrgSummaryInfo.getAdminOrgSelectField())).findFirst();
                if (optionalAdminIdField.isPresent()) {
                    ReportField reportField = optionalAdminIdField.get();
                    if (reportField.isDependField() && adminOrgSummaryInfo.isOnlyGroupOrg()) {
                        reportField.setDependField(false);
                    }
                } else {
                    LatitudeField adminOrgIdField = new LatitudeField();
                    adminOrgIdField.setFieldAlias(adminOrgSummaryInfo.getAdminOrgSelectField());
                    adminOrgIdField.setFieldType(DataTypeEnum.LONG.getDataTypeKey());
                    adminOrgIdField.setPropFullPath(adminOrgSummaryInfo.getAdminOrgSelectFieldFullPath());
                    adminOrgIdField.setUniqueKey(adminOrgSummaryInfo.getAdminOrgSelectField());
                    adminOrgIdField.setFieldComplexType(FieldComplexType.ADMIN_ORG);
                    adminOrgIdField.setFieldControlType(FieldControlType.BIGINT);
                    rowFieldList.add(adminOrgIdField);
                }
            }
            this.calculateInfo.getCostTimeHelper().logCost("buildAdminOrgStructure", "buildAdminOrgStructure");
        }
    }

    private void paramCheck(ReportCalculateInfo calculateInfo) {
        if (CollectionUtils.isEmpty(calculateInfo.getRowFieldList()) && CollectionUtils.isEmpty(calculateInfo.getColumnFieldList())) {
            throw new KDBizException("row and column param error");
        }
        if (CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
            for (TransposeConfigInfo transposeConfigInfo : calculateInfo.getTransposeConfigInfoList()) {
                if (CollectionUtils.isEmpty(transposeConfigInfo.getTransposeValueFieldList())) {
                    throw new KDBizException("row to column param error");
                }
                for (ReportField transposeField : transposeConfigInfo.getTransposeFieldList()) {
                    if (transposeField instanceof LatitudeField) continue;
                    if (transposeField instanceof AggregateIndexField) {
                        AggregateIndexField aggregateIndexField = (AggregateIndexField)transposeField;
                        if (aggregateIndexField.isLatitudeField()) continue;
                        throw new KDBizException("row to column param error");
                    }
                    throw new KDBizException("row to column param error");
                }
            }
        }
    }

    public void setCalculate(CalculateStrategy calculate) {
        this.calculate = calculate;
    }

    public HRComplexObjContext getComplexObjContext() {
        return this.complexObjContext;
    }

    public CalculateStrategy getCalculate() {
        return this.calculate;
    }

    private void neqZeroBatchFit(List<QFilter> qFilterList) {
        for (QFilter qFilter : qFilterList) {
            this.notEqZeroAndIsNotNull(qFilter);
            List nestList = qFilter.getNests(false);
            for (QFilter.QFilterNest nest : nestList) {
                QFilter nestFilter = nest.getFilter();
                this.notEqZeroAndIsNotNull(nestFilter);
            }
        }
    }

    private void notEqZeroAndIsNotNull(QFilter qFilter) {
        if (qFilter.getCP().equals("!=") && this.isNumberZero(qFilter.getValue())) {
            qFilter.and(new QFilter(qFilter.getProperty(), "is not null", null));
        }
    }

    private boolean isNumberZero(Object obj) {
        if (obj instanceof Number) {
            double val = ((Number)obj).doubleValue();
            return val == 0.0;
        }
        return false;
    }
}

