/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.xdb.QueryTimeout;
import kd.hr.hbp.business.extpoint.report.cal.IReportCustomCalPlugin;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.CalculateContext;
import kd.hr.hrptmc.business.repcalculate.NonAggregateIndexHandler;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.algo.CalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.ReportFieldDivideHelper;
import kd.hr.hrptmc.business.repcalculate.algox.CalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.CalculateAlgoXFactory;
import kd.hr.hrptmc.business.repcalculate.func.algo.RemoveIndexSuffixFunction;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.org.handler.AdminOrgGroupHandler;
import kd.hr.hrptmc.business.repcalculate.org.handler.AdminOrgLatitudeReduceHandler;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldMethodInvokeUtil;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldUtils;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;

public class RepCalculateService {
    private static final Log LOGGER = LogFactory.getLog(RepCalculateService.class);
    private static final ExecutorService threadExeService = ThreadPools.newExecutorService((String)"RepCalculateServicePool", (int)2);
    private int algoMaxDataSize = 1000000;
    private final ReportCalculateInfo calculateInfo;
    private CalculateContext globalContext = null;

    public RepCalculateService(ReportCalculateInfo calculateInfo) {
        this.calculateInfo = calculateInfo;
    }

    public RepCalculateService(ReportCalculateInfo calculateInfo, CalculateContext globalContext) {
        this.calculateInfo = calculateInfo;
        this.globalContext = globalContext;
    }

    public DataSet calculate(int start, int limit) {
        CalculateContext calculateContext;
        this.calculateInfo.getCostTimeHelper().nestedStart(false);
        LOGGER.info("[repcalculate] calculate param[start:{}, limit:{}, calculateInfo:{}]", new Object[]{start, limit, this.calculateInfo});
        if (this.globalContext != null) {
            calculateContext = this.globalContext;
        } else {
            this.globalContext = calculateContext = new CalculateContext(this.calculateInfo);
        }
        LOGGER.info("[repcalculate] HRComplexObjContext:{}]", (Object)calculateContext.getComplexObjContext());
        calculateContext.getComplexObjContext().clearAlterAbleField();
        this.calculateInfo.getCostTimeHelper().logCost("buildCalculateContext", true, "buildCalculateContext");
        DataSet resultDataSet = null;
        try {
            if (this.calculateInfo.isRouteByBigData() && calculateContext.getCalculate() instanceof CalculateAlgo) {
                resultDataSet = this.mayBeCalculateByAlgox(calculateContext, start, limit);
            }
            if (resultDataSet == null) {
                resultDataSet = calculateContext.calculate(start, limit);
            }
            this.calculateInfo.getCostTimeHelper().logCost("RepCalculateCost", true, "RepCalculateCost");
            ReportCalculateHandler.Builder builder = new ReportCalculateHandler.Builder();
            builder.addHandler(new AdminOrgGroupHandler(this.calculateInfo)).addHandler(new AdminOrgLatitudeReduceHandler(this.calculateInfo).setPagingConfig(start, limit)).addHandler(new NonAggregateIndexHandler(this.calculateInfo, calculateContext.getComplexObjContext()));
            resultDataSet = builder.build().doHandler(resultDataSet);
        }
        catch (KDBizException kdBizException) {
            LOGGER.error("repcalculate service error:", (Throwable)kdBizException);
            throw kdBizException;
        }
        catch (NullPointerException npe) {
            LOGGER.error("repcalculate service error:", (Throwable)npe);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u670d\u52a1\u5f02\u5e38:%s\u3002", (String)"RepCalculateService_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
        catch (Exception e) {
            LOGGER.error("repcalculate service error:", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u670d\u52a1\u5f02\u5e38:%s\u3002", (String)"RepCalculateService_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), e.getMessage()));
        }
        resultDataSet = this.removeDependFields(resultDataSet);
        calculateContext.getComplexObjContext().clearAlterAbleField();
        this.calculateInfo.getCostTimeHelper().logCost("nonAggAndOrgGroupCost", true, "nonAggAndOrgGroupCost");
        resultDataSet = this.doAfterCalDataSet(resultDataSet, calculateContext.getComplexObjContext());
        this.calculateInfo.getCostTimeHelper().logCost("doAfterCalDataSet", "doAfterCalDataSet");
        return this.removeIndexSuffix(resultDataSet);
    }

    private DataSet mayBeCalculateByAlgox(CalculateContext calculateContext, int start, int limit) {
        LOGGER.info("[repcalculate-route]:algo but need route by data size.");
        Future<Long> submit = threadExeService.submit(() -> this.count(start, limit));
        HRComplexObjContext copyComplexObjContext = this.copyComplexObjContext(calculateContext.getComplexObjContext());
        Long count = null;
        try (QueryTimeout timeout = DB.timeout((int)5);){
            count = submit.get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("CalculateAlgo getCalculate submit.get timeout!", (Throwable)e);
        }
        calculateContext.getComplexObjContext().clearAlterAbleField();
        if (count == null || count > (long)this.algoMaxDataSize) {
            LOGGER.info("[repcalculate-route]:AlgoX because data size too big, copyComplexObjContext:{}", (Object)copyComplexObjContext);
            CalculateAlgoX calculateAlgoX = CalculateAlgoXFactory.getCalculate(copyComplexObjContext, this.getCalculateInfo());
            return calculateAlgoX.calculate(start, limit);
        }
        return null;
    }

    private HRComplexObjContext copyComplexObjContext(HRComplexObjContext hrComplexObjCont) {
        HRComplexObjContext copyObj = new HRComplexObjContext();
        try {
            BeanUtils.copyProperties((Object)copyObj, (Object)hrComplexObjCont);
            copyObj.setAlgoxJobKey(hrComplexObjCont.getAlgoxJobKey());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("copy_HRComplexObjContext_error", (Throwable)e);
            return hrComplexObjCont;
        }
        return copyObj;
    }

    private DataSet removeDependFields(DataSet resultDataSet) {
        Map depRowFieldMap = this.calculateInfo.getRowFieldList().stream().filter(ReportField::isDependField).collect(Collectors.toMap(ReportField::getUniqueKey, Function.identity(), (x, y) -> x));
        String[] fieldNames = resultDataSet.getRowMeta().getFieldNames();
        Map rowFieldMap = this.calculateInfo.getRowFieldListWithoutDp(false).stream().collect(Collectors.toMap(ReportField::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        ArrayList<String> removeField = new ArrayList<String>(10);
        String[] stringArray = fieldNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String fieldName;
            String tmpFieldName = fieldName = stringArray[i];
            if (fieldName.indexOf("\u03b1") > 0) {
                tmpFieldName = fieldName.substring(0, fieldName.indexOf("\u03b1"));
            }
            if (!depRowFieldMap.containsKey(tmpFieldName)) continue;
            ReportField depField = (ReportField)depRowFieldMap.get(tmpFieldName);
            String calcFunction = ReportFieldUtils.getIndexCalcFunction(depField);
            if (HRStringUtils.isEmpty((String)calcFunction)) {
                if (rowFieldMap.containsKey(tmpFieldName)) continue;
                removeField.add(fieldName);
                continue;
            }
            String depFieldCal = ReportFieldUtils.genGroupByCalFieldAlias(tmpFieldName, calcFunction);
            if (!depFieldCal.equals(fieldName)) continue;
            if (rowFieldMap.containsKey(tmpFieldName)) {
                ReportField reportField = (ReportField)rowFieldMap.get(tmpFieldName);
                String rowFieldCalFunc = ReportFieldUtils.getIndexCalcFunction(reportField);
                if (calcFunction.equals(rowFieldCalFunc)) continue;
                removeField.add(fieldName);
                continue;
            }
            removeField.add(fieldName);
        }
        if (!removeField.isEmpty()) {
            LOGGER.info("removeDependFields_{}", removeField);
            resultDataSet = resultDataSet.removeFields(removeField.toArray(new String[0]));
        }
        return resultDataSet;
    }

    public long count(int start, int limit) {
        List<ReportField> rowLatitudeFields;
        this.calculateInfo.getCostTimeHelper().nestedStart();
        LOGGER.info("[repcalculate] count start");
        HashSet<String> transLatitude = new HashSet<String>(16);
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        if (transposeConfigInfoList != null && transposeConfigInfoList.size() > 0) {
            transposeConfigInfoList.forEach(tr -> transLatitude.addAll(tr.getTransposeFieldUniKeyList()));
        }
        if ((rowLatitudeFields = ReportFieldDivideHelper.getRowLatitudeFields(this.calculateInfo, transLatitude)).isEmpty()) {
            return 1L;
        }
        CalculateContext context = new CalculateContext(this.calculateInfo);
        long count = context.count(start, limit);
        this.calculateInfo.getCostTimeHelper().logCost("RepCalculateService_count", "RepCalculateService_count");
        context.getComplexObjContext().clearAlterAbleField();
        LOGGER.info("[repcalculate] count : {}", (Object)count);
        return count;
    }

    public DataSet totalCalculate(int start, int limit) {
        ReportCalculateInfo calculateInfoCopy = this.copyCalculateInfoProp(this.calculateInfo);
        calculateInfoCopy.getCostTimeHelper().nestedStart(false);
        LOGGER.info("[repcalculate] totalCalculate start");
        if (calculateInfoCopy.getRowFieldList().isEmpty()) {
            DataSetBuilder dataSetBuilder = Algo.create((String)"RepCalculateService.totalCalculate.emptydataset").createDataSetBuilder(new RowMeta(new Field[0]));
            return dataSetBuilder.build();
        }
        CalculateContext context = new CalculateContext(calculateInfoCopy);
        DataSet dataSet = context.totalCalculate(start, limit);
        calculateInfoCopy.getCostTimeHelper().logCost("RepCalculateService_totalCalculate", true, "RepCalculateService_totalCalculate");
        calculateInfoCopy.getCostTimeHelper().logCost("RepCalculateService_totalCalculate_NonAggTime", "RepCalculateService_totalCalculate_NonAggTime");
        dataSet = this.removeIndexSuffix(dataSet);
        DataSet copy = dataSet.copy();
        LOGGER.info("totalCalculate_head_{}", (Object)Arrays.toString(copy.getRowMeta().getFieldNames()));
        while (copy.hasNext()) {
            LOGGER.info("totalCalculate_data_{}", (Object)copy.next());
        }
        return dataSet;
    }

    public ReportCalculateInfo getCalculateInfo() {
        return this.calculateInfo;
    }

    @ExcludeFromJacocoGeneratedReport
    private void optimizeRowField(ReportCalculateInfo calculateInfo) {
        if (CollectionUtils.isEmpty(calculateInfo.getColumnFieldList()) && CollectionUtils.isEmpty(calculateInfo.getTransposeConfigInfoList())) {
            List<ReportField> rowFieldList = calculateInfo.getRowFieldList();
            calculateInfo.setRowFieldList(this.removeAllIdleLatitude(rowFieldList));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private List<ReportField> removeAllIdleLatitude(List<ReportField> rowFieldList) {
        HashSet<String> allFieldAliasSet = new HashSet<String>(16);
        for (ReportField reportField : rowFieldList) {
            if (reportField instanceof PresetIndexField) {
                allFieldAliasSet.addAll(ReportFieldMethodInvokeUtil.invokeSetMethod(reportField, "getParamSet"));
            }
            if (!(reportField instanceof AggregateIndexField) && !(reportField instanceof NonAggregateIndexField)) continue;
            allFieldAliasSet.addAll(ReportFieldMethodInvokeUtil.invokeSetMethod(reportField, "getDependentFieldSet"));
        }
        ArrayList<ReportField> rowFieldListNew = new ArrayList<ReportField>(rowFieldList.size());
        for (ReportField reportField : rowFieldList) {
            if (allFieldAliasSet.contains(reportField.getFieldAlias())) {
                rowFieldListNew.add(reportField);
                continue;
            }
            if (reportField instanceof LatitudeField) continue;
            rowFieldListNew.add(reportField);
        }
        return rowFieldListNew;
    }

    private ReportCalculateInfo copyCalculateInfoProp(ReportCalculateInfo reportCalculateInfo) {
        ReportCalculateInfo copyObj = new ReportCalculateInfo();
        try {
            BeanUtils.copyProperties((Object)copyObj, (Object)reportCalculateInfo);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("copy_reportCalculateInfo_error", (Throwable)e);
        }
        return copyObj;
    }

    private DataSet removeIndexSuffix(DataSet dataSet) {
        return dataSet.map((MapFunction)new RemoveIndexSuffixFunction(dataSet.getRowMeta()));
    }

    private DataSet doAfterCalDataSet(DataSet dataSet, HRComplexObjContext context) {
        DataSet resultDataSet = dataSet;
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IReportCustomCalPlugin.class, (String)"kd.hr.hrptmc.business.repcalculate.RepCalculateService#doAfterCalDataSet", null);
        List dataSets = hrPluginProxy.callReplace(customCal -> customCal.doAfterCalDataSet(dataSet, context, (Object)this.calculateInfo));
        Iterator iterator = dataSets.iterator();
        while (iterator.hasNext()) {
            DataSet result;
            resultDataSet = result = (DataSet)iterator.next();
        }
        return resultDataSet;
    }

    public void setGlobalContext(CalculateContext globalContext) {
        this.globalContext = globalContext;
    }

    public CalculateContext getGlobalContext() {
        return this.globalContext;
    }
}

