/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.AbstractReportQueryCacheService;
import kd.hr.hrptmc.business.repcalculate.model.RepQueryConfigBo;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;

public class RepQueryCacheService
extends AbstractReportQueryCacheService {
    protected static final String CACHE_KEY_OBJECT_SORT_VALUE = "objSortValues";
    protected static final String CACHE_KEY_AFTER_KEY = "afterKey";

    public RepQueryCacheService(RepQueryConfigBo repQueryConfigBo, ReportCalculateInfo calculateInfo, IPageCache pageCache) {
        super(repQueryConfigBo, calculateInfo, pageCache);
    }

    public static void clearCache(IPageCache pageCache) {
        AbstractReportQueryCacheService.clearCache(pageCache);
    }

    @Override
    public DataSet calculateFromCache(int start, int limit) {
        return super.calculateFromCache(start, limit);
    }

    public static void setEsPageCache(IPageCache pageCache, Map<Integer, Object[]> objSortValueMap, Map<Integer, Map<String, Object>> afterKeyMap) {
        if (objSortValueMap != null) {
            pageCache.put(CACHE_KEY_OBJECT_SORT_VALUE, SerializationUtils.toJsonString(objSortValueMap));
        }
        if (afterKeyMap != null) {
            pageCache.put(CACHE_KEY_AFTER_KEY, SerializationUtils.toJsonString(afterKeyMap));
        }
    }

    public static Map<Integer, Object[]> getObjSortValueMap(IPageCache pageCache) {
        String str = pageCache.get(CACHE_KEY_OBJECT_SORT_VALUE);
        if (!HRStringUtils.isEmpty((String)str)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            HashMap objSortValueMap = Maps.newHashMapWithExpectedSize((int)map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object[] objSortValues = null;
                if (entry.getValue() != null) {
                    objSortValues = ((List)entry.getValue()).toArray();
                }
                objSortValueMap.put(entry.getKey(), objSortValues);
            }
            return objSortValueMap;
        }
        return null;
    }

    public static Map<Integer, Map<String, Object>> getAfterKeyMap(IPageCache pageCache) {
        String str = pageCache.get(CACHE_KEY_AFTER_KEY);
        if (!HRStringUtils.isEmpty((String)str)) {
            return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return null;
    }

    public static void removeEsPageCache(IPageCache pageCache) {
        pageCache.remove(CACHE_KEY_OBJECT_SORT_VALUE);
        pageCache.remove(CACHE_KEY_AFTER_KEY);
    }
}

