/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class AlgoCountDistinctReduceGroupFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 5162607349716315067L;
    private RowMeta rstRowMeta;
    private List<ReportField> latitudeFieldList;
    private List<ReportField> indexFields;
    private RowMeta originalRowMeta;
    private BiMap<String, String> fieldBiMap;
    private boolean isTransferField;

    public AlgoCountDistinctReduceGroupFunction(List<ReportField> latitudeFieldList, ReportField[] indexFields, BiMap<String, String> fieldBiMap, RowMeta originalRowMeta, boolean isTransferField) {
        this.latitudeFieldList = latitudeFieldList;
        this.indexFields = Arrays.asList(indexFields);
        this.fieldBiMap = fieldBiMap;
        this.originalRowMeta = originalRowMeta;
        this.isTransferField = isTransferField;
    }

    public Field[] getMetaFields() {
        return this.getResultRowMeta().getFields();
    }

    public RowMeta getResultRowMeta() {
        if (this.rstRowMeta != null) {
            return this.rstRowMeta;
        }
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        for (ReportField latitudeField : this.latitudeFieldList) {
            DataType dataType = AlgoDataTypeTransUtil.getDataType((String)latitudeField.getFieldType());
            if (!this.isTransferField && (DataType.BooleanType.equals((Object)dataType) || DataType.TimestampType.equals((Object)dataType))) {
                dataType = DataType.StringType;
            }
            Field field = new Field((String)this.fieldBiMap.get((Object)latitudeField.getUniqueKey()), dataType);
            resultList.add(field);
        }
        int[] index = new int[]{Integer.parseInt((String)this.fieldBiMap.get((Object)"increment"))};
        for (ReportField reportField : this.indexFields) {
            String calFun = this.getCalcFunction(reportField);
            if (!"deCount".equals(calFun)) continue;
            String indexFieldAlias = this.getFieldAliasStr(reportField.getUniqueKey(), calFun);
            String dsCountAlias = this.getDsAlias(indexFieldAlias, index);
            resultList.add(new Field(dsCountAlias, (DataType)DataType.BigDecimalType));
            resultList.add(new Field(dsCountAlias + "\u03c9", (DataType)DataType.StringType));
        }
        this.fieldBiMap.put((Object)"increment", (Object)String.valueOf(index[0]));
        this.rstRowMeta = new RowMeta(resultList.toArray(new Field[0]));
        return this.rstRowMeta;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        Object[] resultRow = new Object[this.getMetaFields().length];
        int[] index = new int[]{Integer.parseInt((String)this.fieldBiMap.get((Object)"increment"))};
        Iterator<Row> it = iterator;
        while (it.hasNext()) {
            Row row = it.next();
            this.setLatitudeResultRowX(resultRow, row);
            this.setDeCountCalculateResult(resultRow, row, index);
        }
        collector.collect(resultRow);
    }

    protected void setLatitudeResultRowX(Object[] resultRow, Row row) {
        for (ReportField reportField : this.latitudeFieldList) {
            String uniqueKey = reportField.getUniqueKey();
            String fieldAlias = (String)this.fieldBiMap.get((Object)uniqueKey);
            int destFieldIdx = this.getValIndex(fieldAlias);
            resultRow[destFieldIdx] = row.get(fieldAlias);
        }
    }

    public void setDeCountCalculateResult(Object[] resultRow, Row row, int[] index) {
        for (ReportField reportField : this.indexFields) {
            String calFun = this.getCalcFunction(reportField);
            if (!"deCount".equals(calFun)) continue;
            int calculateIndex = this.originalRowMeta.getFieldIndex(this.getDsAlias(reportField.getUniqueKey(), index));
            String calculateVal = row.getString(calculateIndex);
            String indexFieldAlias = this.getFieldAliasStr(reportField.getUniqueKey(), calFun);
            String dsCountAlias = this.getDsAlias(indexFieldAlias, index);
            Set<Object> countDisFields = Sets.newHashSetWithExpectedSize((int)16);
            String countFieldKeyDist = dsCountAlias + "\u03c9";
            int countIndexDist = this.getValIndex(countFieldKeyDist);
            Object countValDist = resultRow[countIndexDist];
            if (Objects.nonNull(countValDist) && StringUtils.isNotEmpty((CharSequence)countValDist.toString())) {
                countDisFields = Stream.of(countValDist.toString().split("\u03c9")).collect(Collectors.toSet());
            }
            countDisFields.add(calculateVal);
            resultRow[countIndexDist] = StringUtils.join((Object[])countDisFields.toArray(), (String)"\u03c9");
            int countIndex = this.getValIndex(dsCountAlias);
            resultRow[countIndex] = new BigDecimal(countDisFields.size());
        }
    }

    public int getValIndex(String fieldKey) {
        Field[] metaFields = this.getMetaFields();
        for (int i = 0; i < metaFields.length; ++i) {
            Field metaField = metaFields[i];
            if (!metaField.getName().equals(fieldKey)) continue;
            return i;
        }
        return -1;
    }

    private String getDsAlias(String original, int[] index) {
        String dsAlias = (String)this.fieldBiMap.get((Object)original);
        if (HRStringUtils.isEmpty((String)dsAlias)) {
            index[0] = index[0] + 1;
            dsAlias = "hrptmcdsa_trans_" + index[0];
            this.fieldBiMap.put((Object)original, (Object)dsAlias);
        }
        return dsAlias;
    }

    private String getCalcFunction(ReportField reportField) {
        String calFun = null;
        if (reportField instanceof EntityPrimitiveIndexField) {
            calFun = ((EntityPrimitiveIndexField)reportField).getCalcFunction();
        } else if (reportField instanceof AggregateIndexField) {
            calFun = ((AggregateIndexField)reportField).getCalcFunction();
        } else if (reportField instanceof PresetIndexField) {
            calFun = ((PresetIndexField)reportField).getCalcFunction();
        }
        return calFun;
    }

    private String getFieldAliasStr(String uniqueKey, String calFun) {
        if (HRStringUtils.isEmpty((String)calFun)) {
            return uniqueKey;
        }
        return uniqueKey + "\u03b1" + calFun;
    }
}

