/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Output;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanByKSql;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanByService;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanProxyFactory;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.center.query.ReportQueryPlanByEs;
import kd.hr.hrptmc.business.repcalculate.CalculateStrategy;
import kd.hr.hrptmc.business.repcalculate.PresetIndexHandler;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.algo.CopyFieldMapFunction;
import kd.hr.hrptmc.business.repcalculate.algo.NonAggIndexMapFunctionAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.ReplaceFieldMapFunction;
import kd.hr.hrptmc.business.repcalculate.algo.ReportFieldDivideHelper;
import kd.hr.hrptmc.business.repcalculate.algo.TotalCalculateReduceGroupAlgo;
import kd.hr.hrptmc.business.repcalculate.algox.CalculateAlgoX;
import kd.hr.hrptmc.business.repcalculate.algox.CalculateAlgoXFactory;
import kd.hr.hrptmc.business.repcalculate.algox.helper.AlgoxJobKeyHelper;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.utils.ParseUtils;
import kd.hr.hrptmc.business.repcalculate.algox.query.QueryServiceFactory;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgFlatMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgLongNumberMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.handler.AdminOrgHandler;
import kd.hr.hrptmc.business.repcalculate.org.handler.AdminOrgLatitudeReduceHandler;
import kd.hr.hrptmc.business.repcalculate.utils.ColumnAllValueHelper;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldUtils;
import kd.hr.hrptmc.business.repcalculate.utils.SortFieldUtil;
import kd.hr.hrptmc.business.repcalculate.utils.sort.DimComparator;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import org.apache.commons.beanutils.BeanUtils;

public class CalculateAlgo
extends CalculateStrategy {
    private final int totalCalUseAlgoxThreshold = 1000000;
    private static final Log LOGGER = LogFactory.getLog(CalculateAlgo.class);
    private static final ExecutorService threadExeService = ThreadPools.newExecutorService((String)"CalculateAlgoPool", (int)3);
    private IReportQueryPlan reportQueryPlan;
    protected boolean dsAliasEnable = true;
    public BiMap<String, String> fieldBiMap = HashBiMap.create((int)16);

    public CalculateAlgo(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        super(calculateInfo, complexObjContext);
        this.initFieldBiMap(calculateInfo);
    }

    public IReportQueryPlan getReportQueryPlan() {
        if (this.reportQueryPlan == null) {
            this.reportQueryPlan = QueryServiceFactory.getReportQueryPlanByKSql(this.calculateInfo, this.getComplexObjContext());
        }
        return this.reportQueryPlan;
    }

    @Override
    public DataSet calculate(int start, int limit) {
        return this.getData(start, limit);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public long count(int start, int limit) {
        long count = 0L;
        if (this.isAdminOrgIncludeSub()) {
            try (AlgoContext context = Algo.newContext();){
                DataSet dataSet = this.calculate(start, limit);
                AdminOrgLatitudeReduceHandler adminOrgLatitudeReduceHandler = new AdminOrgLatitudeReduceHandler(this.calculateInfo);
                dataSet = adminOrgLatitudeReduceHandler.doHandler(dataSet);
                dataSet = dataSet.addField("1", "REPORT_COUNT_FIELD");
                count = dataSet.count("REPORT_COUNT_FIELD", false);
            }
        } else {
            count = this.getReportQueryPlan().queryDataCount(start, limit);
        }
        return count;
    }

    @ExcludeFromJacocoGeneratedReport
    public DataSet totalVirtualCalculate(int start, int limit) {
        this.setTotalCal(true);
        DataSet rstDataSet = null;
        List nonAggregateIndexFieldList = this.calculateInfo.getRowFieldListWithoutDp(true).stream().filter(reportField -> reportField instanceof NonAggregateIndexField).map(obj -> (NonAggregateIndexField)obj).collect(Collectors.toList());
        if (this.isVirSummaryBatch(this.getComplexObjContext().getVirtualEntityQueryParamInfo())) {
            boolean doLoop = true;
            while (doLoop) {
                DataSet dataSet = this.calculate(start, limit);
                if (!this.getComplexObjContext().getVirtualEntityQueryParamInfo().getSummaryQueryParamInfo().isAllData()) {
                    dataSet = dataSet.addField("1", "REPORT_COUNT_FIELD");
                    if (!nonAggregateIndexFieldList.isEmpty()) {
                        dataSet = dataSet.map((MapFunction)new NonAggIndexMapFunctionAlgo(this.calculateInfo, dataSet.getRowMeta(), this.getComplexObjContext()));
                    }
                    dataSet = dataSet.reduceGroup((ReduceGroupFunctionWithCollector)new TotalCalculateReduceGroupAlgo(dataSet.getRowMeta(), this.calculateInfo));
                    if (rstDataSet == null) {
                        rstDataSet = dataSet;
                        continue;
                    }
                    rstDataSet = rstDataSet.union(dataSet);
                    continue;
                }
                doLoop = false;
                if (rstDataSet != null) continue;
                DataSetBuilder dataSetBuilder = Algo.create((String)"hrptmc.CalculateAlgo.totalCalculate").createDataSetBuilder(dataSet.getRowMeta());
                rstDataSet = dataSetBuilder.build();
            }
        } else {
            rstDataSet = this.calculate(start, limit);
            rstDataSet = rstDataSet.addField("1", "REPORT_COUNT_FIELD");
            if (!nonAggregateIndexFieldList.isEmpty()) {
                rstDataSet = rstDataSet.map((MapFunction)new NonAggIndexMapFunctionAlgo(this.calculateInfo, rstDataSet.getRowMeta(), this.getComplexObjContext()));
            }
        }
        this.setTotalCal(false);
        if (rstDataSet == null) {
            throw new KDBizException("total Calculate error");
        }
        return rstDataSet.reduceGroup((ReduceGroupFunctionWithCollector)new TotalCalculateReduceGroupAlgo(rstDataSet.getRowMeta(), this.calculateInfo));
    }

    @Override
    public DataSet totalCalculate(int start, int limit) {
        if (this.getComplexObjContext().getVirtualEntity().booleanValue()) {
            return this.totalVirtualCalculate(start, limit);
        }
        List nonAggregateIndexFieldList = this.calculateInfo.getRowFieldListWithoutDp(true).stream().filter(reportField -> reportField instanceof NonAggregateIndexField).map(obj -> (NonAggregateIndexField)obj).collect(Collectors.toList());
        this.setTotalCal(true);
        DataSet rstDataSet = null;
        Long count = null;
        if (!this.isAdminOrgIncludeSub()) {
            Future<Long> submit = threadExeService.submit(() -> this.count(start, limit));
            try {
                count = submit.get(2L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOGGER.error("CalculateAlgo totalCalculate submit.get timeout!", (Throwable)e);
            }
        }
        if (count == null || count > 1000000L) {
            CalculateAlgoX calculateAlgoX = CalculateAlgoXFactory.getCalculate(this.getComplexObjContext(), this.getCalculateInfo());
            return calculateAlgoX.totalCalculate(start, limit);
        }
        if (limit < 0 || limit > this.getComplexObjContext().getkSqlCountBatch() * 2) {
            ArrayList sortFieldInfoList = new ArrayList(this.getComplexObjContext().getSortFieldInfoList());
            this.getComplexObjContext().getSortFieldInfoList().clear();
            this.getComplexObjContext().setOrderBy("");
            int batchStart = 0;
            int batchLimit = 0;
            boolean doLoop = true;
            while (doLoop) {
                DataSet dataSet = this.calculate(batchStart += batchLimit, batchLimit = this.getComplexObjContext().getkSqlCountBatch());
                if (dataSet.hasNext()) {
                    dataSet = dataSet.addField("1", "REPORT_COUNT_FIELD");
                    if (!nonAggregateIndexFieldList.isEmpty()) {
                        dataSet = dataSet.map((MapFunction)new NonAggIndexMapFunctionAlgo(this.calculateInfo, dataSet.getRowMeta(), this.getComplexObjContext()));
                    }
                    dataSet = dataSet.reduceGroup((ReduceGroupFunctionWithCollector)new TotalCalculateReduceGroupAlgo(dataSet.getRowMeta(), this.calculateInfo));
                    if (rstDataSet == null) {
                        rstDataSet = dataSet;
                        continue;
                    }
                    rstDataSet = rstDataSet.union(dataSet);
                    continue;
                }
                doLoop = false;
                if (rstDataSet != null) continue;
                DataSetBuilder dataSetBuilder = Algo.create((String)"hrptmc.CalculateAlgo.totalCalculate").createDataSetBuilder(dataSet.getRowMeta());
                rstDataSet = dataSetBuilder.build();
            }
            this.getComplexObjContext().setSortFieldInfoList(sortFieldInfoList);
        } else {
            rstDataSet = this.calculate(start, limit);
            rstDataSet = rstDataSet.addField("1", "REPORT_COUNT_FIELD");
            if (!nonAggregateIndexFieldList.isEmpty()) {
                rstDataSet = rstDataSet.map((MapFunction)new NonAggIndexMapFunctionAlgo(this.calculateInfo, rstDataSet.getRowMeta(), this.getComplexObjContext()));
            }
        }
        this.setTotalCal(false);
        if (rstDataSet == null) {
            throw new KDBizException("total Calculate error");
        }
        return rstDataSet.reduceGroup((ReduceGroupFunctionWithCollector)new TotalCalculateReduceGroupAlgo(rstDataSet.getRowMeta(), this.calculateInfo));
    }

    protected DataSet getData(int start, int limit) {
        this.calculateInfo.getCostTimeHelper().nestedStart(false);
        DataSet dataSet = start < 0 && limit < 0 ? this.getReportQueryPlan().queryDataSet() : this.getReportQueryPlan().queryDataSet(start, limit);
        if (this.getComplexObjContext().getSortFieldInfoList().isEmpty() && this.hasOrderIdx(dataSet)) {
            dataSet = dataSet.removeFields(new String[]{"rptdbsortidx"});
        }
        this.calculateInfo.setHasOrderIdx(this.hasOrderIdx(dataSet));
        this.calculateInfo.getCostTimeHelper().logCost("Algo_getData", true, "Algo_getData");
        ReportCalculateHandler.Builder builder = new ReportCalculateHandler.Builder();
        builder.addHandler(new AdminOrgHandler(this.calculateInfo, false)).addHandler(new PresetIndexHandler(this.calculateInfo, false));
        dataSet = builder.build().doHandler(dataSet);
        dataSet.copy();
        this.calculateInfo.getCostTimeHelper().logCost("Algo_PresetIndexHandler", "Algo_PresetIndexHandler");
        return this.adaptReport(dataSet);
    }

    protected String[] getAllFieldName(DataSet dataSet) {
        String[] fieldNames;
        Set<String> fieldAlias = this.getAllSelField();
        ArrayList<String> rstFieldAlias = new ArrayList<String>();
        for (String fieldName : fieldNames = dataSet.getRowMeta().getFieldNames()) {
            if (fieldAlias.contains(fieldName)) {
                rstFieldAlias.add(fieldName);
            }
            if (!fieldName.equals("rptdbsortidx")) continue;
            rstFieldAlias.add(fieldName);
        }
        return rstFieldAlias.toArray(new String[0]);
    }

    protected Set<String> getAllSelField() {
        String fieldUniqueKey;
        HashSet<String> fieldAlias = new HashSet<String>(16);
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        List<ReportField> columnFieldList = this.calculateInfo.getColumnFieldList();
        for (ReportField reportField : rowFieldList) {
            fieldUniqueKey = reportField.getUniqueKey();
            fieldAlias.add(fieldUniqueKey);
            fieldAlias.add(reportField.getFieldAlias());
        }
        for (ReportField reportField : columnFieldList) {
            fieldUniqueKey = reportField.getUniqueKey();
            fieldAlias.add(fieldUniqueKey);
            fieldAlias.add(reportField.getFieldAlias());
        }
        return fieldAlias;
    }

    protected List<Map<String, Object>> queryLatitudeValList(List<ReportField> latitudeFieldList) {
        List<Map<String, DimensionData>> columnListMap = this.queryColumnListMap(latitudeFieldList);
        ColumnAllValueHelper columnValueHelper = new ColumnAllValueHelper(this.getComplexObjContext(), latitudeFieldList);
        List<Map<String, DimensionData>> allDimValue = columnValueHelper.getAllDimensionData(columnListMap);
        List<ReportField> sortFields = ParseUtils.getSortFields(latitudeFieldList);
        if (!sortFields.isEmpty()) {
            allDimValue.sort(new DimComparator(sortFields));
        }
        return ColumnAllValueHelper.convertToObjMapList(allDimValue);
    }

    protected DataSet adaptReport(DataSet dataSet) {
        ArrayList<ReportField> needCopyFieldList = new ArrayList<ReportField>();
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        for (ReportField reportField : rowFieldList) {
            String fieldUniqueKey;
            String fieldAlias = reportField.getFieldAlias();
            if (fieldAlias.equals(fieldUniqueKey = reportField.getUniqueKey())) continue;
            needCopyFieldList.add(reportField);
        }
        List<ReportField> columnFieldList = this.calculateInfo.getColumnFieldListWithoutDp();
        for (ReportField reportField : columnFieldList) {
            String fieldUniqueKey;
            String fieldAlias = reportField.getFieldAlias();
            if (fieldAlias.equals(fieldUniqueKey = reportField.getUniqueKey())) continue;
            needCopyFieldList.add(reportField);
        }
        String[] stringArray = this.getAllFieldName(dataSet);
        if (this.dsAliasEnable) {
            return dataSet.map((MapFunction)new CopyFieldMapFunction(needCopyFieldList, stringArray, dataSet.getRowMeta(), this.fieldBiMap)).copy();
        }
        return dataSet.map((MapFunction)new CopyFieldMapFunction(needCopyFieldList, stringArray, dataSet.getRowMeta())).copy();
    }

    protected DataSet renewFieldName(DataSet dataSet) {
        BiMap inverse = this.fieldBiMap.inverse();
        if (this.hasOrderIdx(dataSet)) {
            dataSet = dataSet.removeFields(new String[]{"rptdbsortidx"});
        }
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> customSortFields = new ArrayList<String>(10);
        for (String fieldName : fieldNames) {
            if (!fieldName.endsWith("_customsort")) continue;
            customSortFields.add(fieldName);
        }
        if (!customSortFields.isEmpty()) {
            dataSet = dataSet.removeFields(customSortFields.toArray(new String[0]));
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map((MapFunction)new ReplaceFieldMapFunction((Map<String, String>)inverse, rowMeta));
    }

    protected DataSet reOrder(DataSet dataSet) {
        if (this.hasOrderIdx(dataSet)) {
            LOGGER.info("CalculateAlgo dataset order-by sortindex");
            return dataSet.orderBy(new String[]{"rptdbsortidx"});
        }
        LOGGER.info("CalculateAlgo dataset order-by quadraticOrder");
        return this.quadraticOrder(dataSet);
    }

    protected boolean hasOrderIdx(DataSet dataSet) {
        Field sortRowField = dataSet.getRowMeta().getField("rptdbsortidx", false);
        return sortRowField != null;
    }

    private DataSet quadraticOrder(DataSet dataSet) {
        HashSet<String> transLatitude = new HashSet<String>(16);
        List<TransposeConfigInfo> transposeConfigInfoList = this.calculateInfo.getTransposeConfigInfoList();
        if (transposeConfigInfoList != null && transposeConfigInfoList.size() > 0) {
            transposeConfigInfoList.forEach(tr -> transLatitude.addAll(tr.getTransposeFieldUniKeyList()));
        }
        List<ReportField> latitudeFields = ReportFieldDivideHelper.getRowLatitudeFields(this.calculateInfo, transLatitude);
        dataSet = this.fillCustomSort(dataSet, latitudeFields);
        ArrayList<String> orderList = new ArrayList<String>(10);
        for (ReportField reportField : latitudeFields) {
            String alias = (String)this.fieldBiMap.get((Object)reportField.getUniqueKey());
            if (HRStringUtils.isEmpty((String)reportField.getSortord()) || SortEnum.NONE.getValue().equals(reportField.getSortord())) continue;
            if (SortEnum.CUSTOM.getValue().equals(reportField.getSortord())) {
                orderList.add(alias + "_customsort asc");
                continue;
            }
            orderList.add(alias + " " + reportField.getSortord());
        }
        if (orderList.size() > 0) {
            return dataSet.orderBy(orderList.toArray(new String[0]));
        }
        return dataSet;
    }

    @ExcludeFromJacocoGeneratedReport
    private DataSet fillCustomSort(DataSet dataSet, List<ReportField> rowFieldList) {
        List customSortRow = rowFieldList.stream().filter(rpt -> SortEnum.CUSTOM.getValue().equals(rpt.getSortord())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customSortRow)) {
            return dataSet;
        }
        ArrayList<String> fieldNameList = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        for (ReportField reportField : customSortRow) {
            String field;
            String entityNumber;
            CustomSortInfo customSort = reportField.getCustomSort();
            String fieldType = customSort.getFieldType();
            Field[] fields = new Field[2];
            String aliasAlias = (String)this.fieldBiMap.get((Object)reportField.getUniqueKey());
            fieldNameList.add(aliasAlias + "_customsort");
            fields[0] = new Field(aliasAlias, AlgoDataTypeTransUtil.getDataType((String)reportField.getFieldType()));
            fields[1] = new Field(aliasAlias + "_customsort", (DataType)DataType.IntegerType, true);
            RowMeta rowMeta = new RowMeta(fields);
            DataSetBuilder builder = Algo.create((String)"cu_sort_join").createDataSetBuilder(rowMeta);
            Map<Object, Object> dataMap = new HashMap(16);
            if ("enum".equals(fieldType)) {
                entityNumber = customSort.getEntityNumber();
                field = customSort.getField();
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperty(field);
                if (!(property instanceof ComboProp)) continue;
                ComboProp comboProp = (ComboProp)property;
                List comboItems = comboProp.getComboItems();
                dataMap = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, combo -> combo.getName().getLocaleValue()));
            } else {
                entityNumber = customSort.getEntityNumber();
                field = customSort.getField();
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
                DataSet baseData = serviceHelper.queryDataSet("kd.hr.hrptmc.business.repcalculate.algo.CalculateAlgo_" + entityNumber, "id," + field);
                for (Row row : baseData) {
                    String id = row.getString("id");
                    String sortField = row.getString(field);
                    dataMap.put(id, sortField);
                }
            }
            List<String> valueList = customSort.getValue();
            HashSet<String> cacheVal = new HashSet<String>(valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                String joinData = (String)dataMap.get(valueList.get(i));
                if (cacheVal.contains(joinData)) continue;
                Object[] row = new Object[]{joinData, i};
                cacheVal.add(joinData);
                builder.append(row);
            }
            cacheVal.clear();
            DataSet sortDataset = builder.build();
            dataSet = dataSet.leftJoin(sortDataset).on(aliasAlias, aliasAlias).select(fieldNameList.toArray(new String[0])).finish();
        }
        return dataSet;
    }

    protected List<Map<String, DimensionData>> queryColumnListMap(List<ReportField> fieldList) {
        Optional<ReportField> hasTransPositNamesField = fieldList.stream().filter(field -> field instanceof LatitudeField && !((LatitudeField)field).getTransPositionNames().isEmpty()).findAny();
        List<ReportField> afterSortFields = SortFieldUtil.resetDepSortField(fieldList);
        HRComplexObjContext columnGroupFieldQueryCont = this.genColumnFieldQueryContext(afterSortFields, this.getComplexObjContext());
        List result = Lists.newArrayListWithCapacity((int)10);
        if (!afterSortFields.isEmpty()) {
            Object dimKSqlQueryPlan = this.getComplexObjContext().getVirtualEntity() != false ? new ReportQueryPlanByService(columnGroupFieldQueryCont) : (this.getComplexObjContext().isEsQuery() ? new ReportQueryPlanByEs(columnGroupFieldQueryCont) : ReportQueryPlanProxyFactory.getProxyInstance((IReportQueryPlan)new ReportQueryPlanByKSql(columnGroupFieldQueryCont)));
            result = dimKSqlQueryPlan.queryDimensionData();
        }
        ArrayList finalResult = result;
        hasTransPositNamesField.ifPresent(hasField -> {
            finalResult.clear();
            List<Object> transPositionNames = ((LatitudeField)hasField).getTransPositionNames();
            int index = 0;
            for (HashMap<String, DimensionData> map : finalResult) {
                if (index >= transPositionNames.size()) break;
                map.put(hasField.getFieldAlias(), new DimensionData(transPositionNames.get(index), transPositionNames.get(index), false, null));
                ++index;
            }
            if (index < transPositionNames.size()) {
                for (int i = index; i < transPositionNames.size(); ++i) {
                    HashMap<String, DimensionData> map;
                    map = new HashMap<String, DimensionData>(16);
                    map.put(hasField.getFieldAlias(), new DimensionData(transPositionNames.get(i), transPositionNames.get(i), false, null));
                    finalResult.add(map);
                }
            }
        });
        return result;
    }

    private HRComplexObjContext genColumnFieldQueryContext(List<ReportField> columnFieldList, HRComplexObjContext originalCompObj) {
        boolean hasFieldSort = columnFieldList.stream().anyMatch(reportField -> reportField.getFieldSort() != null);
        ArrayList newColFieldList = Lists.newArrayListWithExpectedSize((int)(columnFieldList.size() * 2));
        Set<String> latitudeUKs = columnFieldList.stream().filter(rpt -> rpt instanceof LatitudeField).map(ReportField::getFieldAlias).collect(Collectors.toSet());
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        HashMap pkIdIndexMap = Maps.newHashMapWithExpectedSize((int)columnFieldList.size());
        for (ReportField reportField2 : columnFieldList) {
            if (SortFieldInfo.SORTORD_USER_DEFINED.equals(reportField2.getSortord())) {
                ReportFieldUtils.addBaseDataIdField(reportField2, mainEntityTypeUtil, latitudeUKs, newColFieldList, pkIdIndexMap);
            }
            newColFieldList.add(reportField2);
        }
        HRComplexObjContext dimCompObj = new HRComplexObjContext();
        dimCompObj.setQfilterList(originalCompObj.getQfilterList());
        dimCompObj.setJoinRelationList(originalCompObj.getJoinRelationList());
        dimCompObj.setEntityTable(originalCompObj.getEntityTable());
        dimCompObj.setEntityNumber(originalCompObj.getEntityNumber());
        dimCompObj.setTransferField(originalCompObj.isTransferField());
        dimCompObj.setDataExtractQuery(originalCompObj.isDataExtractQuery());
        dimCompObj.setEsQuery(originalCompObj.isEsQuery());
        dimCompObj.setEsIndex(originalCompObj.getEsIndex());
        dimCompObj.setObjSortValueMap(originalCompObj.getObjSortValueMap());
        dimCompObj.setAfterKeyMap(originalCompObj.getAfterKeyMap());
        List<HRComplexObjFieldInfo> fieldInfoList = hasFieldSort ? ReportFieldDivideHelper.getComplexObjLatitudeFieldListWithDp(newColFieldList, null) : ReportFieldDivideHelper.getComplexObjLatitudeFieldList(newColFieldList, null);
        dimCompObj.setComplexObjFieldInfoList(fieldInfoList);
        dimCompObj.setGroupFieldList(fieldInfoList);
        dimCompObj.setQueryMode("2");
        if (originalCompObj.getVirtualEntity().booleanValue()) {
            dimCompObj.setVirtualEntity(originalCompObj.getVirtualEntity());
            dimCompObj.setVirtualEntityQueryService(originalCompObj.getVirtualEntityQueryService());
            VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = new VirtualEntityQueryParamInfo();
            try {
                BeanUtils.copyProperties((Object)virtualEntityQueryParamInfo, (Object)originalCompObj.getVirtualEntityQueryParamInfo());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ArrayList<VirtualFieldInfo> columnDimensionList = new ArrayList<VirtualFieldInfo>(10);
            for (HRComplexObjFieldInfo fieldInfo : fieldInfoList) {
                VirtualFieldInfo virtualFieldInfo = new VirtualFieldInfo(Long.valueOf(0L), fieldInfo.getAlias(), "");
                virtualFieldInfo.setFieldPath(fieldInfo.getFullPath());
                virtualFieldInfo.setFieldValueType(fieldInfo.getDataType());
                virtualFieldInfo.setVirtualEntityId(String.valueOf(virtualEntityQueryParamInfo.getVirtualEntityInfo().getId()));
                virtualFieldInfo.setCommonField(HRStringUtils.isNotEmpty((String)fieldInfo.getFullPath()));
                columnDimensionList.add(virtualFieldInfo);
            }
            virtualEntityQueryParamInfo.setColumnDimensionList(columnDimensionList);
            dimCompObj.setDistinct(true);
            dimCompObj.setVirtualEntityQueryParamInfo(virtualEntityQueryParamInfo);
        }
        SortFieldUtil.initSortField(dimCompObj, newColFieldList, this.calculateInfo.getReportId());
        if (originalCompObj.getVirtualEntity().booleanValue()) {
            LinkedHashMap<String, String> colSortFieldsMap = new LinkedHashMap<String, String>(16);
            List sortFieldInfoList = dimCompObj.getSortFieldInfoList();
            for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
                colSortFieldsMap.put(sortFieldInfo.getFieldAlias(), sortFieldInfo.getSortord());
            }
            dimCompObj.getVirtualEntityQueryParamInfo().setSortFieldsMap(colSortFieldsMap);
        }
        return dimCompObj;
    }

    @ExcludeFromJacocoGeneratedReport
    private HRComplexObjContext genVrEntityColumnFieldQueryContext(List<ReportField> columnFieldList, HRComplexObjContext originalCompObj) {
        HRComplexObjContext dimCompObj = new HRComplexObjContext();
        dimCompObj.setQfilterList(originalCompObj.getQfilterList());
        dimCompObj.setJoinRelationList(originalCompObj.getJoinRelationList());
        dimCompObj.setEntityTable(originalCompObj.getEntityTable());
        dimCompObj.setEntityNumber(originalCompObj.getEntityNumber());
        dimCompObj.setVirtualEntity(Boolean.TRUE);
        dimCompObj.setTransferField(false);
        dimCompObj.setVirtualEntityQueryService(originalCompObj.getVirtualEntityQueryService());
        VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = originalCompObj.getVirtualEntityQueryParamInfo();
        List<HRComplexObjFieldInfo> fieldInfoList = ReportFieldDivideHelper.getComplexObjLatitudeFieldList(columnFieldList, null);
        dimCompObj.setComplexObjFieldInfoList(fieldInfoList);
        dimCompObj.setGroupFieldList(fieldInfoList);
        dimCompObj.setQueryMode("2");
        Map<String, ReportField> reportFieldMap = columnFieldList.stream().collect(Collectors.toMap(ReportField::getFieldAlias, field -> field, (x, y) -> x));
        ArrayList<VirtualFieldInfo> virtualFieldInfoList = new ArrayList<VirtualFieldInfo>(fieldInfoList.size());
        for (HRComplexObjFieldInfo fieldInfo : fieldInfoList) {
            VirtualFieldInfo virtualFieldInfo = new VirtualFieldInfo(Long.valueOf(0L), fieldInfo.getAlias(), "");
            virtualFieldInfo.setFieldPath(fieldInfo.getFullPath());
            virtualFieldInfo.setFieldValueType(fieldInfo.getDataType());
            virtualFieldInfo.setVirtualEntityId(String.valueOf(virtualEntityQueryParamInfo.getVirtualEntityInfo().getId()));
            virtualFieldInfo.setCommonField(HRStringUtils.isNotEmpty((String)fieldInfo.getFullPath()));
            ReportField reportField = reportFieldMap.get(fieldInfo.getAlias());
            if (reportField instanceof EntityPropField) {
                virtualFieldInfo.setControlType(((EntityPropField)reportField).getFieldControlType());
                virtualFieldInfo.setComplexType(((EntityPropField)reportField).getFieldComplexType());
            }
            virtualFieldInfoList.add(virtualFieldInfo);
        }
        virtualEntityQueryParamInfo.setColumnDimensionList(virtualFieldInfoList);
        dimCompObj.setVirtualEntityQueryParamInfo(virtualEntityQueryParamInfo);
        String orderBy = fieldInfoList.stream().map(HRComplexObjFieldInfo::getAlias).collect(Collectors.joining(","));
        dimCompObj.setOrderBy(orderBy);
        return dimCompObj;
    }

    private void initFieldBiMap(ReportCalculateInfo calculateInfo) {
        String fieldAlias;
        int index = 0;
        List<ReportField> rowFieldList = calculateInfo.getRowFieldList();
        for (ReportField reportField : rowFieldList) {
            this.fieldBiMap.put((Object)reportField.getUniqueKey(), (Object)("hrptmcdsa_" + ++index));
        }
        List<ReportField> columnFieldList = calculateInfo.getColumnFieldList();
        for (ReportField reportField : columnFieldList) {
            this.fieldBiMap.put((Object)reportField.getUniqueKey(), (Object)("hrptmcdsa_" + ++index));
        }
        for (ReportField reportField : rowFieldList) {
            fieldAlias = (String)this.fieldBiMap.get((Object)reportField.getFieldAlias());
            if (!HRStringUtils.isEmpty((String)fieldAlias)) continue;
            this.fieldBiMap.put((Object)reportField.getFieldAlias(), (Object)("hrptmcdsa_" + ++index));
        }
        for (ReportField reportField : columnFieldList) {
            fieldAlias = (String)this.fieldBiMap.get((Object)reportField.getFieldAlias());
            if (!HRStringUtils.isEmpty((String)fieldAlias)) continue;
            this.fieldBiMap.put((Object)reportField.getFieldAlias(), (Object)("hrptmcdsa_" + ++index));
        }
        this.fieldBiMap.put((Object)"rptdbsortidx", (Object)"rptdbsortidx");
        this.fieldBiMap.put((Object)"increment", (Object)String.valueOf(index));
    }

    protected boolean isAdminOrgIncludeSub() {
        AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
        return adminOrgSummaryInfo != null && !adminOrgSummaryInfo.getTreeShow() && adminOrgSummaryInfo.getIncludeSubOrg();
    }

    protected boolean notOnlyGroupByOrg() {
        AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
        return !this.isAdminOrgIncludeSub() || !adminOrgSummaryInfo.isOnlyGroupOrg();
    }

    protected DataSet addAdminOrgIncludeSub(DataSet dataSet, AdminOrgSummaryInfo adminOrgSummaryInfo) {
        dataSet = dataSet.map((MapFunction)new ReplaceFieldMapFunction((Map<String, String>)this.fieldBiMap.inverse(), dataSet.getRowMeta()));
        String algoXJobKey = this.calculateInfo.getReportId() != null && this.calculateInfo.getReportId() != 0L ? AlgoxJobKeyHelper.getRepAlgoxJobKeyByReportmanage(this.calculateInfo.getReportId()) : AlgoxJobKeyHelper.getRepAlgoxJobKeyByAnalyseObject(this.calculateInfo.getAnObjRelId());
        String SESSION_JOB_NAME = "HR_REPORT_ADMIN_ORG_GROUP_ALGO_SUB_";
        String SESSION_JOB_TITLE = "HR_REPORT_ADMIN_ORG_GROUP_TITLE_ALGO_SUB_";
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        JobSession session = AlgoX.createSession((String)(SESSION_JOB_NAME + algoXJobKey + "_" + traceId), (String)(SESSION_JOB_TITLE + algoXJobKey + "_" + traceId));
        Object[] fieldNames = dataSet.getRowMeta().getFieldNames();
        HashSet fieldNameSet = Sets.newHashSet((Object[])fieldNames);
        if (fieldNameSet.size() != fieldNames.length) {
            dataSet = dataSet.select(Sets.newHashSet((Object[])fieldNames).toArray(new String[0]));
        }
        DataSetX dataSetX = session.fromInput((Input)new DataSetInput(dataSet));
        int fieldIndex = dataSetX.getRowMeta().getFieldIndex("ROW_FIELD_ADMIN_ORG_LONG_NUMBER", false);
        DataSetX newResultDataSetX = dataSetX;
        RowMeta newRowMeta = dataSetX.getRowMeta();
        if (fieldIndex < 0) {
            newResultDataSetX = dataSetX.map((kd.bos.algox.MapFunction)new AdminOrgLongNumberMapFunction(adminOrgSummaryInfo, dataSetX.getRowMeta()));
            newRowMeta = newResultDataSetX.getRowMeta();
            this.fieldBiMap.put((Object)"ROW_FIELD_ADMIN_ORG_ORIGINAL_ID", (Object)"ROW_FIELD_ADMIN_ORG_ORIGINAL_ID");
            this.fieldBiMap.put((Object)"ROW_FIELD_ADMIN_ORG_LONG_NUMBER", (Object)"ROW_FIELD_ADMIN_ORG_LONG_NUMBER");
        }
        if (!adminOrgSummaryInfo.getHasDoneFlatMap()) {
            newResultDataSetX = newResultDataSetX.flatMap((FlatMapFunction)new AdminOrgFlatMapFunction(adminOrgSummaryInfo, newRowMeta, this.calculateInfo.getStoreFieldMapList()));
        }
        DataSetOutput output = new DataSetOutput(newResultDataSetX.getRowMeta());
        String id = output.getId();
        newResultDataSetX.output((Output)output);
        session.commit(600, TimeUnit.SECONDS);
        dataSet = session.readDataSet(id);
        return this.adaptReport(dataSet);
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean isVirSummaryBatch(VirtualEntityQueryParamInfo virtualEntityQueryParamInfo) {
        return virtualEntityQueryParamInfo != null && virtualEntityQueryParamInfo.getSummaryQueryParamInfo() != null && virtualEntityQueryParamInfo.getSummaryQueryParamInfo().isSummaryQueryByBatch();
    }

    @ExcludeFromJacocoGeneratedReport
    private void printDataSet(DataSet dataSet, String tag) {
        int index = 0;
        LOGGER.info("print_out_{},head:{}", (Object)tag, (Object)Arrays.toString(dataSet.getRowMeta().getFieldNames()));
        while (dataSet.hasNext()) {
            LOGGER.info("print_out_{},detail:{}", (Object)tag, (Object)dataSet.next().toString());
            ++index;
        }
        LOGGER.info("print_out_{},count:{}", (Object)tag, (Object)index);
    }
}

