/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.utils.ObjectComparable;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class DetailIndexReplaceFunction
extends ReduceGroupFunction {
    private static final long serialVersionUID = -1112404034065966317L;
    private final DataSet dataSet;
    private final ReportField[] indexFields;
    private final boolean useUniqueKey;
    private boolean addSumAndCount;
    private RowMeta resultRowMeta;
    private BiMap<String, String> fieldBiMap;

    public DetailIndexReplaceFunction(DataSet dataSet, ReportField[] indexFields, BiMap<String, String> fieldBiMap, boolean useUniqueKey) {
        this.dataSet = dataSet;
        this.indexFields = indexFields;
        this.useUniqueKey = useUniqueKey;
        this.fieldBiMap = fieldBiMap;
    }

    public void setAddSumAndCount(boolean addSumAndCount) {
        this.addSumAndCount = addSumAndCount;
    }

    public BiMap<String, String> getFieldBiMap() {
        return this.fieldBiMap;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(10);
        Object[] rowObjs = null;
        while (iterator.hasNext()) {
            Row next = iterator.next();
            Object[] nowVals = ((AbstractRow)next).values();
            if (rowObjs != null) {
                for (ReportField indexField : this.indexFields) {
                    int countIdx;
                    int fieldIdx = this.getFieldIdx(indexField);
                    Object old = rowObjs[fieldIdx];
                    Object now = next.get(fieldIdx);
                    if (old != null) {
                        Object value = old;
                        if (now != null) {
                            String order = "asc";
                            Object headMostObject = ObjectComparable.getHeadMostObject(old, now, order);
                            value = headMostObject == null ? value : headMostObject;
                        }
                        nowVals[fieldIdx] = value;
                    }
                    if (!this.addSumAndCount) continue;
                    int avgSumIdx = this.getFieldAvgFieldIdx(indexField, "avgsum");
                    if (avgSumIdx > 0) {
                        nowVals[avgSumIdx] = nowVals[fieldIdx];
                    }
                    if ((countIdx = this.getFieldAvgFieldIdx(indexField, "avgcount")) <= 0) continue;
                    nowVals[countIdx] = BigDecimal.ONE;
                }
            }
            rowObjs = nowVals;
        }
        if (rowObjs != null) {
            arrayList.add(rowObjs);
        }
        return arrayList.iterator();
    }

    private int getFieldIdx(ReportField reportField) {
        String fieldAlias = reportField.getFieldAlias();
        if (this.useUniqueKey) {
            fieldAlias = reportField.getUniqueKey();
        }
        String dsAlias = (String)this.fieldBiMap.get((Object)fieldAlias);
        return this.getResultRowMeta().getFieldIndex(dsAlias);
    }

    private int getFieldAvgFieldIdx(ReportField reportField, String calFunction) {
        String alias;
        String dsAlias;
        String fieldAlias = reportField.getFieldAlias();
        if (this.useUniqueKey) {
            fieldAlias = reportField.getUniqueKey();
        }
        if ((dsAlias = (String)this.fieldBiMap.get((Object)(alias = this.genGroupByCalFieldAlias(fieldAlias, calFunction)))) == null) {
            return -1;
        }
        return this.getResultRowMeta().getFieldIndex(dsAlias);
    }

    private String genGroupByCalFieldAlias(String fieldAlias, String calFunction) {
        return fieldAlias + "\u03b1" + calFunction;
    }

    private String getDsAlias(String original, int[] index) {
        String dsAlias = (String)this.getFieldBiMap().get((Object)original);
        if (HRStringUtils.isEmpty((String)dsAlias)) {
            index[0] = index[0] + 1;
            dsAlias = "hrptmcdsa_agg_" + index[0];
            this.getFieldBiMap().put((Object)original, (Object)dsAlias);
        }
        return dsAlias;
    }

    public RowMeta getResultRowMeta() {
        if (this.resultRowMeta != null) {
            return this.resultRowMeta;
        }
        RowMeta rowMeta = this.dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<Field> nowFieldList = new ArrayList<Field>(fields.length);
        Map indexMap = Arrays.stream(this.indexFields).collect(Collectors.toMap(ReportField::getUniqueKey, Function.identity(), (x, y) -> y));
        int[] index = new int[]{Integer.parseInt((String)this.getFieldBiMap().get((Object)"increment"))};
        for (Field field : fields) {
            ReportField reportField = (ReportField)indexMap.get(field.getName());
            if (reportField != null) {
                String fieldKey = reportField.getFieldAlias();
                if (this.useUniqueKey) {
                    fieldKey = reportField.getUniqueKey();
                    String dsAlias = (String)this.fieldBiMap.get((Object)reportField.getUniqueKey());
                    field.setAlias(dsAlias);
                    field.setName(dsAlias);
                }
                if (this.addSumAndCount) {
                    String avgSumAlias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldKey, "avgsum"), index);
                    Field fieldAvgSum = new Field(avgSumAlias, (DataType)DataType.BigDecimalType);
                    nowFieldList.add(fieldAvgSum);
                    String countAlias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldKey, "avgcount"), index);
                    Field fieldCount = new Field(countAlias, (DataType)DataType.BigDecimalType);
                    nowFieldList.add(fieldCount);
                }
            }
            nowFieldList.add(field);
        }
        this.getFieldBiMap().put((Object)"increment", (Object)String.valueOf(index[0]));
        this.resultRowMeta = new RowMeta(nowFieldList.toArray(new Field[0]));
        return this.resultRowMeta;
    }
}

