/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.ColumnDataTree;
import kd.hr.hrptmc.business.repcalculate.model.ColumnSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.model.IndexCalInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldMethodInvokeUtil;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import org.apache.commons.lang.ArrayUtils;

public class PivotReduceGroupAlgo
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 475658621077038186L;
    private static final String avgSuffix = "\u03b1avg";
    private static final String sumSuffix = "\u03b1sum";
    private static final String avgSumSuffix = "\u03b1avgsum";
    private static final String countSuffix = "\u03b1avgcount";
    private final List<Map<String, Object>> columnListMap;
    private final ReportField[] rowLatitudeArr;
    private final ReportField[] columnLatitudeArr;
    private final boolean addCountField;
    private final BiMap<String, String> fieldBiMap;
    private final ReportField[] rowIndexArr;
    private RowMeta resultRowMeta;
    private ColumnSummaryInfo columnSummaryInfo;
    private String tag;
    private List<String> allColumnFieldPrex = new ArrayList<String>(10);
    private List<String> subTotalHeads = new ArrayList<String>(10);
    private RowSummaryInfo rowSummaryInfo;
    private boolean isTotalCalculate;
    private boolean isTransferField;

    public PivotReduceGroupAlgo(List<Map<String, Object>> columnListMap, ReportField[] rowLatitudeArr, ReportField[] columnLatitudeArr, ReportField[] rowIndexArr, String tag, boolean addCountField, BiMap<String, String> fieldBiMap, boolean isTransferField) {
        this.columnListMap = columnListMap;
        this.rowLatitudeArr = rowLatitudeArr;
        this.columnLatitudeArr = columnLatitudeArr;
        this.rowIndexArr = rowIndexArr;
        this.addCountField = addCountField;
        this.tag = tag;
        this.fieldBiMap = fieldBiMap;
        this.isTransferField = isTransferField;
    }

    public PivotReduceGroupAlgo(List<Map<String, Object>> columnListMap, ReportField[] rowLatitudeArr, ReportField[] columnLatitudeArr, ReportField[] rowIndexArr, boolean addCountField, BiMap<String, String> fieldBiMap, boolean isTransferField) {
        this.columnListMap = columnListMap;
        this.rowLatitudeArr = rowLatitudeArr;
        this.columnLatitudeArr = columnLatitudeArr;
        this.rowIndexArr = rowIndexArr;
        this.addCountField = addCountField;
        this.fieldBiMap = fieldBiMap;
        this.isTransferField = isTransferField;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        Object[] curRow = new Object[this.getResultRowMeta().getFieldCount()];
        while (iterator.hasNext()) {
            int index;
            Row row = iterator.next();
            if (ArrayUtils.isNotEmpty((Object[])this.rowLatitudeArr)) {
                for (index = 0; index < this.rowLatitudeArr.length; ++index) {
                    String uniqueKey;
                    String drFieldName = uniqueKey = this.rowLatitudeArr[index].getUniqueKey();
                    String fieldAlias = (String)this.fieldBiMap.get((Object)uniqueKey);
                    if (HRStringUtils.isNotEmpty((String)fieldAlias)) {
                        drFieldName = fieldAlias;
                    }
                    int fieldIdx = this.getResultRowMeta().getFieldIndex(drFieldName);
                    curRow[fieldIdx] = row.get(drFieldName);
                }
            }
            for (Map<String, Object> data : this.columnListMap) {
                index = this.amendIndexField(curRow, row, index, data, this.rowIndexArr);
            }
        }
        this.calTotalVal(curRow, this.allColumnFieldPrex);
        this.calSubTotalVal(curRow);
        collector.collect(curRow);
    }

    @ExcludeFromJacocoGeneratedReport
    private void calSubTotalVal(Object[] curRow) {
        if (this.columnSummaryInfo == null || !this.columnSummaryInfo.isShowSubTotalCol()) {
            return;
        }
        for (String subTotalHead : this.subTotalHeads) {
            String[] split = subTotalHead.split("\u03b7");
            String subTotalPrex = split[0];
            List<String> columnLatitudePrex = this.allColumnFieldPrex.stream().filter(columnFieldPrex -> columnFieldPrex.startsWith(subTotalPrex)).collect(Collectors.toList());
            this.calculateFillTotalFieldVal(curRow, columnLatitudePrex, subTotalHead);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void calTotalVal(Object[] curRow, List<String> columnLatitudePrex) {
        if (this.columnSummaryInfo == null || !this.columnSummaryInfo.isShowTotalCol()) {
            return;
        }
        String totalFieldPrex = "\u03b8" + this.columnSummaryInfo.getTotalColName().toString();
        this.calculateFillTotalFieldVal(curRow, columnLatitudePrex, totalFieldPrex);
    }

    @ExcludeFromJacocoGeneratedReport
    private void calculateFillTotalFieldVal(Object[] curRow, List<String> columnLatitudePrex, String totalFieldPrex) {
        for (ReportField indexField : this.rowIndexArr) {
            if (indexField.isDependField()) continue;
            IndexCalInfo indexCalInfo = new IndexCalInfo();
            String calcFunction = ReportFieldMethodInvokeUtil.invokeMethod(indexField, "getCalcFunction", String.class);
            Map<String, String> totalIndexCalcFunctionMap = this.columnSummaryInfo.getSubTotalIndexCalcFunctionMap();
            if (totalIndexCalcFunctionMap != null) {
                calcFunction = totalIndexCalcFunctionMap.get(indexField.getUniqueKey());
            }
            calcFunction = this.getRowSummaryIndexFunction(indexField.getUniqueKey(), calcFunction);
            indexCalInfo.setCalFunction(calcFunction);
            String indexAvgSumSuffix = this.getFieldAliasStr(indexField.getUniqueKey(), "avgsum");
            String indexCountSuffix = this.getFieldAliasStr(indexField.getUniqueKey(), "avgcount");
            for (String columnFieldPrex : columnLatitudePrex) {
                int fieldCountIdx;
                Object countVal;
                String dsAvgAlias = (String)this.fieldBiMap.get((Object)(columnFieldPrex + "\u03b2" + indexAvgSumSuffix));
                String dsCountAlias = (String)this.fieldBiMap.get((Object)(columnFieldPrex + "\u03b2" + indexCountSuffix));
                int fieldAvgSumIdx = this.getResultRowMeta().getFieldIndex(dsAvgAlias);
                Object avgSumVal = curRow[fieldAvgSumIdx];
                if (avgSumVal != null) {
                    indexCalInfo.addSum(new BigDecimal(avgSumVal.toString()));
                }
                if ((countVal = curRow[fieldCountIdx = this.getResultRowMeta().getFieldIndex(dsCountAlias)]) == null) continue;
                indexCalInfo.addCount(new BigDecimal(countVal.toString()));
            }
            String calFieldDsAlias = (String)this.fieldBiMap.get((Object)(totalFieldPrex + "\u03b2" + this.genGroupByCalFieldAlias(indexField, calcFunction)));
            curRow[this.getResultRowMeta().getFieldIndex((String)calFieldDsAlias)] = indexCalInfo.getCalVal();
            String avgSumFieldDsAlias = (String)this.fieldBiMap.get((Object)(totalFieldPrex + "\u03b2" + indexAvgSumSuffix));
            curRow[this.getResultRowMeta().getFieldIndex((String)avgSumFieldDsAlias)] = indexCalInfo.getSum();
            String countFieldDsAlias = (String)this.fieldBiMap.get((Object)(totalFieldPrex + "\u03b2" + indexCountSuffix));
            curRow[this.getResultRowMeta().getFieldIndex((String)countFieldDsAlias)] = indexCalInfo.getCount();
        }
    }

    private int amendIndexField(Object[] curRow, Row row, int index, Map<String, Object> data, ReportField[] reportFields) {
        if (ArrayUtils.isEmpty((Object[])reportFields)) {
            return index;
        }
        int coulumIndex = index;
        StringBuilder fieldStr = new StringBuilder();
        if (HRStringUtils.isNotEmpty((String)this.tag)) {
            fieldStr.append(this.tag);
            fieldStr.append("\u03b3");
        }
        boolean match = true;
        int idx = 0;
        for (ReportField latitudeField : this.columnLatitudeArr) {
            String uniqueKey = latitudeField.getUniqueKey();
            String fieldAlias = (String)this.fieldBiMap.get((Object)uniqueKey);
            if (HRStringUtils.isNotEmpty((String)fieldAlias)) {
                uniqueKey = fieldAlias;
            }
            Object originalVal = row.get(uniqueKey);
            Object headVal = data.get(latitudeField.getUniqueKey());
            if (headVal == null) {
                headVal = data.get(latitudeField.getFieldAlias());
            }
            if (!Objects.equals(headVal, originalVal)) {
                match = false;
                break;
            }
            if (headVal == null || headVal.toString().equals("")) {
                headVal = " ";
            }
            fieldStr.append(headVal);
            if (idx < this.columnLatitudeArr.length - 1) {
                fieldStr.append("\u03b5");
            }
            ++idx;
        }
        fieldStr.append("\u03b2");
        if (match) {
            for (int priIndex = 0; priIndex < reportFields.length; ++priIndex) {
                ReportField reportField = reportFields[priIndex];
                String calFieldAlias = this.genGroupByCalFieldAlias(reportField, null);
                String fieldPrex = fieldStr.toString();
                this.assignAvlCalField(curRow, row, calFieldAlias, fieldPrex, avgSuffix);
                this.assignAvlCalField(curRow, row, calFieldAlias, fieldPrex, sumSuffix);
                int fieldIdx = this.getResultRowMeta().getFieldIndex((String)this.fieldBiMap.get((Object)(fieldPrex + calFieldAlias)));
                String prex = calFieldAlias.indexOf("\u03b1") > 0 ? calFieldAlias.substring(0, calFieldAlias.indexOf("\u03b1")) : calFieldAlias;
                curRow[fieldIdx] = this.isTotalCalculate && this.rowSummaryInfo != null && this.fieldBiMap.get((Object)calFieldAlias) == null ? row.get((String)this.fieldBiMap.get((Object)prex)) : row.get((String)this.fieldBiMap.get((Object)calFieldAlias));
            }
        }
        return coulumIndex += reportFields.length;
    }

    private void assignAvlCalField(Object[] curRow, Row row, String calFieldAlias, String fieldPrex, String suffix) {
        if (calFieldAlias.endsWith(suffix)) {
            String avgsumFieldName = calFieldAlias.replace(suffix, avgSumSuffix);
            String countFieldName = calFieldAlias.replace(suffix, countSuffix);
            int avgSumFieldIdx = this.getResultRowMeta().getFieldIndex((String)this.fieldBiMap.get((Object)(fieldPrex + avgsumFieldName)));
            int countFieldIdx = this.getResultRowMeta().getFieldIndex((String)this.fieldBiMap.get((Object)(fieldPrex + countFieldName)));
            String prex = calFieldAlias.indexOf("\u03b1") > 0 ? calFieldAlias.substring(0, calFieldAlias.indexOf("\u03b1")) : calFieldAlias;
            curRow[avgSumFieldIdx] = this.isTotalCalculate && this.rowSummaryInfo != null && this.fieldBiMap.get((Object)avgsumFieldName) == null ? row.get((String)this.fieldBiMap.get((Object)prex)) : row.get((String)this.fieldBiMap.get((Object)avgsumFieldName));
            curRow[countFieldIdx] = this.isTotalCalculate && this.rowSummaryInfo != null && this.fieldBiMap.get((Object)countFieldName) == null ? BigDecimal.ONE : row.get((String)this.fieldBiMap.get((Object)countFieldName));
        }
    }

    public RowMeta getResultRowMeta() {
        if (this.resultRowMeta != null) {
            return this.resultRowMeta;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>(16);
        HashSet<String> fieldCache = new HashSet<String>(16);
        if (ArrayUtils.isNotEmpty((Object[])this.rowLatitudeArr)) {
            for (ReportField latitudeField : this.rowLatitudeArr) {
                String curFieldName;
                DataType dataType = AlgoDataTypeTransUtil.getDataType((String)latitudeField.getFieldType());
                if (!this.isTransferField && (DataType.BooleanType.equals((Object)dataType) || DataType.TimestampType.equals((Object)dataType))) {
                    dataType = DataType.StringType;
                }
                if (!fieldCache.add(curFieldName = (String)this.fieldBiMap.get((Object)latitudeField.getUniqueKey()))) continue;
                Field field = new Field(curFieldName, dataType);
                fieldList.add(field);
            }
        }
        int[] index = new int[]{Integer.parseInt((String)this.fieldBiMap.get((Object)"increment"))};
        ColumnDataTree columnDataTree = new ColumnDataTree();
        String specialPrex = null;
        if (HRStringUtils.isNotEmpty((String)this.tag)) {
            specialPrex = this.tag + "\u03b3";
        }
        columnDataTree.setRowSummaryInfo(this.rowSummaryInfo);
        columnDataTree.setTotalCalculate(this.isTotalCalculate);
        columnDataTree.convertToTree(this.columnListMap, this.columnLatitudeArr, specialPrex);
        this.allColumnFieldPrex = columnDataTree.dfsTraversal(columnDataTree.getRoot(), null);
        columnDataTree.addTotalNode(columnDataTree.getRoot(), this.columnSummaryInfo);
        columnDataTree.addSubTotalNode(this.columnListMap, this.columnLatitudeArr, this.columnSummaryInfo);
        this.subTotalHeads = columnDataTree.dfsTraversal(columnDataTree.getRoot(), null, "total");
        columnDataTree.addIndexLeaf(columnDataTree.getRoot(), this.rowIndexArr, this.columnSummaryInfo);
        List<String> allColumnFieldNames = columnDataTree.dfsTraversal(columnDataTree.getRoot(), null);
        for (String fieldName : allColumnFieldNames) {
            String dsAlias = this.getDsAlias(fieldName, index);
            if (!fieldCache.add(dsAlias)) continue;
            Field field = new Field(dsAlias, (DataType)DataType.BigDecimalType);
            fieldList.add(field);
        }
        this.fieldBiMap.put((Object)"increment", (Object)String.valueOf(index[0]));
        this.resultRowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        return this.resultRowMeta;
    }

    private String getDsAlias(String original, int[] index) {
        String dsAlias = (String)this.fieldBiMap.get((Object)original);
        if (HRStringUtils.isEmpty((String)dsAlias)) {
            index[0] = index[0] + 1;
            dsAlias = "hrptmcdsa_trans_" + index[0];
            this.fieldBiMap.put((Object)original, (Object)dsAlias);
        }
        return dsAlias;
    }

    private String genGroupByCalFieldAlias(ReportField reportField, String calcFunction) {
        if (reportField instanceof EntityPrimitiveIndexField || reportField instanceof AggregateIndexField || reportField instanceof PresetIndexField) {
            String uniqueKey = ReportFieldMethodInvokeUtil.invokeMethod(reportField, "getUniqueKey", String.class);
            if (HRStringUtils.isEmpty((String)calcFunction)) {
                calcFunction = ReportFieldMethodInvokeUtil.invokeMethod(reportField, "getCalcFunction", String.class);
            }
            calcFunction = this.getRowSummaryIndexFunction(reportField.getUniqueKey(), calcFunction);
            return this.getFieldAliasStr(uniqueKey, calcFunction);
        }
        throw new KDBizException("index field type error!");
    }

    private String getFieldAliasStr(String uniqueKey, String calFun) {
        if (HRStringUtils.isEmpty((String)calFun) || "rownummax".equals(calFun)) {
            return uniqueKey;
        }
        return uniqueKey + "\u03b1" + calFun;
    }

    public void setColumnSummaryInfo(ColumnSummaryInfo columnSummaryInfo) {
        this.columnSummaryInfo = columnSummaryInfo;
    }

    public void setRowSummaryInfo(RowSummaryInfo rowSummaryInfo) {
        this.rowSummaryInfo = rowSummaryInfo;
    }

    public void setTotalCalculate(boolean totalCalculate) {
        this.isTotalCalculate = totalCalculate;
    }

    private String getRowSummaryIndexFunction(String indexUniqueKey, String originalFunction) {
        String summaryFunction;
        Map<String, String> indexFunctionMap;
        String indexFunction = originalFunction;
        if (this.isTotalCalculate && this.rowSummaryInfo != null && (indexFunctionMap = this.rowSummaryInfo.getIndexFunctionMap()) != null && HRStringUtils.isNotEmpty((String)(summaryFunction = indexFunctionMap.get(indexUniqueKey)))) {
            indexFunction = summaryFunction;
        }
        return indexFunction;
    }
}

