/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algo.AlgoCountDistinctReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algo.Tuple2;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import org.apache.commons.collections.MapUtils;

public abstract class RptTransform {
    protected ReportField[] rowLatitudeArr;
    protected ReportField[] columnLatitudeArr;
    protected ReportField[] rowIndexArr;
    protected ReportCalculateInfo calculateInfo;
    private List<ReportField> latitudeFieldList;
    protected int aliasMapIdx = 0;
    private boolean addCountField;
    protected boolean isTotalCalculate;
    private BiMap<String, String> fieldBiMap = HashBiMap.create((int)16);

    public BiMap<String, String> getFieldBiMap() {
        return this.fieldBiMap;
    }

    public void setFieldBiMap(BiMap<String, String> fieldBiMap) {
        this.fieldBiMap = fieldBiMap;
    }

    public void init(ReportCalculateInfo calculateInfo) {
        this.calculateInfo = calculateInfo;
    }

    protected List<ReportField> getLatitudeFieldList(ReportCalculateInfo calculateInfo) {
        return this.getLatitudeFieldList(calculateInfo, null);
    }

    protected List<ReportField> getLatitudeFieldList(ReportCalculateInfo calculateInfo, TransposeConfigInfo transposeConfigInfo) {
        if (this.latitudeFieldList != null) {
            return this.latitudeFieldList;
        }
        this.latitudeFieldList = this.getAllLatitudeFields(calculateInfo, transposeConfigInfo);
        return this.latitudeFieldList;
    }

    protected abstract List<ReportField> getAllLatitudeFields(ReportCalculateInfo var1, TransposeConfigInfo var2);

    public boolean isAddCountField() {
        return this.addCountField;
    }

    public void setAddCountField(boolean addCountField) {
        this.addCountField = addCountField;
    }

    public void setTotalCalculate(boolean totalCalculate) {
        this.isTotalCalculate = totalCalculate;
    }

    protected String getCalcFunction(ReportField field) {
        String calcFunction = null;
        if (field instanceof EntityPrimitiveIndexField) {
            EntityPrimitiveIndexField primitiveIndexField = (EntityPrimitiveIndexField)field;
            calcFunction = primitiveIndexField.getCalcFunction();
        } else if (field instanceof AggregateIndexField) {
            AggregateIndexField aggregateIndexField = (AggregateIndexField)field;
            if (aggregateIndexField.isIndexField()) {
                calcFunction = aggregateIndexField.getCalcFunction();
            }
        } else if (field instanceof PresetIndexField) {
            calcFunction = "avg";
            field.setFieldType(DataTypeEnum.BIGDECIMAL.getDataTypeKey());
            return calcFunction;
        }
        calcFunction = this.getRowSummaryIndexFunction(field.getUniqueKey(), calcFunction);
        return calcFunction;
    }

    @ExcludeFromJacocoGeneratedReport
    public DataSet groupbyDataSet(DataSet dataSet, List<ReportField> latitudeFieldList, ReportField[] indexFields) {
        LinkedHashSet<String> aliasMap = new LinkedHashSet<String>(16);
        DataSet dataSetCopy = dataSet.copy();
        String[] latitudeArr = (String[])latitudeFieldList.stream().map(ReportField::getUniqueKey).toArray(String[]::new);
        for (int i = 0; i < latitudeArr.length; ++i) {
            latitudeArr[i] = (String)this.getFieldBiMap().get((Object)latitudeArr[i]);
        }
        DataSet dataSetGroup = this.groupbyDataSetLeft(dataSet, latitudeArr, indexFields);
        boolean countDistFlag = false;
        for (ReportField reportField : indexFields) {
            String calFun = this.getCalcFunction(reportField);
            if (!"deCount".equals(calFun)) continue;
            countDistFlag = true;
            break;
        }
        if (!countDistFlag) {
            return dataSetGroup;
        }
        DataSet dataSetCountDis = dataSetCopy.groupBy(latitudeArr).reduceGroup((ReduceGroupFunctionWithCollector)new AlgoCountDistinctReduceGroupFunction(latitudeFieldList, indexFields, this.getFieldBiMap(), dataSet.getRowMeta(), this.calculateInfo.isTransferField()));
        this.recordFieldNames(dataSetGroup, aliasMap);
        this.recordFieldNames(dataSetCountDis, aliasMap);
        if (latitudeFieldList.isEmpty()) {
            dataSetGroup = dataSetGroup.addField("1", "onwrowid");
            dataSetCountDis = dataSetCountDis.addField("1", "onwrowid");
            aliasMap.add("onwrowid");
            latitudeArr = new String[]{"onwrowid"};
        }
        JoinDataSet join = dataSetGroup.leftJoin(dataSetCountDis);
        for (String latitudeField : latitudeArr) {
            join.on(latitudeField, latitudeField);
        }
        String[] joinFieldNames = aliasMap.toArray(new String[0]);
        return join.select(joinFieldNames).finish();
    }

    @ExcludeFromJacocoGeneratedReport
    private void recordFieldNames(DataSet dataSet, LinkedHashSet<String> aliasMap) {
        RowMeta rowMeta = dataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        if (fieldNames.length == 0) {
            return;
        }
        for (String fieldName : fieldNames) {
            if (!this.getFieldBiMap().containsValue((Object)fieldName)) continue;
            aliasMap.add(fieldName);
        }
    }

    public DataSet groupbyDataSetLeft(DataSet dataSet, String[] latitudeArr, ReportField[] indexFields) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(latitudeArr);
        int[] index = new int[]{Integer.parseInt((String)this.getFieldBiMap().get((Object)"increment"))};
        HashSet<String> calField = new HashSet<String>(16);
        HashSet<String> countSumSet = new HashSet<String>(16);
        for (ReportField field : indexFields) {
            String alias;
            String countAlias;
            String avgSumAlias;
            String fieldUniqueKey = field.getUniqueKey();
            String fieldAlias = (String)this.getFieldBiMap().get((Object)fieldUniqueKey);
            String calcFunction = this.getCalcFunction(field);
            String cacheKey = fieldUniqueKey + calcFunction;
            if (calField.contains(cacheKey)) continue;
            calField.add(cacheKey);
            if (calcFunction == null) continue;
            if ("sum".equals(calcFunction)) {
                if (!countSumSet.contains(fieldUniqueKey)) {
                    avgSumAlias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldUniqueKey, "avgsum"), index);
                    groupbyDataSet.sum(fieldAlias, avgSumAlias);
                    countAlias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldUniqueKey, "avgcount"), index);
                    groupbyDataSet.count(countAlias);
                    countSumSet.add(fieldUniqueKey);
                }
                alias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldUniqueKey, "sum"), index);
                groupbyDataSet.sum(fieldAlias, alias);
                continue;
            }
            if ("avg".equals(calcFunction)) {
                if (!countSumSet.contains(fieldUniqueKey)) {
                    avgSumAlias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldUniqueKey, "avgsum"), index);
                    if (field instanceof PresetIndexField) {
                        groupbyDataSet.avg(fieldAlias, avgSumAlias);
                    } else {
                        groupbyDataSet.sum(fieldAlias, avgSumAlias);
                    }
                    countAlias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldUniqueKey, "avgcount"), index);
                    groupbyDataSet.count(countAlias);
                    countSumSet.add(fieldUniqueKey);
                }
                alias = this.getDsAlias(this.genGroupByCalFieldAlias(fieldUniqueKey, "avg"), index);
                groupbyDataSet.avg(fieldAlias, alias);
                continue;
            }
            if ("count".equals(calcFunction)) {
                groupbyDataSet.count(this.getDsAlias(this.genGroupByCalFieldAlias(fieldUniqueKey, "count"), index));
                continue;
            }
            if ("deCount".equals(calcFunction)) continue;
            if ("rownummax".equals(calcFunction)) {
                groupbyDataSet.min(fieldAlias, fieldAlias);
                continue;
            }
            groupbyDataSet.count(fieldAlias);
        }
        this.getFieldBiMap().put((Object)"increment", (Object)String.valueOf(index[0]));
        return groupbyDataSet.finish();
    }

    @ExcludeFromJacocoGeneratedReport
    protected DataSet countDistinct(DataSet copyDataSet, List<ReportField> latitudeFieldList, ReportField[] indexFields) {
        String[] latitudeArr = (String[])latitudeFieldList.stream().map(ReportField::getUniqueKey).toArray(String[]::new);
        for (int i = 0; i < latitudeArr.length; ++i) {
            String fieldName = latitudeArr[i];
            latitudeArr[i] = (String)this.getFieldBiMap().get((Object)fieldName);
        }
        int[] index = new int[]{Integer.parseInt((String)this.getFieldBiMap().get((Object)"increment"))};
        for (ReportField field : indexFields) {
            String fieldUniqueKey = field.getUniqueKey();
            String calcFunction = this.getCalcFunction(field);
            if (calcFunction == null || !"deCount".equals(calcFunction)) continue;
            int n = copyDataSet.count(this.getDsAlias(fieldUniqueKey, index), true);
        }
        this.getFieldBiMap().put((Object)"increment", (Object)String.valueOf(index[0]));
        copyDataSet.groupBy(new String[]{"hrptmcdsa_1"});
        return copyDataSet.groupBy(new String[]{"hrptmcdsa_1"}).finish();
    }

    protected String getDsAlias(String original, int[] index) {
        String dsAlias = (String)this.getFieldBiMap().get((Object)original);
        if (HRStringUtils.isEmpty((String)dsAlias)) {
            index[0] = index[0] + 1;
            dsAlias = "hrptmcdsa_agg_" + index[0];
            this.getFieldBiMap().put((Object)original, (Object)dsAlias);
        }
        return dsAlias;
    }

    protected String genGroupByCalFieldAlias(String fieldAlias, String calFunction) {
        return fieldAlias + "\u03b1" + calFunction;
    }

    public DataSet groupAfterMerge(DataSet dataSet, String[] latitudeArr, ReportField[] indexFields) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(latitudeArr);
        HashMap<String, Tuple2<String, String>> avgMap = new HashMap<String, Tuple2<String, String>>(16);
        HashSet<String> calField = new HashSet<String>(16);
        HashSet<String> countSumSet = new HashSet<String>(16);
        for (ReportField field : indexFields) {
            String countFieldAlias;
            String cacheKey;
            String fieldUniqueKey = field.getUniqueKey();
            String calcFunction = this.getCalcFunction(field);
            if (calcFunction == null || calField.contains(cacheKey = fieldUniqueKey + calcFunction)) continue;
            calField.add(cacheKey);
            if ("sum".equals(calcFunction)) {
                String sumFieldAlias = this.genGroupByCalFieldAlias(fieldUniqueKey, "sum");
                groupbyDataSet.sum((String)this.getFieldBiMap().get((Object)sumFieldAlias));
                if (countSumSet.contains(fieldUniqueKey)) continue;
                String avgSumFieldAlias = this.genGroupByCalFieldAlias(fieldUniqueKey, "avgsum");
                groupbyDataSet.sum((String)this.getFieldBiMap().get((Object)avgSumFieldAlias));
                countFieldAlias = this.genGroupByCalFieldAlias(fieldUniqueKey, "avgcount");
                groupbyDataSet.sum((String)this.getFieldBiMap().get((Object)countFieldAlias));
                countSumSet.add(fieldUniqueKey);
                continue;
            }
            if ("avg".equals(calcFunction)) {
                String avgFieldAlias = this.genGroupByCalFieldAlias(fieldUniqueKey, "avg");
                groupbyDataSet.avg((String)this.getFieldBiMap().get((Object)avgFieldAlias));
                if (countSumSet.contains(fieldUniqueKey)) continue;
                String sumFieldAlias = this.genGroupByCalFieldAlias(fieldUniqueKey, "avgsum");
                groupbyDataSet.sum((String)this.getFieldBiMap().get((Object)sumFieldAlias));
                countFieldAlias = this.genGroupByCalFieldAlias(fieldUniqueKey, "avgcount");
                groupbyDataSet.sum((String)this.getFieldBiMap().get((Object)countFieldAlias));
                countSumSet.add(fieldUniqueKey);
                avgMap.put((String)this.getFieldBiMap().get((Object)avgFieldAlias), new Tuple2<Object, Object>(this.getFieldBiMap().get((Object)sumFieldAlias), this.getFieldBiMap().get((Object)countFieldAlias)));
                continue;
            }
            if ("count".equals(calcFunction)) {
                String countFieldAlias2 = this.genGroupByCalFieldAlias(fieldUniqueKey, "count");
                groupbyDataSet.sum((String)this.getFieldBiMap().get((Object)countFieldAlias2));
                continue;
            }
            if ("deCount".equals(calcFunction)) {
                String countDisFieldAlias = this.genGroupByCalFieldAlias(fieldUniqueKey, "deCount");
                groupbyDataSet.sum((String)this.getFieldBiMap().get((Object)countDisFieldAlias));
                continue;
            }
            if ("rownummax".equals(calcFunction)) {
                groupbyDataSet.min(fieldUniqueKey, fieldUniqueKey);
                continue;
            }
            groupbyDataSet.count((String)this.getFieldBiMap().get((Object)fieldUniqueKey));
        }
        DataSet rstDataSet = groupbyDataSet.finish();
        if (MapUtils.isNotEmpty(avgMap)) {
            rstDataSet = this.calculateAvg(avgMap, rstDataSet);
        }
        return rstDataSet;
    }

    private DataSet calculateAvg(final Map<String, Tuple2<String, String>> avgMap, final DataSet rstDataSet) {
        DataSet avgDataSet = rstDataSet.map(new MapFunction(){
            private static final long serialVersionUID = 6967826829644888463L;

            public Object[] map(Row row) {
                String[] fieldNames = rstDataSet.getRowMeta().getFieldNames();
                Object[] objects = new Object[fieldNames.length];
                for (int i = 0; i < fieldNames.length; ++i) {
                    String fieldName = fieldNames[i];
                    if (avgMap.containsKey(fieldName)) {
                        BigDecimal count;
                        Tuple2 tuple2 = (Tuple2)avgMap.get(fieldName);
                        String t1Val = row.getString((String)tuple2.t1);
                        if (t1Val == null) {
                            t1Val = "0";
                        }
                        BigDecimal tatal = new BigDecimal(t1Val);
                        String t2Val = row.getString((String)tuple2.t2);
                        if (t2Val == null) {
                            t2Val = "0";
                        }
                        if ((count = new BigDecimal(t2Val)).intValue() == 0) {
                            objects[i] = BigDecimal.ZERO;
                            continue;
                        }
                        objects[i] = tatal.divide(count, 10, RoundingMode.HALF_DOWN);
                        continue;
                    }
                    objects[i] = row.get(fieldName);
                }
                return objects;
            }

            public RowMeta getResultRowMeta() {
                return rstDataSet.getRowMeta();
            }
        });
        return avgDataSet.copy();
    }

    private String getRowSummaryIndexFunction(String indexUniqueKey, String originalFunction) {
        String summaryFunction;
        Map<String, String> indexFunctionMap;
        String indexFunction = originalFunction;
        RowSummaryInfo rowSummaryInfo = this.calculateInfo.getRowSummaryInfo();
        if (this.isTotalCalculate && rowSummaryInfo != null && (indexFunctionMap = rowSummaryInfo.getIndexFunctionMap()) != null && HRStringUtils.isNotEmpty((String)(summaryFunction = indexFunctionMap.get(indexUniqueKey)))) {
            indexFunction = summaryFunction;
        }
        return indexFunction;
    }
}

