/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.QuerySegment;
import kd.hr.hrptmc.business.repcalculate.algo.CalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.PivotHelper;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class SummaryCalculateAlgo
extends CalculateAlgo {
    public SummaryCalculateAlgo(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        super(calculateInfo, complexObjContext);
    }

    @Override
    public DataSet calculate(int start, int limit) {
        int pageStart = start;
        int pageLimit = limit;
        if (this.isAdminOrgIncludeSub()) {
            pageStart = -1;
            pageLimit = -1;
        }
        DataSet dataSet = this.getData(pageStart, pageLimit);
        DataSet calculateDataSet = this.doCalculate(dataSet, pageStart, pageLimit);
        if (this.isAdminOrgIncludeSub() && this.notOnlyGroupByOrg() && start >= 0 && limit > 0) {
            calculateDataSet = calculateDataSet.range(start, limit);
        }
        return this.renewFieldName(calculateDataSet);
    }

    private DataSet doCalculate(DataSet dataSet, int start, int limit) {
        DataSet rstDataSet;
        List<ReportField> columnFieldList;
        this.calculateInfo.getCostTimeHelper().nestedStart();
        AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
        if (adminOrgSummaryInfo != null && !adminOrgSummaryInfo.getTreeShow() && adminOrgSummaryInfo.getIncludeSubOrg()) {
            dataSet = this.addAdminOrgIncludeSub(dataSet, adminOrgSummaryInfo);
        }
        if (CollectionUtils.isNotEmpty(columnFieldList = this.getCalculateInfo().getColumnFieldList())) {
            List<Map<String, Object>> finalColListMap = this.queryLatitudeValList(columnFieldList);
            PivotHelper pivotHelper = new PivotHelper();
            pivotHelper.setAddCountField(this.isTotalCal());
            pivotHelper.setTotalCalculate(this.isTotalCal());
            pivotHelper.init(this.calculateInfo);
            pivotHelper.setFieldBiMap((BiMap<String, String>)this.fieldBiMap);
            DataSet rstDs = this.onlyGroupByAgg(dataSet, start, limit, false);
            rstDataSet = pivotHelper.convert(rstDs, finalColListMap);
        } else {
            rstDataSet = this.onlyGroupByAgg(dataSet, start, limit, true);
        }
        this.calculateInfo.getCostTimeHelper().logCost("algo_do_PivotHelper", "algo_do_PivotHelper");
        return this.reOrder(rstDataSet);
    }

    private DataSet onlyGroupByAgg(DataSet dataSet, int start, int limit, boolean containDependField) {
        PivotHelper pivotHelper = new PivotHelper();
        pivotHelper.setAddCountField(this.isTotalCal());
        pivotHelper.setTotalCalculate(this.isTotalCal());
        pivotHelper.setFieldBiMap((BiMap<String, String>)this.fieldBiMap);
        pivotHelper.setContainDependField(containDependField);
        pivotHelper.init(this.calculateInfo);
        QuerySegment querySegment = this.getComplexObjContext().getQuerySegment();
        DataSet rstDataSet = null;
        DataSet copyDataSet = dataSet.copy();
        if (this.getComplexObjContext().getVirtualEntity().booleanValue()) {
            return this.onlyVirtualGroupByAgg(pivotHelper, copyDataSet, start, limit);
        }
        if (querySegment == null) {
            rstDataSet = this.groupBy(pivotHelper, copyDataSet);
        } else {
            pivotHelper.setAddCountField(true);
            boolean loop = true;
            while (loop) {
                rstDataSet = rstDataSet == null ? this.groupBy(pivotHelper, copyDataSet) : rstDataSet.union(this.groupBy(pivotHelper, copyDataSet));
                if (querySegment.hasNext()) {
                    copyDataSet = this.getData(start, limit).copy();
                    if (!this.isAdminOrgIncludeSub()) continue;
                    AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
                    copyDataSet = this.addAdminOrgIncludeSub(copyDataSet, adminOrgSummaryInfo);
                    continue;
                }
                loop = false;
            }
            rstDataSet = this.merge(pivotHelper, rstDataSet);
        }
        this.getComplexObjContext().clearAlterAbleField();
        return rstDataSet;
    }

    private DataSet onlyVirtualGroupByAgg(PivotHelper pivotHelper, DataSet copyDataSet, int start, int limit) {
        DataSet rstDataSet = null;
        if (!this.isVirSummaryBatch(this.getComplexObjContext().getVirtualEntityQueryParamInfo())) {
            rstDataSet = this.groupBy(pivotHelper, copyDataSet);
        } else {
            pivotHelper.setAddCountField(true);
            boolean loop = true;
            while (loop) {
                rstDataSet = rstDataSet == null ? this.groupBy(pivotHelper, copyDataSet) : rstDataSet.union(this.groupBy(pivotHelper, copyDataSet));
                if (!this.getComplexObjContext().getVirtualEntityQueryParamInfo().getSummaryQueryParamInfo().isAllData()) {
                    copyDataSet = this.getData(start, limit).copy();
                    continue;
                }
                loop = false;
            }
            rstDataSet = this.merge(pivotHelper, rstDataSet);
        }
        return rstDataSet;
    }

    private DataSet groupBy(PivotHelper pivotHelper, DataSet dataSet) {
        return pivotHelper.groupLatitudeCalPrimitive(dataSet);
    }

    private DataSet merge(PivotHelper pivotHelper, DataSet dataSet) {
        return pivotHelper.groupAfterMerge(dataSet).copy();
    }
}

