/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Collector;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.RowMetaBuilder;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class TotalCalculateReduceGroupAlgo
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 7030554982564380669L;
    private final RowMeta rowMeta;
    private final String reportType;
    private final RowSummaryInfo rowSummaryInfo;
    private final Map<String, PresetIndexField> presetIndexFieldMap;
    private final RowMeta newRowMeta;
    private final Map<String, Integer> newRowMetaAliasIndexMap;
    private final Set<String> nonAggIndexAliasExtends;

    public TotalCalculateReduceGroupAlgo(RowMeta rowMeta, ReportCalculateInfo calculateInfo) {
        this.rowMeta = rowMeta;
        this.reportType = calculateInfo.getReportType();
        this.rowSummaryInfo = calculateInfo.getRowSummaryInfo();
        this.presetIndexFieldMap = calculateInfo.getRowFieldList().stream().filter(reportField -> reportField instanceof PresetIndexField).map(reportField -> (PresetIndexField)reportField).collect(Collectors.toMap(ReportField::getUniqueKey, Function.identity()));
        this.newRowMeta = this.getResultRowMeta();
        Field[] fields = this.newRowMeta.getFields();
        this.newRowMetaAliasIndexMap = Maps.newHashMapWithExpectedSize((int)fields.length);
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            this.newRowMetaAliasIndexMap.put(field.getAlias(), index);
        }
        this.nonAggIndexAliasExtends = calculateInfo.getRowFieldListWithoutDp(true).stream().filter(reportField -> reportField instanceof NonAggregateIndexField).map(obj -> (NonAggregateIndexField)obj).map(ReportField::getUniqueKey).collect(Collectors.toSet());
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        Field[] fields = this.rowMeta.getFields();
        Object[] resultRow = new Object[this.newRowMeta.getFieldCount()];
        while (iterator.hasNext()) {
            Row row = iterator.next();
            this.setTotalCountResultRow(resultRow, row);
            for (int i = 0; i < fields.length; ++i) {
                String alias = fields[i].getAlias();
                String dataTypeName = fields[i].getDataType().getName();
                if ("REPORT_COUNT_FIELD".equals(alias) || !RowMetaBuilder.TOTALCALCULATE_SET.contains(dataTypeName)) continue;
                this.setTotalCalculateResultRowX(resultRow, row, i, alias);
            }
        }
        collector.collect(resultRow);
    }

    public final RowMeta getResultRowMeta() {
        return RowMetaBuilder.buildAlgoTotalResultRowMeta(this.rowMeta, this.reportType, this.rowSummaryInfo);
    }

    private void setTotalCalculateResultRowX(Object[] resultRow, Row row, int index, String algoAlias) {
        if ("0".equals(this.reportType)) {
            if (algoAlias.contains("\u03b1")) {
                String[] tempArr = algoAlias.split("\u03b1");
                String fieldName = tempArr[0];
                String calculateSuffix = tempArr[1];
                if ("sum".equals(calculateSuffix)) {
                    this.setTotalSumCalculateResultRow(resultRow, row, index);
                } else if ("avg".equals(calculateSuffix)) {
                    if (this.presetIndexFieldMap.containsKey(fieldName)) {
                        PresetIndexField presetIndexField = this.presetIndexFieldMap.get(fieldName);
                        Map<String, String> indexFunctionMap = this.rowSummaryInfo.getIndexFunctionMap();
                        if (indexFunctionMap != null) {
                            String function = indexFunctionMap.get(presetIndexField.getUniqueKey());
                            if ("sum".equals(function)) {
                                this.setTotalSumCalculateResultRow(resultRow, row, index);
                            } else if ("avg".equals(function)) {
                                this.setNonAggIndexTotalAvgCalculateResultRow(resultRow, row, index, fieldName);
                            }
                        }
                    } else if (this.nonAggIndexAliasExtends.contains(fieldName)) {
                        this.setNonAggIndexTotalAvgCalculateResultRow(resultRow, row, index, fieldName);
                    } else {
                        this.setTotalAvgCalculateResultRowX(resultRow, row, index, fieldName);
                    }
                } else if ("count".equals(calculateSuffix)) {
                    this.setTotalSumCalculateResultRow(resultRow, row, index);
                }
            }
        } else {
            Object val = row.get(index);
            String function = RowSummaryInfo.getTotalCalFunction(algoAlias, "sum", this.rowSummaryInfo);
            Integer newIndex = this.newRowMetaAliasIndexMap.get(algoAlias);
            BigDecimal calculateVal = new BigDecimal(String.valueOf(val == null ? Integer.valueOf(0) : val));
            if ("avg".equals(function)) {
                String fieldKey = algoAlias + '\u03b1' + "avgsum";
                BigDecimal sumVal = this.setSumAddCalculateResultRow(resultRow, calculateVal, fieldKey);
                String countFieldKey = algoAlias + '\u03b1' + "avgcount";
                BigDecimal countVal = this.setSumAddCalculateResultRow(resultRow, BigDecimal.ONE, countFieldKey);
                BigDecimal avgVal = countVal.intValue() == 0 ? BigDecimal.ZERO : sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
                resultRow[newIndex.intValue()] = avgVal;
            } else {
                BigDecimal nowVal = (BigDecimal)resultRow[newIndex];
                if (nowVal == null) {
                    nowVal = BigDecimal.ZERO;
                }
                nowVal = nowVal.add(calculateVal);
                resultRow[newIndex.intValue()] = nowVal;
            }
        }
    }

    private void setTotalCountResultRow(Object[] resultRow, Row row) {
        int newCountIndex = this.newRowMetaAliasIndexMap.get("REPORT_COUNT_FIELD");
        int oldCountIndex = this.getValIndex("REPORT_COUNT_FIELD");
        BigDecimal nowVal = (BigDecimal)resultRow[newCountIndex];
        BigDecimal oldVal = row.getBigDecimal(oldCountIndex);
        if (nowVal == null) {
            nowVal = BigDecimal.ZERO;
        }
        if (oldVal == null) {
            oldVal = BigDecimal.ONE;
        }
        nowVal = nowVal.add(oldVal);
        resultRow[newCountIndex] = nowVal;
    }

    public BigDecimal setTotalSumCalculateResultRow(Object[] resultRow, Row row, int index) {
        BigDecimal calculateVal = row.getBigDecimal(index);
        BigDecimal nowVal = (BigDecimal)resultRow[index];
        if (nowVal == null) {
            nowVal = BigDecimal.ZERO;
        }
        nowVal = nowVal.add(calculateVal == null ? BigDecimal.ZERO : calculateVal);
        resultRow[index] = nowVal;
        return nowVal;
    }

    public void setTotalAvgCalculateResultRowX(Object[] resultRow, Row row, int index, String fieldName) {
        String fieldKey = fieldName + '\u03b1' + "avgsum";
        int avgsumIndex = this.getValIndex(fieldKey);
        BigDecimal sumVal = this.setTotalSumCalculateResultRow(resultRow, row, avgsumIndex);
        String countFieldKey = fieldName + '\u03b1' + "avgcount";
        int countIndex = this.getValIndex(countFieldKey);
        BigDecimal countVal = this.setTotalSumCalculateResultRow(resultRow, row, countIndex);
        BigDecimal avgVal = countVal.intValue() == 0 ? BigDecimal.ZERO : sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
        resultRow[index] = avgVal;
    }

    private int getValIndex(String fieldKey) {
        Field[] fields = this.rowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field metaField = fields[i];
            if (!metaField.getAlias().equals(fieldKey)) continue;
            return i;
        }
        return -1;
    }

    public BigDecimal setSumAddCalculateResultRow(Object[] resultRow, BigDecimal sumAddValue, String fieldKey) {
        int addSumIndex = this.newRowMetaAliasIndexMap.get(fieldKey);
        BigDecimal resultValue = (BigDecimal)resultRow[addSumIndex];
        if (resultValue == null) {
            resultValue = BigDecimal.ZERO;
        }
        if (sumAddValue == null) {
            sumAddValue = BigDecimal.ZERO;
        }
        resultValue = resultValue.add(sumAddValue);
        resultRow[addSumIndex] = resultValue;
        return resultValue;
    }

    public void setNonAggIndexTotalAvgCalculateResultRow(Object[] resultRow, Row row, int index, String fieldName) {
        String fieldKey = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.getValIndex(fieldKey);
        BigDecimal sumVal = this.setTotalSumCalculateResultRow(resultRow, row, avgSumIndex);
        int countIndex = this.getValIndex("REPORT_COUNT_FIELD");
        BigDecimal countVal = (BigDecimal)resultRow[countIndex];
        BigDecimal avgVal = countVal.intValue() == 0 ? BigDecimal.ZERO : sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
        resultRow[index] = avgVal;
    }
}

